/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.ObjectCharAssociativeContainer;
import com.carrotsearch.hppc.ObjectCharHashMap;

public class ObjectCharIdentityHashMap<KType>
extends ObjectCharHashMap<KType> {
    public ObjectCharIdentityHashMap() {
        this(4);
    }

    public ObjectCharIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectCharIdentityHashMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectCharIdentityHashMap(ObjectCharAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key2) {
        assert (key2 != null);
        return BitMixer.mixPhi(System.identityHashCode(key2));
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectCharIdentityHashMap<KType> from(KType[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectCharIdentityHashMap<KType> map = new ObjectCharIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

