/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx;

import java.io.IOException;
import java.io.Reader;
import net.loomchild.segment.util.IORuntimeException;

public class TextManager {
    private CharSequence text;
    int nextCharacter;
    private Reader reader;
    private int bufferLength;

    public TextManager(CharSequence text2) {
        this.text = text2;
        this.nextCharacter = -1;
        this.reader = null;
        this.bufferLength = text2.length();
    }

    public TextManager(Reader reader, int bufferLength) {
        if (bufferLength <= 0) {
            throw new IllegalArgumentException("Buffer size: " + bufferLength + " must be positive.");
        }
        this.text = null;
        this.reader = reader;
        this.bufferLength = bufferLength;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public CharSequence getText() {
        this.initText();
        return this.text;
    }

    public boolean hasMoreText() {
        this.initText();
        return this.nextCharacter != -1;
    }

    public void readText(int amount) {
        this.initText();
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        if (amount > this.bufferLength) {
            throw new IllegalArgumentException("Amount to read is larger than buffer size.");
        }
        if (!this.hasMoreText()) {
            throw new IllegalStateException("No more text to read.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.text.subSequence(amount, this.text.length()));
        builder.append((char)this.nextCharacter);
        builder.append(this.read(amount));
        this.text = builder.toString();
    }

    private void initText() {
        if (this.text == null) {
            this.text = this.read(this.bufferLength + 1);
        }
    }

    private String read(int amount) {
        String result2;
        char[] charBuffer = new char[amount];
        int count = this.read(this.reader, charBuffer);
        if (count == amount) {
            result2 = new String(charBuffer, 0, count - 1);
            this.nextCharacter = charBuffer[count - 1];
        } else if (count > 0 && count < amount) {
            result2 = new String(charBuffer, 0, count);
            this.nextCharacter = -1;
        } else {
            result2 = "";
            this.nextCharacter = -1;
        }
        return result2;
    }

    private int read(Reader reader, char[] buffer) {
        try {
            int start;
            int count;
            for (start = 0; (count = reader.read(buffer, start, buffer.length - start)) != -1 && start < buffer.length; start += count) {
            }
            return start;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

