/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class WordRepeatBeginningRule
extends TextLevelRule {
    public WordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    @Override
    public String getId() {
        return "WORD_REPEAT_BEGINNING_RULE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_repetition_beginning");
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        return false;
    }

    public boolean isException(String token) {
        return token.equals(":") || token.equals("\u2013") || token.equals("-") || token.equals("\u2714\ufe0f") || token.equals("\u27a1\ufe0f") || token.equals("\u2014") || token.equals("\u2b50\ufe0f") || token.equals("\u26a0\ufe0f");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences2) throws IOException {
        String lastToken = "";
        String beforeLastToken = "";
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        AnalyzedSentence prevSentence = null;
        for (AnalyzedSentence sentence : sentences2) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            String token = "";
            if (tokens.length > 1) {
                AnalyzedTokenReadings analyzedToken = tokens[1];
                token = analyzedToken.getToken();
                if (tokens.length > 3) {
                    String shortMsg;
                    boolean isWord = true;
                    if (token.length() == 1 && !Character.isLetter(token.charAt(0))) {
                        isWord = false;
                    }
                    if (isWord && lastToken.equals(token) && !this.isException(token) && !this.isException(tokens[2].getToken()) && !this.isException(tokens[3].getToken()) && prevSentence != null && prevSentence.getText().trim().matches(".+[.?!]$") && !(shortMsg = this.isAdverb(analyzedToken) ? this.messages.getString("desc_repetition_beginning_adv") : (beforeLastToken.equals(token) ? this.messages.getString("desc_repetition_beginning_word") : "")).isEmpty()) {
                        String msg = shortMsg + " " + this.messages.getString("desc_repetition_beginning_thesaurus");
                        int startPos = analyzedToken.getStartPos();
                        int endPos = startPos + token.length();
                        RuleMatch ruleMatch = new RuleMatch(this, sentence, pos + startPos, pos + endPos, msg, shortMsg);
                        List<String> suggestions = this.getSuggestions(analyzedToken);
                        if (suggestions.size() > 0) {
                            ruleMatch.setSuggestedReplacements(suggestions);
                        }
                        ruleMatches.add(ruleMatch);
                    }
                }
            }
            beforeLastToken = lastToken;
            lastToken = token;
            pos += sentence.getCorrectedTextLength();
            prevSentence = sentence;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected List<String> getSuggestions(AnalyzedTokenReadings analyzedToken) {
        return Collections.emptyList();
    }

    @Override
    public int minToCheckParagraph() {
        return 2;
    }
}

