/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHEnterpriseServerMeta;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.pullrequest.GHPRAction;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRListSearchValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001'\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020\u0004H\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u001e\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\bJ\u000e\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00102\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00104\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00105\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00106\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00107\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00108\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u001e\u00109\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u0016\u0010>\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0016\u0010B\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010C\u001a\u00020 J\u000e\u0010D\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010E\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010F\u001a\u00020+2\u0006\u0010,\u001a\u00020-R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010$0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u0006G"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "COUNTERS_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "DETAILS_ACTION_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRAction;", "", "DETAILS_BRANCHES_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "DETAILS_BRANCH_CHECKED_OUT_EVENT", "DETAILS_CHANGE_EVENT", "DETAILS_CHECKS_EVENT", "DETAILS_COMMIT_CHOSEN_EVENT", "DETAILS_NEXT_COMMIT_EVENT", "DETAILS_OPENED_EVENT", "DETAILS_PREV_COMMIT_EVENT", "DIFF_OPENED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "FILTERS_APPLIED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "FILTER_ASSIGNEE_PRESENT", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "FILTER_AUTHOR_PRESENT", "FILTER_LABEL_PRESENT", "FILTER_REVIEW_PRESENT", "FILTER_SEARCH_PRESENT", "FILTER_STATE_PRESENT", "LIST_OPENED_EVENT", "MERGED_EVENT", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestMergeMethod;", "NEW_OPENED_EVENT", "SELECTORS_OPENED_EVENT", "SERVER_META_EVENT", "", "TIMELINE_OPENED_EVENT", "anonymizedId", "org/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$anonymizedId$1", "Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$anonymizedId$1;", "getGroup", "logChangeSelected", "", "project", "Lcom/intellij/openapi/project/Project;", "logDetailsActionInvoked", "action", "isDefault", "logDetailsBranchCheckedOut", "logDetailsBranchesOpened", "logDetailsChecksOpened", "logDetailsCommitChosen", "logDetailsNextCommitChosen", "logDetailsOpened", "logDetailsPrevCommitChosen", "logDiffOpened", "logEnterpriseServerMeta", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "meta", "Lorg/jetbrains/plugins/github/api/data/GHEnterpriseServerMeta;", "logListFiltersApplied", "filters", "Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRListSearchValue;", "logListOpened", "logMergedEvent", "method", "logNewPRViewOpened", "logSelectorsOpened", "logTimelineOpened", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRStatisticsCollector.kt\norg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,212:1\n12634#2,3:213\n12634#2,3:216\n193#3:219\n192#3,2:220\n*S KotlinDebug\n*F\n+ 1 GHPRStatisticsCollector.kt\norg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector\n*L\n112#1:213,3\n117#1:216,3\n55#1:219\n81#1:220,2\n*E\n"})
public final class GHPRStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final GHPRStatisticsCollector INSTANCE;
    @NotNull
    private static final EventLogGroup COUNTERS_GROUP;
    @NotNull
    private static final EventId SELECTORS_OPENED_EVENT;
    @NotNull
    private static final EventId LIST_OPENED_EVENT;
    @NotNull
    private static final BooleanEventField FILTER_SEARCH_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_STATE_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_AUTHOR_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_ASSIGNEE_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_REVIEW_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_LABEL_PRESENT;
    @NotNull
    private static final VarargEventId FILTERS_APPLIED_EVENT;
    @NotNull
    private static final EventId DETAILS_OPENED_EVENT;
    @NotNull
    private static final EventId NEW_OPENED_EVENT;
    @NotNull
    private static final EventId1<Integer> TIMELINE_OPENED_EVENT;
    @NotNull
    private static final EventId1<Integer> DIFF_OPENED_EVENT;
    @NotNull
    private static final EventId1<GithubPullRequestMergeMethod> MERGED_EVENT;
    @NotNull
    private static final anonymizedId.1 anonymizedId;
    @NotNull
    private static final EventId2<String, String> SERVER_META_EVENT;
    @NotNull
    private static final EventId DETAILS_BRANCHES_EVENT;
    @NotNull
    private static final EventId DETAILS_BRANCH_CHECKED_OUT_EVENT;
    @NotNull
    private static final EventId DETAILS_COMMIT_CHOSEN_EVENT;
    @NotNull
    private static final EventId DETAILS_NEXT_COMMIT_EVENT;
    @NotNull
    private static final EventId DETAILS_PREV_COMMIT_EVENT;
    @NotNull
    private static final EventId DETAILS_CHANGE_EVENT;
    @NotNull
    private static final EventId DETAILS_CHECKS_EVENT;
    @NotNull
    private static final EventId2<GHPRAction, Boolean> DETAILS_ACTION_EVENT;

    private GHPRStatisticsCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return COUNTERS_GROUP;
    }

    public final void logSelectorsOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SELECTORS_OPENED_EVENT.log(project);
    }

    public final void logListOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LIST_OPENED_EVENT.log(project);
    }

    public final void logListFiltersApplied(@NotNull Project project, @NotNull GHPRListSearchValue filters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        EventPair[] eventPairArray = new EventPair[]{new EventPair((EventField)FILTER_SEARCH_PRESENT, (Object)(filters.getSearchQuery() != null ? 1 : 0)), new EventPair((EventField)FILTER_STATE_PRESENT, (Object)(filters.getState() != null ? 1 : 0)), new EventPair((EventField)FILTER_AUTHOR_PRESENT, (Object)(filters.getAuthor() != null ? 1 : 0)), new EventPair((EventField)FILTER_ASSIGNEE_PRESENT, (Object)(filters.getAssignee() != null ? 1 : 0)), new EventPair((EventField)FILTER_REVIEW_PRESENT, (Object)(filters.getReviewState() != null ? 1 : 0)), new EventPair((EventField)FILTER_LABEL_PRESENT, (Object)(filters.getLabel() != null ? 1 : 0))};
        FILTERS_APPLIED_EVENT.log(project, eventPairArray);
    }

    public final void logDetailsOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_OPENED_EVENT.log(project);
    }

    public final void logNewPRViewOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NEW_OPENED_EVENT.log(project);
    }

    public final void logTimelineOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(it instanceof GHPRTimelineVirtualFile)) continue;
            ++count$iv;
        }
        int count = count$iv;
        TIMELINE_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logDiffOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            boolean bl2 = it instanceof GHPRDiffVirtualFileBase || it instanceof GHPRCombinedDiffPreviewVirtualFileBase;
            if (!bl2) continue;
            ++count$iv;
        }
        int count = count$iv;
        DIFF_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logDetailsBranchesOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_BRANCHES_EVENT.log(project);
    }

    public final void logDetailsBranchCheckedOut(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_BRANCH_CHECKED_OUT_EVENT.log(project);
    }

    public final void logDetailsCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_COMMIT_CHOSEN_EVENT.log(project);
    }

    public final void logDetailsNextCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_NEXT_COMMIT_EVENT.log(project);
    }

    public final void logDetailsPrevCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_PREV_COMMIT_EVENT.log(project);
    }

    public final void logDetailsChecksOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_CHECKS_EVENT.log(project);
    }

    public final void logDetailsActionInvoked(@NotNull Project project, @NotNull GHPRAction action2, boolean isDefault) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        DETAILS_ACTION_EVENT.log(project, (Object)action2, (Object)isDefault);
    }

    public final void logChangeSelected(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_CHANGE_EVENT.log(project);
    }

    public final void logMergedEvent(@NotNull Project project, @NotNull GithubPullRequestMergeMethod method) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        MERGED_EVENT.log(project, (Object)method);
    }

    public final void logEnterpriseServerMeta(@NotNull Project project, @NotNull GithubServerPath server, @NotNull GHEnterpriseServerMeta meta) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        String string = server.toUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUrl(...)");
        SERVER_META_EVENT.log(project, (Object)string, (Object)meta.getInstalledVersion());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        String name$iv;
        INSTANCE = new GHPRStatisticsCollector();
        COUNTERS_GROUP = new EventLogGroup("vcs.github.pullrequest.counters", 5, null, 4, null);
        SELECTORS_OPENED_EVENT = COUNTERS_GROUP.registerEvent("selectors.opened");
        LIST_OPENED_EVENT = COUNTERS_GROUP.registerEvent("list.opened");
        FILTER_SEARCH_PRESENT = EventFields.Boolean((String)"has_search");
        FILTER_STATE_PRESENT = EventFields.Boolean((String)"has_state");
        FILTER_AUTHOR_PRESENT = EventFields.Boolean((String)"has_author");
        FILTER_ASSIGNEE_PRESENT = EventFields.Boolean((String)"has_assignee");
        FILTER_REVIEW_PRESENT = EventFields.Boolean((String)"has_review_state");
        FILTER_LABEL_PRESENT = EventFields.Boolean((String)"has_label");
        EventFields eventFields = new EventFields[]{FILTER_SEARCH_PRESENT, FILTER_STATE_PRESENT, FILTER_AUTHOR_PRESENT, FILTER_ASSIGNEE_PRESENT, FILTER_REVIEW_PRESENT, FILTER_LABEL_PRESENT};
        FILTERS_APPLIED_EVENT = COUNTERS_GROUP.registerVarargEvent("list.filters.applied", (EventField[])eventFields);
        DETAILS_OPENED_EVENT = COUNTERS_GROUP.registerEvent("details.opened");
        NEW_OPENED_EVENT = COUNTERS_GROUP.registerEvent("new.pr.view.opened");
        TIMELINE_OPENED_EVENT = COUNTERS_GROUP.registerEvent("timeline.opened", (EventField)EventFields.Int((String)"count"));
        DIFF_OPENED_EVENT = COUNTERS_GROUP.registerEvent("diff.opened", (EventField)EventFields.Int((String)"count"));
        eventFields = EventFields.INSTANCE;
        String string = "method";
        Function1 transform$iv = MERGED_EVENT.1.INSTANCE;
        boolean $i$f$Enum = false;
        MERGED_EVENT = COUNTERS_GROUP.registerEvent("merged", (EventField)new EnumEventField(name$iv, GithubPullRequestMergeMethod.class, transform$iv));
        anonymizedId = new PrimitiveEventField<String>(){
            @NotNull
            private final String name;
            {
                this.name = "anonymized_id";
            }

            @NotNull
            public String getName() {
                return this.name;
            }

            public void addData(@NotNull FeatureUsageData fuData, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                fuData.addAnonymizedId(value);
            }

            @NotNull
            public List<String> getValidationRule() {
                return CollectionsKt.listOf((Object)"{regexp#hash}");
            }
        };
        SERVER_META_EVENT = COUNTERS_GROUP.registerEvent("server.meta.collected", (EventField)anonymizedId, (EventField)EventFields.Version);
        DETAILS_BRANCHES_EVENT = COUNTERS_GROUP.registerEvent("details.branches.opened");
        DETAILS_BRANCH_CHECKED_OUT_EVENT = COUNTERS_GROUP.registerEvent("details.branch.checked.out");
        DETAILS_COMMIT_CHOSEN_EVENT = COUNTERS_GROUP.registerEvent("details.commit.chosen");
        DETAILS_NEXT_COMMIT_EVENT = COUNTERS_GROUP.registerEvent("details.next.commit.chosen");
        DETAILS_PREV_COMMIT_EVENT = COUNTERS_GROUP.registerEvent("details.prev.commit.chosen");
        DETAILS_CHANGE_EVENT = COUNTERS_GROUP.registerEvent("details.change.selected");
        DETAILS_CHECKS_EVENT = COUNTERS_GROUP.registerEvent("details.checks.opened");
        EventFields this_$iv = EventFields.INSTANCE;
        name$iv = "action";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        DETAILS_ACTION_EVENT = COUNTERS_GROUP.registerEvent("details.additional.actions.invoked", (EventField)new EnumEventField(name$iv, GHPRAction.class, transform$iv), (EventField)EventFields.Boolean((String)"is_default"));
    }
}

