/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryConnection;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.GHRepositoryConnectionManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFile;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "equals", "", "other", "", "findDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "getIcon", "Ljavax/swing/Icon;", "getName", "getPath", "getPresentableName", "getPresentablePath", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRTimelineVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n1#2:47\n30#3,3:48\n*S KotlinDebug\n*F\n+ 1 GHPRTimelineVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile\n*L\n34#1:48,3\n*E\n"})
public final class GHPRTimelineVirtualFile
extends GHPRVirtualFile {
    public GHPRTimelineVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        super(fileManagerId, project, repository, pullRequest);
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
        this.setWritable(false);
    }

    @NotNull
    public String getName() {
        return "#" + this.getPullRequest().getNumber();
    }

    @NotNull
    public String getPresentableName() {
        Object object;
        block3: {
            block2: {
                object = this.findDetails();
                if (object == null) break block2;
                GHPullRequestShort it = object;
                boolean bl = false;
                String string = it.getTitle() + " " + this.getName();
                object = string;
                if (string != null) break block3;
            }
            object = this.getName();
        }
        return object;
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return GHPRVirtualFileSystem.getPath$default((GHPRVirtualFileSystem)complexPathVirtualFileSystem, this.getSessionId(), this.getProject(), this.getRepository(), this.getPullRequest(), null, false, 32, null);
    }

    @NotNull
    public String getPresentablePath() {
        Object object = this.findDetails();
        if (object == null || (object = ((GHPullRequestShort)object).getUrl()) == null) {
            object = this.getRepository().toUrl() + "/pulls/" + this.getPullRequest().getNumber();
        }
        return object;
    }

    @Nullable
    public final Icon getIcon() {
        Icon icon;
        GHPullRequestShort gHPullRequestShort = this.findDetails();
        if (gHPullRequestShort != null) {
            GHPullRequestShort it = gHPullRequestShort;
            boolean bl = false;
            icon = GHUIUtil.INSTANCE.getPullRequestStateIcon(it.getState(), it.isDraft());
        } else {
            icon = null;
        }
        return icon;
    }

    private final GHPullRequestShort findDetails() {
        GHPullRequestShort gHPullRequestShort;
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<GHRepositoryConnectionManager> serviceClass$iv = GHRepositoryConnectionManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        Object object2 = (GHRepositoryConnection)((GHRepositoryConnectionManager)object).getConnectionState().getValue();
        if (object2 != null && (object2 = ((GHRepositoryConnection)object2).getDataContext()) != null) {
            Object v1;
            Object $this$findDetails_u24lambda_u243;
            block5: {
                $this$findDetails_u24lambda_u243 = object2;
                boolean bl = false;
                Iterable iterable = ((GHPRDataContext)$this$findDetails_u24lambda_u243).getListLoader().getLoadedData();
                for (Object t : iterable) {
                    GHPullRequestShort it = (GHPullRequestShort)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.getPullRequest().getId())) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            if ((gHPullRequestShort = (GHPullRequestShort)v1) == null) {
                Object object3 = ((GHPRDataContext)$this$findDetails_u24lambda_u243).getDataProviderRepository().findDataProvider(this.getPullRequest());
                gHPullRequestShort = object3 != null && (object3 = object3.getDetailsData()) != null ? object3.getLoadedDetails() : null;
            }
        } else {
            gHPullRequestShort = null;
        }
        return gHPullRequestShort;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRTimelineVirtualFile)) {
            return false;
        }
        return super.equals(other);
    }
}

