/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverter;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestedChange;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestedChangeApplier;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewSuggestedChangeComponentFactory;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;)V", "markdownConverter", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter;", "createCommentComponent", "Ljavax/swing/JComponent;", "commentBody", "", "maxTextWidth", "", "createCommentPane", "htmlBody", "createCommentWithSuggestedChangeComponent", "thread", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "suggestedChange", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestedChange;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "CommentBlock", "CommentType", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRReviewCommentComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRReviewCommentComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1855#2,2:113\n*S KotlinDebug\n*F\n+ 1 GHPRReviewCommentComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory\n*L\n43#1:113,2\n*E\n"})
public final class GHPRReviewCommentComponentFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final GHMarkdownToHtmlConverter markdownConverter;
    @NotNull
    private static final String SUGGESTED_CHANGE_START_TAG = "<code class=\"language-suggestion\">";
    @NotNull
    private static final String SUGGESTED_CHANGE_END_TAG = "</code>";

    public GHPRReviewCommentComponentFactory(@NotNull Project project, @NotNull AsyncHtmlImageLoader htmlImageLoader) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)htmlImageLoader, (String)"htmlImageLoader");
        this.project = project;
        this.htmlImageLoader = htmlImageLoader;
        this.markdownConverter = new GHMarkdownToHtmlConverter(this.project);
    }

    @NotNull
    public final JComponent createCommentComponent(@NotNull String commentBody, int maxTextWidth) {
        Intrinsics.checkNotNullParameter((Object)commentBody, (String)"commentBody");
        String htmlBody = this.markdownConverter.convertMarkdown(commentBody);
        return this.createCommentPane(htmlBody, maxTextWidth);
    }

    @NotNull
    public final JComponent createCommentWithSuggestedChangeComponent(@NotNull GHPRReviewThreadModel thread, @NotNull GHSuggestedChange suggestedChange, @NotNull GHPRSuggestedChangeHelper suggestedChangeHelper, int maxTextWidth) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)suggestedChange, (String)"suggestedChange");
        Intrinsics.checkNotNullParameter((Object)suggestedChangeHelper, (String)"suggestedChangeHelper");
        String htmlBody = this.markdownConverter.convertMarkdownWithSuggestedChange(suggestedChange);
        String content2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)htmlBody, (CharSequence)"<body>"), (CharSequence)"</body>");
        List<CommentBlock> commentBlocks = Companion.collectCommentBlocks(content2);
        GHSuggestedChangeApplier suggestedChangeApplier = new GHSuggestedChangeApplier(this.project, suggestedChangeHelper.getRepository(), suggestedChange);
        GHPRReviewSuggestedChangeComponentFactory suggestedChangeComponent = new GHPRReviewSuggestedChangeComponentFactory(this.project, thread, suggestedChangeApplier, suggestedChangeHelper);
        JPanel $this$createCommentWithSuggestedChangeComponent_u24lambda_u241 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        boolean bl = false;
        Iterable $this$forEach$iv = commentBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommentBlock block = (CommentBlock)element$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[block.getCommentType().ordinal()]) {
                case 1: {
                    $this$createCommentWithSuggestedChangeComponent_u24lambda_u241.add(this.createCommentPane(block.getContent(), maxTextWidth));
                    break;
                }
                case 2: {
                    $this$createCommentWithSuggestedChangeComponent_u24lambda_u241.add(suggestedChangeComponent.create(block.getContent()));
                }
            }
        }
        return jPanel;
    }

    private final JComponent createCommentPane(String htmlBody, int maxTextWidth) {
        JEditorPane jEditorPane;
        JEditorPane $this$createCommentPane_u24lambda_u242 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, (AsyncHtmlImageLoader)this.htmlImageLoader, null, (int)11, null);
        boolean bl = false;
        HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)$this$createCommentPane_u24lambda_u242, (String)htmlBody);
        JEditorPane it = jEditorPane;
        boolean bl2 = false;
        return CollaborationToolsUIUtil.wrapWithLimitedSize$default((CollaborationToolsUIUtil)CollaborationToolsUIUtil.INSTANCE, (JComponent)it, (Integer)maxTextWidth, null, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentBlock;", "", "commentType", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;", "content", "", "(Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;Ljava/lang/String;)V", "getCommentType", "()Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;", "getContent", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.github"})
    @VisibleForTesting
    public static final class CommentBlock {
        @NotNull
        private final CommentType commentType;
        @NotNull
        private final String content;

        public CommentBlock(@NotNull CommentType commentType, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)((Object)commentType), (String)"commentType");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.commentType = commentType;
            this.content = content2;
        }

        @NotNull
        public final CommentType getCommentType() {
            return this.commentType;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @NotNull
        public final CommentType component1() {
            return this.commentType;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @NotNull
        public final CommentBlock copy(@NotNull CommentType commentType, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)((Object)commentType), (String)"commentType");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new CommentBlock(commentType, content2);
        }

        public static /* synthetic */ CommentBlock copy$default(CommentBlock commentBlock, CommentType commentType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                commentType = commentBlock.commentType;
            }
            if ((n & 2) != 0) {
                string = commentBlock.content;
            }
            return commentBlock.copy(commentType, string);
        }

        @NotNull
        public String toString() {
            return "CommentBlock(commentType=" + this.commentType + ", content=" + this.content + ")";
        }

        public int hashCode() {
            int result = this.commentType.hashCode();
            result = result * 31 + this.content.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommentBlock)) {
                return false;
            }
            CommentBlock commentBlock = (CommentBlock)other;
            if (this.commentType != commentBlock.commentType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.content, (Object)commentBlock.content);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;", "", "(Ljava/lang/String;I)V", "COMMENT", "SUGGESTED_CHANGE", "intellij.vcs.github"})
    @VisibleForTesting
    public static final class CommentType
    extends Enum<CommentType> {
        public static final /* enum */ CommentType COMMENT = new CommentType();
        public static final /* enum */ CommentType SUGGESTED_CHANGE = new CommentType();
        private static final /* synthetic */ CommentType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CommentType[] values() {
            return (CommentType[])$VALUES.clone();
        }

        public static CommentType valueOf(String value) {
            return Enum.valueOf(CommentType.class, value);
        }

        @NotNull
        public static EnumEntries<CommentType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = commentTypeArray = new CommentType[]{CommentType.COMMENT, CommentType.SUGGESTED_CHANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$Companion;", "", "()V", "SUGGESTED_CHANGE_END_TAG", "", "SUGGESTED_CHANGE_START_TAG", "collectCommentBlockRanges", "", "Lkotlin/ranges/IntRange;", "comment", "collectCommentBlocks", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentBlock;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGHPRReviewCommentComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRReviewCommentComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n3464#2,10:113\n*S KotlinDebug\n*F\n+ 1 GHPRReviewCommentComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$Companion\n*L\n109#1:113,10\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final List<CommentBlock> collectCommentBlocks(@NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            List<IntRange> commentBlockRanges = this.collectCommentBlockRanges(comment);
            boolean isSuggestedChange = false;
            List result = new ArrayList();
            for (IntRange range : commentBlockRanges) {
                if (range.getLast() > range.getFirst()) {
                    CommentBlock commentBlock;
                    if (isSuggestedChange) {
                        String string = comment.substring(range.getFirst(), range.getLast());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        commentBlock = new CommentBlock(CommentType.SUGGESTED_CHANGE, string);
                    } else {
                        String string = comment.substring(range.getFirst(), range.getLast());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        commentBlock = new CommentBlock(CommentType.COMMENT, string);
                    }
                    CommentBlock commentBlock2 = commentBlock;
                    result.add(commentBlock2);
                }
                isSuggestedChange = !isSuggestedChange;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IntRange> collectCommentBlockRanges(String comment) {
            List list;
            Object[] objectArray = new Integer[]{0};
            List indexes = CollectionsKt.mutableListOf((Object[])objectArray);
            int startIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_START_TAG, (int)0, (boolean)false, (int)6, null);
            int endIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_END_TAG, (int)0, (boolean)false, (int)6, null) + 7;
            while (startIndex >= 0) {
                indexes.add(startIndex);
                indexes.add(endIndex);
                startIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_START_TAG, (int)(startIndex + 1), (boolean)false, (int)4, null);
                endIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_END_TAG, (int)(endIndex + 1), (boolean)false, (int)4, null) + 7;
            }
            indexes.add(comment.length());
            Iterable $this$zipWithNext$iv = indexes;
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                list = CollectionsKt.emptyList();
            } else {
                List result$iv = new ArrayList();
                Object current$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void end;
                    void start;
                    Object next$iv = iterator$iv.next();
                    int n = ((Number)next$iv).intValue();
                    int n2 = ((Number)current$iv).intValue();
                    List list2 = result$iv;
                    boolean bl = false;
                    list2.add(new IntRange((int)start, (int)end));
                    current$iv = next$iv;
                }
                list = result$iv;
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommentType.values().length];
            try {
                nArray[CommentType.COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommentType.SUGGESTED_CHANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

