/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.config;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountSerializer;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;

@Service(value={Service.Level.PROJECT})
@State(name="GithubPullRequestsUISettings", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=false)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR@\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$SettingsState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "recentNewPullRequestHead", "getRecentNewPullRequestHead", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "setRecentNewPullRequestHead", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "selectedRepoAndAccount", "getSelectedRepoAndAccount", "()Lkotlin/Pair;", "setSelectedRepoAndAccount", "(Lkotlin/Pair;)V", "state", "getState", "getStateModificationCount", "", "loadState", "", "Companion", "SettingsState", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubPullRequestsProjectUISettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubPullRequestsProjectUISettings.kt\norg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n30#2,3:88\n1#3:91\n*S KotlinDebug\n*F\n+ 1 GithubPullRequestsProjectUISettings.kt\norg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings\n*L\n30#1:88,3\n*E\n"})
public final class GithubPullRequestsProjectUISettings
implements PersistentStateComponentWithModificationTracker<SettingsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private SettingsState state;

    public GithubPullRequestsProjectUISettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = new SettingsState();
    }

    @Nullable
    public final Pair<GHGitRepositoryMapping, GithubAccount> getSelectedRepoAndAccount() {
        Object object;
        String accountId;
        block5: {
            Companion.UrlAndAccount urlAndAccount = this.state.getSelectedUrlAndAccountId();
            if (urlAndAccount == null) {
                return null;
            }
            Companion.UrlAndAccount urlAndAccount2 = urlAndAccount;
            String url = urlAndAccount2.component1();
            accountId = urlAndAccount2.component2();
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<GHHostedRepositoriesManager> serviceClass$iv = GHHostedRepositoriesManager.class;
            Object object22 = $this$service$iv.getService(serviceClass$iv);
            if (object22 == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            Iterable iterable = HostedGitRepositoriesManagerKt.getKnownRepositories((HostedGitRepositoriesManager)((HostedGitRepositoriesManager)object22));
            for (Object object22 : iterable) {
                GHGitRepositoryMapping it = (GHGitRepositoryMapping)object22;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRemote().getUrl(), (Object)url)) continue;
                object = object22;
                break block5;
            }
            object = null;
        }
        GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)object;
        if (gHGitRepositoryMapping == null) {
            return null;
        }
        GHGitRepositoryMapping repo = gHGitRepositoryMapping;
        GithubAccount githubAccount = GHAccountSerializer.INSTANCE.deserialize(accountId);
        if (githubAccount == null) {
            return null;
        }
        GithubAccount account = githubAccount;
        return TuplesKt.to((Object)repo, (Object)((Object)account));
    }

    public final void setSelectedRepoAndAccount(@Nullable Pair<GHGitRepositoryMapping, GithubAccount> value) {
        Companion.UrlAndAccount urlAndAccount;
        SettingsState settingsState = this.state;
        Pair<GHGitRepositoryMapping, GithubAccount> pair = value;
        if (pair != null) {
            Pair<GHGitRepositoryMapping, GithubAccount> pair2 = pair;
            SettingsState settingsState2 = settingsState;
            boolean bl = false;
            GHGitRepositoryMapping repo = (GHGitRepositoryMapping)pair2.component1();
            GithubAccount account = (GithubAccount)((Object)pair2.component2());
            urlAndAccount = new Companion.UrlAndAccount(repo.getRemote().getUrl(), GHAccountSerializer.INSTANCE.serialize(account));
            settingsState = settingsState2;
        } else {
            urlAndAccount = null;
        }
        settingsState.setSelectedUrlAndAccountId(urlAndAccount);
    }

    @Nullable
    public final GHRepositoryCoordinates getRecentNewPullRequestHead() {
        GHRepositoryCoordinates gHRepositoryCoordinates;
        Companion.RepoCoordinatesHolder repoCoordinatesHolder = this.state.getRecentNewPullRequestHead();
        if (repoCoordinatesHolder != null) {
            Companion.RepoCoordinatesHolder it = repoCoordinatesHolder;
            boolean bl = false;
            gHRepositoryCoordinates = new GHRepositoryCoordinates(it.getServer(), new GHRepositoryPath(it.getOwner(), it.getRepository()));
        } else {
            gHRepositoryCoordinates = null;
        }
        return gHRepositoryCoordinates;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRecentNewPullRequestHead(@Nullable GHRepositoryCoordinates value) {
        Companion.RepoCoordinatesHolder repoCoordinatesHolder;
        SettingsState settingsState = this.state;
        GHRepositoryCoordinates gHRepositoryCoordinates = value;
        if (gHRepositoryCoordinates != null) {
            void it;
            GHRepositoryCoordinates gHRepositoryCoordinates2 = gHRepositoryCoordinates;
            SettingsState settingsState2 = settingsState;
            boolean bl = false;
            repoCoordinatesHolder = new Companion.RepoCoordinatesHolder((GHRepositoryCoordinates)it);
            settingsState = settingsState2;
        } else {
            repoCoordinatesHolder = null;
        }
        settingsState.setRecentNewPullRequestHead(repoCoordinatesHolder);
    }

    public long getStateModificationCount() {
        return this.state.getModificationCount();
    }

    @NotNull
    public SettingsState getState() {
        return this.state;
    }

    public void loadState(@NotNull SettingsState state2) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        this.state = state2;
    }

    @JvmStatic
    @NotNull
    public static final GithubPullRequestsProjectUISettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "project", "Lcom/intellij/openapi/project/Project;", "RepoCoordinatesHolder", "UrlAndAccount", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGithubPullRequestsProjectUISettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubPullRequestsProjectUISettings.kt\norg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,87:1\n30#2,3:88\n*S KotlinDebug\n*F\n+ 1 GithubPullRequestsProjectUISettings.kt\norg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion\n*L\n56#1:88,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GithubPullRequestsProjectUISettings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GithubPullRequestsProjectUISettings> serviceClass$iv = GithubPullRequestsProjectUISettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (GithubPullRequestsProjectUISettings)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$RepoCoordinatesHolder;", "", "coordinates", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "()V", "owner", "", "getOwner", "()Ljava/lang/String;", "setOwner", "(Ljava/lang/String;)V", "repository", "getRepository", "setRepository", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getServer", "()Lorg/jetbrains/plugins/github/api/GithubServerPath;", "setServer", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;)V", "intellij.vcs.github"})
        public static final class RepoCoordinatesHolder {
            @NotNull
            private GithubServerPath server;
            @NotNull
            private String owner;
            @NotNull
            private String repository;

            private RepoCoordinatesHolder() {
                GithubServerPath githubServerPath = GithubServerPath.DEFAULT_SERVER;
                Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"DEFAULT_SERVER");
                this.server = githubServerPath;
                this.owner = "";
                this.repository = "";
            }

            @NotNull
            public final GithubServerPath getServer() {
                return this.server;
            }

            public final void setServer(@NotNull GithubServerPath githubServerPath) {
                Intrinsics.checkNotNullParameter((Object)githubServerPath, (String)"<set-?>");
                this.server = githubServerPath;
            }

            @NotNull
            public final String getOwner() {
                return this.owner;
            }

            public final void setOwner(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.owner = string;
            }

            @NotNull
            public final String getRepository() {
                return this.repository;
            }

            public final void setRepository(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.repository = string;
            }

            public RepoCoordinatesHolder(@NotNull GHRepositoryCoordinates coordinates) {
                Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
                this();
                this.server = coordinates.getServerPath();
                this.owner = coordinates.getRepositoryPath().getOwner();
                this.repository = coordinates.getRepositoryPath().getRepository();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u0086\u0002R \u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0006\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0006\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$UrlAndAccount;", "", "url", "", "accountId", "(Ljava/lang/String;Ljava/lang/String;)V", "()V", "getAccountId$annotations", "getAccountId", "()Ljava/lang/String;", "setAccountId", "(Ljava/lang/String;)V", "getUrl$annotations", "getUrl", "setUrl", "component1", "component2", "intellij.vcs.github"})
        public static final class UrlAndAccount {
            @NotNull
            private String url;
            @NotNull
            private String accountId;

            private UrlAndAccount() {
                this.url = "";
                this.accountId = "";
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            public final void setUrl(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.url = string;
            }

            public static /* synthetic */ void getUrl$annotations() {
            }

            @NotNull
            public final String getAccountId() {
                return this.accountId;
            }

            public final void setAccountId(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.accountId = string;
            }

            public static /* synthetic */ void getAccountId$annotations() {
            }

            public UrlAndAccount(@NotNull String url, @NotNull String accountId) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
                this();
                this.url = url;
                this.accountId = accountId;
            }

            @NotNull
            public final String component1() {
                return this.url;
            }

            @NotNull
            public final String component2() {
                return this.accountId;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR/\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$SettingsState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$RepoCoordinatesHolder;", "recentNewPullRequestHead", "getRecentNewPullRequestHead", "()Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$RepoCoordinatesHolder;", "setRecentNewPullRequestHead", "(Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$RepoCoordinatesHolder;)V", "recentNewPullRequestHead$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$UrlAndAccount;", "selectedUrlAndAccountId", "getSelectedUrlAndAccountId", "()Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$UrlAndAccount;", "setSelectedUrlAndAccountId", "(Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$UrlAndAccount;)V", "selectedUrlAndAccountId$delegate", "intellij.vcs.github"})
    public static final class SettingsState
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty selectedUrlAndAccountId$delegate = this.property(null, selectedUrlAndAccountId.2.INSTANCE).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty recentNewPullRequestHead$delegate = this.property(null, recentNewPullRequestHead.2.INSTANCE).provideDelegate((Object)this, $$delegatedProperties[1]);

        @Nullable
        public final Companion.UrlAndAccount getSelectedUrlAndAccountId() {
            return (Companion.UrlAndAccount)this.selectedUrlAndAccountId$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setSelectedUrlAndAccountId(@Nullable Companion.UrlAndAccount urlAndAccount) {
            this.selectedUrlAndAccountId$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)urlAndAccount);
        }

        @Nullable
        public final Companion.RepoCoordinatesHolder getRecentNewPullRequestHead() {
            return (Companion.RepoCoordinatesHolder)this.recentNewPullRequestHead$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setRecentNewPullRequestHead(@Nullable Companion.RepoCoordinatesHolder repoCoordinatesHolder) {
            this.recentNewPullRequestHead$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)repoCoordinatesHolder);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SettingsState.class, "selectedUrlAndAccountId", "getSelectedUrlAndAccountId()Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$UrlAndAccount;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SettingsState.class, "recentNewPullRequestHead", "getRecentNewPullRequestHead()Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings$Companion$RepoCoordinatesHolder;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

