/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.editor;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.CoroutinesKt;
import icons.CollaborationToolsIcons;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.mergerequest.ui.editor.GitLabMergeRequestDiscussionInlayRenderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u00012BN\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\r\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\b\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J \u0010'\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J \u0010(\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010)\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\bH\u0002J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0002J\f\u00100\u001a\u00020\u0012*\u000201H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "Lcom/intellij/openapi/editor/markup/ActiveGutterRenderer;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "nonCommentableRanges", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/diff/util/LineRange;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "requestNewDiscussion", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "lineIdx", "", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/flow/StateFlow;Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlin/jvm/functions/Function1;)V", "hoverHandler", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion$HoverHandler;", "canDoAction", "", "Lcom/intellij/openapi/editor/Editor;", "e", "Ljava/awt/event/MouseEvent;", "doAction", "getHoveredIconSlotIndex", "range", "Lkotlin/ranges/IntRange;", "y", "getPosition", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "paint", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "paintCommentIcons", "paintNewCommentIcon", "toggleDiscussions", "renderers", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestDiscussionInlayRenderer;", "unfoldOrRequestNewDiscussion", "lineData", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion$LogicalLineData;", "unfoldOrToggle", "unfold", "Lcom/intellij/openapi/editor/FoldRegion;", "Companion", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestReviewControlsGutterRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestReviewControlsGutterRenderer.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1549#2:316\n1620#2,3:317\n1855#2,2:320\n1747#2,3:322\n1855#2,2:325\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestReviewControlsGutterRenderer.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer\n*L\n75#1:316\n75#1:317,3\n75#1:320,2\n173#1:322,3\n174#1:325,2\n*E\n"})
public final class GitLabMergeRequestReviewControlsGutterRenderer
implements LineMarkerRenderer,
LineMarkerRendererEx,
ActiveGutterRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Function1<Integer, Unit> requestNewDiscussion;
    @NotNull
    private final Companion.HoverHandler hoverHandler;
    private static final int ICON_AREA_WIDTH = 16;

    private GitLabMergeRequestReviewControlsGutterRenderer(CoroutineScope cs, StateFlow<? extends List<? extends LineRange>> nonCommentableRanges, EditorEx editor, Function1<? super Integer, Unit> requestNewDiscussion2) {
        this.editor = editor;
        this.requestNewDiscussion = requestNewDiscussion2;
        this.hoverHandler = new Companion.HoverHandler(this.editor);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable areaDisposable = disposable;
        this.editor.getGutterComponentEx().reserveLeftFreePaintersAreaWidth(areaDisposable, 16);
        this.editor.addEditorMouseListener((EditorMouseListener)this.hoverHandler);
        this.editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.hoverHandler);
        CoroutineUtilKt.launchNow$default((CoroutineScope)cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(nonCommentableRanges, this, null){
            int label;
            final /* synthetic */ StateFlow<List<LineRange>> $nonCommentableRanges;
            final /* synthetic */ GitLabMergeRequestReviewControlsGutterRenderer this$0;
            {
                this.$nonCommentableRanges = $nonCommentableRanges;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$nonCommentableRanges.collect(new FlowCollector(){

                            @Nullable
                            public final Object emit(@NotNull List<? extends LineRange> it, @NotNull Continuation<? super Unit> $completion) {
                                this$0.hoverHandler.setNonCommentableRanges(it);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, areaDisposable, null){
            int label;
            final /* synthetic */ GitLabMergeRequestReviewControlsGutterRenderer this$0;
            final /* synthetic */ Disposable $areaDisposable;
            {
                this.this$0 = $receiver;
                this.$areaDisposable = $areaDisposable;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.editor.removeEditorMouseListener((EditorMouseListener)this.this$0.hoverHandler);
                        this.this$0.editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this.this$0.hoverHandler);
                        Disposer.dispose((Disposable)this.$areaDisposable);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.paintCommentIcons(editor, g, r);
        this.paintNewCommentIcon(editor, g, r);
    }

    /*
     * WARNING - void declaration
     */
    private final void paintCommentIcons(Editor editor, Graphics g, Rectangle r) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list = editor.getInlayModel().getBlockElementsInRange(0, editor.getDocument().getTextLength(), GitLabMergeRequestDiscussionInlayRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Inlay inlay = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(editor.getDocument().getLineNumber(it.getOffset()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Icon icon;
            int lineIdx = ((Number)element$iv).intValue();
            boolean bl = false;
            Interval yRange2 = (Interval)EditorUtil.logicalLineToYRange((Editor)editor, (int)lineIdx).first;
            int lineCenter = yRange2.intervalStart() + editor.getLineHeight() / 2;
            Intrinsics.checkNotNullExpressionValue((Object)CollaborationToolsIcons.Comment, (String)"Comment");
            int y = lineCenter - icon.getIconWidth() / 2;
            icon.paintIcon(null, g, r.x, y);
        }
    }

    private final void paintNewCommentIcon(Editor editor, Graphics g, Rectangle r) {
        int yShift;
        Companion.LogicalLineData logicalLineData = this.hoverHandler.calcHoveredLineData();
        if (logicalLineData == null) {
            return;
        }
        Companion.LogicalLineData lineData = logicalLineData;
        if (!lineData.getCommentable()) {
            return;
        }
        int n = yShift = lineData.getHasComments() ? editor.getLineHeight() : 0;
        if (yShift > 0 && lineData.getYRangeWithInlays().getLast() - lineData.getYRangeWithInlays().getFirst() < yShift + editor.getLineHeight()) {
            return;
        }
        Icon icon = lineData.getColumnHovered() ? AllIcons.General.InlineAddHover : AllIcons.General.InlineAdd;
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        int y = lineData.getYRangeWithInlays().getFirst() + yShift + (editor.getLineHeight() - icon2.getIconHeight()) / 2;
        icon2.paintIcon(null, g, r.x, y);
    }

    public boolean canDoAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Companion.LogicalLineData logicalLineData = this.hoverHandler.calcHoveredLineData();
        if (logicalLineData == null) {
            return false;
        }
        Companion.LogicalLineData lineData = logicalLineData;
        if (!lineData.getColumnHovered()) {
            return false;
        }
        if (!lineData.getHasComments() && !lineData.getCommentable()) {
            return false;
        }
        int actionableHeight = 0;
        if (lineData.getHasComments()) {
            actionableHeight += editor.getLineHeight();
        }
        if (lineData.getCommentable()) {
            actionableHeight += editor.getLineHeight();
        }
        IntRange yRange2 = lineData.getYRangeWithInlays();
        int actionableYStart = yRange2.getFirst();
        int actionableYEnd = Math.min(yRange2.getFirst() + actionableHeight, yRange2.getLast());
        int n = e.getY();
        return actionableYStart <= n ? n <= actionableYEnd : false;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        block11: {
            Companion.LogicalLineData lineData;
            block10: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Companion.LogicalLineData logicalLineData = this.hoverHandler.calcHoveredLineData();
                if (logicalLineData == null) {
                    return;
                }
                lineData = logicalLineData;
                if (!lineData.getColumnHovered()) {
                    return;
                }
                if (!lineData.getHasComments() || !lineData.getCommentable()) break block10;
                int hoveredIconIdx = this.getHoveredIconSlotIndex(lineData.getYRangeWithInlays(), e.getY());
                switch (hoveredIconIdx) {
                    case 0: {
                        this.unfoldOrToggle(lineData);
                        break block11;
                    }
                    case 1: {
                        this.unfoldOrRequestNewDiscussion(lineData);
                        break block11;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (lineData.getHasComments()) {
                this.unfoldOrToggle(lineData);
            } else if (lineData.getCommentable()) {
                this.unfoldOrRequestNewDiscussion(lineData);
            } else {
                return;
            }
        }
        e.consume();
    }

    private final int getHoveredIconSlotIndex(IntRange range, int y) {
        if (y < range.getFirst()) {
            return -1;
        }
        int idx = -1;
        int n = range.getFirst() + this.editor.getLineHeight();
        int n2 = range.getLast();
        int n3 = this.editor.getLineHeight();
        if (n3 <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + n3 + ".");
        }
        int slotEnd = n;
        int n4 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)n2, (int)n3);
        int n5 = n3;
        if (slotEnd <= n4) {
            while (true) {
                ++idx;
                if (y < slotEnd || slotEnd == n4) break;
                slotEnd += n5;
            }
        }
        return idx;
    }

    private final void unfoldOrRequestNewDiscussion(Companion.LogicalLineData lineData) {
        FoldRegion foldedRegion2;
        FoldRegion foldRegion = foldedRegion2 = lineData.getFoldedRegion();
        if (foldRegion != null) {
            this.unfold(foldRegion);
        } else {
            this.requestNewDiscussion.invoke((Object)lineData.getLogicalLine());
        }
    }

    private final void unfoldOrToggle(Companion.LogicalLineData lineData) {
        FoldRegion foldedRegion2;
        FoldRegion foldRegion = foldedRegion2 = lineData.getFoldedRegion();
        if (foldRegion != null) {
            this.unfold(foldRegion);
        } else {
            this.toggleDiscussions(lineData.getDiscussionRenderers());
        }
    }

    private final void unfold(FoldRegion $this$unfold) {
        if ($this$unfold instanceof CustomFoldRegion) {
            CustomFoldRegionRenderer customFoldRegionRenderer = ((CustomFoldRegion)$this$unfold).getRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)customFoldRegionRenderer, (String)"getRenderer(...)");
            CustomFoldRegionRenderer renderer = customFoldRegionRenderer;
            if (renderer instanceof DocRenderer) {
                ((DocRenderer)renderer).getItem().toggle();
                return;
            }
        } else {
            $this$unfold.getEditor().getFoldingModel().runBatchFoldingOperation(() -> GitLabMergeRequestReviewControlsGutterRenderer.unfold$lambda$2($this$unfold));
        }
    }

    private final void toggleDiscussions(List<GitLabMergeRequestDiscussionInlayRenderer> renderers) {
        GitLabMergeRequestDiscussionInlayRenderer it;
        boolean bl;
        block4: {
            Iterable $this$any$iv = renderers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (GitLabMergeRequestDiscussionInlayRenderer)((Object)element$iv);
                    boolean bl2 = false;
                    if (!it.isVisible()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean hideAll = bl;
        Iterable $this$forEach$iv = renderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GitLabMergeRequestDiscussionInlayRenderer)((Object)element$iv);
            boolean bl3 = false;
            it.setVisible(!hideAll);
        }
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.LEFT;
    }

    private static final void unfold$lambda$2(FoldRegion $this_unfold) {
        Intrinsics.checkNotNullParameter((Object)$this_unfold, (String)"$this_unfold");
        $this_unfold.setExpanded(true);
    }

    public /* synthetic */ GitLabMergeRequestReviewControlsGutterRenderer(CoroutineScope cs, StateFlow nonCommentableRanges, EditorEx editor, Function1 requestNewDiscussion2, DefaultConstructorMarker $constructor_marker) {
        this(cs, (StateFlow<? extends List<? extends LineRange>>)nonCommentableRanges, editor, (Function1<? super Integer, Unit>)requestNewDiscussion2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JM\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00060\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion;", "", "()V", "ICON_AREA_WIDTH", "", "setupIn", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "nonCommentableRanges", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/diff/util/LineRange;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "requestNewDiscussion", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "lineIdx", "HoverHandler", "LogicalLineData", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        public final void setupIn(@NotNull CoroutineScope cs, @NotNull StateFlow<? extends List<? extends LineRange>> nonCommentableRanges, @NotNull EditorEx editor, @NotNull Function1<? super Integer, Unit> requestNewDiscussion2) {
            RangeHighlighter rangeHighlighter;
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            Intrinsics.checkNotNullParameter(nonCommentableRanges, (String)"nonCommentableRanges");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(requestNewDiscussion2, (String)"requestNewDiscussion");
            GitLabMergeRequestReviewControlsGutterRenderer renderer = new GitLabMergeRequestReviewControlsGutterRenderer(cs, nonCommentableRanges, editor, requestNewDiscussion2, null);
            RangeHighlighter $this$setupIn_u24lambda_u240 = rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(null, 0, editor.getDocument().getTextLength(), 5999, HighlighterTargetArea.LINES_IN_RANGE);
            boolean bl = false;
            $this$setupIn_u24lambda_u240.setGreedyToLeft(true);
            $this$setupIn_u24lambda_u240.setGreedyToRight(true);
            $this$setupIn_u24lambda_u240.setLineMarkerRenderer((LineMarkerRenderer)renderer);
            RangeHighlighter rangeHighlighter2 = rangeHighlighter;
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"apply(...)");
            RangeHighlighter highlighter = rangeHighlighter2;
            CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(highlighter, null){
                int label;
                final /* synthetic */ RangeHighlighter $highlighter;
                {
                    this.$highlighter = $highlighter;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$highlighter.dispose();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020 H\u0016J\u0019\u0010\"\u001a\u00020\u001f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR7\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion$HoverHandler;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "columnHovered", "", "hoveredLogicalLine", "", "Ljava/lang/Integer;", "<set-?>", "", "Lcom/intellij/diff/util/LineRange;", "nonCommentableRanges", "getNonCommentableRanges", "()Ljava/util/List;", "setNonCommentableRanges", "(Ljava/util/List;)V", "nonCommentableRanges$delegate", "Lkotlin/properties/ReadWriteProperty;", "calcHoveredLineData", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion$LogicalLineData;", "convertX", "x", "getIconColumnXRange", "Lkotlin/ranges/IntRange;", "isIconColumnHovered", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseMoved", "repaintColumn", "line", "(Ljava/lang/Integer;)V", "intellij.vcs.gitlab"})
        @SourceDebugExtension(value={"SMAP\nGitLabMergeRequestReviewControlsGutterRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestReviewControlsGutterRenderer.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion$HoverHandler\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n33#2,3:316\n1#3:319\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestReviewControlsGutterRenderer.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion$HoverHandler\n*L\n235#1:316,3\n*E\n"})
        private static final class HoverHandler
        implements EditorMouseListener,
        EditorMouseMotionListener {
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            @NotNull
            private final EditorEx editor;
            @Nullable
            private Integer hoveredLogicalLine;
            private boolean columnHovered;
            @NotNull
            private final ReadWriteProperty nonCommentableRanges$delegate;

            public HoverHandler(@NotNull EditorEx editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.editor = editor;
                Delegates delegates = Delegates.INSTANCE;
                List initialValue$iv = CollectionsKt.emptyList();
                boolean $i$f$observable = false;
                this.nonCommentableRanges$delegate = (ReadWriteProperty)new ObservableProperty<List<? extends LineRange>>((Object)initialValue$iv, this){
                    final /* synthetic */ HoverHandler this$0;
                    {
                        this.this$0 = hoverHandler;
                        super($initialValue);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                        List cfr_ignored_0 = (List)newValue;
                        List cfr_ignored_1 = (List)oldValue;
                        boolean bl = false;
                        HoverHandler.access$setHoveredLogicalLine$p(this.this$0, null);
                        HoverHandler.access$setColumnHovered$p(this.this$0, false);
                        HoverHandler.repaintColumn$default(this.this$0, null, 1, null);
                    }
                };
            }

            @NotNull
            public final List<LineRange> getNonCommentableRanges() {
                return (List)this.nonCommentableRanges$delegate.getValue((Object)this, $$delegatedProperties[0]);
            }

            public final void setNonCommentableRanges(@NotNull List<? extends LineRange> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.nonCommentableRanges$delegate.setValue((Object)this, $$delegatedProperties[0], list);
            }

            @Nullable
            public final LogicalLineData calcHoveredLineData() {
                Integer n;
                block4: {
                    block3: {
                        n = this.hoveredLogicalLine;
                        if (n == null) break block3;
                        Integer n2 = n;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        n = (0 <= it ? it < this.editor.getDocument().getLineCount() : false) ? n2 : null;
                        if (n != null) break block4;
                    }
                    return null;
                }
                int logicalLine = n;
                return new LogicalLineData(this.editor, this.getNonCommentableRanges(), logicalLine, this.columnHovered);
            }

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                int line2;
                Integer prevLine;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Integer n = this.hoveredLogicalLine;
                Integer n2 = prevLine = n == null || (line2 = RangesKt.coerceAtLeast((int)e.getLogicalPosition().line, (int)0)) != n ? this.hoveredLogicalLine : null;
                this.hoveredLogicalLine = (0 <= line2 ? line2 < DiffUtil.getLineCount((Document)((Document)this.editor.getDocument())) : false) ? Integer.valueOf(line2) : null;
                MouseEvent mouseEvent = e.getMouseEvent();
                Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                this.columnHovered = this.isIconColumnHovered(this.editor, mouseEvent);
                if (prevLine != null) {
                    this.repaintColumn(prevLine);
                }
                this.repaintColumn(e.getLogicalPosition().line);
            }

            public void mouseExited(@NotNull EditorMouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.repaintColumn(this.hoveredLogicalLine);
                this.hoveredLogicalLine = null;
                this.columnHovered = false;
            }

            private final void repaintColumn(Integer line2) {
                IntRange intRange;
                IntRange xRange = this.getIconColumnXRange(this.editor);
                if (line2 != null && line2 > 0) {
                    int y = this.editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line2.intValue(), (int)0)).y;
                    intRange = new IntRange(y, y + this.editor.getLineHeight());
                } else {
                    intRange = new IntRange(0, this.editor.getGutterComponentEx().getHeight());
                }
                IntRange yRange2 = intRange;
                this.editor.getGutterComponentEx().repaint(xRange.getFirst(), yRange2.getFirst(), xRange.getLast() - xRange.getFirst(), yRange2.getLast());
            }

            static /* synthetic */ void repaintColumn$default(HoverHandler hoverHandler, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = null;
                }
                hoverHandler.repaintColumn(n);
            }

            private final boolean isIconColumnHovered(EditorEx editor, MouseEvent e) {
                if (e.getComponent() != editor.getGutter()) {
                    return false;
                }
                int x = this.convertX(editor, e.getX());
                IntRange intRange = this.getIconColumnXRange(editor);
                int n = intRange.getFirst();
                return x <= intRange.getLast() ? n <= x : false;
            }

            private final IntRange getIconColumnXRange(EditorEx editor) {
                int iconStart = editor.getGutterComponentEx().getLineMarkerAreaOffset();
                int iconEnd = iconStart + 16;
                return RangesKt.until((int)iconStart, (int)iconEnd);
            }

            private final int convertX(EditorEx editor, int x) {
                if (editor.getVerticalScrollbarOrientation() == 1) {
                    return x;
                }
                return editor.getGutterComponentEx().getWidth() - x;
            }

            public static final /* synthetic */ void access$setHoveredLogicalLine$p(HoverHandler $this, Integer n) {
                $this.hoveredLogicalLine = n;
            }

            public static final /* synthetic */ void access$setColumnHovered$p(HoverHandler $this, boolean bl) {
                $this.columnHovered = bl;
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HoverHandler.class, "nonCommentableRanges", "getNonCommentableRanges()Ljava/util/List;", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\rR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001d\u0010\rR\u000e\u0010\u001f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0011\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0011\u001a\u0004\b)\u0010&\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestReviewControlsGutterRenderer$Companion$LogicalLineData;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "nonCommentableRanges", "", "Lcom/intellij/diff/util/LineRange;", "logicalLine", "", "columnHovered", "", "(Lcom/intellij/openapi/editor/ex/EditorEx;Ljava/util/List;IZ)V", "getColumnHovered", "()Z", "commentable", "getCommentable", "commentable$delegate", "Lkotlin/Lazy;", "discussionRenderers", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/editor/GitLabMergeRequestDiscussionInlayRenderer;", "getDiscussionRenderers", "()Ljava/util/List;", "discussionRenderers$delegate", "foldedRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "getFoldedRegion", "()Lcom/intellij/openapi/editor/FoldRegion;", "foldedRegion$delegate", "hasComments", "getHasComments", "hasComments$delegate", "lineEndOffset", "lineStartOffset", "getLogicalLine", "()I", "yRange", "Lkotlin/ranges/IntRange;", "getYRange", "()Lkotlin/ranges/IntRange;", "yRange$delegate", "yRangeWithInlays", "getYRangeWithInlays", "yRangeWithInlays$delegate", "intellij.vcs.gitlab"})
        private static final class LogicalLineData {
            private final int logicalLine;
            private final boolean columnHovered;
            private final int lineStartOffset;
            private final int lineEndOffset;
            @NotNull
            private final Lazy yRange$delegate;
            @NotNull
            private final Lazy foldedRegion$delegate;
            @NotNull
            private final Lazy yRangeWithInlays$delegate;
            @NotNull
            private final Lazy discussionRenderers$delegate;
            @NotNull
            private final Lazy hasComments$delegate;
            @NotNull
            private final Lazy commentable$delegate;

            public LogicalLineData(@NotNull EditorEx editor, @NotNull List<? extends LineRange> nonCommentableRanges, int logicalLine, boolean columnHovered) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter(nonCommentableRanges, (String)"nonCommentableRanges");
                this.logicalLine = logicalLine;
                this.columnHovered = columnHovered;
                this.lineStartOffset = editor.getDocument().getLineStartOffset(this.logicalLine);
                this.lineEndOffset = editor.getDocument().getLineEndOffset(this.logicalLine);
                this.yRange$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IntRange>(editor, this){
                    final /* synthetic */ EditorEx $editor;
                    final /* synthetic */ LogicalLineData this$0;
                    {
                        this.$editor = $editor;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final IntRange invoke() {
                        int startVisualLine = this.$editor.offsetToVisualLine(LogicalLineData.access$getLineStartOffset$p(this.this$0), false);
                        int softWrapCount = this.$editor.getSoftWrapModel().getSoftWrapsForRange(LogicalLineData.access$getLineStartOffset$p(this.this$0) + 1, LogicalLineData.access$getLineEndOffset$p(this.this$0) - 1).size();
                        int endVisualLine = startVisualLine + softWrapCount;
                        int startY = this.$editor.visualLineToY(startVisualLine);
                        int endY = (endVisualLine == startVisualLine ? startY : this.$editor.visualLineToY(endVisualLine)) + this.$editor.getLineHeight();
                        return new IntRange(startY, endY);
                    }
                }));
                this.foldedRegion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FoldRegion>(editor, this){
                    final /* synthetic */ EditorEx $editor;
                    final /* synthetic */ LogicalLineData this$0;
                    {
                        this.$editor = $editor;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final FoldRegion invoke() {
                        return this.$editor.getFoldingModel().getCollapsedRegionAtOffset(LogicalLineData.access$getLineEndOffset$p(this.this$0));
                    }
                }));
                this.yRangeWithInlays$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IntRange>(editor, this){
                    final /* synthetic */ EditorEx $editor;
                    final /* synthetic */ LogicalLineData this$0;
                    {
                        this.$editor = $editor;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final IntRange invoke() {
                        int visualLine = this.$editor.offsetToVisualLine(LogicalLineData.access$getLineEndOffset$p(this.this$0), false);
                        int inlaysBelowHeight = 0;
                        List list = this.$editor.getInlayModel().getBlockElementsForVisualLine(visualLine, false);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsForVisualLine(...)");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Inlay it = (Inlay)element$iv;
                            boolean bl = false;
                            inlaysBelowHeight += it.getHeightInPixels();
                        }
                        return new IntRange(LogicalLineData.access$getYRange(this.this$0).getFirst(), LogicalLineData.access$getYRange(this.this$0).getLast() + RangesKt.coerceAtLeast((int)inlaysBelowHeight, (int)0));
                    }
                }));
                this.discussionRenderers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends GitLabMergeRequestDiscussionInlayRenderer>>(this, editor){
                    final /* synthetic */ LogicalLineData this$0;
                    final /* synthetic */ EditorEx $editor;
                    {
                        this.this$0 = $receiver;
                        this.$editor = $editor;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<GitLabMergeRequestDiscussionInlayRenderer> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        FoldRegion foldRegion = this.this$0.getFoldedRegion();
                        int rangeEnd = foldRegion != null ? foldRegion.getEndOffset() : LogicalLineData.access$getLineEndOffset$p(this.this$0);
                        List list = this.$editor.getInlayModel().getBlockElementsInRange(LogicalLineData.access$getLineStartOffset$p(this.this$0), rangeEnd);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
                        Iterable $this$mapNotNull$iv = list;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            GitLabMergeRequestDiscussionInlayRenderer it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            Inlay it = (Inlay)element$iv$iv;
                            boolean bl2 = false;
                            EditorCustomElementRenderer editorCustomElementRenderer = it.getRenderer();
                            if ((editorCustomElementRenderer instanceof GitLabMergeRequestDiscussionInlayRenderer ? (GitLabMergeRequestDiscussionInlayRenderer)editorCustomElementRenderer : null) == null) continue;
                            it$iv$iv = it$iv$iv;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }));
                this.hasComments$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this.getDiscussionRenderers()){

                    @NotNull
                    public final Boolean invoke() {
                        return !((Collection)this.receiver).isEmpty();
                    }
                }));
                this.commentable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(nonCommentableRanges, this){
                    final /* synthetic */ List<LineRange> $nonCommentableRanges;
                    final /* synthetic */ LogicalLineData this$0;
                    {
                        this.$nonCommentableRanges = $nonCommentableRanges;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke() {
                        boolean bl;
                        block3: {
                            void $this$none$iv;
                            Iterable iterable = this.$nonCommentableRanges;
                            LogicalLineData logicalLineData = this.this$0;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    LineRange it = (LineRange)element$iv;
                                    boolean bl2 = false;
                                    int n = it.start;
                                    int n2 = it.end;
                                    int n3 = logicalLineData.getLogicalLine();
                                    boolean bl3 = n <= n3 ? n3 < n2 : false;
                                    if (!bl3) continue;
                                    bl = false;
                                    break block3;
                                }
                                bl = true;
                            }
                        }
                        boolean inCommentableRange = bl;
                        return inCommentableRange;
                    }
                }));
            }

            public final int getLogicalLine() {
                return this.logicalLine;
            }

            public final boolean getColumnHovered() {
                return this.columnHovered;
            }

            private final IntRange getYRange() {
                Lazy lazy = this.yRange$delegate;
                return (IntRange)lazy.getValue();
            }

            @Nullable
            public final FoldRegion getFoldedRegion() {
                Lazy lazy = this.foldedRegion$delegate;
                return (FoldRegion)lazy.getValue();
            }

            @NotNull
            public final IntRange getYRangeWithInlays() {
                Lazy lazy = this.yRangeWithInlays$delegate;
                return (IntRange)lazy.getValue();
            }

            @NotNull
            public final List<GitLabMergeRequestDiscussionInlayRenderer> getDiscussionRenderers() {
                Lazy lazy = this.discussionRenderers$delegate;
                return (List)lazy.getValue();
            }

            public final boolean getHasComments() {
                Lazy lazy = this.hasComments$delegate;
                return (Boolean)lazy.getValue();
            }

            public final boolean getCommentable() {
                Lazy lazy = this.commentable$delegate;
                return (Boolean)lazy.getValue();
            }

            public static final /* synthetic */ int access$getLineStartOffset$p(LogicalLineData $this) {
                return $this.lineStartOffset;
            }

            public static final /* synthetic */ int access$getLineEndOffset$p(LogicalLineData $this) {
                return $this.lineEndOffset;
            }

            public static final /* synthetic */ IntRange access$getYRange(LogicalLineData $this) {
                return $this.getYRange();
            }
        }
    }
}

