/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.Glob;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0019\u0010\u0007\u001a\u00130\b\u00a2\u0006\u000e\b\t\u0012\n\b\n\u0012\u0006\b\n0\u000b8\fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "ChooseFileAction", "Handler", "SectionLineMarkerInfo", "intellij.editorconfig"})
public final class EditorConfigPreviewMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return EditorConfigBundle.message("line.marker.name.code.preview");
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof EditorConfigHeader && Handler.INSTANCE.isEditorConfigEnabled(element)) {
            ActionGroup actionGroup = Handler.INSTANCE.createActions((EditorConfigHeader)element);
            PsiElement child = element.getFirstChild();
            if (child != null && child.getNode().getElementType() == EditorConfigElementTypes.L_BRACKET) {
                TextRange textRange = element.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return new SectionLineMarkerInfo(actionGroup, child, textRange, null);
            }
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$ChooseFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myHeader", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "(Lorg/editorconfig/language/psi/EditorConfigHeader;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.editorconfig"})
    private static final class ChooseFileAction
    extends DumbAwareAction {
        @NotNull
        private final EditorConfigHeader myHeader;

        public ChooseFileAction(@NotNull EditorConfigHeader myHeader) {
            Intrinsics.checkNotNullParameter((Object)myHeader, (String)"myHeader");
            super(EditorConfigBundle.message("editor.preview.open"));
            this.myHeader = myHeader;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.myHeader.isValid()) {
                Project project = this.myHeader.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                VirtualFile virtualFile = Handler.INSTANCE.getRootDir(this.myHeader);
                String string = this.myHeader.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                VirtualFile previewFile = Handler.INSTANCE.choosePreviewFile(project, virtualFile, Handler.INSTANCE.getPattern(string));
                if (previewFile != null) {
                    VirtualFile editorConfigFile = this.myHeader.getContainingFile().getVirtualFile();
                    Project project2 = this.myHeader.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    Intrinsics.checkNotNull((Object)editorConfigFile);
                    Handler.INSTANCE.openPreview(project2, editorConfigFile, previewFile);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004\u00a8\u0006\u001a"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$Handler;", "", "()V", "choosePreviewFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "rootDir", "pattern", "", "createActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "header", "Lorg/editorconfig/language/psi/EditorConfigHeader;", "getPattern", "getRootDir", "isEditorConfigEnabled", "", "element", "Lcom/intellij/psi/PsiElement;", "matchesPattern", "filePath", "openPreview", "", "editorConfigFile", "previewFile", "intellij.editorconfig"})
    private static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEditorConfigEnabled(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!element.isValid()) return false;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!Utils.INSTANCE.isEnabled(project)) return false;
            return true;
        }

        @NotNull
        public final ActionGroup createActions(@NotNull EditorConfigHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            return (ActionGroup)new DefaultActionGroup(CollectionsKt.listOf((Object)((Object)new ChooseFileAction(header))));
        }

        @NotNull
        public final String getPattern(@NotNull String header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            char[] cArray = new char[]{'['};
            String string = StringsKt.trimStart((String)header, (char[])cArray);
            cArray = new char[]{']'};
            return StringsKt.trimEnd((String)string, (char[])cArray);
        }

        @Nullable
        public final VirtualFile choosePreviewFile(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            VirtualFile[] virtualFileArray = new VirtualFile[]{rootDir};
            FileChooserDescriptor descriptor2 = new FileChooserDescriptor(rootDir, pattern){
                final /* synthetic */ VirtualFile $rootDir;
                final /* synthetic */ String $pattern;
                {
                    this.$rootDir = $rootDir;
                    this.$pattern = $pattern;
                    super(true, false, false, false, false, false);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean isFileVisible(@NotNull VirtualFile file, boolean showHiddenFiles) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!(!showHiddenFiles && FileElement.isFileHidden((VirtualFile)file) || Intrinsics.areEqual((Object)".editorconfig", (Object)file.getName()) || file.getLength() > 10000L)) {
                        String string = file.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (Handler.access$matchesPattern(Handler.INSTANCE, this.$rootDir, this.$pattern, string)) return true;
                    }
                    if (!file.isDirectory()) return false;
                    return true;
                }

                public boolean isFileSelectable(@Nullable VirtualFile file) {
                    return file != null && !file.isDirectory();
                }
            }.withRoots(virtualFileArray);
            descriptor2.setForcedToUseIdeaFileChooser(true);
            FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(descriptor2, project, null);
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
            FileChooserDialog fileChooser = fileChooserDialog;
            VirtualFile[] virtualFileArray2 = VirtualFile.EMPTY_ARRAY;
            VirtualFile[] virtualFileArray3 = fileChooser.choose(project, Arrays.copyOf(virtualFileArray2, virtualFileArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"choose(...)");
            VirtualFile[] virtualFiles = virtualFileArray3;
            return !(virtualFiles.length == 0) ? virtualFiles[0] : null;
        }

        private final boolean matchesPattern(VirtualFile rootDir, String pattern, String filePath) {
            Glob glob = new Glob(pattern);
            return glob.match(Ec4jPath.Ec4jPaths.of(rootDir.getPath()).relativize(Ec4jPath.Ec4jPaths.of(filePath)));
        }

        @NotNull
        public final VirtualFile getRootDir(@NotNull EditorConfigHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            PsiFile psiFile = header.getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            return virtualFile;
        }

        public final void openPreview(@NotNull Project project, @NotNull VirtualFile editorConfigFile, @NotNull VirtualFile previewFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editorConfigFile, (String)"editorConfigFile");
            Intrinsics.checkNotNullParameter((Object)previewFile, (String)"previewFile");
            FileEditorManager.getInstance((Project)project).closeFile(editorConfigFile);
            EditorConfigPreviewManager.getInstance(project).associateWithPreviewFile(editorConfigFile, previewFile);
            FileEditorManager.getInstance((Project)project).openFile(editorConfigFile, true);
        }

        public static final /* synthetic */ boolean access$matchesPattern(Handler $this, VirtualFile rootDir, String pattern, String filePath) {
            return $this.matchesPattern(rootDir, pattern, filePath);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$SectionLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "myActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "tooltipProvider", "Lkotlin/Function1;", "", "(Lcom/intellij/openapi/actionSystem/ActionGroup;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Lkotlin/jvm/functions/Function1;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "intellij.editorconfig"})
    private static final class SectionLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        @NotNull
        private final ActionGroup myActionGroup;

        public SectionLineMarkerInfo(@NotNull ActionGroup myActionGroup, @NotNull PsiElement element, @NotNull TextRange range, @Nullable Function1<? super PsiElement, String> tooltipProvider) {
            Intrinsics.checkNotNullParameter((Object)myActionGroup, (String)"myActionGroup");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Function1<? super PsiElement, String> function1 = tooltipProvider;
            super(element, range, AllIcons.General.InspectionsEye, (Function)(function1 != null ? arg_0 -> SectionLineMarkerInfo._init_$lambda$0(function1, arg_0) : null), null, GutterIconRenderer.Alignment.LEFT);
            this.myActionGroup = myActionGroup;
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this){
                final /* synthetic */ SectionLineMarkerInfo this$0;
                {
                    this.this$0 = $receiver;
                    super((LineMarkerInfo)$receiver);
                }

                @Nullable
                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                @NotNull
                public ActionGroup getPopupMenuActions() {
                    return SectionLineMarkerInfo.access$getMyActionGroup$p(this.this$0);
                }
            };
        }

        private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ ActionGroup access$getMyActionGroup$p(SectionLineMarkerInfo $this) {
            return $this.myActionGroup;
        }
    }
}

