/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.impldep.com.google.common.collect.MapMaker;
import org.gradle.internal.impldep.com.google.common.io.ByteStreams;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.target.GradleServerClasspathInferer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J@\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\t2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/ClasspathInferer;", "", "classNamePredicate", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "classPathCache", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/lang/Class;", "", "Ljava/net/URL;", "find", "target", "visited", "", "dest", "getClassPathFor", "targetClass", "Companion", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nGradleServerClasspathInferer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleServerClasspathInferer.kt\norg/jetbrains/plugins/gradle/execution/target/ClasspathInferer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n1#2:127\n10#3:128\n*S KotlinDebug\n*F\n+ 1 GradleServerClasspathInferer.kt\norg/jetbrains/plugins/gradle/execution/target/ClasspathInferer\n*L\n123#1:128\n*E\n"})
final class ClasspathInferer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Boolean> classNamePredicate;
    @NotNull
    private final ConcurrentMap<Class<?>, Collection<URL>> classPathCache;
    @NotNull
    private static final Logger log;

    public ClasspathInferer(@NotNull Function1<? super String, Boolean> classNamePredicate) {
        Intrinsics.checkNotNullParameter(classNamePredicate, (String)"classNamePredicate");
        this.classNamePredicate = classNamePredicate;
        ConcurrentMap concurrentMap = new MapMaker().weakKeys().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        this.classPathCache = concurrentMap;
    }

    public /* synthetic */ ClasspathInferer(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super String, Boolean>)function1);
    }

    @NotNull
    public final Collection<URL> getClassPathFor(@NotNull Class<?> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        String string2 = targetClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!((Boolean)this.classNamePredicate.invoke((Object)string2)).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        Collection collection = this.classPathCache.computeIfAbsent(targetClass, arg_0 -> ClasspathInferer.getClassPathFor$lambda$0((Function1)new Function1<Class<?>, Collection<? extends URL>>(this, targetClass){
            final /* synthetic */ ClasspathInferer this$0;
            final /* synthetic */ Class<?> $targetClass;
            {
                this.this$0 = $receiver;
                this.$targetClass = $targetClass;
                super(1);
            }

            public final Collection<URL> invoke(Class<?> it) {
                return ClasspathInferer.find$default(this.this$0, this.$targetClass, null, null, 6, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"computeIfAbsent(...)");
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<URL> find(Class<?> target, Collection<Class<?>> visited, Collection<URL> dest) {
        ClassLoader classLoader = target.getClassLoader();
        if (classLoader == null) {
            return dest;
        }
        ClassLoader targetClassLoader = classLoader;
        if (targetClassLoader == ClassLoaderUtils.getPlatformClassLoader()) {
            return dest;
        }
        if (!visited.add(target)) {
            return dest;
        }
        String string2 = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String resourceName = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
        URL resource = targetClassLoader.getResource(resourceName);
        if (resource == null) {
            log.warn("Could not determine classpath for " + target);
            return dest;
        }
        try {
            ClassReader classReader;
            File classPathRoot = ClasspathUtil.getClasspathForClass(target);
            URL uRL = classPathRoot.toURI().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            dest.add(uRL);
            URLConnection urlConnection = resource.openConnection();
            JarURLConnection jarURLConnection = urlConnection instanceof JarURLConnection ? (JarURLConnection)urlConnection : null;
            if (jarURLConnection != null) {
                jarURLConnection.setUseCaches(false);
            }
            Closeable closeable = urlConnection.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                classReader = new ClassReader(ByteStreams.toByteArray((InputStream)it));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ClassReader reader = classReader;
            char[] charBuffer = new char[reader.getMaxStringLength()];
            int n = reader.getItemCount();
            for (int i = 1; i < n; ++i) {
                Class<?> clazz;
                String className;
                int itemOffset = reader.getItem(i);
                if (itemOffset <= 0 || reader.readByte(itemOffset - 1) != 7) continue;
                String classDescriptor = reader.readUTF8(itemOffset, charBuffer);
                Type type = Type.getObjectType((String)classDescriptor);
                while (type.getSort() == 9) {
                    type = type.getElementType();
                }
                if (type.getSort() != 10 || Intrinsics.areEqual((Object)(className = type.getClassName()), (Object)target.getName())) continue;
                Intrinsics.checkNotNull((Object)className);
                if (!((Boolean)this.classNamePredicate.invoke((Object)className)).booleanValue()) continue;
                try {
                    clazz = Class.forName(className, false, targetClassLoader);
                    Intrinsics.checkNotNull(clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn("Could not determine classpath for " + target);
                    continue;
                }
                Class<?> cl = clazz;
                this.find(cl, visited, dest);
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not determine the class-path for " + target + ".", (Throwable)e);
        }
        return dest;
    }

    static /* synthetic */ Collection find$default(ClasspathInferer classpathInferer2, Class clazz, Collection collection, Collection collection2, int n, Object object) {
        if ((n & 2) != 0) {
            collection = new HashSet();
        }
        if ((n & 4) != 0) {
            collection2 = new LinkedHashSet();
        }
        return classpathInferer2.find(clazz, collection, collection2);
    }

    private static final Collection getClassPathFor$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Collection)$tmp0.invoke(p0);
    }

    public ClasspathInferer() {
        this(null, 1, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleServerClasspathInferer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/ClasspathInferer$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

