/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\b\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssue;", "Lcom/intellij/build/issue/BuildIssue;", "gradleVersionUsed", "Lorg/gradle/util/GradleVersion;", "projectPath", "", "gradleMinimumVersionRequired", "(Lorg/gradle/util/GradleVersion;Ljava/lang/String;Lorg/gradle/util/GradleVersion;)V", "description", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "setQuickFixes", "(Ljava/util/List;)V", "title", "getTitle", "setTitle", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.gradle.common"})
public final class UnsupportedGradleVersionIssue
implements BuildIssue {
    public String title;
    public String description;
    public List<? extends BuildIssueQuickFix> quickFixes;

    public UnsupportedGradleVersionIssue(@Nullable GradleVersion gradleVersionUsed, @NotNull String projectPath, @NotNull GradleVersion gradleMinimumVersionRequired) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)gradleMinimumVersionRequired, (String)"gradleMinimumVersionRequired");
        List suggestedFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder();
        GradleVersion gradleVersion2 = gradleVersionUsed;
        String gradleVersionString = gradleVersion2 != null ? gradleVersion2.getVersion() : "version";
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
        ApplicationInfoEx appInfo = applicationInfoEx;
        String ideVersion = appInfo.getVersionName() + " " + appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
        issueDescription.append("Unsupported Gradle. \n").append("The project uses Gradle " + gradleVersionString + " which is incompatible with " + ideVersion + ".\n");
        issueDescription.append("\nPossible solution:\n");
        Path wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(projectPath);
        if (wrapperPropertiesFile == null || gradleVersionUsed != null && gradleVersionUsed.getBaseVersion().compareTo(gradleMinimumVersionRequired) < 0) {
            GradleVersionQuickFix gradleVersionFix = new GradleVersionQuickFix(projectPath, gradleMinimumVersionRequired, true);
            issueDescription.append(" - <a href=\"" + gradleVersionFix.getId() + "\">Upgrade Gradle wrapper to " + gradleMinimumVersionRequired.getVersion() + " version and re-import the project</a>\n");
            suggestedFixes.add(gradleVersionFix);
        } else {
            GradleWrapperSettingsOpenQuickFix wrapperSettingsOpenQuickFix = new GradleWrapperSettingsOpenQuickFix(projectPath, "distributionUrl");
            ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
            ReimportQuickFix reimportQuickFix = new ReimportQuickFix(projectPath, projectSystemId);
            issueDescription.append(" - <a href=\"" + wrapperSettingsOpenQuickFix.getId() + "\">Open Gradle wrapper settings</a>, upgrade version to " + gradleMinimumVersionRequired.getVersion() + " or newer and <a href=\"" + reimportQuickFix.getId() + "\">reload the project</a>\n");
            suggestedFixes.add(wrapperSettingsOpenQuickFix);
            suggestedFixes.add(reimportQuickFix);
        }
        String string2 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.setDescription(string2);
        String string3 = BuildConsoleUtils.getMessageTitle((String)this.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMessageTitle(...)");
        this.setTitle(string3);
        this.setQuickFixes(suggestedFixes);
    }

    @NotNull
    public String getTitle() {
        String string2 = this.title;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        return null;
    }

    public void setTitle(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.title = string2;
    }

    @NotNull
    public String getDescription() {
        String string2 = this.description;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"description");
        return null;
    }

    public void setDescription(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.description = string2;
    }

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        List<BuildIssueQuickFix> list2 = this.quickFixes;
        if (list2 != null) {
            return list2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"quickFixes");
        return null;
    }

    public void setQuickFixes(@NotNull List<? extends BuildIssueQuickFix> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.quickFixes = list2;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }
}

