/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.properties.GradleLocalProperties;
import org.jetbrains.plugins.gradle.properties.GradleLocalPropertiesImpl;
import org.jetbrains.plugins.gradle.properties.base.BasePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradleLocalPropertiesFile;", "Lorg/jetbrains/plugins/gradle/properties/base/BasePropertiesFile;", "Lorg/jetbrains/plugins/gradle/properties/GradleLocalProperties;", "()V", "propertiesFileName", "", "getPropertiesFileName", "()Ljava/lang/String;", "getGradleLocalPropertiesPath", "Ljava/nio/file/Path;", "externalProjectPath", "getProperties", "project", "Lcom/intellij/openapi/project/Project;", "loadGradleLocalProperties", "propertiesPath", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nGradleLocalPropertiesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleLocalPropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradleLocalPropertiesFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class GradleLocalPropertiesFile
extends BasePropertiesFile<GradleLocalProperties> {
    @NotNull
    public static final GradleLocalPropertiesFile INSTANCE = new GradleLocalPropertiesFile();
    @NotNull
    private static final String propertiesFileName = "config.properties";

    private GradleLocalPropertiesFile() {
    }

    @Override
    @NotNull
    public String getPropertiesFileName() {
        return propertiesFileName;
    }

    @Override
    @NotNull
    public GradleLocalProperties getProperties(@NotNull Project project, @NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Path propertiesPath = this.getGradleLocalPropertiesPath(externalProjectPath2);
        return this.loadGradleLocalProperties(propertiesPath);
    }

    private final GradleLocalProperties loadGradleLocalProperties(Path propertiesPath) {
        Property<String> property2;
        String javaHome;
        Properties properties = this.loadProperties(propertiesPath);
        if (properties == null) {
            return GradleLocalProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        String string2 = javaHome = properties2.getProperty("java.home");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            property2 = new Property<String>(it, ((Object)propertiesPath).toString());
        } else {
            property2 = null;
        }
        Property<String> javaHomeProperty = property2;
        return new GradleLocalPropertiesImpl(javaHomeProperty);
    }

    private final Path getGradleLocalPropertiesPath(Path externalProjectPath2) {
        String[] stringArray = new String[]{this.getPropertiesFileName()};
        Path gradleLocalPath = externalProjectPath2.resolve(Paths.get(".gradle", stringArray));
        Path path = gradleLocalPath.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }
}

