/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.statistics;

import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.project.Project;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.statistics.AggregatedTaskReport;
import org.jetbrains.plugins.gradle.statistics.GradleTaskExecutionCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionHandler;", "", "taskId", "", "project", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/project/Project;", "(JLjava/lang/ref/WeakReference;)V", "getProject", "()Ljava/lang/ref/WeakReference;", "getTaskId", "()J", "onTaskExecuted", "", "task", "Lorg/jetbrains/plugins/gradle/service/execution/statistics/AggregatedTaskReport;", "emit", "target", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "intellij.gradle.common"})
public final class GradleTaskExecutionHandler {
    private final long taskId;
    @NotNull
    private final WeakReference<Project> project;

    public GradleTaskExecutionHandler(long taskId, @NotNull WeakReference<Project> project) {
        Intrinsics.checkNotNullParameter(project, (String)"project");
        this.taskId = taskId;
        this.project = project;
    }

    public final long getTaskId() {
        return this.taskId;
    }

    @NotNull
    public final WeakReference<Project> getProject() {
        return this.project;
    }

    public final void onTaskExecuted(@NotNull AggregatedTaskReport task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this.emit(task2, GradleTaskExecutionCollector.Companion.getTASK_EXECUTED());
    }

    private final void emit(AggregatedTaskReport $this$emit, VarargEventId target) {
        Object[] objectArray = new EventPair[]{GradleTaskExecutionCollector.Companion.getEXTERNAL_TASK_ID().with((Object)this.taskId), GradleTaskExecutionCollector.Companion.getSUM_DURATION_MS().with((Object)$this$emit.getSumDurationMs()), GradleTaskExecutionCollector.Companion.getNAME().with((Object)$this$emit.getName()), GradleTaskExecutionCollector.Companion.getGRADLE_PLUGIN().with((Object)$this$emit.getPlugin()), GradleTaskExecutionCollector.Companion.getUP_TO_DATE_COUNT().with((Object)$this$emit.getUpToDateCount()), GradleTaskExecutionCollector.Companion.getFROM_CACHE_COUNT().with((Object)$this$emit.getFromCacheCount()), EventFields.Count.with((Object)$this$emit.getCount()), GradleTaskExecutionCollector.Companion.getUP_TO_DATE_DURATION_MS().with((Object)$this$emit.getUpToDateDuration()), GradleTaskExecutionCollector.Companion.getFROM_CACHE_DURATION_MS().with((Object)$this$emit.getFromCacheDuration()), GradleTaskExecutionCollector.Companion.getFAILED_COUNT().with((Object)$this$emit.getFailed())};
        List events = CollectionsKt.listOf((Object[])objectArray);
        target.log((Project)this.project.get(), events);
    }
}

