/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.util.PtyUtil;
import com.pty4j.windows.CygwinPTYInputStream;
import com.pty4j.windows.CygwinPTYOutputStream;
import com.pty4j.windows.NamedPipe;
import com.pty4j.windows.WinPty;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class CygwinPtyProcess
extends PtyProcess {
    private static final int CONNECT_PIPE_TIMEOUT = 1000;
    private static final int PIPE_ACCESS_INBOUND = 1;
    private static final int PIPE_ACCESS_OUTBOUND = 2;
    private static final AtomicInteger processCounter = new AtomicInteger();
    private final Process myProcess;
    private final NamedPipe myInputPipe;
    private final NamedPipe myOutputPipe;
    private final NamedPipe myErrorPipe;
    private final WinNT.HANDLE myInputHandle;
    private final WinNT.HANDLE myOutputHandle;
    private final WinNT.HANDLE myErrorHandle;
    private final boolean myConsoleMode;

    public CygwinPtyProcess(String[] command, Map<String, String> environment, String workingDirectory, File logFile, boolean console) throws IOException {
        this.myConsoleMode = console;
        String pipePrefix = String.format("\\\\.\\pipe\\cygwinpty-%d-%d-", WinPty.KERNEL32.GetCurrentProcessId(), processCounter.getAndIncrement());
        String inPipeName = pipePrefix + "in";
        String outPipeName = pipePrefix + "out";
        String errPipeName = pipePrefix + "err";
        this.myInputHandle = WinPty.KERNEL32.CreateNamedPipeA(inPipeName, 0x40000002, 0, 1, 0, 0, 0, null);
        this.myOutputHandle = WinPty.KERNEL32.CreateNamedPipeA(outPipeName, 0x40000001, 0, 1, 0, 0, 0, null);
        WinNT.HANDLE hANDLE = this.myErrorHandle = console ? WinPty.KERNEL32.CreateNamedPipeA(errPipeName, 0x40000001, 0, 1, 0, 0, 0, null) : null;
        if (this.myInputHandle == WinBase.INVALID_HANDLE_VALUE || this.myOutputHandle == WinBase.INVALID_HANDLE_VALUE || this.myErrorHandle == WinBase.INVALID_HANDLE_VALUE) {
            this.closeHandles();
            throw new IOException("Unable to create a named pipe");
        }
        this.myInputPipe = new NamedPipe(this.myInputHandle, false);
        this.myOutputPipe = new NamedPipe(this.myOutputHandle, false);
        this.myErrorPipe = this.myErrorHandle != null ? new NamedPipe(this.myErrorHandle, false) : null;
        this.myProcess = this.startProcess(inPipeName, outPipeName, errPipeName, workingDirectory, command, environment, logFile, console);
    }

    @Override
    public boolean isConsoleMode() {
        return this.myConsoleMode;
    }

    private Process startProcess(String inPipeName, String outPipeName, String errPipeName, String workingDirectory, String[] command, Map<String, String> environment, File logFile, boolean console) throws IOException {
        File nativeFile;
        try {
            nativeFile = PtyUtil.resolveNativeFile("cyglaunch.exe");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        String logPath = logFile == null ? "null" : logFile.getAbsolutePath();
        ProcessBuilder processBuilder = new ProcessBuilder(nativeFile.getAbsolutePath(), logPath, console ? "1" : "0", inPipeName, outPipeName, errPipeName);
        for (String s : command) {
            processBuilder.command().add(s);
        }
        if (workingDirectory != null) {
            processBuilder.directory(new File(workingDirectory));
        }
        processBuilder.environment().clear();
        processBuilder.environment().putAll(environment);
        final Process process = processBuilder.start();
        try {
            CygwinPtyProcess.waitForPipe(this.myInputHandle);
            CygwinPtyProcess.waitForPipe(this.myOutputHandle);
            if (this.myErrorHandle != null) {
                CygwinPtyProcess.waitForPipe(this.myErrorHandle);
            }
        }
        catch (IOException e) {
            process.destroy();
            this.closeHandles();
            throw e;
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                CygwinPtyProcess.this.closePipes();
            }
        }.start();
        return process;
    }

    private static void waitForPipe(WinNT.HANDLE handle) throws IOException {
        WinNT.HANDLE connectEvent = WinPty.KERNEL32.CreateEventA(null, true, false, null);
        WinBase.OVERLAPPED povl = new WinBase.OVERLAPPED();
        povl.hEvent = connectEvent;
        boolean success = WinPty.KERNEL32.ConnectNamedPipe(handle, povl);
        if (!success) {
            switch (WinPty.KERNEL32.GetLastError()) {
                case 535: {
                    success = true;
                    break;
                }
                case 997: {
                    if (WinPty.KERNEL32.WaitForSingleObject(connectEvent, 1000) != 0) {
                        WinPty.KERNEL32.CancelIo(handle);
                        success = false;
                        break;
                    }
                    success = true;
                }
            }
        }
        WinPty.KERNEL32.CloseHandle(connectEvent);
        if (!success) {
            throw new IOException("Cannot connect to a named pipe");
        }
    }

    @Override
    public void setWinSize(@NotNull WinSize winSize) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    @NotNull
    public WinSize getWinSize() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public long pid() {
        return -1L;
    }

    @Override
    public OutputStream getOutputStream() {
        return new CygwinPTYOutputStream(this.myInputPipe);
    }

    @Override
    public InputStream getInputStream() {
        return new CygwinPTYInputStream(this.myOutputPipe);
    }

    @Override
    public InputStream getErrorStream() {
        if (this.myErrorPipe == null) {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }
        return new CygwinPTYInputStream(this.myErrorPipe);
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.myProcess.waitFor();
    }

    @Override
    public int exitValue() {
        return this.myProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.myProcess.destroy();
    }

    @Override
    public byte getEnterKeyCode() {
        return 10;
    }

    private void closeHandles() {
        WinPty.KERNEL32.CloseHandle(this.myInputHandle);
        WinPty.KERNEL32.CloseHandle(this.myOutputHandle);
        if (this.myErrorHandle != null) {
            WinPty.KERNEL32.CloseHandle(this.myErrorHandle);
        }
    }

    private void closePipes() {
        this.myInputPipe.markClosed();
        this.myOutputPipe.markClosed();
        if (this.myErrorPipe != null) {
            this.myErrorPipe.markClosed();
        }
    }
}

