/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.driver.impl;

import com.intellij.driver.impl.CallTarget;
import com.intellij.driver.impl.InvokerMBean;
import com.intellij.driver.impl.RefProducer;
import com.intellij.driver.impl.Session;
import com.intellij.driver.model.OnDispatcher;
import com.intellij.driver.model.ProductVersion;
import com.intellij.driver.model.transport.NewInstanceCall;
import com.intellij.driver.model.transport.Ref;
import com.intellij.driver.model.transport.RefCall;
import com.intellij.driver.model.transport.RefList;
import com.intellij.driver.model.transport.RemoteCall;
import com.intellij.driver.model.transport.RemoteCallResult;
import com.intellij.driver.model.transport.ServiceCall;
import com.intellij.driver.model.transport.UtilityCall;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.util.ExceptionUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Invoker
implements InvokerMBean {
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    public static final int NO_SESSION_ID = 0;
    static final AtomicInteger REF_SEQUENCE = new AtomicInteger(1);
    private final Map<Integer, Session> sessions;
    private final AtomicInteger sessionIdSequence;
    private final Map<Integer, WeakReference<Object>> adhocReferenceMap;
    private final ClearableLazyValue<IJTracer> tracer;
    private final Supplier<? extends Context> timedContextSupplier;

    public Invoker(final @NotNull Supplier<? extends IJTracer> tracerSupplier, @NotNull Supplier<? extends Context> timedContextSupplier) {
        if (tracerSupplier == null) {
            Invoker.$$$reportNull$$$0(0);
        }
        if (timedContextSupplier == null) {
            Invoker.$$$reportNull$$$0(1);
        }
        this.sessions = new ConcurrentHashMap<Integer, Session>();
        this.sessionIdSequence = new AtomicInteger(1);
        this.adhocReferenceMap = new ConcurrentHashMap<Integer, WeakReference<Object>>();
        this.timedContextSupplier = timedContextSupplier;
        this.tracer = new ClearableLazyValue<IJTracer>(){

            @NotNull
            protected IJTracer compute() {
                IJTracer iJTracer = (IJTracer)tracerSupplier.get();
                if (iJTracer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iJTracer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/driver/impl/Invoker$1", "compute"));
            }
        };
    }

    @Override
    public ProductVersion getProductVersion() {
        BuildNumber build = ApplicationInfoImpl.getShadowInstanceImpl().getBuild();
        return new ProductVersion(build.getProductCode(), build.isSnapshot(), build.getBaselineVersion(), build.asString());
    }

    @Override
    public boolean isApplicationInitialized() {
        Application application = ApplicationManager.getApplication();
        return application != null && ((ApplicationEx)application).isComponentCreated();
    }

    @Override
    public void exit() {
        ApplicationManager.getApplication().exit(true, true, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RemoteCallResult invoke(@NotNull RemoteCall call) {
        ArrayList<Ref> items;
        Ref ref;
        Object result;
        if (call == null) {
            Invoker.$$$reportNull$$$0(2);
        }
        Object[] transformedArgs = this.transformArgs(call);
        if (call instanceof NewInstanceCall) {
            Class<?> targetClass = this.getTargetClass(call);
            Constructor<?> constructor = Invoker.getConstructor(call, targetClass, transformedArgs);
            LOG.debug("Creating instance of " + targetClass);
            result = this.withSemantics(call, () -> Invoker.invokeConstructor(constructor, transformedArgs));
        } else {
            Class componentType;
            Type type;
            Type[] typeArray;
            Object returnType;
            Object instance;
            CallTarget callTarget = this.getCallTarget(call, transformedArgs);
            LOG.debug("Calling " + callTarget);
            try {
                instance = this.findInstance(call, callTarget.clazz());
            }
            catch (Exception e) {
                LOG.error("Unable to get instance for " + call);
                throw new RuntimeException("Unable to get instance for " + call, e);
            }
            if (call.getDispatcher() == OnDispatcher.EDT) {
                Object[] res = new Object[1];
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    res[0] = this.withSemantics(call, () -> Invoker.invokeMethod(callTarget, instance, transformedArgs));
                });
                result = res[0];
            } else {
                result = this.withSemantics(call, () -> Invoker.invokeMethod(callTarget, instance, transformedArgs));
            }
            Method targetMethod = callTarget.targetMethod();
            if (Collection.class.isAssignableFrom(targetMethod.getReturnType()) ? (returnType = targetMethod.getGenericReturnType()) instanceof ParameterizedType && (typeArray = ((ParameterizedType)returnType).getActualTypeArguments()).length == 1 && (type = typeArray[0]) instanceof Class && RemoteCall.isPassByValue(componentType = (Class)type) : targetMethod.getReturnType().isArray() && RemoteCall.isPassByValue(targetMethod.getReturnType().getComponentType())) {
                return new RemoteCallResult(result);
            }
        }
        if (RemoteCall.isPassByValue(result)) {
            return new RemoteCallResult(result);
        }
        if (call.getSessionId() == 0) {
            int id = REF_SEQUENCE.getAndIncrement();
            ref = RefProducer.makeRef(id, result);
            this.adhocReferenceMap.put(id, new WeakReference<Object>(result));
            if (result instanceof Collection) {
                ArrayList<Ref> items2 = new ArrayList<Ref>(((Collection)result).size());
                for (Object e : (Collection)result) {
                    items2.add(this.putAdhocReference(e));
                }
                return new RemoteCallResult(new RefList(id, result.getClass().getName(), items2));
            }
            if (result.getClass().isArray()) {
                Object[] array = (Object[])result;
                items = new ArrayList(array.length);
                for (Object item : array) {
                    items.add(this.putAdhocReference(item));
                }
                return new RemoteCallResult(new RefList(id, result.getClass().getName(), items));
            }
            return new RemoteCallResult(ref);
        }
        Session session = this.sessions.get(call.getSessionId());
        ref = session.putReference(result);
        this.adhocReferenceMap.put(ref.id(), new WeakReference<Object>(result));
        if (result instanceof Collection) {
            ArrayList<Ref> items2 = new ArrayList<Ref>(((Collection)result).size());
            for (Object e : (Collection)result) {
                Ref child = session.putReference(e);
                this.adhocReferenceMap.put(child.id(), new WeakReference(e));
                items2.add(child);
            }
            return new RemoteCallResult(new RefList(ref.id(), result.getClass().getName(), items2));
        }
        if (result.getClass().isArray()) {
            void var8_18;
            int length = Array.getLength(result);
            items = new ArrayList<Ref>(length);
            boolean bl = false;
            while (var8_18 < length) {
                Object item = Array.get(result, (int)var8_18);
                Ref child = session.putReference(item);
                this.adhocReferenceMap.put(child.id(), new WeakReference<Object>(item));
                items.add(child);
                ++var8_18;
            }
            return new RemoteCallResult(new RefList(ref.id(), result.getClass().getName(), items));
        }
        return new RemoteCallResult(ref);
    }

    @NotNull
    private static Object invokeConstructor(Constructor<?> constructor, Object[] transformedArgs) throws Exception {
        Object obj;
        try {
            obj = constructor.newInstance(transformedArgs);
        }
        catch (IllegalArgumentException ie) {
            String message = "Argument type mismatch for constructor " + constructor + " , actual types are [" + Invoker.getExpectedTypesMessage(transformedArgs) + "]";
            LOG.warn(message, (Throwable)ie);
            throw new IllegalArgumentException(message, ie);
        }
        catch (Throwable e) {
            LOG.warn("Error during remote driver call " + constructor, e);
            throw e;
        }
        if (obj == null) {
            Invoker.$$$reportNull$$$0(3);
        }
        return obj;
    }

    @NotNull
    private static String getExpectedTypesMessage(Object[] transformedArgs) {
        String string = Arrays.stream(transformedArgs).map(a -> {
            if (a == null) {
                return "null";
            }
            return a.getClass().getSimpleName();
        }).collect(Collectors.joining(", "));
        if (string == null) {
            Invoker.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static Object invokeMethod(CallTarget callTarget, Object instance, Object[] args) throws Exception {
        try {
            return callTarget.targetMethod().invoke(instance, args);
        }
        catch (IllegalArgumentException ie) {
            String message = "Argument type mismatch for call " + callTarget.targetMethod() + ", actual types are [" + Invoker.getExpectedTypesMessage(args) + "]";
            LOG.warn(message, (Throwable)ie);
            throw new IllegalArgumentException(message, ie);
        }
        catch (Throwable e) {
            LOG.warn("Error during remote driver call " + callTarget.targetMethod(), e);
            throw e;
        }
    }

    @Nullable
    private Object withSemantics(@NotNull RemoteCall call, @NotNull Callable<?> supplier) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(5);
        }
        if (supplier == null) {
            Invoker.$$$reportNull$$$0(6);
        }
        switch (call.getLockSemantics()) {
            case NO_LOCK: {
                return this.call(call, supplier);
            }
            case READ_ACTION: {
                return ReadAction.compute(() -> this.call(call, supplier));
            }
            case WRITE_ACTION: {
                return WriteAction.compute(() -> this.call(call, supplier));
            }
        }
        throw new UnsupportedOperationException("Unsupported LockSemantics " + call.getLockSemantics());
    }

    @Nullable
    private Object call(@NotNull RemoteCall call, @NotNull Callable<?> supplier) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(7);
        }
        if (supplier == null) {
            Invoker.$$$reportNull$$$0(8);
        }
        if (call.getTimedSpan() == null || call.getTimedSpan().isEmpty()) {
            try {
                return supplier.call();
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e);
                throw new IllegalStateException();
            }
        }
        SpanBuilder spanBuilder = ((IJTracer)this.tracer.getValue()).spanBuilder(call.getTimedSpan()).setParent(this.timedContextSupplier.get());
        Span span = spanBuilder.startSpan();
        try {
            Object obj = supplier.call();
            return obj;
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
        finally {
            span.end();
        }
    }

    @NotNull
    private Ref putAdhocReference(@NotNull Object item) {
        if (item == null) {
            Invoker.$$$reportNull$$$0(9);
        }
        int itemId = REF_SEQUENCE.getAndIncrement();
        this.adhocReferenceMap.put(itemId, new WeakReference<Object>(item));
        Ref ref = RefProducer.makeRef(itemId, item);
        if (ref == null) {
            Invoker.$$$reportNull$$$0(10);
        }
        return ref;
    }

    private static Constructor<?> getConstructor(@NotNull RemoteCall call, @NotNull Class<?> targetClass, Object[] transformedArgs) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(11);
        }
        if (targetClass == null) {
            Invoker.$$$reportNull$$$0(12);
        }
        int argCount = call.getArgs().length;
        List<Constructor<?>> availableConstructors = Arrays.stream(targetClass.getConstructors()).toList();
        List<Constructor> constructors = availableConstructors.stream().filter(x -> x.getParameterCount() == argCount).toList();
        if (constructors.isEmpty()) {
            throw new IllegalStateException(String.format("No constructor with parameter count %s in class %s. Available constructors: %n%s", argCount, call.getClassName(), availableConstructors.stream().map(it -> it.toString()).collect(Collectors.joining(" - " + System.lineSeparator()))));
        }
        if (constructors.size() > 1) {
            List<@Nullable Class<?>> argumentTypes = Invoker.getArgumentTypes(transformedArgs);
            for (Constructor constructor : constructors) {
                if (!Invoker.areTypesCompatible(constructor.getParameterTypes(), argumentTypes)) continue;
                return constructor;
            }
        }
        return constructors.get(0);
    }

    @NotNull
    private CallTarget getCallTarget(@NotNull RemoteCall call, Object[] transformedArgs) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(13);
        }
        Class<?> clazz = this.getTargetClass(call);
        int argCount = call.getArgs().length;
        List<Method> availableMethods = Arrays.stream(clazz.getMethods()).toList();
        List<Method> targetMethods = availableMethods.stream().filter(m -> m.getName().equals(call.getMethodName()) && argCount == m.getParameterCount()).toList();
        if (targetMethods.isEmpty()) {
            throw new IllegalStateException(String.format("No method '%s' with parameter count %s in class %s. Available methods: %n%s", call.getMethodName(), argCount, call.getClassName(), availableMethods.stream().map(it -> it.toString()).collect(Collectors.joining(" - " + System.lineSeparator()))));
        }
        if (targetMethods.size() > 1) {
            List<@Nullable Class<?>> argumentTypes = Invoker.getArgumentTypes(transformedArgs);
            for (Method method : targetMethods) {
                if (!Invoker.areTypesCompatible(method.getParameterTypes(), argumentTypes)) continue;
                return Invoker.buildCallTarget(clazz, method);
            }
        }
        return Invoker.buildCallTarget(clazz, targetMethods.get(0));
    }

    @NotNull
    private static CallTarget buildCallTarget(Class<?> clazz, Method method) {
        method.setAccessible(true);
        return new CallTarget(clazz, method);
    }

    private static @NotNull List<@Nullable Class<?>> getArgumentTypes(Object[] transformedArgs) {
        List<Class<?>> list = Arrays.stream(transformedArgs).map(a -> {
            if (a == null) {
                return null;
            }
            return a.getClass();
        }).toList();
        if (list == null) {
            Invoker.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static boolean areTypesCompatible(Class<?> @NotNull [] parameterTypes, @NotNull List<@Nullable Class<?>> argumentTypes) {
        if (argumentTypes == null) {
            Invoker.$$$reportNull$$$0(15);
        }
        if (parameterTypes == null) {
            Invoker.$$$reportNull$$$0(16);
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            Class<?> parameterType;
            Class<?> argType = argumentTypes.get(i);
            if (argType == null || ClassUtils.isAssignable(argType, parameterType = parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Class<?> getTargetClass(RemoteCall call) {
        Class<?> clazz;
        try {
            clazz = this.getClassLoader(call).loadClass(call.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("No such class '" + call.getClassName() + "'", e);
        }
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            Invoker.$$$reportNull$$$0(17);
        }
        return clazz2;
    }

    @NotNull
    private ClassLoader getClassLoader(RemoteCall call) {
        String pluginId = call.getPluginId();
        if (pluginId == null || pluginId.isEmpty()) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                Invoker.$$$reportNull$$$0(18);
            }
            return classLoader;
        }
        if (pluginId.contains("/")) {
            String mainId = StringsKt.substringBefore((String)pluginId, (String)"/", (String)pluginId);
            String moduleId = StringsKt.substringAfter((String)pluginId, (String)"/", (String)pluginId);
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)mainId));
            if (plugin == null) {
                throw new IllegalStateException("No such plugin " + mainId);
            }
            List modules = ((IdeaPluginDescriptorImpl)plugin).content.modules;
            for (PluginContentDescriptor.ModuleItem module : modules) {
                if (!Objects.equals(moduleId, module.name)) continue;
                ClassLoader classLoader = Objects.requireNonNull(module.requireDescriptor().getPluginClassLoader());
                if (classLoader == null) {
                    Invoker.$$$reportNull$$$0(19);
                }
                return classLoader;
            }
            throw new IllegalStateException("No such plugin module " + pluginId);
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId));
        if (plugin == null) {
            throw new IllegalStateException("No such plugin " + pluginId);
        }
        ClassLoader classLoader = plugin.getClassLoader();
        if (classLoader == null) {
            Invoker.$$$reportNull$$$0(20);
        }
        return classLoader;
    }

    @Nullable
    private Object findInstance(RemoteCall call, Class<?> clazz) {
        if (call instanceof ServiceCall) {
            Object projectInstance = null;
            Ref projectRef = ((ServiceCall)call).getProjectRef();
            if (projectRef != null) {
                projectInstance = this.getReference(call.getSessionId(), projectRef.id());
            }
            Class<?> serviceClass = clazz;
            String serviceInterface = ((ServiceCall)call).getServiceInterface();
            if (serviceInterface != null && (serviceClass = Invoker.findServiceInterface(clazz, serviceInterface)) == null) {
                throw new IllegalStateException("Unable to find interface " + serviceInterface + " for service " + clazz);
            }
            Object instance = projectInstance instanceof Project ? ((Project)projectInstance).getService(serviceClass) : ApplicationManager.getApplication().getService(serviceClass);
            return instance;
        }
        if (call instanceof RefCall) {
            Ref ref = ((RefCall)call).getRef();
            Object reference = this.getReference(call.getSessionId(), ref.id());
            if (reference == null) {
                throw new IllegalStateException("No such ref exists " + ref);
            }
            return reference;
        }
        if (call instanceof UtilityCall) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported call type " + call);
    }

    @Nullable
    private static Class<?> findServiceInterface(@NotNull Class<?> clazz, @NotNull String serviceInterface) {
        if (clazz == null) {
            Invoker.$$$reportNull$$$0(21);
        }
        if (serviceInterface == null) {
            Invoker.$$$reportNull$$$0(22);
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            if (!serviceInterface.equals(anInterface.getName())) continue;
            return anInterface;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            if (serviceInterface.equals(superclass.getName())) {
                return superclass;
            }
            return Invoker.findServiceInterface(superclass, serviceInterface);
        }
        return null;
    }

    private Object @NotNull [] transformArgs(@NotNull RemoteCall call) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(23);
        }
        Object[] args = new Object[call.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            Object reference;
            Object arg = call.getArgs()[i];
            args[i] = arg instanceof Ref ? (reference = this.getReference(call.getSessionId(), ((Ref)arg).id())) : arg;
        }
        if (args == null) {
            Invoker.$$$reportNull$$$0(24);
        }
        return args;
    }

    @NotNull
    private Object getReference(int sessionId, int id) {
        if (sessionId != 0) {
            WeakReference<Object> adhocReference = this.adhocReferenceMap.get(id);
            if (adhocReference != null) {
                return Invoker.dereference(adhocReference, id);
            }
            Session session = this.sessions.get(sessionId);
            if (session == null) {
                throw new IllegalStateException("No such session " + sessionId);
            }
            Object object = session.findReference(id);
            if (object == null) {
                Invoker.$$$reportNull$$$0(25);
            }
            return object;
        }
        WeakReference<Object> reference = this.adhocReferenceMap.get(id);
        if (reference == null) {
            throw new IllegalStateException("No such variable " + id);
        }
        return Invoker.dereference(reference, id);
    }

    @NotNull
    private static Object dereference(@NotNull WeakReference<Object> reference, int id) {
        Object weakTarget;
        if (reference == null) {
            Invoker.$$$reportNull$$$0(26);
        }
        if ((weakTarget = reference.get()) == null) {
            throw new IllegalStateException("Weak reference to variable " + id + " expired. Please use `Driver.withContext { }` for hard variable references.");
        }
        Object t = weakTarget;
        if (t == null) {
            Invoker.$$$reportNull$$$0(27);
        }
        return t;
    }

    @Override
    public int newSession() {
        int id = this.sessionIdSequence.getAndIncrement();
        this.sessions.put(id, new Session());
        return id;
    }

    @Override
    public void cleanup(int sessionId) {
        this.sessions.remove(sessionId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 14, 17, 18, 19, 20, 24, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracerSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timedContextSupplier";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/driver/impl/Invoker";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/driver/impl/Invoker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeConstructor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "putAdhocReference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClass";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoader";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "transformArgs";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "dereference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withSemantics";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "call";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putAdhocReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCallTarget";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areTypesCompatible";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findServiceInterface";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "transformArgs";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 14, 17, 18, 19, 20, 24, 25, 27 -> new IllegalStateException(string);
        };
    }
}

