/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetModel;

import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import com.intellij.gradle.toolingExtension.util.GradleNegotiationUtil;
import com.intellij.gradle.toolingExtension.util.GradleReflectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;

public class GradleSourceSetCachedFinder {
    @NotNull
    private static final GradleVersion gradleBaseVersion = GradleVersion.current().getBaseVersion();
    private static final boolean is51OrBetter = gradleBaseVersion.compareTo(GradleVersion.version((String)"5.1")) >= 0;
    private static final boolean is73OrBetter = gradleBaseVersion.compareTo(GradleVersion.version((String)"7.3")) >= 0;
    @NotNull
    private final ArtifactsMap myArtifactsMap;
    @NotNull
    private final ConcurrentMap<String, Set<File>> mySourceMap;
    @NotNull
    private static final ModelBuilderContext.DataProvider<GradleSourceSetCachedFinder> INSTANCE_PROVIDER = GradleSourceSetCachedFinder::new;

    private GradleSourceSetCachedFinder(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(0);
        }
        this.mySourceMap = new ConcurrentHashMap<String, Set<File>>();
        this.myArtifactsMap = GradleSourceSetCachedFinder.createArtifactsMap(context);
    }

    @NotNull
    public List<File> findArtifactSources(@NotNull Collection<? extends File> artifactFiles) {
        if (artifactFiles == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(1);
        }
        ArrayList<File> artifactSources = new ArrayList<File>();
        for (File file : artifactFiles) {
            artifactSources.addAll(this.findSourcesByArtifact(file.getPath()));
        }
        ArrayList<File> arrayList = artifactSources;
        if (arrayList == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private Set<File> findSourcesByArtifact(@NotNull String path) {
        SourceSet sourceSet;
        if (path == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(3);
        }
        if (!this.mySourceMap.containsKey(path) && (sourceSet = this.myArtifactsMap.myArtifactsMap.get(path)) != null) {
            Set sources = sourceSet.getAllJava().getSrcDirs();
            Set calculatedSources = this.mySourceMap.putIfAbsent(path, sources);
            Set set = calculatedSources != null ? calculatedSources : sources;
            if (set == null) {
                GradleSourceSetCachedFinder.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<File> set = Collections.emptySet();
        if (set == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public SourceSet findByArtifact(@NotNull String artifactPath) {
        if (artifactPath == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(6);
        }
        return this.myArtifactsMap.myArtifactsMap.get(artifactPath);
    }

    @Nullable
    public String findArtifactBySourceSetOutputDir(@NotNull String outputPath) {
        if (outputPath == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(7);
        }
        return this.myArtifactsMap.mySourceSetOutputDirsToArtifactsMap.get(outputPath);
    }

    @NotNull
    private static ArtifactsMap createArtifactsMap(@NotNull ModelBuilderContext context) {
        boolean isCompositeBuildsSupported;
        if (context == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(8);
        }
        Gradle gradle = context.getGradle();
        HashMap<String, SourceSet> artifactsMap = new HashMap<String, SourceSet>();
        HashMap<String, String> sourceSetOutputDirsToArtifactsMap = new HashMap<String, String>();
        ArrayList<Project> projects = new ArrayList<Project>(gradle.getRootProject().getAllprojects());
        boolean bl = isCompositeBuildsSupported = DependencyResolverImpl.isIsNewDependencyResolutionApplicable() || GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"3.1")) >= 0;
        if (isCompositeBuildsSupported) {
            projects.addAll(GradleSourceSetCachedFinder.exposeIncludedBuilds(gradle));
        }
        for (Project project : projects) {
            SourceSetContainer sourceSetContainer = JavaPluginUtil.getSourceSetContainer(project);
            if (sourceSetContainer == null || sourceSetContainer.isEmpty()) continue;
            for (SourceSet sourceSet : sourceSetContainer) {
                AbstractArchiveTask jarTask;
                File archivePath;
                Task task = (Task)project.getTasks().findByName(sourceSet.getJarTaskName());
                if (!(task instanceof AbstractArchiveTask) || (archivePath = GradleNegotiationUtil.getTaskArchiveFile((AbstractArchiveTask)(jarTask = (AbstractArchiveTask)task))) == null) continue;
                artifactsMap.put(archivePath.getPath(), sourceSet);
                if (!DependencyResolverImpl.isIsNewDependencyResolutionApplicable()) continue;
                for (File file : sourceSet.getOutput().getClassesDirs().getFiles()) {
                    sourceSetOutputDirsToArtifactsMap.put(file.getPath(), archivePath.getPath());
                }
                File resourcesDir = Objects.requireNonNull(sourceSet.getOutput().getResourcesDir());
                sourceSetOutputDirsToArtifactsMap.put(resourcesDir.getPath(), archivePath.getPath());
            }
        }
        return new ArtifactsMap(artifactsMap, sourceSetOutputDirsToArtifactsMap);
    }

    @NotNull
    private static List<Project> exposeIncludedBuilds(@NotNull Gradle gradle) {
        if (gradle == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(9);
        }
        ArrayList<Project> result = new ArrayList<Project>();
        for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
            Object unwrapped = GradleSourceSetCachedFinder.maybeUnwrapIncludedBuildInternal(includedBuild);
            if (!(unwrapped instanceof DefaultIncludedBuild)) continue;
            DefaultIncludedBuild build = (DefaultIncludedBuild)unwrapped;
            if (is73OrBetter) {
                build.ensureProjectsConfigured();
            }
            if (is51OrBetter) {
                result.addAll((Collection)build.withState(it -> it.getRootProject().getAllprojects()));
                continue;
            }
            result.addAll(GradleSourceSetCachedFinder.getProjectsWithReflection(build));
        }
        ArrayList<Project> arrayList = result;
        if (arrayList == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static Set<Project> getProjectsWithReflection(@NotNull DefaultIncludedBuild build) {
        if (build == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(11);
        }
        GradleInternal gradleInternal = (GradleInternal)GradleReflectionUtil.reflectiveCall((Object)build, (String)"getConfiguredBuild", GradleInternal.class);
        Set set = gradleInternal.getRootProject().getAllprojects();
        if (set == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    private static Object maybeUnwrapIncludedBuildInternal(@NotNull IncludedBuild includedBuild) {
        Class includedBuildInternalClass;
        if (includedBuild == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(13);
        }
        if ((includedBuildInternalClass = GradleReflectionUtil.findClassForName((String)"org.gradle.internal.composite.IncludedBuildInternal")) != null && includedBuildInternalClass.isAssignableFrom(includedBuild.getClass())) {
            Object object = GradleReflectionUtil.reflectiveCall((Object)includedBuild, (String)"getTarget", Object.class);
            if (object == null) {
                GradleSourceSetCachedFinder.$$$reportNull$$$0(14);
            }
            return object;
        }
        IncludedBuild includedBuild2 = includedBuild;
        if (includedBuild2 == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(15);
        }
        return includedBuild2;
    }

    @NotNull
    public static GradleSourceSetCachedFinder getInstance(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(16);
        }
        GradleSourceSetCachedFinder gradleSourceSetCachedFinder = (GradleSourceSetCachedFinder)context.getData(INSTANCE_PROVIDER);
        if (gradleSourceSetCachedFinder == null) {
            GradleSourceSetCachedFinder.$$$reportNull$$$0(17);
        }
        return gradleSourceSetCachedFinder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFiles";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetCachedFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradle";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedBuild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetCachedFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifactSources";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourcesByArtifact";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "exposeIncludedBuilds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsWithReflection";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "maybeUnwrapIncludedBuildInternal";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactSources";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSourcesByArtifact";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findByArtifact";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactBySourceSetOutputDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactsMap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exposeIncludedBuilds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectsWithReflection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "maybeUnwrapIncludedBuildInternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArtifactsMap {
        @NotNull
        public final Map<String, SourceSet> myArtifactsMap;
        @NotNull
        public final Map<String, String> mySourceSetOutputDirsToArtifactsMap;

        ArtifactsMap(@NotNull Map<String, SourceSet> artifactsMap, @NotNull Map<String, String> sourceSetOutputDirsToArtifactsMap) {
            if (artifactsMap == null) {
                ArtifactsMap.$$$reportNull$$$0(0);
            }
            if (sourceSetOutputDirsToArtifactsMap == null) {
                ArtifactsMap.$$$reportNull$$$0(1);
            }
            this.myArtifactsMap = Collections.unmodifiableMap(artifactsMap);
            this.mySourceSetOutputDirsToArtifactsMap = Collections.unmodifiableMap(sourceSetOutputDirsToArtifactsMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifactsMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceSetOutputDirsToArtifactsMap";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetCachedFinder$ArtifactsMap";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

