/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleTooling.model.kapt;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleTooling.AbstractKotlinGradleModelBuilder;
import org.jetbrains.kotlin.idea.gradleTooling.AndroidAwareGradleModelProvider;
import org.jetbrains.kotlin.idea.gradleTooling.ModelBuilderUtilsKt;
import org.jetbrains.kotlin.idea.gradleTooling.UtilsKt;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptGradleModel;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptGradleModelImpl;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptSourceSetModel;
import org.jetbrains.kotlin.idea.gradleTooling.model.kapt.KaptSourceSetModelImpl;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptModelBuilderService;", "Lorg/jetbrains/kotlin/idea/gradleTooling/AbstractKotlinGradleModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService$ParameterizedModelBuilderService;", "()V", "buildAll", "Lorg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptGradleModelImpl;", "modelName", "", "project", "Lorg/gradle/api/Project;", "builderContext", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "parameter", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService$Parameter;", "canBuild", "", "getErrorMessageBuilder", "Lorg/jetbrains/plugins/gradle/tooling/ErrorMessageBuilder;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getKaptDirectory", "funName", "sourceSetName", "isWithJavaEnabled", "target", "Lorg/gradle/api/Named;", "kotlin.gradle.gradle-tooling.impl"})
@SourceDebugExtension(value={"SMAP\nKaptModelBuilderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaptModelBuilderService.kt\norg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptModelBuilderService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n1549#2:142\n1620#2,3:143\n1855#2,2:146\n1282#3,2:148\n1282#3,2:150\n*S KotlinDebug\n*F\n+ 1 KaptModelBuilderService.kt\norg/jetbrains/kotlin/idea/gradleTooling/model/kapt/KaptModelBuilderService\n*L\n112#1:142\n112#1:143,3\n114#1:146,2\n127#1:148,2\n135#1:150,2\n*E\n"})
public final class KaptModelBuilderService
extends AbstractKotlinGradleModelBuilder
implements ModelBuilderService.ParameterizedModelBuilderService {
    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Gradle import errors").withDescription("Unable to build kotlin-kapt plugin configuration");
        Intrinsics.checkNotNullExpressionValue((Object)errorMessageBuilder, (String)"withDescription(...)");
        return errorMessageBuilder;
    }

    public boolean canBuild(@Nullable String modelName) {
        return Intrinsics.areEqual((Object)modelName, (Object)KaptGradleModel.class.getName());
    }

    @Nullable
    public KaptGradleModelImpl buildAll(@Nullable String modelName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.buildAll(project, null, null);
    }

    @Nullable
    public KaptGradleModelImpl buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext builderContext, @Nullable ModelBuilderService.Parameter parameter) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)builderContext, (String)"builderContext");
        return this.buildAll(project, builderContext, parameter);
    }

    /*
     * WARNING - void declaration
     */
    private final KaptGradleModelImpl buildAll(Project project, ModelBuilderContext builderContext, ModelBuilderService.Parameter parameter) {
        ModelBuilderService.Parameter parameter2 = parameter;
        AndroidAwareGradleModelProvider.Result androidVariantRequest = AndroidAwareGradleModelProvider.Companion.parseParameter(project, parameter2 != null ? parameter2.getValue() : null);
        if (androidVariantRequest.shouldSkipBuildAllCall()) {
            return null;
        }
        Plugin kaptPlugin = project.getPlugins().findPlugin("kotlin-kapt");
        boolean kaptIsEnabled = kaptPlugin != null;
        List sourceSets2 = new ArrayList();
        if (kaptIsEnabled) {
            Collection<Named> targets2 = ModelBuilderUtilsKt.getTargets(project);
            Collection<Named> collection = targets2;
            if (!(collection == null || collection.isEmpty())) {
                for (Named target2 : targets2) {
                    Collection<Named> compilations2;
                    if (!this.isWithJavaEnabled(target2) || ModelBuilderUtilsKt.getCompilations(target2) == null) continue;
                    for (Named compilation : compilations2) {
                        Task compileTask;
                        if (ModelBuilderUtilsKt.getCompileKotlinTaskName(compilation, project) == null) continue;
                        StringBuilder stringBuilder = new StringBuilder().append(target2.getName());
                        String string = compilation.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String moduleName = stringBuilder.append(UtilsKt.capitalize(string)).toString();
                        KaptModelBuilderService.buildAll$handleCompileTask(this, project, sourceSets2, moduleName, compileTask);
                    }
                }
            } else {
                Collection compileTasks;
                Collection collection2;
                Object object = ModelBuilderUtilsKt.getTarget(project);
                if (object != null && (object = ModelBuilderUtilsKt.getCompilations(object)) != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable moduleName = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void compilation;
                        Named named = (Named)item$iv$iv;
                        Collection collection3 = destination$iv$iv;
                        boolean bl = false;
                        collection3.add(ModelBuilderUtilsKt.getCompileKotlinTaskName((Named)compilation, project));
                    }
                    collection2 = (List)destination$iv$iv;
                } else {
                    collection2 = (Collection)project.getAllTasks(false).get(project);
                }
                Collection collection4 = compileTasks = collection2;
                if (collection4 != null) {
                    Iterable $this$forEach$iv = collection4;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Task compileTask = (Task)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)compileTask);
                        String sourceSetName = AbstractKotlinGradleModelBuilder.Companion.getSourceSetName(compileTask);
                        if (androidVariantRequest.shouldSkipSourceSet(sourceSetName)) continue;
                        KaptModelBuilderService.buildAll$handleCompileTask(this, project, sourceSets2, sourceSetName, compileTask);
                    }
                }
            }
        }
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        return new KaptGradleModelImpl(kaptIsEnabled, file, sourceSets2);
    }

    private final boolean isWithJavaEnabled(Named target2) {
        Object object;
        block2: {
            Method[] methodArray = target2.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$firstOrNull$iv = methodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getWithJavaEnabled") && it.getParameterCount() == 0)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Method method = (Method)object;
        if (method == null) {
            return false;
        }
        Method getWithJavaEnabledMethod = method;
        return Intrinsics.areEqual((Object)getWithJavaEnabledMethod.invoke((Object)target2, new Object[0]), (Object)true);
    }

    private final String getKaptDirectory(String funName, Project project, String sourceSetName) {
        Object object;
        block4: {
            Plugin plugin = project.getPlugins().findPlugin("kotlin-kapt");
            if (plugin == null) {
                return "";
            }
            Plugin kotlinKaptPlugin = plugin;
            Method[] methodArray = kotlinKaptPlugin.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$firstOrNull$iv = methodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!(Modifier.isStatic(it.getModifiers()) && Intrinsics.areEqual((Object)it.getName(), (Object)funName) && it.getParameterCount() == 2)) continue;
                object = element$iv;
                break block4;
            }
            object = null;
        }
        Method method = (Method)object;
        if (method == null) {
            return "";
        }
        Method targetMethod = method;
        Object[] objectArray = new Object[]{project, sourceSetName};
        Object object2 = targetMethod.invoke(null, objectArray);
        File file = object2 instanceof File ? (File)object2 : null;
        String string = file != null ? file.getAbsolutePath() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final void buildAll$handleCompileTask(KaptModelBuilderService this$0, Project $project, List<KaptSourceSetModel> sourceSets2, String moduleName, Task compileTask) {
        if (!AbstractKotlinGradleModelBuilder.Companion.getKotlinCompileJvmTaskClasses().contains(compileTask.getClass().getName())) {
            return;
        }
        String sourceSetName = AbstractKotlinGradleModelBuilder.Companion.getSourceSetName(compileTask);
        String string = sourceSetName.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        boolean isTest = StringsKt.endsWith$default((String)string, (String)"test", (boolean)false, (int)2, null);
        String kaptGeneratedSourcesDir = this$0.getKaptDirectory("getKaptGeneratedSourcesDir", $project, sourceSetName);
        String kaptGeneratedClassesDir = this$0.getKaptDirectory("getKaptGeneratedClassesDir", $project, sourceSetName);
        String kaptGeneratedKotlinSourcesDir = this$0.getKaptDirectory("getKaptGeneratedKotlinSourcesDir", $project, sourceSetName);
        ((Collection)sourceSets2).add(new KaptSourceSetModelImpl(moduleName, isTest, kaptGeneratedSourcesDir, kaptGeneratedClassesDir, kaptGeneratedKotlinSourcesDir));
    }
}

