/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.AdvancedSettingsUI;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.MethodParameterInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.MethodParameterPanel;
import org.intellij.plugins.intelliLang.inject.java.ConcatenationInjector;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    @NonNls
    public static final String JAVA_SUPPORT_ID = "java";
    private static final Pattern ourPresentationPattern = Pattern.compile("(.+)(\\(\\S+(?:\\.\\S+)+\\))");

    private static boolean isMine(PsiLanguageInjectionHost psiElement) {
        return PsiUtilEx.isStringOrCharacterLiteral((PsiElement)psiElement);
    }

    @NotNull
    public String getId() {
        return JAVA_SUPPORT_ID;
    }

    public Class<?> @NotNull [] getPatternClasses() {
        Class[] classArray = new Class[]{PsiJavaPatterns.class};
        if (classArray == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    public Configurable[] createSettings(Project project, Configuration configuration) {
        return new Configurable[]{new AdvancedSettingsUI(project, configuration)};
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof PsiLiteralExpression;
    }

    @Nullable
    public BaseInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<? super PsiElement> commentRef) {
        PsiFile containingFile;
        if (host == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(1);
        }
        boolean compiled = (containingFile = host.getContainingFile()) != null && containingFile.getOriginalFile() instanceof PsiCompiledFile;
        return compiled ? null : super.findCommentInjection(host, commentRef);
    }

    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        if (!JavaLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        return JavaLanguageInjectionSupport.doInjectInJava(psiElement.getProject(), (PsiElement)psiElement, psiElement, language.getID());
    }

    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        if (!JavaLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        HashMap<BaseInjection, Pair<PsiMethod, Integer>> injectionsMap = new HashMap<BaseInjection, Pair<PsiMethod, Integer>>();
        ArrayList annotations = new ArrayList();
        PsiLiteralExpression host = (PsiLiteralExpression)psiElement;
        Project project = host.getProject();
        Configuration configuration = Configuration.getProjectInstance((Project)project);
        JavaLanguageInjectionSupport.collectInjections(host, configuration, this, injectionsMap, annotations);
        if (injectionsMap.isEmpty() && annotations.isEmpty()) {
            return false;
        }
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>(injectionsMap.keySet());
        List newInjections = ContainerUtil.mapNotNull(originalInjections, (Function)((NullableFunction)injection -> {
            Pair pair = (Pair)injectionsMap.get(injection);
            String placeText = JavaLanguageInjectionSupport.getPatternStringForJavaPlace((PsiMethod)pair.first, (Integer)pair.second);
            BaseInjection newInjection = injection.copy();
            newInjection.setPlaceEnabled(placeText, false);
            return InjectorUtils.canBeRemoved((BaseInjection)newInjection) ? null : newInjection;
        }));
        configuration.replaceInjectionsWithUndo(project, host.getContainingFile(), newInjections, originalInjections, annotations);
        return true;
    }

    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        if (!JavaLanguageInjectionSupport.isMine(psiElement)) {
            return false;
        }
        HashMap<BaseInjection, Pair<PsiMethod, Integer>> injectionsMap = new HashMap<BaseInjection, Pair<PsiMethod, Integer>>();
        ArrayList annotations = new ArrayList();
        PsiLiteralExpression host = (PsiLiteralExpression)psiElement;
        Project project = host.getProject();
        Configuration configuration = Configuration.getProjectInstance((Project)project);
        JavaLanguageInjectionSupport.collectInjections(host, configuration, this, injectionsMap, annotations);
        if (injectionsMap.isEmpty() || !annotations.isEmpty()) {
            return false;
        }
        BaseInjection originalInjection = injectionsMap.keySet().iterator().next();
        MethodParameterInjection methodParameterInjection = JavaLanguageInjectionSupport.createFrom(psiElement.getProject(), originalInjection, (PsiMethod)injectionsMap.get((Object)originalInjection).first, false);
        MethodParameterInjection copy = methodParameterInjection.copy();
        BaseInjection newInjection = JavaLanguageInjectionSupport.showInjectionUI(project, methodParameterInjection);
        if (newInjection != null) {
            newInjection.mergeOriginalPlacesFrom((BaseInjection)copy, false);
            newInjection.mergeOriginalPlacesFrom(originalInjection, true);
            configuration.replaceInjectionsWithUndo(project, psiElement.getContainingFile(), Collections.singletonList(newInjection), Collections.singletonList(originalInjection), Collections.emptyList());
        }
        return true;
    }

    private static BaseInjection showInjectionUI(Project project, MethodParameterInjection methodParameterInjection) {
        MethodParameterPanel panel = new MethodParameterPanel(methodParameterInjection, project);
        panel.reset();
        String helpID = "reference.settings.injection.language.injection.settings.java.parameter";
        return JavaLanguageInjectionSupport.showEditInjectionDialog((Project)project, (AbstractInjectionPanel)panel, null, (String)helpID) ? new BaseInjection(methodParameterInjection.getSupportId()).copyFrom((BaseInjection)methodParameterInjection) : null;
    }

    public BaseInjection createInjection(Element element) {
        return new BaseInjection(JAVA_SUPPORT_ID);
    }

    private static boolean doInjectInJava(Project project, @NotNull PsiElement psiElement, PsiLanguageInjectionHost host, String languageId) {
        PsiElement target;
        PsiElement parent;
        if (psiElement == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(2);
        }
        if ((parent = (target = ContextComputationProcessor.getTopLevelInjectionTarget(psiElement)).getParent()) instanceof PsiReturnStatement || parent instanceof PsiMethod || parent instanceof PsiNameValuePair) {
            return JavaLanguageInjectionSupport.doInjectInJavaMethod(project, JavaLanguageInjectionSupport.findPsiMethod(parent), -1, host, languageId);
        }
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCall) {
            return JavaLanguageInjectionSupport.doInjectInJavaMethod(project, JavaLanguageInjectionSupport.findPsiMethod(parent), JavaLanguageInjectionSupport.findParameterIndex(target, (PsiExpressionList)parent), host, languageId);
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiElement element;
            PsiExpression psiExpression = ((PsiAssignmentExpression)parent).getLExpression();
            if (psiExpression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)psiExpression).resolve()) != null) {
                return JavaLanguageInjectionSupport.doInjectInJava(project, element, host, languageId);
            }
        } else {
            if (parent instanceof PsiVariable) {
                return JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, (PsiModifierListOwner)parent, host, languageId);
            }
            if (target instanceof PsiVariable) {
                return JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, (PsiModifierListOwner)target, host, languageId);
            }
        }
        return false;
    }

    public static boolean doAddLanguageAnnotation(Project project, PsiModifierListOwner modifierListOwner, @NotNull PsiLanguageInjectionHost host, String languageId) {
        if (host == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(3);
        }
        return JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, modifierListOwner, host, languageId, (Processor<? super PsiLanguageInjectionHost>)((Processor)host1 -> {
            Configuration.AdvancedConfiguration configuration = Configuration.getProjectInstance((Project)project).getAdvancedConfiguration();
            boolean allowed = configuration.isSourceModificationAllowed();
            configuration.setSourceModificationAllowed(true);
            try {
                boolean bl = JavaLanguageInjectionSupport.doInjectInJava(project, (PsiElement)host1, host1, languageId);
                return bl;
            }
            finally {
                configuration.setSourceModificationAllowed(allowed);
            }
        }));
    }

    private static boolean isAnnotationsJarInPath(Module module) {
        if (module == null) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.intellij.lang.annotations.Language", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    public static boolean doAddLanguageAnnotation(@NotNull Project project, final @Nullable PsiModifierListOwner modifierListOwner, @NotNull PsiLanguageInjectionHost host, String languageId, Processor<? super PsiLanguageInjectionHost> annotationFixer) {
        if (project == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(4);
        }
        if (host == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(5);
        }
        if (modifierListOwner == null) {
            return false;
        }
        Task.WithResult<Boolean, RuntimeException> task = new Task.WithResult<Boolean, RuntimeException>(project, IntelliLangBundle.message((String)"progress.looking.for", (Object[])new Object[]{"org.intellij.lang.annotations.Language"}), true){

            protected Boolean compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (Boolean)ReadAction.nonBlocking(() -> JavaLanguageInjectionSupport.isAnnotationsJarInPath(ModuleUtilCore.findModuleForPsiElement((PsiElement)modifierListOwner))).executeSynchronously();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/intellij/plugins/intelliLang/inject/java/JavaLanguageInjectionSupport$1", "compute"));
            }
        };
        boolean addAnnotation = (Boolean)ProgressManager.getInstance().run((Task.WithResult)task) != false && PsiUtil.isLanguageLevel5OrHigher((PsiElement)modifierListOwner) && modifierListOwner.getModifierList() != null;
        PsiElement statement = PsiTreeUtil.getParentOfType((PsiElement)host, (Class[])new Class[]{PsiStatement.class, PsiField.class});
        if (!addAnnotation && statement == null) {
            return false;
        }
        Configuration.AdvancedConfiguration configuration = Configuration.getProjectInstance((Project)project).getAdvancedConfiguration();
        if (!configuration.isSourceModificationAllowed()) {
            String fixText = addAnnotation ? IntelliLangBundle.message((String)"intelliLang.suggest.insert.annotation", (Object[])new Object[0]) : IntelliLangBundle.message((String)"intelliLang.suggest.insert.comment", (Object[])new Object[0]);
            InjectLanguageAction.addFixer((PsiLanguageInjectionHost)host, annotationFixer, (String)fixText);
            return false;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{modifierListOwner.getContainingFile()}).run(() -> {
            PsiElementFactory javaFacade = JavaPsiFacade.getElementFactory((Project)project);
            if (addAnnotation) {
                JVMElementFactory factory = (JVMElementFactory)ObjectUtils.chooseNotNull((Object)JVMElementFactories.getFactory((Language)modifierListOwner.getLanguage(), (Project)project), (Object)javaFacade);
                PsiAnnotation annotation = factory.createAnnotationFromText("@org.intellij.lang.annotations.Language(\"" + languageId + "\")", (PsiElement)modifierListOwner);
                PsiModifierList list = Objects.requireNonNull(modifierListOwner.getModifierList());
                PsiAnnotation existingAnnotation = list.findAnnotation("org.intellij.lang.annotations.Language");
                if (existingAnnotation != null) {
                    existingAnnotation.replace((PsiElement)annotation);
                } else {
                    list.addAfter((PsiElement)annotation, null);
                }
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)list);
            } else {
                statement.getParent().addBefore((PsiElement)javaFacade.createCommentFromText("//language=" + languageId, (PsiElement)host), statement);
            }
        });
        return true;
    }

    public static boolean doInjectInJavaMethod(@NotNull Project project, @Nullable PsiMethod psiMethod, int parameterIndex, @NotNull PsiLanguageInjectionHost host, @NotNull String languageId) {
        if (project == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(6);
        }
        if (host == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(7);
        }
        if (languageId == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(8);
        }
        if (psiMethod == null) {
            return false;
        }
        if (parameterIndex < -1) {
            return false;
        }
        if (parameterIndex >= psiMethod.getParameterList().getParametersCount()) {
            return false;
        }
        PsiModifierList methodModifiers = psiMethod.getModifierList();
        if (methodModifiers.hasModifierProperty("private") || methodModifiers.hasModifierProperty("packageLocal")) {
            return JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, (PsiModifierListOwner)(parameterIndex >= 0 ? psiMethod.getParameterList().getParameters()[parameterIndex] : psiMethod), host, languageId);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        assert (containingClass != null);
        PsiModifierList classModifiers = containingClass.getModifierList();
        if (classModifiers != null && (classModifiers.hasModifierProperty("private") || classModifiers.hasModifierProperty("packageLocal"))) {
            return JavaLanguageInjectionSupport.doAddLanguageAnnotation(project, (PsiModifierListOwner)(parameterIndex >= 0 ? psiMethod.getParameterList().getParameters()[parameterIndex] : psiMethod), host, languageId);
        }
        MethodParameterInjection injection = JavaLanguageInjectionSupport.makeParameterInjection(psiMethod, parameterIndex, languageId);
        JavaLanguageInjectionSupport.doEditInjection(project, injection, host.getContainingFile(), psiMethod);
        return true;
    }

    @NotNull
    public static MethodParameterInjection makeParameterInjection(@NotNull PsiMethod psiMethod, int parameterIndex, @NotNull String languageId) {
        if (psiMethod == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(9);
        }
        if (languageId == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(10);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        assert (containingClass != null);
        String className = containingClass.getQualifiedName();
        assert (className != null);
        MethodParameterInjection injection = new MethodParameterInjection();
        injection.setInjectedLanguageId(languageId);
        injection.setClassName(className);
        MethodParameterInjection.MethodInfo info = MethodParameterInjection.createMethodInfo(psiMethod);
        if (parameterIndex < 0) {
            info.setReturnFlag(true);
        } else {
            info.getParamFlags()[parameterIndex] = true;
        }
        injection.setMethodInfos(Collections.singletonList(info));
        injection.generatePlaces();
        MethodParameterInjection methodParameterInjection = injection;
        if (methodParameterInjection == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(11);
        }
        return methodParameterInjection;
    }

    static int findParameterIndex(PsiElement target, PsiExpressionList parent) {
        int idx = Arrays.asList(parent.getExpressions()).indexOf(target);
        return idx < 0 ? -2 : idx;
    }

    @Nullable
    static PsiMethod findPsiMethod(PsiElement parent) {
        String name;
        PsiMethod[] methods;
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation;
        if (parent instanceof PsiNameValuePair && (annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiAnnotation.class)) != null && (referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null && (methods = ((PsiClass)resolved).findMethodsByName((name = ((PsiNameValuePair)parent).getName()) == null ? "value" : name, false)).length == 1) {
            return methods[0];
        }
        PsiMethod first = parent.getParent() instanceof PsiCall ? ((PsiCall)parent.getParent()).resolveMethod() : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class, (boolean)false);
        if (first == null || first.getContainingClass() == null) {
            return null;
        }
        LinkedList<PsiMethod> methods2 = new LinkedList<PsiMethod>();
        methods2.add(first);
        while (!methods2.isEmpty()) {
            PsiMethod method = (PsiMethod)methods2.removeFirst();
            PsiClass psiClass = method.getContainingClass();
            if (psiClass != null && psiClass.getQualifiedName() != null) {
                return method;
            }
            ContainerUtil.addAll(methods2, (Object[])method.findSuperMethods());
        }
        return null;
    }

    private static void doEditInjection(Project project, MethodParameterInjection template, PsiFile psiFile, PsiMethod contextMethod) {
        MethodParameterInjection methodParameterInjection;
        BaseInjection baseTemplate;
        MethodParameterInjection allMethodParameterInjection;
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        BaseInjection originalInjection = configuration.findExistingInjection((BaseInjection)(allMethodParameterInjection = JavaLanguageInjectionSupport.createFrom(project, baseTemplate = new BaseInjection(template.getSupportId()).copyFrom((BaseInjection)template), contextMethod, true)));
        if (originalInjection == null) {
            methodParameterInjection = template;
        } else {
            BaseInjection originalCopy = originalInjection.copy();
            InjectionPlace currentPlace = template.getInjectionPlaces()[0];
            originalCopy.mergeOriginalPlacesFrom((BaseInjection)template, true);
            originalCopy.setPlaceEnabled(currentPlace.getText(), true);
            methodParameterInjection = JavaLanguageInjectionSupport.createFrom(project, originalCopy, contextMethod, false);
        }
        JavaLanguageInjectionSupport.mergePlacesAndAddToConfiguration(project, psiFile, configuration, methodParameterInjection, originalInjection);
    }

    private static void mergePlacesAndAddToConfiguration(@NotNull Project project, @Nullable PsiFile psiFile, @NotNull Configuration configuration, @NotNull MethodParameterInjection injection, @Nullable BaseInjection originalInjection) {
        if (project == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(12);
        }
        if (configuration == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(13);
        }
        if (injection == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(14);
        }
        BaseInjection newInjection = new BaseInjection(injection.getSupportId()).copyFrom((BaseInjection)injection);
        if (originalInjection != null) {
            newInjection.mergeOriginalPlacesFrom(originalInjection, true);
        }
        configuration.replaceInjectionsWithUndo(project, psiFile, Collections.singletonList(newInjection), ContainerUtil.createMaybeSingletonList((Object)originalInjection), Collections.emptyList());
    }

    private static void collectInjections(PsiLiteralExpression host, Configuration configuration, JavaLanguageInjectionSupport support, final HashMap<BaseInjection, Pair<PsiMethod, Integer>> injectionsMap, final ArrayList<? super PsiElement> annotations) {
        new ConcatenationInjector.InjectionProcessor(configuration, (LanguageInjectionSupport)support, new PsiElement[]{host}){

            @Override
            protected boolean processCommentInjectionInner(PsiElement comment, BaseInjection injection) {
                ContainerUtil.addAll((Collection)annotations, (Object[])new PsiElement[]{comment});
                return true;
            }

            @Override
            protected boolean processAnnotationInjectionInner(PsiModifierListOwner owner, PsiAnnotation[] annos) {
                ContainerUtil.addAll((Collection)annotations, (Object[])annos);
                return true;
            }

            @Override
            protected boolean processXmlInjections(BaseInjection injection, PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
                injectionsMap.put(injection, Pair.create((Object)method, (Object)paramIndex));
                return true;
            }
        }.processInjections();
    }

    @NotNull
    private static MethodParameterInjection createFrom(Project project, BaseInjection injection, PsiMethod contextMethod, boolean includeAllPlaces) {
        PsiClass[] classes;
        String className;
        if (contextMethod != null) {
            PsiClass[] psiClassArray;
            PsiClass psiClass = contextMethod.getContainingClass();
            String string = className = psiClass == null ? "" : StringUtil.notNullize((String)psiClass.getQualifiedName());
            if (psiClass == null) {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            } else {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = psiClass;
            }
            classes = psiClassArray;
        } else {
            Matcher matcher;
            Object found = null;
            Pattern pattern = Pattern.compile(".*definedInClass\\(\"([^\"]*)\"\\)+");
            for (InjectionPlace place : injection.getInjectionPlaces()) {
                Matcher matcher2 = pattern.matcher(place.getText());
                if (!matcher2.matches()) continue;
                found = matcher2.group(1);
            }
            if (found == null && (matcher = ourPresentationPattern.matcher(injection.getDisplayName())).matches()) {
                String pkg = matcher.group(2);
                found = pkg.substring(1, pkg.length() - 1) + "." + matcher.group(1);
            }
            classes = found != null && project.isInitialized() ? JavaPsiFacade.getInstance((Project)project).findClasses(found, GlobalSearchScope.allScope((Project)project)) : PsiClass.EMPTY_ARRAY;
            className = StringUtil.notNullize(classes.length == 0 ? found : classes[0].getQualifiedName());
        }
        MethodParameterInjection result = new MethodParameterInjection();
        result.copyFrom(injection);
        result.setInjectionPlaces(InjectionPlace.EMPTY_ARRAY);
        result.setClassName(className);
        ArrayList<MethodParameterInjection.MethodInfo> infos = new ArrayList<MethodParameterInjection.MethodInfo>();
        if (classes.length > 0) {
            HashSet<String> visitedSignatures = new HashSet<String>();
            PatternCompiler compiler = injection.getCompiler();
            for (PsiClass psiClass : classes) {
                for (PsiMethod method : psiClass.getMethods()) {
                    PsiModifierList modifiers = method.getModifierList();
                    if (modifiers.hasModifierProperty("private") || modifiers.hasModifierProperty("packageLocal")) continue;
                    boolean add = false;
                    MethodParameterInjection.MethodInfo methodInfo = MethodParameterInjection.createMethodInfo(method);
                    if (!visitedSignatures.add(methodInfo.getMethodSignature())) continue;
                    if (MethodParameterInjection.isInjectable(method.getReturnType(), method.getProject())) {
                        int parameterIndex = -1;
                        int index = ArrayUtilRt.find((Object[])injection.getInjectionPlaces(), (Object)new InjectionPlace(compiler.compileElementPattern(JavaLanguageInjectionSupport.getPatternStringForJavaPlace(method, -1)), true));
                        InjectionPlace place = index > -1 ? injection.getInjectionPlaces()[index] : null;
                        methodInfo.setReturnFlag(place != null && place.isEnabled() || includeAllPlaces);
                        add = true;
                    }
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        PsiParameter p = parameters[i];
                        if (!MethodParameterInjection.isInjectable(p.getType(), p.getProject())) continue;
                        int index = ArrayUtilRt.find((Object[])injection.getInjectionPlaces(), (Object)new InjectionPlace(compiler.compileElementPattern(JavaLanguageInjectionSupport.getPatternStringForJavaPlace(method, i)), true));
                        InjectionPlace place = index > -1 ? injection.getInjectionPlaces()[index] : null;
                        methodInfo.getParamFlags()[i] = place != null && place.isEnabled() || includeAllPlaces;
                        add = true;
                    }
                    if (!add) continue;
                    infos.add(methodInfo);
                }
            }
        }
        result.setMethodInfos(infos);
        result.generatePlaces();
        MethodParameterInjection methodParameterInjection = result;
        if (methodParameterInjection == null) {
            JavaLanguageInjectionSupport.$$$reportNull$$$0(15);
        }
        return methodParameterInjection;
    }

    public static String getPatternStringForJavaPlace(PsiMethod method, int parameterIndex) {
        PsiClass psiClass = method.getContainingClass();
        String className = psiClass == null ? "" : StringUtil.notNullize((String)psiClass.getQualifiedName());
        String signature = MethodParameterInjection.createMethodInfo(method).getMethodSignature();
        return MethodParameterInjection.getPatternStringForJavaPlace(method.getName(), MethodParameterInjection.getParameterTypesString(signature), parameterIndex, className);
    }

    public AnAction[] createAddActions(final Project project, final Consumer<? super BaseInjection> consumer) {
        return new AnAction[]{new AnAction(IntelliLangBundle.message((String)"java.parameter", (Object[])new Object[0]), null, IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter)){

            public void actionPerformed(@NotNull AnActionEvent e) {
                BaseInjection injection;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((injection = JavaLanguageInjectionSupport.showInjectionUI(project, new MethodParameterInjection())) != null) {
                    consumer.consume((Object)injection);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/inject/java/JavaLanguageInjectionSupport$3", "actionPerformed"));
            }
        }};
    }

    public AnAction createEditAction(final Project project, final Factory<? extends BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                BaseInjection originalInjection = (BaseInjection)producer.create();
                MethodParameterInjection injection = JavaLanguageInjectionSupport.createFrom(project, originalInjection, null, false);
                boolean mergeEnabled = !project.isInitialized() || JavaPsiFacade.getInstance((Project)project).findClass(injection.getClassName(), GlobalSearchScope.allScope((Project)project)) == null;
                BaseInjection newInjection = JavaLanguageInjectionSupport.showInjectionUI(project, injection);
                if (newInjection != null) {
                    newInjection.mergeOriginalPlacesFrom(originalInjection, mergeEnabled);
                    originalInjection.copyFrom(newInjection);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/inject/java/JavaLanguageInjectionSupport$4", "actionPerformed"));
            }
        };
    }

    public void setupPresentation(BaseInjection injection, SimpleColoredText presentation, boolean isSelected) {
        Matcher matcher = ourPresentationPattern.matcher(injection.getDisplayName());
        if (matcher.matches()) {
            presentation.append(matcher.group(1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation.append(matcher.group(2), isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            super.setupPresentation(injection, presentation, isSelected);
        }
    }

    public String getHelpId() {
        return "reference.settings.injection.language.injection.settings.java.parameter";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/java/JavaLanguageInjectionSupport";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/java/JavaLanguageInjectionSupport";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "makeParameterInjection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrom";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInjectInJava";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddLanguageAnnotation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doInjectInJavaMethod";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "makeParameterInjection";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mergePlacesAndAddToConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

