/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.jetbrains.plugins.textmate.regex.TextMateRange;

public final class SyntaxMatchUtils {
    private static final Cache<MatchKey, TextMateLexerState> CACHE = Caffeine.newBuilder().maximumSize(100000L).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final TextMateSelectorWeigher mySelectorWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
    private static Runnable ourCheckCancelledCallback = null;
    private static final Pattern CAPTURE_GROUP_REGEX = Pattern.compile("\\$([0-9]+)|\\$\\{([0-9]+):/(downcase|upcase)}");

    public static void setCheckCancelledCallback(@Nullable Runnable runnable) {
        ourCheckCancelledCallback = runnable;
    }

    public static Runnable getCheckCancelledCallback() {
        return ourCheckCancelledCallback;
    }

    @NotNull
    public static TextMateLexerState matchFirst(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, int gosOffset, boolean matchBeginOfString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope) {
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(0);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(1);
        }
        if (priority == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(2);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(3);
        }
        TextMateLexerState textMateLexerState = (TextMateLexerState)CACHE.get((Object)new MatchKey(syntaxNodeDescriptor, string, byteOffset, gosOffset, matchBeginOfString, priority, currentScope), SyntaxMatchUtils::matchFirstUncached);
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(4);
        }
        return textMateLexerState;
    }

    private static TextMateLexerState matchFirstUncached(MatchKey key) {
        return SyntaxMatchUtils.matchFirstUncached(Objects.requireNonNull(key).descriptor, key.string, key.byteOffset, key.gosOffset, key.matchBeginOfString, key.priority, key.currentScope);
    }

    @NotNull
    private static TextMateLexerState matchFirstUncached(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, int gosOffset, boolean matchBeginOfString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope) {
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(5);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(6);
        }
        if (priority == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(7);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(8);
        }
        TextMateLexerState resultState = TextMateLexerState.notMatched(syntaxNodeDescriptor);
        List<SyntaxNodeDescriptor> children = syntaxNodeDescriptor.getChildren();
        for (SyntaxNodeDescriptor child : children) {
            resultState = SyntaxMatchUtils.moreImportantState(resultState, SyntaxMatchUtils.matchFirstChild(child, string, byteOffset, gosOffset, matchBeginOfString, priority, currentScope));
            if (!resultState.matchData.matched() || resultState.matchData.byteOffset().start != byteOffset) continue;
            break;
        }
        return SyntaxMatchUtils.moreImportantState(resultState, SyntaxMatchUtils.matchInjections(syntaxNodeDescriptor, string, byteOffset, gosOffset, matchBeginOfString, currentScope));
    }

    @NotNull
    private static TextMateLexerState matchInjections(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, int gosOffset, boolean matchBeginOfString, @NotNull TextMateScope currentScope) {
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(9);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(10);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(11);
        }
        TextMateLexerState resultState = TextMateLexerState.notMatched(syntaxNodeDescriptor);
        List<InjectionNodeDescriptor> injections = syntaxNodeDescriptor.getInjections();
        for (InjectionNodeDescriptor injection : injections) {
            TextMateWeigh selectorWeigh = mySelectorWeigher.weigh(injection.getSelector(), currentScope);
            if (selectorWeigh.weigh <= 0) continue;
            TextMateLexerState injectionState = SyntaxMatchUtils.matchFirstUncached(injection.getSyntaxNodeDescriptor(), string, byteOffset, gosOffset, matchBeginOfString, selectorWeigh.priority, currentScope);
            resultState = SyntaxMatchUtils.moreImportantState(resultState, injectionState);
        }
        TextMateLexerState textMateLexerState = resultState;
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(12);
        }
        return textMateLexerState;
    }

    @NotNull
    private static TextMateLexerState moreImportantState(@NotNull TextMateLexerState oldState, @NotNull TextMateLexerState newState) {
        if (oldState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(13);
        }
        if (newState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(14);
        }
        if (!newState.matchData.matched()) {
            TextMateLexerState textMateLexerState = oldState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(15);
            }
            return textMateLexerState;
        }
        if (!oldState.matchData.matched()) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(16);
            }
            return textMateLexerState;
        }
        int newScore = newState.matchData.byteOffset().start;
        int oldScore = oldState.matchData.byteOffset().start;
        if ((newScore < oldScore || newScore == oldScore && newState.priorityMatch.compareTo(oldState.priorityMatch) > 0) && (!newState.matchData.byteOffset().isEmpty() || oldState.matchData.byteOffset().isEmpty() || SyntaxMatchUtils.hasBeginKey(newState))) {
            TextMateLexerState textMateLexerState = newState;
            if (textMateLexerState == null) {
                SyntaxMatchUtils.$$$reportNull$$$0(17);
            }
            return textMateLexerState;
        }
        TextMateLexerState textMateLexerState = oldState;
        if (textMateLexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(18);
        }
        return textMateLexerState;
    }

    private static boolean hasBeginKey(@NotNull TextMateLexerState lexerState) {
        if (lexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(19);
        }
        return lexerState.syntaxRule.getStringAttribute(Constants.StringKey.BEGIN) != null;
    }

    private static TextMateLexerState matchFirstChild(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull StringWithId string, int byteOffset, int gosOffset, boolean matchBeginOfString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope) {
        CharSequence match;
        if (syntaxNodeDescriptor == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(20);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(21);
        }
        if (priority == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(22);
        }
        if (currentScope == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(23);
        }
        if ((match = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.MATCH)) != null) {
            RegexFacade regex = RegexFacade.regex(match.toString());
            MatchData matchData = regex.match(string, byteOffset, gosOffset, matchBeginOfString, ourCheckCancelledCallback);
            return new TextMateLexerState(syntaxNodeDescriptor, matchData, priority, byteOffset, string);
        }
        CharSequence begin = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.BEGIN);
        if (begin != null) {
            RegexFacade regex = RegexFacade.regex(begin.toString());
            MatchData matchData = regex.match(string, byteOffset, gosOffset, matchBeginOfString, ourCheckCancelledCallback);
            return new TextMateLexerState(syntaxNodeDescriptor, matchData, priority, byteOffset, string);
        }
        if (syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.END) != null) {
            return TextMateLexerState.notMatched(syntaxNodeDescriptor);
        }
        return SyntaxMatchUtils.matchFirstUncached(syntaxNodeDescriptor, string, byteOffset, gosOffset, matchBeginOfString, priority, currentScope);
    }

    public static MatchData matchStringRegex(@NotNull Constants.StringKey keyName, @NotNull StringWithId string, int byteOffset, int anchorOffset, boolean matchBeginOfString, @NotNull TextMateLexerState lexerState) {
        CharSequence regex;
        if (keyName == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(24);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(25);
        }
        if (lexerState == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(26);
        }
        if ((regex = lexerState.syntaxRule.getStringAttribute(keyName)) == null) {
            return MatchData.NOT_MATCHED;
        }
        String regexString = lexerState.syntaxRule.hasBackReference(keyName) ? SyntaxMatchUtils.replaceGroupsWithMatchDataInRegex(regex, lexerState.string, lexerState.matchData) : regex.toString();
        return RegexFacade.regex(regexString).match(string, byteOffset, anchorOffset, matchBeginOfString, ourCheckCancelledCallback);
    }

    @Nullable
    public static CharSequence getStringAttribute(@NotNull Constants.StringKey keyName, @NotNull SyntaxNodeDescriptor syntaxRule, @NotNull StringWithId string, @NotNull MatchData matchData) {
        CharSequence stringAttribute;
        if (syntaxRule == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(27);
        }
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(28);
        }
        if (matchData == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(29);
        }
        if (keyName == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(30);
        }
        if ((stringAttribute = syntaxRule.getStringAttribute(keyName)) == null) {
            return null;
        }
        return syntaxRule.hasBackReference(keyName) ? SyntaxMatchUtils.replaceGroupsWithMatchDataInCaptures(stringAttribute, string, matchData) : stringAttribute;
    }

    public static String replaceGroupsWithMatchDataInRegex(@NotNull CharSequence string, @Nullable StringWithId matchingString, @NotNull MatchData matchData) {
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(31);
        }
        if (matchData == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(32);
        }
        if (matchingString == null || !matchData.matched()) {
            return string.toString();
        }
        StringBuilder result = new StringBuilder();
        int charIndex = 0;
        int length = string.length();
        while (charIndex < length) {
            char c = string.charAt(charIndex);
            if (c == '\\') {
                int digit;
                int digitIndex;
                boolean hasGroupIndex = false;
                int groupIndex = 0;
                for (digitIndex = charIndex + 1; digitIndex < length && (digit = Character.digit(string.charAt(digitIndex), 10)) != -1; ++digitIndex) {
                    hasGroupIndex = true;
                    groupIndex = groupIndex * 10 + digit;
                }
                if (hasGroupIndex && matchData.count() > groupIndex) {
                    TextMateRange range = matchData.byteOffset(groupIndex);
                    Strings.escapeToRegexp((CharSequence)new String(matchingString.bytes, range.start, range.getLength(), StandardCharsets.UTF_8), (StringBuilder)result);
                    charIndex = digitIndex;
                    continue;
                }
            }
            result.append(c);
            ++charIndex;
        }
        return result.toString();
    }

    public static CharSequence replaceGroupsWithMatchDataInCaptures(@NotNull CharSequence string, @NotNull StringWithId matchingString, @NotNull MatchData matchData) {
        if (string == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(33);
        }
        if (matchingString == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(34);
        }
        if (matchData == null) {
            SyntaxMatchUtils.$$$reportNull$$$0(35);
        }
        if (!matchData.matched()) {
            return string;
        }
        Matcher matcher = CAPTURE_GROUP_REGEX.matcher(string);
        StringBuilder result = new StringBuilder();
        int lastPosition = 0;
        while (matcher.find()) {
            int groupIndex = StringUtilRt.parseInt((String)(matcher.group(1) != null ? matcher.group(1) : matcher.group(2)), (int)-1);
            if (groupIndex < 0 || matchData.count() <= groupIndex) continue;
            result.append(string, lastPosition, matcher.start());
            TextMateRange range = matchData.byteOffset(groupIndex);
            String capturedText = new String(matchingString.bytes, range.start, range.getLength(), StandardCharsets.UTF_8);
            int numberOfDotsAtTheBeginning = Strings.countChars((CharSequence)capturedText, (char)'.', (int)0, (boolean)true);
            String replacement = capturedText.substring(numberOfDotsAtTheBeginning);
            String command = matcher.group(3);
            if ("downcase".equals(command)) {
                result.append(replacement.toLowerCase(Locale.ROOT));
            } else if ("upcase".equals(command)) {
                result.append(replacement.toUpperCase(Locale.ROOT));
            } else {
                result.append(replacement);
            }
            lastPosition = matcher.end();
        }
        if (lastPosition < string.length()) {
            result.append(string.subSequence(lastPosition, string.length()));
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxNodeDescriptor";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScope";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexerState";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxRule";
                break;
            }
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchData";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "matchFirst";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "matchInjections";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "moreImportantState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchFirst";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchFirstUncached";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchInjections";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moreImportantState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasBeginKey";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "matchFirstChild";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "matchStringRegex";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttribute";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "replaceGroupsWithMatchDataInRegex";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceGroupsWithMatchDataInCaptures";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static final class MatchKey {
        final SyntaxNodeDescriptor descriptor;
        final StringWithId string;
        final int byteOffset;
        final int gosOffset;
        final boolean matchBeginOfString;
        private final TextMateWeigh.Priority priority;
        final TextMateScope currentScope;

        private MatchKey(SyntaxNodeDescriptor descriptor, StringWithId string, int byteOffset, int gosOffset, boolean matchBeginOfString, TextMateWeigh.Priority priority, TextMateScope currentScope) {
            this.descriptor = descriptor;
            this.string = string;
            this.byteOffset = byteOffset;
            this.gosOffset = gosOffset;
            this.matchBeginOfString = matchBeginOfString;
            this.priority = priority;
            this.currentScope = currentScope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchKey key = (MatchKey)o;
            return this.byteOffset == key.byteOffset && this.gosOffset == key.gosOffset && this.matchBeginOfString == key.matchBeginOfString && this.descriptor.equals(key.descriptor) && Objects.equals(this.string, key.string) && this.priority == key.priority && this.currentScope.equals(key.currentScope);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.descriptor, this.string, this.byteOffset, this.gosOffset, this.matchBeginOfString, this.priority, this.currentScope});
        }
    }
}

