/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.ScrollRequestListener;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.editors.EditorToEditorSynchronizer;
import com.jetbrains.rdserver.editors.EditorToEditorSynchronizerKt;
import com.jetbrains.rdserver.editors.RemoteEditorDataKt;
import com.jetbrains.rdserver.editors.ScrollRequest;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0006\u0010!\u001a\u00020\u0012J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020$H\u0002J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010(\u001a\u00020.H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Lcom/intellij/openapi/editor/impl/ScrollRequestListener;", "from", "Lcom/intellij/openapi/editor/Editor;", "to", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "lastRequest", "Lcom/jetbrains/rdserver/editors/ScrollRequest;", "visibleAreaChangesQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "adviseOnRemoteScroll", "", "editor", "caretAdded", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretPositionChanged", "caretRemoved", "dump", "", "getOther", "editorImpl", "headlessVisibleAreaChanged", "startOffset", "", "endOffset", "install", "scrollRequested", "targetPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "selectionChanged", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "syncCaret", "otherEditor", "position", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "intellij.cwm.host"})
@SourceDebugExtension(value={"SMAP\nEditorToEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorToEditorSynchronizer.kt\ncom/jetbrains/rdserver/editors/EditorToEditorSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class EditorToEditorSynchronizer
implements CaretListener,
SelectionListener,
VisibleAreaListener,
ScrollRequestListener {
    @NotNull
    private final Editor from;
    @NotNull
    private final Editor to;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue visibleAreaChangesQueue;
    @Nullable
    private ScrollRequest lastRequest;
    private static final String[] a;
    private static final String[] b;

    public EditorToEditorSynchronizer(@NotNull Editor from, @NotNull Editor to, @NotNull Lifetime lifetime) {
        long l2 = 35475453493865L;
        Intrinsics.checkNotNullParameter((Object)from, (String)EditorToEditorSynchronizer.a(976340430 + 21831, -976340430 + -((char)-25061), (int)l2));
        Intrinsics.checkNotNullParameter((Object)to, (String)EditorToEditorSynchronizer.a(976340430 + 21830, 976340430 + (char)-21549, (int)l2));
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)EditorToEditorSynchronizer.a(976340430 + 21833, 976340430 + 17159, (int)l2));
        this.from = from;
        this.to = to;
        this.lifetime = lifetime;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)this.lifetime, (String)EditorToEditorSynchronizer.a(976340430 + 21832, -976340430 + -((char)-24153), (int)l2));
        this.visibleAreaChangesQueue = new MergingUpdateQueue(EditorToEditorSynchronizer.a(976340430 + 21827, -976340430 + -29800, (int)l2), 100, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, this.from.getComponent(), true);
        LogicalPosition logicalPosition = this.from.getCaretModel().getPrimaryCaret().getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)EditorToEditorSynchronizer.a(976340430 + 21826, 976340430 + (char)-21352, (int)l2));
        this.syncCaret(this.to, logicalPosition);
        this.visibleAreaChangesQueue.setRestartTimerOnAdd(true);
        this.adviseOnRemoteScroll(this.from);
    }

    public final void install() {
        ScrollingModelImpl scrollingModelImpl;
        block9: {
            block8: {
                ScrollingModel scrollingModel;
                block7: {
                    long l2 = 104565948084697L;
                    ActionTimestamp[] actionTimestampArray = BackendEditorHost.V();
                    this.from.getSelectionModel().addSelectionListener((SelectionListener)this, this.disposable);
                    this.from.getCaretModel().addCaretListener((CaretListener)this, this.disposable);
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    this.from.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this, this.disposable);
                    ScrollingModel scrollingModel2 = this.from.getScrollingModel();
                    try {
                        try {
                            scrollingModel = scrollingModel2;
                            if (actionTimestampArray2 != null) break block7;
                            if (!(scrollingModel instanceof ScrollingModelImpl)) break block8;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                        }
                        scrollingModel = scrollingModel2;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                    }
                }
                scrollingModelImpl = (ScrollingModelImpl)scrollingModel;
                break block9;
            }
            scrollingModelImpl = null;
        }
        try {
            if (scrollingModelImpl != null) {
                scrollingModelImpl.addScrollRequestListener((ScrollRequestListener)this, this.disposable);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw EditorToEditorSynchronizer.a(unsupportedOperationException);
        }
    }

    private final void adviseOnRemoteScroll(Editor editor) {
        block4: {
            long l2 = 39124674449703L;
            try {
                OptProperty<ProperTextRange> optProperty;
                try {
                    optProperty = RemoteEditorDataKt.getRemoteEditorData(editor);
                    if (optProperty == null || (optProperty = optProperty.getVisibleRange()) == null) break block4;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                }
                optProperty.advise(this.lifetime, (Function1)new Function1<ProperTextRange, Unit>(this, editor){
                    final /* synthetic */ EditorToEditorSynchronizer this$0;
                    final /* synthetic */ Editor $editor;
                    private static final String a;
                    {
                        this.this$0 = $receiver;
                        this.$editor = $editor;
                        super(1);
                    }

                    public final void invoke(@NotNull ProperTextRange it) {
                        long l2 = 101693848256719L;
                        Intrinsics.checkNotNullParameter((Object)it, (String)a);
                        EditorToEditorSynchronizer.access$headlessVisibleAreaChanged(this.this$0, this.$editor, it.getStartOffset(), it.getEndOffset());
                    }

                    /*
                     * Handled impossible loop by duplicating code
                     * Enabled aggressive block sorting
                     */
                    static {
                        char[] cArray;
                        block12: {
                            int n2;
                            char[] cArray2;
                            int n3;
                            int n4;
                            block11: {
                                char[] cArray3 = "\u00161".toCharArray();
                                int n5 = cArray3.length;
                                n4 = 0;
                                n3 = 88;
                                cArray2 = cArray3;
                                n2 = n5;
                                if (n5 <= 1) break block11;
                                cArray = cArray2;
                                n2 = n2;
                                if (n2 <= n4) break block12;
                            }
                            do {
                                int n6 = n3;
                                cArray2 = cArray2;
                                char[] cArray4 = cArray2;
                                int n7 = n3;
                                int n8 = n4;
                                while (true) {
                                    cArray4[n8] = (char)(cArray4[n8] ^ (n7 ^ (switch (n4 % 7) {
                                        case 0 -> 39;
                                        case 1 -> 29;
                                        case 2 -> 35;
                                        case 3 -> 56;
                                        case 4 -> 120;
                                        case 5 -> 76;
                                        default -> 31;
                                    })));
                                    ++n4;
                                    n3 = n6;
                                    if (n6 != 0) break;
                                    n6 = n3;
                                    cArray2 = cArray2;
                                    n8 = n3;
                                    cArray4 = cArray2;
                                    n7 = n3;
                                }
                                cArray = cArray2;
                                n2 = n2;
                            } while (n2 > n4);
                        }
                        a = new String(cArray).intern();
                    }
                });
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw EditorToEditorSynchronizer.a(unsupportedOperationException);
            }
        }
    }

    private final Editor getOther(Editor editorImpl) {
        long l2;
        block11: {
            Editor editor;
            block10: {
                boolean bl;
                block8: {
                    ActionTimestamp[] actionTimestampArray;
                    block9: {
                        l2 = 84697069095924L;
                        actionTimestampArray = BackendEditorHost.V();
                        try {
                            try {
                                bl = Intrinsics.areEqual((Object)editorImpl, (Object)this.from);
                                if (actionTimestampArray != null) break block8;
                                if (!bl) break block9;
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                            }
                            return this.to;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                        }
                    }
                    try {
                        editor = editorImpl;
                        if (actionTimestampArray != null) break block10;
                        bl = Intrinsics.areEqual((Object)editor, (Object)this.to);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                    }
                }
                try {
                    if (!bl) break block11;
                    editor = this.from;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                }
            }
            return editor;
        }
        throw new UnsupportedOperationException(EditorToEditorSynchronizer.a(-314043720 - -16342, -314043720 - -16003, (int)l2));
    }

    public void selectionChanged(@NotNull SelectionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Editor editor = e2.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        Editor editor2 = this.getOther(editor);
        editor2.getSelectionModel().setSelection(e2.getNewRange().getStartOffset(), e2.getNewRange().getEndOffset());
        DocumentExKt.adjustScrollPosition((Editor)editor2);
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        long l2 = 91906457200772L;
        Intrinsics.checkNotNullParameter((Object)event, (String)EditorToEditorSynchronizer.a(1547936700 + (char)-29117, -1547936700 + -((char)-11232), (int)l2));
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)EditorToEditorSynchronizer.a(1547936700 + (char)-29132, 1547936700 + 23973, (int)l2));
        Editor editor2 = editor;
        Editor editor3 = this.getOther(editor2);
        LogicalPosition logicalPosition = event.getNewPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)EditorToEditorSynchronizer.a(1547936700 + (char)-29131, 1547936700 + 28827, (int)l2));
        this.syncCaret(editor3, logicalPosition);
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e2) {
        VisibleAreaEvent visibleAreaEvent;
        long l2;
        block4: {
            block5: {
                l2 = 107765600719872L;
                ActionTimestamp[] actionTimestampArray = BackendEditorHost.V();
                try {
                    try {
                        visibleAreaEvent = e2;
                        if (actionTimestampArray != null) break block4;
                        Intrinsics.checkNotNullParameter((Object)visibleAreaEvent, (String)"e");
                        if (ClientId.Companion.isCurrentlyUnderLocalId()) break block5;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                    }
                    return;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw EditorToEditorSynchronizer.a(unsupportedOperationException);
                }
            }
            visibleAreaEvent = e2;
        }
        Editor editor = visibleAreaEvent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)EditorToEditorSynchronizer.a(-576314790 - -11036, -576314790 - -23349, (int)l2));
        Editor editor2 = editor;
        Editor editor3 = this.getOther(editor2);
        this.visibleAreaChangesQueue.queue(new Update(editor2, this, editor3, e2){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ EditorToEditorSynchronizer this$0;
            final /* synthetic */ Editor $otherEditor;
            final /* synthetic */ VisibleAreaEvent $e;
            private static final String[] a;
            private static final String[] b;
            {
                long l2 = 8833091159862L;
                this.$editor = $editor;
                this.this$0 = $receiver;
                this.$otherEditor = $otherEditor;
                this.$e = $e;
                super((Object)visibleAreaChanged.1.a(1656593730 - 12868, -1656593730 - -27828, (int)l2));
            }

            public void run() {
                Object object;
                ScrollRequest scrollRequest;
                ScrollingModel scrollingModel;
                block27: {
                    block26: {
                        ScrollRequest scrollRequest2;
                        ScrollRequest scrollRequest3;
                        ActionTimestamp[] actionTimestampArray;
                        block25: {
                            LogicalPosition logicalPosition;
                            long l2;
                            block24: {
                                Rectangle rectangle;
                                block23: {
                                    ScrollRequest scrollRequest4;
                                    boolean bl;
                                    block21: {
                                        block20: {
                                            block22: {
                                                ScrollRequest scrollRequest5;
                                                l2 = 26724602758857L;
                                                ActionTimestamp[] actionTimestampArray2 = BackendEditorHost.V();
                                                Rectangle rectangle2 = this.$editor.getScrollingModel().getVisibleArea();
                                                Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)visibleAreaChanged.1.a(-1316204940 + -25460, 1316204940 + (char)-19653, (int)l2));
                                                rectangle = rectangle2;
                                                actionTimestampArray = actionTimestampArray2;
                                                try {
                                                    if (actionTimestampArray != null || (scrollRequest5 = EditorToEditorSynchronizer.access$getLastRequest$p(this.this$0)) == null) break block20;
                                                }
                                                catch (RuntimeException runtimeException) {
                                                    throw visibleAreaChanged.1.a(runtimeException);
                                                }
                                                ScrollRequest scrollRequest6 = scrollRequest5;
                                                VisibleAreaEvent visibleAreaEvent = this.$e;
                                                ScrollRequest scrollRequest7 = scrollRequest6;
                                                boolean bl2 = false;
                                                try {
                                                    try {
                                                        bl = rectangle.contains(visibleAreaEvent.getEditor().logicalPositionToXY(scrollRequest7.getTargetPosition()));
                                                        if (actionTimestampArray != null) break block21;
                                                        if (!bl) break block22;
                                                    }
                                                    catch (RuntimeException runtimeException) {
                                                        throw visibleAreaChanged.1.a(runtimeException);
                                                    }
                                                    bl = true;
                                                    break block21;
                                                }
                                                catch (RuntimeException runtimeException) {
                                                    throw visibleAreaChanged.1.a(runtimeException);
                                                }
                                            }
                                            bl = false;
                                            break block21;
                                        }
                                        bl = false;
                                    }
                                    try {
                                        scrollRequest4 = bl ? EditorToEditorSynchronizer.access$getLastRequest$p(this.this$0) : null;
                                    }
                                    catch (RuntimeException runtimeException) {
                                        throw visibleAreaChanged.1.a(runtimeException);
                                    }
                                    scrollRequest3 = scrollRequest4;
                                    try {
                                        try {
                                            try {
                                                EditorToEditorSynchronizer.access$setLastRequest$p(this.this$0, null);
                                                if (actionTimestampArray != null || (scrollRequest2 = scrollRequest3) == null) break block23;
                                            }
                                            catch (RuntimeException runtimeException) {
                                                throw visibleAreaChanged.1.a(runtimeException);
                                            }
                                            LogicalPosition logicalPosition2 = scrollRequest2.getTargetPosition();
                                            logicalPosition = logicalPosition2;
                                            scrollRequest2 = logicalPosition2;
                                            if (actionTimestampArray != null) break block24;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            throw visibleAreaChanged.1.a(runtimeException);
                                        }
                                        if (logicalPosition != null) break block25;
                                    }
                                    catch (RuntimeException runtimeException) {
                                        throw visibleAreaChanged.1.a(runtimeException);
                                    }
                                }
                                LogicalPosition logicalPosition3 = this.$editor.xyToLogicalPosition(new Point(0, rectangle.y + rectangle.height / 3));
                                logicalPosition = logicalPosition3;
                                scrollRequest2 = logicalPosition3;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)visibleAreaChanged.1.a(-1316204940 + -25457, -1316204940 + -20898, (int)l2));
                        }
                        ScrollRequest scrollRequest8 = scrollRequest2;
                        try {
                            try {
                                try {
                                    this.$otherEditor.getScrollingModel().disableAnimation();
                                    scrollingModel = this.$otherEditor.getScrollingModel();
                                    scrollRequest = scrollRequest8;
                                    if (actionTimestampArray != null) break block26;
                                    object = scrollRequest3;
                                    if (object == null) break block26;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw visibleAreaChanged.1.a(runtimeException);
                                }
                                if ((object = ((ScrollRequest)object).getType()) != null) break block27;
                            }
                            catch (RuntimeException runtimeException) {
                                throw visibleAreaChanged.1.a(runtimeException);
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw visibleAreaChanged.1.a(runtimeException);
                        }
                    }
                    object = ScrollType.CENTER;
                }
                scrollingModel.scrollTo((LogicalPosition)scrollRequest, (ScrollType)object);
                this.$otherEditor.getScrollingModel().enableAnimation();
            }

            private static RuntimeException a(RuntimeException runtimeException) {
                return runtimeException;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[3];
                    var3_1 = 0;
                    var2_2 = "\u00e8\u008e7\u00df\u008fc\u00f5\u0001$\u00ab+\u001f\u0013iS\u00afV\u00fa<\u008f\u00a6\u00fa\u00e2\\{\u009e\u00cfl\u00b9\u00f3Q \u0018\u00e8\\C\u0011f\u00d6\u0093o\u00b9\u00b5\u00f77i2\u0098\fC\u00b7\u00deE\u00ab\u00f5\u0093\u0001";
                    var4_3 = "\u00e8\u008e7\u00df\u008fc\u00f5\u0001$\u00ab+\u001f\u0013iS\u00afV\u00fa<\u008f\u00a6\u00fa\u00e2\\{\u009e\u00cfl\u00b9\u00f3Q \u0018\u00e8\\C\u0011f\u00d6\u0093o\u00b9\u00b5\u00f77i2\u0098\fC\u00b7\u00deE\u00ab\u00f5\u0093\u0001".length();
                    var1_4 = 12;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 66;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 19;
                                    break;
                                }
                                case 1: {
                                    v11 = 7;
                                    break;
                                }
                                case 2: {
                                    v11 = 21;
                                    break;
                                }
                                case 3: {
                                    v11 = 73;
                                    break;
                                }
                                case 4: {
                                    v11 = 52;
                                    break;
                                }
                                case 5: {
                                    v11 = 58;
                                    break;
                                }
                                default: {
                                    v11 = 113;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                visibleAreaChanged.1.a = var5;
                visibleAreaChanged.1.b = new String[3];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0xFFFFADC8) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 95;
                        case 1 -> 174;
                        case 2 -> 93;
                        case 3 -> 28;
                        case 4 -> 107;
                        case 5 -> 237;
                        case 6 -> 164;
                        case 7 -> 52;
                        case 8 -> 0;
                        case 9 -> 224;
                        case 10 -> 5;
                        case 11 -> 44;
                        case 12 -> 192;
                        case 13 -> 100;
                        case 14 -> 142;
                        case 15 -> 187;
                        case 16 -> 194;
                        case 17 -> 15;
                        case 18 -> 196;
                        case 19 -> 14;
                        case 20 -> 223;
                        case 21 -> 153;
                        case 22 -> 229;
                        case 23 -> 61;
                        case 24 -> 248;
                        case 25 -> 73;
                        case 26 -> 186;
                        case 27 -> 199;
                        case 28 -> 249;
                        case 29 -> 133;
                        case 30 -> 140;
                        case 31 -> 247;
                        case 32 -> 230;
                        case 33 -> 116;
                        case 34 -> 11;
                        case 35 -> 8;
                        case 36 -> 83;
                        case 37 -> 49;
                        case 38 -> 212;
                        case 39 -> 2;
                        case 40 -> 204;
                        case 41 -> 211;
                        case 42 -> 219;
                        case 43 -> 67;
                        case 44 -> 151;
                        case 45 -> 72;
                        case 46 -> 141;
                        case 47 -> 59;
                        case 48 -> 79;
                        case 49 -> 17;
                        case 50 -> 148;
                        case 51 -> 91;
                        case 52 -> 26;
                        case 53 -> 96;
                        case 54 -> 6;
                        case 55 -> 56;
                        case 56 -> 175;
                        case 57 -> 31;
                        case 58 -> 218;
                        case 59 -> 97;
                        case 60 -> 75;
                        case 61 -> 207;
                        case 62 -> 193;
                        case 63 -> 176;
                        case 64 -> 76;
                        case 65 -> 250;
                        case 66 -> 251;
                        case 67 -> 185;
                        case 68 -> 138;
                        case 69 -> 255;
                        case 70 -> 222;
                        case 71 -> 65;
                        case 72 -> 167;
                        case 73 -> 168;
                        case 74 -> 169;
                        case 75 -> 40;
                        case 76 -> 139;
                        case 77 -> 245;
                        case 78 -> 217;
                        case 79 -> 123;
                        case 80 -> 128;
                        case 81 -> 253;
                        case 82 -> 63;
                        case 83 -> 103;
                        case 84 -> 38;
                        case 85 -> 177;
                        case 86 -> 158;
                        case 87 -> 201;
                        case 88 -> 68;
                        case 89 -> 42;
                        case 90 -> 227;
                        case 91 -> 94;
                        case 92 -> 180;
                        case 93 -> 53;
                        case 94 -> 84;
                        case 95 -> 66;
                        case 96 -> 89;
                        case 97 -> 226;
                        case 98 -> 125;
                        case 99 -> 22;
                        case 100 -> 81;
                        case 101 -> 114;
                        case 102 -> 46;
                        case 103 -> 129;
                        case 104 -> 235;
                        case 105 -> 203;
                        case 106 -> 62;
                        case 107 -> 36;
                        case 108 -> 69;
                        case 109 -> 37;
                        case 110 -> 210;
                        case 111 -> 21;
                        case 112 -> 25;
                        case 113 -> 244;
                        case 114 -> 41;
                        case 115 -> 183;
                        case 116 -> 9;
                        case 117 -> 82;
                        case 118 -> 234;
                        case 119 -> 241;
                        case 120 -> 108;
                        case 121 -> 166;
                        case 122 -> 77;
                        case 123 -> 143;
                        case 124 -> 57;
                        case 125 -> 80;
                        case 126 -> 208;
                        case 127 -> 181;
                        case 128 -> 195;
                        case 129 -> 35;
                        case 130 -> 246;
                        case 131 -> 29;
                        case 132 -> 205;
                        case 133 -> 213;
                        case 134 -> 85;
                        case 135 -> 45;
                        case 136 -> 104;
                        case 137 -> 232;
                        case 138 -> 12;
                        case 139 -> 136;
                        case 140 -> 64;
                        case 141 -> 132;
                        case 142 -> 70;
                        case 143 -> 216;
                        case 144 -> 1;
                        case 145 -> 135;
                        case 146 -> 109;
                        case 147 -> 191;
                        case 148 -> 188;
                        case 149 -> 206;
                        case 150 -> 30;
                        case 151 -> 239;
                        case 152 -> 243;
                        case 153 -> 20;
                        case 154 -> 99;
                        case 155 -> 190;
                        case 156 -> 33;
                        case 157 -> 119;
                        case 158 -> 16;
                        case 159 -> 10;
                        case 160 -> 170;
                        case 161 -> 179;
                        case 162 -> 161;
                        case 163 -> 24;
                        case 164 -> 27;
                        case 165 -> 13;
                        case 166 -> 231;
                        case 167 -> 50;
                        case 168 -> 105;
                        case 169 -> 154;
                        case 170 -> 18;
                        case 171 -> 150;
                        case 172 -> 225;
                        case 173 -> 221;
                        case 174 -> 130;
                        case 175 -> 112;
                        case 176 -> 144;
                        case 177 -> 4;
                        case 178 -> 156;
                        case 179 -> 39;
                        case 180 -> 101;
                        case 181 -> 7;
                        case 182 -> 242;
                        case 183 -> 47;
                        case 184 -> 145;
                        case 185 -> 90;
                        case 186 -> 252;
                        case 187 -> 172;
                        case 188 -> 202;
                        case 189 -> 43;
                        case 190 -> 54;
                        case 191 -> 124;
                        case 192 -> 178;
                        case 193 -> 102;
                        case 194 -> 155;
                        case 195 -> 198;
                        case 196 -> 120;
                        case 197 -> 182;
                        case 198 -> 19;
                        case 199 -> 87;
                        case 200 -> 110;
                        case 201 -> 51;
                        case 202 -> 160;
                        case 203 -> 200;
                        case 204 -> 238;
                        case 205 -> 58;
                        case 206 -> 215;
                        case 207 -> 113;
                        case 208 -> 131;
                        case 209 -> 71;
                        case 210 -> 146;
                        case 211 -> 209;
                        case 212 -> 236;
                        case 213 -> 3;
                        case 214 -> 60;
                        case 215 -> 86;
                        case 216 -> 134;
                        case 217 -> 163;
                        case 218 -> 92;
                        case 219 -> 233;
                        case 220 -> 240;
                        case 221 -> 74;
                        case 222 -> 126;
                        case 223 -> 147;
                        case 224 -> 137;
                        case 225 -> 78;
                        case 226 -> 111;
                        case 227 -> 98;
                        case 228 -> 55;
                        case 229 -> 189;
                        case 230 -> 23;
                        case 231 -> 152;
                        case 232 -> 220;
                        case 233 -> 184;
                        case 234 -> 228;
                        case 235 -> 32;
                        case 236 -> 34;
                        case 237 -> 171;
                        case 238 -> 159;
                        case 239 -> 117;
                        case 240 -> 197;
                        case 241 -> 165;
                        case 242 -> 115;
                        case 243 -> 149;
                        case 244 -> 173;
                        case 245 -> 157;
                        case 246 -> 121;
                        case 247 -> 127;
                        case 248 -> 162;
                        case 249 -> 122;
                        case 250 -> 254;
                        case 251 -> 88;
                        case 252 -> 214;
                        case 253 -> 118;
                        case 254 -> 106;
                        default -> 48;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    visibleAreaChanged.1.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        });
    }

    private final void headlessVisibleAreaChanged(Editor editor, int startOffset, int endOffset) {
        Editor editor2 = this.getOther(editor);
        int n2 = editor.offsetToLogicalPosition((int)startOffset).line;
        int n3 = editor.offsetToLogicalPosition((int)endOffset).line;
        int n4 = (2 * n2 + n3) / 3;
        LogicalPosition logicalPosition = new LogicalPosition(n4, 0);
        editor2.getScrollingModel().disableAnimation();
        editor2.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
        editor2.getScrollingModel().enableAnimation();
    }

    private final void syncCaret(Editor otherEditor, LogicalPosition position) {
        otherEditor.getCaretModel().moveToLogicalPosition(position);
        DocumentExKt.adjustScrollPosition((Editor)otherEditor);
    }

    public void caretAdded(@NotNull CaretEvent event) {
        long l2 = 17793855841159L;
        Intrinsics.checkNotNullParameter((Object)event, (String)EditorToEditorSynchronizer.a(193721460 - (char)-18044, 193721460 - (char)-7088, (int)l2));
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)EditorToEditorSynchronizer.a(193721460 - (char)-18045, 193721460 - (char)-5524, (int)l2));
        Editor editor2 = editor;
        Editor editor3 = this.getOther(editor2);
        boolean bl = Intrinsics.areEqual((Object)editor3.getCaretModel().getPrimaryCaret(), (Object)event.getCaret());
        editor3.getCaretModel().addCaret(event.getNewPosition(), bl);
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        block5: {
            Caret caret;
            Object v3;
            ActionTimestamp[] actionTimestampArray;
            Iterable iterable;
            Editor editor;
            block4: {
                long l2 = 122437501271713L;
                ActionTimestamp[] actionTimestampArray2 = BackendEditorHost.V();
                Intrinsics.checkNotNullParameter((Object)event, (String)EditorToEditorSynchronizer.a(-868600890 - -((char)-19440), -868600890 - -((char)-26308), (int)l2));
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)EditorToEditorSynchronizer.a(-868600890 - -((char)-19439), -868600890 - -((char)-23704), (int)l2));
                Editor editor3 = editor2;
                editor = this.getOther(editor3);
                List list = editor.getCaretModel().getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)EditorToEditorSynchronizer.a(-868600890 - -((char)-19445), -868600890 - -((char)-26643), (int)l2));
                iterable = list;
                Iterator iterator = iterable.iterator();
                actionTimestampArray = actionTimestampArray2;
                block2: while (iterator.hasNext()) {
                    Object t2 = iterator.next();
                    v3 = t2;
                    do {
                        Caret caret2 = v3;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)caret2.getLogicalPosition(), (Object)event.getOldPosition())) continue block2;
                        v3 = t2;
                    } while (actionTimestampArray != null);
                    break block4;
                }
                v3 = null;
            }
            Caret caret3 = v3;
            try {
                if (actionTimestampArray != null) break block5;
                caret = caret3;
                if (caret == null) break block5;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw EditorToEditorSynchronizer.a(unsupportedOperationException);
            }
            iterable = caret;
            boolean bl = false;
            editor.getCaretModel().removeCaret(caret3);
        }
    }

    @NotNull
    public final String dump() {
        long l2 = 99574308193340L;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append(EditorToEditorSynchronizer.a(213644100 - (char)-10761, 213644100 - (char)-29631, (int)l2) + EditorToEditorSynchronizerKt.presentableName(this.from));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)EditorToEditorSynchronizer.a(213644100 - (char)-10762, 213644100 - (char)-7579, (int)l2));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)EditorToEditorSynchronizer.a(213644100 - (char)-10763, -213644100 - -((char)-28861), (int)l2));
        StringBuilder stringBuilder3 = stringBuilder.append(EditorToEditorSynchronizer.a(213644100 - (char)-10764, -213644100 - -((char)-19581), (int)l2) + EditorToEditorSynchronizerKt.presentableName(this.to));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)EditorToEditorSynchronizer.a(213644100 - (char)-10763, -213644100 - -((char)-28861), (int)l2));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)EditorToEditorSynchronizer.a(213644100 - (char)-10763, -213644100 - -((char)-28861), (int)l2));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)EditorToEditorSynchronizer.a(213644100 - (char)-10765, 213644100 - (char)-11329, (int)l2));
        return string;
    }

    public void scrollRequested(@NotNull LogicalPosition targetPosition, @NotNull ScrollType scrollType) {
        long l2 = 122264552583980L;
        Intrinsics.checkNotNullParameter((Object)targetPosition, (String)EditorToEditorSynchronizer.a(281407290 + 31496, 281407290 + 11026, (int)l2));
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)EditorToEditorSynchronizer.a(281407290 + 31497, 281407290 + 31967, (int)l2));
        this.lastRequest = new ScrollRequest(targetPosition, scrollType);
    }

    public static final /* synthetic */ void access$headlessVisibleAreaChanged(EditorToEditorSynchronizer $this, Editor editor, int startOffset, int endOffset) {
        $this.headlessVisibleAreaChanged(editor, startOffset, endOffset);
    }

    public static final /* synthetic */ ScrollRequest access$getLastRequest$p(EditorToEditorSynchronizer $this) {
        return $this.lastRequest;
    }

    public static final /* synthetic */ void access$setLastRequest$p(EditorToEditorSynchronizer $this, ScrollRequest scrollRequest) {
        $this.lastRequest = scrollRequest;
    }

    private static UnsupportedOperationException a(UnsupportedOperationException unsupportedOperationException) {
        return unsupportedOperationException;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[20];
                var3_1 = 0;
                var2_2 = "\rw\u00a5\u00de\u0002\u009a\u00e2\b\u00b9\u00ccq\u00d9\u00aa\u00a6?\u001b\u0016\u00bck\u00f6\u0090\u00af\u00a7\u00deI\u00a1\u000e\u00d1\u0007,\u0095\u00a5\u0006\u00d6\u0080^\u008d\u00a1~\u001e@\u00abi\u0088\\\u00a4\u00a0)n\u0002(\u0086\u0013\u00a5O\u001b$_T\u00f3=\u009blt\u0014L\u00d7j\u00ba\u0000\u0017\u0012\u00bf|\u0013@\u00fd\u001e\u00b9\u0007\u0095\u009cf\u0087\u00daw\u0097\u00ba\u00b9\u00a7\u0087\n\u00dbb5)I\u0096Xf\u0089\u00f0U\u00bee\u001c\u00b3\u00dd\u00aa\u00d11\u0012\u00caU\u00d9{J\u0099a\b=\u00e4\u00f8i\u00bc]3\u00a0\u00fe\t\u009d\u0096\u00d0\u00e9\u000b\u00d8>\u00eev\u00b0r\u00ee\u00d5`\u00f4qt\u00c7\u0005\u0096\u000b\u00bf\u00d6\u0010\u000ev\u0006\u00f0-\u00da\u001c:F.\u00a3\u00b6-.\u009a\u0013\u00a0\u00d5*\\\u0080Ft\u00d0F0\u00c0q\u00b0\u00f9RS\u0088\u00ce\u0089\u000e\u00d9+\u0005\u0088d\u00a8\u00ed\u00d0\u00d4q\u00e9w\u00c5\u00d1\u0005@\u00cde\u000eK\u0011\u00fb\u00d2A\u00b3\u00e4N\u00c3\u00a7\u00c0\u001d1C\u00c9\u00a6\u00d4\u00f0\u0099\r`\u00de\b\u00eb\u00f9\u00c5\u0082\u00d2-\u00b0L\u00f4\u00a8\u000b\u00c1\u00ad\u00c4\u00cf\u00d2i,\u0005g\u00a4O\u000br\u0089\u00b2K\u001c\u00f9\u00f5\u0017\\\u00e6(\u000b\u00fb\u00afdS\u0096\u00d3\u00b3\u00bf\u001f\u008e\u009e\r]\u00ea\u00c3\u00cai\u00f7\u00823:\u0002%\u00df[";
                var4_3 = "\rw\u00a5\u00de\u0002\u009a\u00e2\b\u00b9\u00ccq\u00d9\u00aa\u00a6?\u001b\u0016\u00bck\u00f6\u0090\u00af\u00a7\u00deI\u00a1\u000e\u00d1\u0007,\u0095\u00a5\u0006\u00d6\u0080^\u008d\u00a1~\u001e@\u00abi\u0088\\\u00a4\u00a0)n\u0002(\u0086\u0013\u00a5O\u001b$_T\u00f3=\u009blt\u0014L\u00d7j\u00ba\u0000\u0017\u0012\u00bf|\u0013@\u00fd\u001e\u00b9\u0007\u0095\u009cf\u0087\u00daw\u0097\u00ba\u00b9\u00a7\u0087\n\u00dbb5)I\u0096Xf\u0089\u00f0U\u00bee\u001c\u00b3\u00dd\u00aa\u00d11\u0012\u00caU\u00d9{J\u0099a\b=\u00e4\u00f8i\u00bc]3\u00a0\u00fe\t\u009d\u0096\u00d0\u00e9\u000b\u00d8>\u00eev\u00b0r\u00ee\u00d5`\u00f4qt\u00c7\u0005\u0096\u000b\u00bf\u00d6\u0010\u000ev\u0006\u00f0-\u00da\u001c:F.\u00a3\u00b6-.\u009a\u0013\u00a0\u00d5*\\\u0080Ft\u00d0F0\u00c0q\u00b0\u00f9RS\u0088\u00ce\u0089\u000e\u00d9+\u0005\u0088d\u00a8\u00ed\u00d0\u00d4q\u00e9w\u00c5\u00d1\u0005@\u00cde\u000eK\u0011\u00fb\u00d2A\u00b3\u00e4N\u00c3\u00a7\u00c0\u001d1C\u00c9\u00a6\u00d4\u00f0\u0099\r`\u00de\b\u00eb\u00f9\u00c5\u0082\u00d2-\u00b0L\u00f4\u00a8\u000b\u00c1\u00ad\u00c4\u00cf\u00d2i,\u0005g\u00a4O\u000br\u0089\u00b2K\u001c\u00f9\u00f5\u0017\\\u00e6(\u000b\u00fb\u00afdS\u0096\u00d3\u00b3\u00bf\u001f\u008e\u009e\r]\u00ea\u00c3\u00cai\u00f7\u00823:\u0002%\u00df[".length();
                var1_4 = 4;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 86;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "`b|>\u00b5<\u00eb\u00c5\u008c\u00ab\u00a0;\u0085\u0089\n\u0019-\u00b4\u009d\u00a5Y\u00c5d\u00ceG";
                    var4_3 = "`b|>\u00b5<\u00eb\u00c5\u008c\u00ab\u00a0;\u0085\u0089\n\u0019-\u00b4\u009d\u00a5Y\u00c5d\u00ceG".length();
                    var1_4 = 14;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 5;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 27;
                            break;
                        }
                        case 1: {
                            v15 = 85;
                            break;
                        }
                        case 2: {
                            v15 = 62;
                            break;
                        }
                        case 3: {
                            v15 = 87;
                            break;
                        }
                        case 4: {
                            v15 = 1;
                            break;
                        }
                        case 5: {
                            v15 = 75;
                            break;
                        }
                        default: {
                            v15 = 65;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        EditorToEditorSynchronizer.a = var5;
        EditorToEditorSynchronizer.b = new String[20];
    }

    private static String a(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFD97C) & 0xFFFF;
        if (b[n5] == null) {
            int n6;
            char[] cArray = a[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 233;
                case 1 -> 225;
                case 2 -> 53;
                case 3 -> 14;
                case 4 -> 196;
                case 5 -> 24;
                case 6 -> 49;
                case 7 -> 193;
                case 8 -> 143;
                case 9 -> 142;
                case 10 -> 56;
                case 11 -> 168;
                case 12 -> 245;
                case 13 -> 59;
                case 14 -> 216;
                case 15 -> 114;
                case 16 -> 85;
                case 17 -> 17;
                case 18 -> 32;
                case 19 -> 11;
                case 20 -> 41;
                case 21 -> 94;
                case 22 -> 218;
                case 23 -> 89;
                case 24 -> 103;
                case 25 -> 224;
                case 26 -> 113;
                case 27 -> 149;
                case 28 -> 163;
                case 29 -> 182;
                case 30 -> 5;
                case 31 -> 188;
                case 32 -> 160;
                case 33 -> 186;
                case 34 -> 129;
                case 35 -> 97;
                case 36 -> 174;
                case 37 -> 169;
                case 38 -> 148;
                case 39 -> 91;
                case 40 -> 60;
                case 41 -> 72;
                case 42 -> 176;
                case 43 -> 159;
                case 44 -> 75;
                case 45 -> 244;
                case 46 -> 96;
                case 47 -> 125;
                case 48 -> 30;
                case 49 -> 208;
                case 50 -> 221;
                case 51 -> 172;
                case 52 -> 100;
                case 53 -> 70;
                case 54 -> 108;
                case 55 -> 190;
                case 56 -> 0;
                case 57 -> 227;
                case 58 -> 54;
                case 59 -> 137;
                case 60 -> 8;
                case 61 -> 39;
                case 62 -> 242;
                case 63 -> 101;
                case 64 -> 88;
                case 65 -> 255;
                case 66 -> 177;
                case 67 -> 166;
                case 68 -> 48;
                case 69 -> 206;
                case 70 -> 104;
                case 71 -> 106;
                case 72 -> 251;
                case 73 -> 121;
                case 74 -> 239;
                case 75 -> 209;
                case 76 -> 238;
                case 77 -> 25;
                case 78 -> 81;
                case 79 -> 2;
                case 80 -> 161;
                case 81 -> 132;
                case 82 -> 21;
                case 83 -> 71;
                case 84 -> 16;
                case 85 -> 235;
                case 86 -> 250;
                case 87 -> 90;
                case 88 -> 200;
                case 89 -> 131;
                case 90 -> 231;
                case 91 -> 130;
                case 92 -> 20;
                case 93 -> 205;
                case 94 -> 62;
                case 95 -> 215;
                case 96 -> 77;
                case 97 -> 203;
                case 98 -> 201;
                case 99 -> 66;
                case 100 -> 184;
                case 101 -> 167;
                case 102 -> 189;
                case 103 -> 111;
                case 104 -> 164;
                case 105 -> 157;
                case 106 -> 232;
                case 107 -> 33;
                case 108 -> 120;
                case 109 -> 57;
                case 110 -> 95;
                case 111 -> 175;
                case 112 -> 179;
                case 113 -> 243;
                case 114 -> 207;
                case 115 -> 212;
                case 116 -> 102;
                case 117 -> 51;
                case 118 -> 162;
                case 119 -> 4;
                case 120 -> 194;
                case 121 -> 153;
                case 122 -> 87;
                case 123 -> 183;
                case 124 -> 68;
                case 125 -> 74;
                case 126 -> 86;
                case 127 -> 63;
                case 128 -> 202;
                case 129 -> 3;
                case 130 -> 230;
                case 131 -> 18;
                case 132 -> 124;
                case 133 -> 147;
                case 134 -> 15;
                case 135 -> 152;
                case 136 -> 136;
                case 137 -> 44;
                case 138 -> 198;
                case 139 -> 248;
                case 140 -> 246;
                case 141 -> 7;
                case 142 -> 23;
                case 143 -> 119;
                case 144 -> 220;
                case 145 -> 214;
                case 146 -> 222;
                case 147 -> 138;
                case 148 -> 156;
                case 149 -> 109;
                case 150 -> 204;
                case 151 -> 229;
                case 152 -> 6;
                case 153 -> 27;
                case 154 -> 252;
                case 155 -> 211;
                case 156 -> 76;
                case 157 -> 79;
                case 158 -> 123;
                case 159 -> 253;
                case 160 -> 9;
                case 161 -> 126;
                case 162 -> 171;
                case 163 -> 67;
                case 164 -> 92;
                case 165 -> 134;
                case 166 -> 145;
                case 167 -> 249;
                case 168 -> 223;
                case 169 -> 93;
                case 170 -> 236;
                case 171 -> 58;
                case 172 -> 117;
                case 173 -> 52;
                case 174 -> 151;
                case 175 -> 13;
                case 176 -> 195;
                case 177 -> 165;
                case 178 -> 107;
                case 179 -> 118;
                case 180 -> 38;
                case 181 -> 26;
                case 182 -> 65;
                case 183 -> 29;
                case 184 -> 69;
                case 185 -> 234;
                case 186 -> 141;
                case 187 -> 181;
                case 188 -> 127;
                case 189 -> 22;
                case 190 -> 199;
                case 191 -> 217;
                case 192 -> 31;
                case 193 -> 83;
                case 194 -> 61;
                case 195 -> 1;
                case 196 -> 35;
                case 197 -> 158;
                case 198 -> 116;
                case 199 -> 210;
                case 200 -> 40;
                case 201 -> 28;
                case 202 -> 64;
                case 203 -> 219;
                case 204 -> 173;
                case 205 -> 197;
                case 206 -> 241;
                case 207 -> 228;
                case 208 -> 80;
                case 209 -> 122;
                case 210 -> 185;
                case 211 -> 144;
                case 212 -> 45;
                case 213 -> 43;
                case 214 -> 213;
                case 215 -> 37;
                case 216 -> 50;
                case 217 -> 187;
                case 218 -> 10;
                case 219 -> 226;
                case 220 -> 55;
                case 221 -> 135;
                case 222 -> 170;
                case 223 -> 82;
                case 224 -> 139;
                case 225 -> 140;
                case 226 -> 84;
                case 227 -> 191;
                case 228 -> 154;
                case 229 -> 99;
                case 230 -> 128;
                case 231 -> 34;
                case 232 -> 12;
                case 233 -> 247;
                case 234 -> 19;
                case 235 -> 110;
                case 236 -> 98;
                case 237 -> 73;
                case 238 -> 146;
                case 239 -> 254;
                case 240 -> 47;
                case 241 -> 78;
                case 242 -> 155;
                case 243 -> 150;
                case 244 -> 36;
                case 245 -> 46;
                case 246 -> 240;
                case 247 -> 192;
                case 248 -> 112;
                case 249 -> 178;
                case 250 -> 133;
                case 251 -> 180;
                case 252 -> 105;
                case 253 -> 237;
                case 254 -> 42;
                default -> 115;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            EditorToEditorSynchronizer.b[n5] = new String(cArray).intern();
        }
        return b[n5];
    }
}

