/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationManagerImpl;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsTaskId;
import org.jetbrains.plugins.gradle.service.project.data.ExternalAnnotationsDataServiceKt;

@Order(value=1000)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Lcom/intellij/openapi/roots/libraries/Library;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "onSuccessImport", "", "imported", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nExternalAnnotationsDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalAnnotationsDataService.kt\norg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1603#2,9:164\n1855#2:173\n1856#2:175\n1612#2:176\n1#3:174\n*S KotlinDebug\n*F\n+ 1 ExternalAnnotationsDataService.kt\norg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService\n*L\n47#1:164,9\n47#1:173\n47#1:175\n47#1:176\n47#1:174\n*E\n"})
public final class ExternalAnnotationsDataService
extends AbstractProjectDataService<LibraryData, Library> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LIBRARY");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public void onSuccessImport(@NotNull Collection<DataNode<LibraryData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (!ExternalAnnotationsDataServiceKt.shouldImportExternalAnnotations(projectData, project)) {
            return;
        }
        ExternalAnnotationsProgressNotificationManagerImpl externalAnnotationNotificationManager = ExternalAnnotationsProgressNotificationManagerImpl.Companion.getInstanceImpl();
        Iterable $this$mapNotNull$iv = imported;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair<Library, Collection<AnnotationsLocation>> pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
            LibraryData libData = (LibraryData)object;
            if (modelsProvider.getLibraryByName(libData.getInternalName()) == null) {
                pair = null;
            } else {
                Library library;
                Intrinsics.checkNotNull((Object)library);
                Library lib = library;
                pair = ExternalAnnotationsDataServiceKt.lookForLocations(project, lib, libData);
            }
            if (pair == null) continue;
            Pair<Library, Collection<AnnotationsLocation>> it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map providedAnnotations = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        externalAnnotationNotificationManager.onStartResolve(ExternalAnnotationsTaskId.Companion.of(this.getTargetDataKey(), project));
        ExternalAnnotationsDataServiceKt.resolveProvidedAnnotations(providedAnnotations, project, (Function0<Unit>)((Function0)new Function0<Unit>(externalAnnotationNotificationManager, this, project){
            final /* synthetic */ ExternalAnnotationsProgressNotificationManagerImpl $externalAnnotationNotificationManager;
            final /* synthetic */ ExternalAnnotationsDataService this$0;
            final /* synthetic */ Project $project;
            {
                this.$externalAnnotationNotificationManager = $externalAnnotationNotificationManager;
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                this.$externalAnnotationNotificationManager.onFinishResolve(ExternalAnnotationsTaskId.Companion.of(this.this$0.getTargetDataKey(), this.$project));
            }
        }));
    }

    static {
        Logger logger = Logger.getInstance(ExternalAnnotationsDataService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

