/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard.util;

import com.intellij.ide.starters.local.StandardAssetsProvider;
import com.intellij.ide.starters.local.generator.AssetsProcessor;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"generateGradleWrapper", "", "root", "Ljava/nio/file/Path;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "configuration", "Lorg/gradle/wrapper/WrapperConfiguration;", "generateGradleWrapperConfiguration", "getWrapperProperties", "Ljava/util/Properties;", "getWrapperPropertiesContent", "", "intellij.gradle.java"})
@JvmName(name="GradleWrapperUtil")
public final class GradleWrapperUtil {
    @ApiStatus.Internal
    public static final void generateGradleWrapper(@NotNull Path root, @NotNull GradleVersion gradleVersion2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        GradleWrapperUtil.generateGradleWrapper(root, GradleWrapperUtil.generateGradleWrapperConfiguration(gradleVersion2));
    }

    private static final void generateGradleWrapper(Path root, WrapperConfiguration configuration) {
        String propertiesLocation = new StandardAssetsProvider().getGradleWrapperPropertiesLocation();
        Path propertiesFile = NioPathUtil.findOrCreateFile((Path)root, (String)propertiesLocation);
        String propertiesContent = GradleWrapperUtil.getWrapperPropertiesContent(configuration);
        PathsKt.writeText$default((Path)propertiesFile, (CharSequence)propertiesContent, null, (OpenOption[])new OpenOption[0], (int)2, null);
        List assets = new StandardAssetsProvider().getGradlewAssets();
        AssetsProcessor.Companion.getInstance().generateSources(root, assets, MapsKt.emptyMap());
    }

    private static final WrapperConfiguration generateGradleWrapperConfiguration(GradleVersion gradleVersion2) {
        WrapperConfiguration wrapperConfiguration;
        WrapperConfiguration $this$generateGradleWrapperConfiguration_u24lambda_u240 = wrapperConfiguration = new WrapperConfiguration();
        boolean bl = false;
        String distributionSource = gradleVersion2.isSnapshot() ? "distributions-snapshots" : "distributions";
        $this$generateGradleWrapperConfiguration_u24lambda_u240.setDistribution(new URI("https://services.gradle.org/" + distributionSource + "/gradle-" + gradleVersion2.getVersion() + "-bin.zip"));
        return wrapperConfiguration;
    }

    private static final String getWrapperPropertiesContent(WrapperConfiguration configuration) {
        Properties properties = GradleWrapperUtil.getWrapperProperties(configuration);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.store(output, null);
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Properties getWrapperProperties(WrapperConfiguration configuration) {
        Properties properties;
        Properties $this$getWrapperProperties_u24lambda_u241 = properties = new Properties();
        boolean bl = false;
        $this$getWrapperProperties_u24lambda_u241.setProperty("distributionUrl", configuration.getDistribution().toString());
        $this$getWrapperProperties_u24lambda_u241.setProperty("distributionBase", configuration.getDistributionBase());
        $this$getWrapperProperties_u24lambda_u241.setProperty("distributionPath", configuration.getDistributionPath());
        $this$getWrapperProperties_u24lambda_u241.setProperty("zipStoreBase", configuration.getZipBase());
        $this$getWrapperProperties_u24lambda_u241.setProperty("zipStorePath", configuration.getZipPath());
        return properties;
    }
}

