/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.Axiomatic;
import org.apache.lucene.search.similarities.BasicStats;

public class AxiomaticF3LOG
extends Axiomatic {
    public AxiomaticF3LOG(float s, int queryLen) {
        super(s, queryLen);
    }

    @Override
    public String toString() {
        return "F3LOG";
    }

    @Override
    protected double tf(BasicStats stats2, double freq, double docLen) {
        return 1.0 + Math.log(1.0 + Math.log(freq += 1.0));
    }

    @Override
    protected double ln(BasicStats stats2, double freq, double docLen) {
        return 1.0;
    }

    @Override
    protected double tfln(BasicStats stats2, double freq, double docLen) {
        return 1.0;
    }

    @Override
    protected double idf(BasicStats stats2, double freq, double docLen) {
        return Math.log(((double)stats2.getNumberOfDocuments() + 1.0) / (double)stats2.getDocFreq());
    }

    @Override
    protected double gamma(BasicStats stats2, double freq, double docLen) {
        return (docLen - (double)this.queryLen) * (double)this.s * (double)this.queryLen / stats2.getAvgFieldLength();
    }

    @Override
    protected Explanation tfExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tf(stats2, freq, docLen)), "tf, term frequency computed as 1 + log(1 + log(freq)) from:", Explanation.match((Number)Float.valueOf((float)freq), "freq, number of occurrences of term in the document", new Explanation[0]));
    }

    @Override
    protected Explanation lnExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.ln(stats2, freq, docLen)), "ln, document length, equals to 1", new Explanation[0]);
    }

    @Override
    protected Explanation tflnExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tfln(stats2, freq, docLen)), "tfln, mixed term frequency and document length, equals to 1", new Explanation[0]);
    }

    @Override
    protected Explanation idfExplain(BasicStats stats2, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.idf(stats2, freq, docLen)), "idf, inverted document frequency computed as log((N + 1) / n) from:", Explanation.match((Number)Float.valueOf(stats2.getNumberOfDocuments()), "N, total number of documents with field", new Explanation[0]), Explanation.match((Number)Float.valueOf(stats2.getDocFreq()), "n, number of documents containing term", new Explanation[0]));
    }
}

