/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.AbstractDataStructure;
import org.jetbrains.jetCheck.BoundedIntDistribution;
import org.jetbrains.jetCheck.GenerationEnvironment;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.StructureKind;

public class Generator<T> {
    private final Function<GenerationEnvironment, T> myFunction;

    Generator(Function<GenerationEnvironment, T> function) {
        this.myFunction = function;
    }

    @NotNull
    public static <T> Generator<T> from(@NotNull Function<GenerationEnvironment, T> function) {
        return new Generator<T>(function);
    }

    Function<GenerationEnvironment, T> getGeneratorFunction() {
        return this.myFunction;
    }

    public <V> Generator<V> map(@NotNull Function<? super T, ? extends V> fun) {
        return Generator.from(data -> fun.apply((T)this.myFunction.apply((GenerationEnvironment)data)));
    }

    public <V> Generator<V> flatMap(@NotNull Function<? super T, ? extends Generator<V>> fun) {
        return Generator.from(data -> {
            Object value = data.generate(this);
            Generator result2 = (Generator)fun.apply((T)value);
            if (result2 == null) {
                throw new NullPointerException(fun + " returned null on " + value);
            }
            return data.generate(result2);
        });
    }

    public Generator<T> noShrink() {
        return Generator.from(data -> ((AbstractDataStructure)data).generateNonShrinkable(this));
    }

    public Generator<T> suchThat(@NotNull Predicate<? super T> condition) {
        return Generator.from(data -> ((AbstractDataStructure)data).generateConditional(this, condition));
    }

    public static <T> Generator<T> constant(T value) {
        return Generator.from(data -> value);
    }

    @SafeVarargs
    public static <T> Generator<T> sampledFrom(T ... values) {
        return Generator.sampledFrom(Arrays.asList(values));
    }

    public static <T> Generator<T> sampledFrom(List<T> values) {
        return Generator.anyOf(values.stream().map(Generator::constant).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> Generator<T> anyOf(Generator<? extends T> ... alternatives) {
        return Generator.anyOf(Arrays.asList(alternatives));
    }

    public static <T> Generator<T> anyOf(List<? extends Generator<? extends T>> alternatives) {
        if (alternatives.isEmpty()) {
            throw new IllegalArgumentException("No alternatives to choose from");
        }
        return Generator.from(data -> {
            ((AbstractDataStructure)data).changeKind(StructureKind.CHOICE);
            int index = ((AbstractDataStructure)data).drawInt(IntDistribution.uniform(0, alternatives.size() - 1));
            return data.generate((Generator)alternatives.get(index));
        });
    }

    public static <T> Generator<T> frequency(int weight1, Generator<? extends T> alternative1, int weight2, Generator<? extends T> alternative2) {
        LinkedHashMap<Generator<T>, Integer> map2 = new LinkedHashMap<Generator<T>, Integer>();
        map2.put(alternative1, weight1);
        map2.put(alternative2, weight2);
        return Generator.frequency(map2);
    }

    public static <T> Generator<T> frequency(int weight1, Generator<? extends T> alternative1, int weight2, Generator<? extends T> alternative2, int weight3, Generator<? extends T> alternative3) {
        LinkedHashMap<Generator<T>, Integer> map2 = new LinkedHashMap<Generator<T>, Integer>();
        map2.put(alternative1, weight1);
        map2.put(alternative2, weight2);
        map2.put(alternative3, weight3);
        return Generator.frequency(map2);
    }

    public static <T> Generator<T> frequency(LinkedHashMap<Generator<? extends T>, Integer> alternatives) {
        ArrayList keys = new ArrayList();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (Map.Entry<Generator<T>, Integer> entry : alternatives.entrySet()) {
            keys.add(entry.getKey());
            weights.add(entry.getValue());
        }
        if (keys.contains(null) || weights.contains(null)) {
            throw new IllegalArgumentException("Alternatives passed to 'frequency' shouldn't contain nulls");
        }
        IntDistribution distribution = IntDistribution.frequencyDistribution(weights);
        return Generator.from(data -> {
            ((AbstractDataStructure)data).changeKind(StructureKind.CHOICE);
            return data.generate((Generator)keys.get(((AbstractDataStructure)data).drawInt(distribution)));
        });
    }

    public static <A, B, C> Generator<C> zipWith(Generator<A> gen1, Generator<B> gen2, BiFunction<? super A, ? super B, ? extends C> zip) {
        return Generator.from(data -> zip.apply((Object)data.generate(gen1), (Object)data.generate(gen2)));
    }

    @NotNull
    public static <T> Generator<T> recursive(@NotNull Function<? super Generator<T>, ? extends Generator<T>> createGenerator) {
        AtomicReference ref = new AtomicReference();
        Generator<Object> result2 = Generator.from(data -> ((Generator)ref.get()).getGeneratorFunction().apply((GenerationEnvironment)data));
        ref.set(createGenerator.apply(result2));
        return result2;
    }

    public static Generator<Boolean> booleans() {
        return Generator.integers(0, 1).map(i -> i == 1);
    }

    public static Generator<Character> charsInRange(char min, char max) {
        return Generator.integers(min, max).map(i -> Character.valueOf((char)i.intValue()));
    }

    public static Generator<Character> charsFrom(String possibleChars) {
        return Generator.sampledFrom(IntStream.range(0, possibleChars.length()).mapToObj(possibleChars::charAt).collect(Collectors.toList()));
    }

    public static Generator<Character> asciiPrintableChars() {
        return Generator.charsInRange(' ', '~');
    }

    public static Generator<Character> asciiUppercaseChars() {
        return Generator.charsInRange('A', 'Z');
    }

    public static Generator<Character> asciiLowercaseChars() {
        return Generator.charsInRange('a', 'z');
    }

    public static Generator<Character> asciiLetters() {
        return Generator.frequency(9, Generator.asciiLowercaseChars(), 1, Generator.asciiUppercaseChars()).noShrink();
    }

    public static Generator<Character> digits() {
        return Generator.charsInRange('0', '9');
    }

    public static Generator<String> stringsOf(@NotNull String possibleChars) {
        return Generator.stringsOf(Generator.charsFrom(possibleChars));
    }

    public static Generator<String> stringsOf(@NotNull Generator<Character> charGen) {
        return Generator.listsOf(charGen).map(Generator::charsToString);
    }

    public static Generator<String> stringsOf(@NotNull IntDistribution length, @NotNull Generator<Character> charGen) {
        return Generator.listsOf(length, charGen).map(Generator::charsToString);
    }

    @NotNull
    private static String charsToString(List<Character> chars) {
        StringBuilder sb = new StringBuilder();
        chars.forEach(sb::append);
        return sb.toString();
    }

    public static Generator<String> asciiIdentifiers() {
        return Generator.stringsOf(Generator.frequency(50, Generator.asciiLetters(), 5, Generator.digits(), 1, Generator.constant(Character.valueOf('_')))).suchThat(s -> s.length() > 0 && !Character.isDigit(s.charAt(0)));
    }

    public static Generator<Integer> integers() {
        return Generator.integers(BoundedIntDistribution.ALL_INTS);
    }

    public static Generator<Integer> naturals() {
        return Generator.integers(0, Integer.MAX_VALUE);
    }

    public static Generator<Integer> integers(int min, int max) {
        return Generator.integers(IntDistribution.uniform(min, max));
    }

    public static Generator<Integer> integers(@NotNull IntDistribution distribution) {
        return Generator.from(data -> ((AbstractDataStructure)data).drawInt(distribution));
    }

    public static Generator<Double> doubles() {
        return Generator.from(data -> {
            long i1 = data.generate(Generator.integers(BoundedIntDistribution.ALL_INTS)).intValue();
            long i2 = data.generate(Generator.integers(BoundedIntDistribution.ALL_INTS)).intValue();
            return Double.longBitsToDouble((i1 << 32) + (i2 & 0xFFFFFFFFL));
        });
    }

    public static <T> Generator<List<T>> listsOf(Generator<T> itemGenerator) {
        return Generator.from(data -> Generator.generateList(itemGenerator, data, ((AbstractDataStructure)data).suggestCollectionSize()));
    }

    public static <T> Generator<List<T>> nonEmptyLists(Generator<T> itemGenerator) {
        return Generator.listsOf(itemGenerator).suchThat(l -> !l.isEmpty());
    }

    public static <T> Generator<List<T>> listsOf(IntDistribution length, Generator<T> itemGenerator) {
        return Generator.from(data -> Generator.generateList(itemGenerator, data, ((AbstractDataStructure)data).drawInt(length)));
    }

    private static <T> List<T> generateList(Generator<T> itemGenerator, GenerationEnvironment data, int size) {
        ((AbstractDataStructure)data).changeKind(StructureKind.LIST);
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(data.generate(itemGenerator));
        }
        return Collections.unmodifiableList(list);
    }
}

