/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.metrics;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.metrics.GcMetrics;
import org.jetbrains.kotlin.build.report.metrics.ValueType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000bH\u0016J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\nH\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Ljava/io/Serializable;", "()V", "myBuildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "myBuildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetrics;", "myBuildTimeStartNs", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "", "myBuildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "myGcMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetrics;", "myGcPerformance", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addGcMetric", "metric", "value", "addMetric", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetric", "addTimeMetricNs", "time", "durationNs", "endGcMetric", "name", "endMeasure", "getMetrics", "startGcMetric", "startMeasure", "kotlin-build-statistics"})
public final class BuildMetricsReporterImpl
implements Serializable,
BuildMetricsReporter {
    @NotNull
    private final EnumMap<BuildTime, Long> myBuildTimeStartNs = new EnumMap(BuildTime.class);
    @NotNull
    private final HashMap<String, GcMetric> myGcPerformance = new HashMap();
    @NotNull
    private final BuildTimes myBuildTimes = new BuildTimes();
    @NotNull
    private final BuildPerformanceMetrics myBuildMetrics = new BuildPerformanceMetrics();
    @NotNull
    private final BuildAttributes myBuildAttributes = new BuildAttributes();
    @NotNull
    private final GcMetrics myGcMetrics = new GcMetrics();

    @Override
    public void startMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter(time, "time");
        if (((Map)this.myBuildTimeStartNs).containsKey(time)) {
            throw new IllegalStateException((time + " was restarted before it finished").toString());
        }
        ((Map)this.myBuildTimeStartNs).put(time, System.nanoTime());
    }

    @Override
    public void endMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter(time, "time");
        Long l = this.myBuildTimeStartNs.remove(time);
        if (l == null) {
            throw new IllegalStateException((time + " finished before it started").toString());
        }
        long startNs = ((Number)l).longValue();
        long durationNs = System.nanoTime() - startNs;
        this.myBuildTimes.addTimeNs(time, durationNs);
    }

    @Override
    public void startGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        if (((Map)this.myGcPerformance).containsKey(name2)) {
            throw new IllegalStateException((name2 + " was restarted before it finished").toString());
        }
        ((Map)this.myGcPerformance).put(name2, value2);
    }

    @Override
    public void endGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        GcMetric gcMetric = this.myGcPerformance.remove(name2);
        if (gcMetric == null) {
            throw new IllegalStateException((name2 + " finished before it started").toString());
        }
        GcMetric startValue = gcMetric;
        GcMetric diff = value2.minus(startValue);
        this.myGcMetrics.add(name2, diff);
    }

    @Override
    public void addTimeMetricNs(@NotNull BuildTime time, long durationNs) {
        Intrinsics.checkNotNullParameter(time, "time");
        this.myBuildTimes.addTimeNs(time, durationNs);
    }

    @Override
    public void addMetric(@NotNull BuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        this.myBuildMetrics.add(metric, value2);
    }

    @Override
    public void addTimeMetric(@NotNull BuildPerformanceMetric metric) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        switch (WhenMappings.$EnumSwitchMapping$0[metric.getType().ordinal()]) {
            case 1: {
                this.myBuildMetrics.add(metric, System.nanoTime());
                break;
            }
            case 2: {
                this.myBuildMetrics.add(metric, System.currentTimeMillis());
                break;
            }
            case 3: {
                this.myBuildMetrics.add(metric, System.currentTimeMillis());
                break;
            }
            default: {
                throw new IllegalStateException(("Unable to add time metric for '" + (Object)((Object)metric.getType()) + "' type").toString());
            }
        }
    }

    @Override
    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.myGcMetrics.add(metric, value2);
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        BuildAttributes.add$default(this.myBuildAttributes, attribute, 0, 2, null);
    }

    @Override
    @NotNull
    public BuildMetrics getMetrics() {
        return new BuildMetrics(this.myBuildTimes, this.myBuildMetrics, this.myBuildAttributes, this.myGcMetrics);
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics metrics) {
        Intrinsics.checkNotNullParameter(metrics, "metrics");
        this.myBuildAttributes.addAll(metrics.getBuildAttributes());
        this.myBuildTimes.addAll(metrics.getBuildTimes());
        this.myBuildMetrics.addAll(metrics.getBuildPerformanceMetrics());
        this.myGcMetrics.addAll(metrics.getGcMetrics());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.NANOSECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.TIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

