/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/psi/KotlinReferenceProvidersService;", "", "()V", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "Companion", "psi"})
public class KotlinReferenceProvidersService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KotlinReferenceProvidersService NO_REFERENCES_SERVICE = new KotlinReferenceProvidersService();

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        Intrinsics.checkNotNullExpressionValue(PsiReference.EMPTY_ARRAY, "EMPTY_ARRAY");
        return PsiReference.EMPTY_ARRAY;
    }

    @JvmStatic
    @NotNull
    public static final KotlinReferenceProvidersService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final PsiReference[] getReferencesFromProviders(@NotNull PsiElement psiElement) {
        return Companion.getReferencesFromProviders(psiElement);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/psi/KotlinReferenceProvidersService$Companion;", "", "()V", "NO_REFERENCES_SERVICE", "Lorg/jetbrains/kotlin/psi/KotlinReferenceProvidersService;", "getInstance", "project", "Lcom/intellij/openapi/project/Project;", "getReferencesFromProviders", "", "Lcom/intellij/psi/PsiReference;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "psi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KotlinReferenceProvidersService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            KotlinReferenceProvidersService kotlinReferenceProvidersService = project.getService(KotlinReferenceProvidersService.class);
            if (kotlinReferenceProvidersService == null) {
                kotlinReferenceProvidersService = NO_REFERENCES_SERVICE;
            }
            return kotlinReferenceProvidersService;
        }

        @JvmStatic
        @NotNull
        public final PsiReference[] getReferencesFromProviders(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter(psiElement, "psiElement");
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "psiElement.project");
            return this.getInstance(project).getReferences(psiElement);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

