/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Enumerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class BiDirectionalEnumerator<T>
extends Enumerator<T> {
    @NotNull
    private final Int2ObjectMap<T> myIntToObjectMap;

    public BiDirectionalEnumerator(int expectNumber) {
        super(expectNumber);
        this.myIntToObjectMap = new Int2ObjectOpenHashMap<T>(expectNumber);
    }

    @Override
    public int enumerateImpl(T object) {
        int index = super.enumerateImpl(object);
        this.myIntToObjectMap.put(Math.max(index, -index), object);
        return index;
    }

    @Override
    public void clear() {
        super.clear();
        this.myIntToObjectMap.clear();
    }

    @NotNull
    public T getValue(int index) {
        Object value = this.myIntToObjectMap.get(index);
        if (value == null) {
            throw new RuntimeException("Can not find value by index " + index);
        }
        Object v = value;
        if (v == null) {
            BiDirectionalEnumerator.$$$reportNull$$$0(0);
        }
        return (T)v;
    }

    public void forEachValue(@NotNull Predicate<? super T> processor) {
        if (processor == null) {
            BiDirectionalEnumerator.$$$reportNull$$$0(1);
        }
        for (Object value : this.myIntToObjectMap.values()) {
            if (!processor.test(value)) break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/BiDirectionalEnumerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/BiDirectionalEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forEachValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

