/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.SingletonIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class JBIterable<E>
implements Iterable<E> {
    private final Object content;
    private static final JBIterable<?> EMPTY = new Empty();

    protected JBIterable() {
        this.content = this;
    }

    JBIterable(@NotNull E content) {
        if (content == null) {
            JBIterable.$$$reportNull$$$0(0);
        }
        this.content = content;
    }

    JBIterable(@NotNull Iterable<? extends E> content) {
        if (content == null) {
            JBIterable.$$$reportNull$$$0(1);
        }
        this.content = content;
    }

    @NotNull
    public static <E> JBIterable<E> create(final @Nullable Supplier<? extends Iterator<E>> producer) {
        if (producer == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                Iterator iterator2 = (Iterator)producer.get();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable$1", "iterator"));
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null || iterable == EMPTY) {
            return JBIterable.empty();
        }
        if (iterable instanceof JBIterable) {
            JBIterable jBIterable = (JBIterable)iterable;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return JBIterable.empty();
        }
        return new Multi<E>(iterable);
    }

    @NotNull
    public static <E> @NotNull JBIterable<@NotNull E> generate(final @Nullable E first2, final @NotNull Function<? super E, ? extends E> generator) {
        if (generator == null) {
            JBIterable.$$$reportNull$$$0(3);
        }
        if (first2 == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result2 = this.cur;
                        if (result2 == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result2;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> @NotNull JBIterable<@NotNull E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (generator == null) {
            JBIterable.$$$reportNull$$$0(4);
        }
        if (first1 == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result2 = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result2, this.cur2);
                        if (result2 == null) {
                            return this.stop();
                        }
                        return result2;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> @NotNull JBIterable<@NotNull E> of(@Nullable E element) {
        if (element == null) {
            return JBIterable.empty();
        }
        return new Single<E>(element);
    }

    @SafeVarargs
    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        return elements == null || elements.length == 0 ? JBIterable.empty() : JBIterable.from(Arrays.asList(elements));
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        JBIterable<?> jBIterable = EMPTY;
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<? extends E> iterator2) {
        if (iterator2 == null) {
            JBIterable.$$$reportNull$$$0(6);
        }
        return JBIterable.of(Ref.create(iterator2)).intercept(iterator1 -> {
            Ref ref = (Ref)iterator1.next();
            Iterator result2 = (Iterator)ref.get();
            if (result2 == null) {
                throw new UnsupportedOperationException();
            }
            ref.set(null);
            return result2;
        });
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        Iterator iterator2 = this.iterator();
        if (iterator2 == null) {
            JBIterable.$$$reportNull$$$0(7);
        }
        return (T)iterator2;
    }

    public final boolean processEach(@NotNull Processor<? super E> processor) {
        if (processor == null) {
            JBIterable.$$$reportNull$$$0(8);
        }
        return ContainerUtil.process(this, processor);
    }

    public final void consumeEach(@NotNull Consumer<? super E> consumer2) {
        if (consumer2 == null) {
            JBIterable.$$$reportNull$$$0(9);
        }
        for (Object e : this) {
            consumer2.consume(e);
        }
    }

    @NotNull
    public String toString() {
        String string2 = this.content == this ? JBIterable.class.getSimpleName() : String.valueOf(this.content);
        if (string2 == null) {
            JBIterable.$$$reportNull$$$0(10);
        }
        return string2;
    }

    public final int size() {
        if (this == EMPTY) {
            return 0;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            return 1;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.size();
        }
        int count2 = 0;
        for (Object ignored : this) {
            ++count2;
        }
        return count2;
    }

    public final boolean contains(@Nullable Object element) {
        if (this == EMPTY) {
            return false;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            return Comparing.equal(single2, (Object)element);
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.contains(element);
        }
        for (Object e : this) {
            if (!Comparing.equal(e, (Object)element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index) {
        if (this == EMPTY) {
            return null;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            return (E)(index == 0 ? single2 : null);
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return index >= list.size() ? null : (E)list.get(index);
        }
        return this.skip(index).first();
    }

    @Nullable
    private List<E> asRandomAccess() {
        return this.content instanceof RandomAccess ? (List)this.content : null;
    }

    @Nullable
    private Collection<E> asCollection() {
        return this.content instanceof Collection ? (Collection)this.content : null;
    }

    @Nullable
    Iterable<E> asIterable() {
        return this.content instanceof Iterable ? (Iterable)this.content : null;
    }

    @Nullable
    E asElement() {
        return (E)(this instanceof Single ? this.content : null);
    }

    @NotNull
    public final JBIterable<E> repeat(int count2) {
        JBIterable jBIterable = JBIterable.generate(this, Functions.id()).take(count2).flatten(Functions.id());
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        if (other == null || other == EMPTY) {
            JBIterable jBIterable = this;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        if (this == EMPTY) {
            return JBIterable.from(other);
        }
        Appended parent = this instanceof Appended ? (Appended)this : new Appended(this, null);
        return new Appended<E>(other, parent);
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<? extends T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        if (fun == null) {
            JBIterable.$$$reportNull$$$0(13);
        }
        return other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
    }

    @NotNull
    public final JBIterable<E> append(E @NotNull [] elements) {
        if (elements == null) {
            JBIterable.$$$reportNull$$$0(14);
        }
        return this == EMPTY ? JBIterable.of(elements) : this.append((E)JBIterable.of(elements));
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E element) {
        return element == null ? this : (this == EMPTY ? JBIterable.of(element) : this.append(JBIterable.of(element)));
    }

    @NotNull
    public final JBIterable<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(15);
        }
        return this.intercept(iterator2 -> JBIterator.from(iterator2).filter(Stateful.copy(condition)));
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type2) {
        if (type2 == null) {
            JBIterable.$$$reportNull$$$0(16);
        }
        return this.filter(Conditions.instanceOf(type2));
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull E> filterNotNull() {
        return this.filter(Objects::nonNull);
    }

    @NotNull
    public final JBIterable<E> take(int count2) {
        return this.intercept(iterator2 -> JBIterator.from(iterator2).take(count2));
    }

    @NotNull
    public final JBIterable<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(17);
        }
        return this.intercept(iterator2 -> JBIterator.from(iterator2).takeWhile(Stateful.copy(condition)));
    }

    @NotNull
    public final JBIterable<E> skip(int count2) {
        return this.intercept(iterator2 -> JBIterator.from(iterator2).skip(count2));
    }

    @NotNull
    public final JBIterable<E> skipWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(18);
        }
        return this.intercept(iterator2 -> JBIterator.from(iterator2).skipWhile(Stateful.copy(condition)));
    }

    @NotNull
    public final <T> JBIterable<T> map(@NotNull Function<? super E, ? extends T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(19);
        }
        return this.intercept(iterator2 -> JBIterator.from(iterator2).map(Stateful.copy(function)));
    }

    @NotNull
    public final <T> JBIterable<T> transform(@NotNull Function<? super E, ? extends T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(20);
        }
        return this.map(function);
    }

    @NotNull
    public <T> JBIterable<T> flatten(@NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(21);
        }
        return this.intercept(new FlattenFun(function));
    }

    @NotNull
    public final JBIterable<E> unique() {
        return this.unique(Functions.identity());
    }

    @NotNull
    public final JBIterable<E> unique(final @NotNull Function<? super E, ?> identity) {
        if (identity == null) {
            JBIterable.$$$reportNull$$$0(22);
        }
        return this.filter(new SCond<E>(){
            Set<Object> visited;

            @Override
            public boolean value(E e) {
                if (this.visited == null) {
                    this.visited = new HashSet<Object>();
                }
                return this.visited.add(identity.fun(e));
            }
        });
    }

    @NotNull
    public final <T> JBIterable<T> intercept(@NotNull Function<? super Iterator<? extends E>, ? extends Iterator<? extends T>> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(23);
        }
        if (this == EMPTY) {
            return JBIterable.empty();
        }
        if (this instanceof Intercepted) {
            Intercepted intercepted = (Intercepted)this;
            Function compose = Functions.compose(intercepted.interceptor, function);
            return new Intercepted(intercepted.original, compose);
        }
        return new Intercepted(this, function);
    }

    @Nullable
    public final E first() {
        if (this == EMPTY) {
            return null;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            return single2;
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(0);
        }
        Iterator iterator2 = this.iterator();
        return iterator2.hasNext() ? (E)iterator2.next() : null;
    }

    @Nullable
    public final E single() {
        if (this == EMPTY) {
            return null;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            return single2;
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.size() != 1 ? null : (E)list.get(0);
        }
        Iterator iterator2 = this.iterator();
        E first2 = iterator2.hasNext() ? (E)iterator2.next() : null;
        return iterator2.hasNext() ? null : first2;
    }

    @Nullable
    public final E last() {
        if (this == EMPTY) {
            return null;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            return single2;
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(list.size() - 1);
        }
        E cur = null;
        for (Object e : this) {
            cur = (E)e;
        }
        return cur;
    }

    public final <T> T reduce(@Nullable T first2, @NotNull PairFunction<? super T, ? super E, ? extends T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(24);
        }
        T cur = first2;
        for (Object e : this) {
            cur = function.fun(cur, e);
        }
        return cur;
    }

    public final E reduce(@NotNull PairFunction<? super E, ? super E, ? extends E> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(25);
        }
        boolean first2 = true;
        Object cur = null;
        for (Object e : this) {
            if (first2) {
                cur = e;
                first2 = false;
                continue;
            }
            cur = function.fun(cur, e);
        }
        return (E)cur;
    }

    @Nullable
    public final E find(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(26);
        }
        return this.filter(condition).first();
    }

    public final int indexOf(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(27);
        }
        int index = 0;
        for (Object e : this) {
            if (condition.value(e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @NotNull
    public final <T> @NotNull JBIterable<@NotNull T> filterMap(@NotNull Function<? super E, ? extends T> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(28);
        }
        return this.intercept(iterator2 -> JBIterator.from(iterator2).filterMap(Stateful.copy(function)));
    }

    @NotNull
    public final <T> JBIterable<T> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
        if (function == null) {
            JBIterable.$$$reportNull$$$0(29);
        }
        JBIterable<T> jBIterable = this.map(function).flatten(Functions.identity());
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> join(@Nullable E separator) {
        return this.intercept(original -> new JBIterator<E>((Iterator)original, separator){
            boolean flag;
            final /* synthetic */ Iterator val$original;
            final /* synthetic */ Object val$separator;
            {
                this.val$original = iterator2;
                this.val$separator = object;
            }

            @Override
            protected E nextImpl() {
                if (!this.val$original.hasNext()) {
                    return this.stop();
                }
                this.flag = !this.flag;
                return this.flag ? this.val$original.next() : this.val$separator;
            }
        });
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull List<E>> split(int size, boolean strict) {
        return this.split(size).filterMap(es -> {
            List list = es.addAllTo(new ArrayList(size));
            return strict && list.size() < size ? null : list;
        });
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull JBIterable<E>> split(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(size + " <= 0");
        }
        return this.intercept(orig -> new JBIterator<JBIterable<E>>((Iterator)orig, size){
            JBIterator<E> it;
            final /* synthetic */ Iterator val$orig;
            final /* synthetic */ int val$size;
            {
                this.val$orig = iterator2;
                this.val$size = n;
            }

            @Override
            protected JBIterable<E> nextImpl() {
                JBIterable jBIterable;
                while (this.it != null && this.it.advance()) {
                }
                this.it = null;
                if (this.val$orig.hasNext()) {
                    this.it = JBIterator.wrap(this.val$orig);
                    jBIterable = JBIterable.once(this.it.take(this.val$size));
                } else {
                    jBIterable = (JBIterable)this.stop();
                }
                return jBIterable;
            }
        });
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull JBIterable<E>> split(@NotNull Split mode, @NotNull Condition<? super E> separator) {
        if (mode == null) {
            JBIterable.$$$reportNull$$$0(31);
        }
        if (separator == null) {
            JBIterable.$$$reportNull$$$0(32);
        }
        return this.intercept(orig -> {
            Condition condition = Stateful.copy(separator);
            return new JBIterator<JBIterable<E>>((Iterator)orig, mode, condition){
                JBIterator<E> it;
                E stored;
                int st;
                final /* synthetic */ Iterator val$orig;
                final /* synthetic */ Split val$mode;
                final /* synthetic */ Condition val$condition;
                {
                    this.val$orig = iterator2;
                    this.val$mode = split;
                    this.val$condition = condition;
                }

                @Override
                protected JBIterable<E> nextImpl() {
                    while (this.it != null && this.it.advance()) {
                    }
                    this.it = null;
                    if (this.stored == null && !this.val$orig.hasNext()) {
                        if (this.st < 0 && this.val$mode != Split.BEFORE && this.val$mode != Split.GROUP) {
                            this.st = 1;
                            return JBIterable.empty();
                        }
                        return (JBIterable)this.stop();
                    }
                    if (this.st == -2 && this.val$mode == Split.AROUND) {
                        this.st = -1;
                        return JBIterable.empty();
                    }
                    Object tmp = this.stored;
                    this.stored = null;
                    this.it = JBIterator.wrap(this.val$orig);
                    return JBIterable.of(tmp).append(JBIterable.once(this.it.takeWhile(e -> {
                        boolean result2;
                        boolean sep = this.val$condition.value(e);
                        int st0 = this.st;
                        this.st = st0 < 0 && sep ? -2 : (st0 > 0 && !sep ? 2 : (sep ? -1 : 1));
                        switch (this.val$mode) {
                            case AFTER: {
                                result2 = this.st != -2 && (this.st != 1 || st0 == 0);
                                break;
                            }
                            case BEFORE: {
                                result2 = this.st != -2 && this.st != -1;
                                break;
                            }
                            case AROUND: {
                                result2 = st0 >= 0 && this.st > 0;
                                break;
                            }
                            case GROUP: {
                                result2 = st0 >= 0 && this.st > 0 || st0 <= 0 && this.st < 0;
                                break;
                            }
                            case OFF: {
                                result2 = this.st > 0;
                                break;
                            }
                            default: {
                                throw new AssertionError(this.st);
                            }
                        }
                        this.stored = !result2 && this.val$mode != Split.OFF ? e : null;
                        return result2;
                    })));
                }
            };
        });
    }

    public final boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            return false;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.isEmpty();
        }
        return !this.iterator().hasNext();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final JBIterable<E> collect(@NotNull Collection<E> collection) {
        if (collection == null) {
            JBIterable.$$$reportNull$$$0(33);
        }
        return JBIterable.from(this.addAllTo(collection));
    }

    @NotNull
    public final JBIterable<E> collect() {
        if (this.content instanceof Collection) {
            JBIterable jBIterable = this;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(34);
            }
            return jBIterable;
        }
        return this.collect(new ArrayList());
    }

    @NotNull
    public final JBIterable<E> sort(@NotNull Comparator<? super E> comparator) {
        if (comparator == null) {
            JBIterable.$$$reportNull$$$0(35);
        }
        ArrayList<? super E> list = this.addAllTo(new ArrayList());
        list.sort(comparator);
        return JBIterable.from(list);
    }

    public final @Unmodifiable @NotNull List<E> toList() {
        if (this == EMPTY) {
            List list = Collections.emptyList();
            if (list == null) {
                JBIterable.$$$reportNull$$$0(36);
            }
            return list;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            List<E> list = Collections.singletonList(single2);
            if (list == null) {
                JBIterable.$$$reportNull$$$0(37);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList(this);
        List<Object> list = result2.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(result2);
        if (list == null) {
            JBIterable.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    public final Set<E> toSet() {
        if (this == EMPTY) {
            Set set = Collections.emptySet();
            if (set == null) {
                JBIterable.$$$reportNull$$$0(39);
            }
            return set;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            Set<E> set = Collections.singleton(single2);
            if (set == null) {
                JBIterable.$$$reportNull$$$0(40);
            }
            return set;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet(this);
        Set set = result2.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(result2);
        if (set == null) {
            JBIterable.$$$reportNull$$$0(41);
        }
        return set;
    }

    public final E @NotNull [] toArray(E @NotNull [] array) {
        if (array == null) {
            JBIterable.$$$reportNull$$$0(42);
        }
        if (this == EMPTY) {
            if (array == null) {
                JBIterable.$$$reportNull$$$0(43);
            }
            return array;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            E[] EArray = Collections.singletonList(single2).toArray(array);
            if (EArray == null) {
                JBIterable.$$$reportNull$$$0(44);
            }
            return EArray;
        }
        E[] EArray = ContainerUtil.newArrayList(this).toArray(array);
        if (EArray == null) {
            JBIterable.$$$reportNull$$$0(45);
        }
        return EArray;
    }

    @NotNull
    public final <K, V> Map<K, V> toMap(@NotNull Convertor<? super E, ? extends K> toKey, @NotNull Convertor<? super E, ? extends V> toValue) {
        if (toKey == null) {
            JBIterable.$$$reportNull$$$0(46);
        }
        if (toValue == null) {
            JBIterable.$$$reportNull$$$0(47);
        }
        if (this == EMPTY) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                JBIterable.$$$reportNull$$$0(48);
            }
            return map2;
        }
        LinkedHashMap<K, V> map3 = new LinkedHashMap<K, V>();
        for (Object e : this) {
            map3.put(toKey.convert(e), toValue.convert(e));
        }
        Map map4 = map3.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map3);
        if (map4 == null) {
            JBIterable.$$$reportNull$$$0(49);
        }
        return map4;
    }

    @NotNull
    public final <V> Map<E, V> toMap(@NotNull Convertor<? super E, ? extends V> toValue) {
        if (toValue == null) {
            JBIterable.$$$reportNull$$$0(50);
        }
        return this.toMap(Convertor.self(), toValue);
    }

    @NotNull
    public final <K> Map<K, E> toReverseMap(@NotNull Convertor<? super E, ? extends K> toKey) {
        if (toKey == null) {
            JBIterable.$$$reportNull$$$0(51);
        }
        return this.toMap(toKey, Convertor.self());
    }

    @NotNull
    public final Stream<E> toStream() {
        Stream stream = StreamSupport.stream(this.spliterator(), false);
        if (stream == null) {
            JBIterable.$$$reportNull$$$0(52);
        }
        return stream;
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (collection == null) {
            JBIterable.$$$reportNull$$$0(53);
        }
        if (this == EMPTY) {
            C c = collection;
            if (c == null) {
                JBIterable.$$$reportNull$$$0(54);
            }
            return c;
        }
        E single2 = this.asElement();
        if (single2 != null) {
            collection.add(single2);
            C c = collection;
            if (c == null) {
                JBIterable.$$$reportNull$$$0(55);
            }
            return c;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            collection.addAll(col);
        } else {
            for (Object item : this) {
                collection.add(item);
            }
        }
        C c = collection;
        if (c == null) {
            JBIterable.$$$reportNull$$$0(56);
        }
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/JBIterable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 33: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toKey";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/JBIterable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "typedIterator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toSet";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "toStream";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "once";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processEach";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "consumeEach";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "takeWhile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "skipWhile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "filterMap";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 46: 
            case 47: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toMap";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "toReverseMap";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addAllTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Multi<E>
    extends JBIterable<E> {
        Multi(@NotNull Iterable<? extends E> iterable) {
            if (iterable == null) {
                Multi.$$$reportNull$$$0(0);
            }
            super(iterable);
        }

        @Override
        public Iterator<E> iterator() {
            return JBIterator.from(Objects.requireNonNull(this.asIterable()).iterator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/JBIterable$Multi", "<init>"));
        }
    }

    private static final class Single<E>
    extends JBIterable<E> {
        Single(@NotNull E content) {
            if (content == null) {
                Single.$$$reportNull$$$0(0);
            }
            super(content);
        }

        @Override
        public Iterator<E> iterator() {
            return new SingletonIterator(this.asElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/containers/JBIterable$Single", "<init>"));
        }
    }

    private static final class Appended<E>
    extends JBIterable<E> {
        final Iterable<? extends E> iterable;
        final Appended<? extends E> parent;

        Appended(@NotNull Iterable<? extends E> iterable, @Nullable Appended<? extends E> parent) {
            if (iterable == null) {
                Appended.$$$reportNull$$$0(0);
            }
            this.iterable = iterable;
            this.parent = parent;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            List<Iterable<E>> iterables = Arrays.asList(this.getIterables());
            return new FlattenFun.FlattenIt(iterables.iterator(), Functions.identity());
        }

        private Iterable<? extends E> @NotNull [] getIterables() {
            int size = 0;
            Appended<? extends E> p = this;
            while (p != null) {
                ++size;
                p = p.parent;
            }
            Iterable[] iterables = new Iterable[size];
            int i = 0;
            Appended<? extends E> p2 = this;
            while (p2 != null) {
                iterables[size - ++i] = p2.iterable;
                p2 = p2.parent;
            }
            if (iterables == null) {
                Appended.$$$reportNull$$$0(1);
            }
            return iterables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/JBIterable$Appended";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/JBIterable$Appended";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIterables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class FlattenFun<E, T>
    implements NotNullFunction<Iterator<? extends E>, Iterator<? extends T>> {
        final Function<? super E, ? extends Iterable<? extends T>> function;

        FlattenFun(@NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
            if (function == null) {
                FlattenFun.$$$reportNull$$$0(0);
            }
            this.function = function;
        }

        @Override
        @NotNull
        public Iterator<T> fun(@NotNull Iterator<? extends E> iterator2) {
            if (iterator2 == null) {
                FlattenFun.$$$reportNull$$$0(1);
            }
            return new FlattenIt(iterator2, Stateful.copy(this.function));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/JBIterable$FlattenFun";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static final class FlattenIt<E, T>
        extends JBIterator<T> {
            final Iterator<? extends E> original;
            final Function<? super E, ? extends Iterable<? extends T>> function;
            Iterator<? extends T> cur;

            FlattenIt(@NotNull Iterator<? extends E> iterator2, @NotNull Function<? super E, ? extends Iterable<? extends T>> fun) {
                if (iterator2 == null) {
                    FlattenIt.$$$reportNull$$$0(0);
                }
                if (fun == null) {
                    FlattenIt.$$$reportNull$$$0(1);
                }
                this.original = iterator2;
                this.function = fun;
            }

            @Override
            public T nextImpl() {
                if (this.cur != null && this.cur.hasNext()) {
                    return this.cur.next();
                }
                if (!this.original.hasNext()) {
                    return (T)this.stop();
                }
                Iterable<T> next = this.function.fun(this.original.next());
                this.cur = next == null ? null : next.iterator();
                return (T)this.skip();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "iterator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fun";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/containers/JBIterable$FlattenFun$FlattenIt";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class Intercepted<E, T>
    extends JBIterable<T> {
        final JBIterable<? extends E> original;
        private final Function<? super Iterator<? extends E>, ? extends Iterator<? extends T>> interceptor;

        Intercepted(@NotNull JBIterable<? extends E> original, @NotNull Function<? super Iterator<? extends E>, ? extends Iterator<? extends T>> interceptor) {
            if (original == null) {
                Intercepted.$$$reportNull$$$0(0);
            }
            if (interceptor == null) {
                Intercepted.$$$reportNull$$$0(1);
            }
            this.original = original;
            this.interceptor = interceptor;
        }

        @Override
        public Iterator<T> iterator() {
            return this.interceptor.fun(this.original.iterator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "original";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interceptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/JBIterable$Intercepted";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Split {
        AFTER,
        BEFORE,
        AROUND,
        OFF,
        GROUP;

    }

    public static abstract class Stateful<Self extends Stateful<?>>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (o == null) {
                Stateful.$$$reportNull$$$0(0);
            }
            if (!(o instanceof Stateful)) {
                T t = o;
                if (t == null) {
                    Stateful.$$$reportNull$$$0(1);
                }
                return t;
            }
            Object object = ((Stateful)o).clone();
            if (object == null) {
                Stateful.$$$reportNull$$$0(2);
            }
            return (T)object;
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/JBIterable$Stateful";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/JBIterable$Stateful";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copy";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Empty
    extends JBIterable<Object> {
        private Empty() {
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static abstract class SFun<S, T>
    extends Stateful<SFun<S, T>>
    implements Function<S, T> {
    }

    public static abstract class SCond<T>
    extends Stateful<SCond<T>>
    implements Condition<T> {
    }
}

