/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.blobstorage;

public interface SpaceAllocationStrategy {
    public int defaultCapacity();

    public int capacity(int var1, int var2);

    public static final class DataLengthPlusFixedPercentStrategy
    implements SpaceAllocationStrategy {
        private final int defaultCapacity;
        private final int minCapacity;
        private final int maxCapacity;
        private final int percentOnTheTop;

        public DataLengthPlusFixedPercentStrategy(int minCapacity, int defaultCapacity, int maxCapacity, int percentOnTheTop) {
            if (maxCapacity <= 0) {
                throw new IllegalArgumentException("maxCapacity(" + maxCapacity + ") must be >0");
            }
            if (defaultCapacity <= 0 || defaultCapacity > maxCapacity) {
                throw new IllegalArgumentException("defaultCapacity(" + defaultCapacity + ") must be in [1," + maxCapacity + "]");
            }
            if (minCapacity <= 0 || minCapacity > defaultCapacity) {
                throw new IllegalArgumentException("minCapacity(" + minCapacity + ") must be > 0 && <= defaultCapacity(" + defaultCapacity + ")");
            }
            if (percentOnTheTop < 0) {
                throw new IllegalArgumentException("percentOnTheTop(" + percentOnTheTop + ") must be >= 0");
            }
            this.minCapacity = minCapacity;
            this.defaultCapacity = defaultCapacity;
            this.maxCapacity = maxCapacity;
            this.percentOnTheTop = percentOnTheTop;
        }

        @Override
        public int defaultCapacity() {
            return this.defaultCapacity;
        }

        @Override
        public int capacity(int actualLength, int currentCapacity) {
            if (actualLength < 0) {
                throw new IllegalArgumentException("actualLength(=" + actualLength + " should be >=0");
            }
            if (currentCapacity < actualLength) {
                throw new IllegalArgumentException("currentCapacity(=" + currentCapacity + ") should be >= actualLength(=" + actualLength + ")");
            }
            double capacity = Math.ceil((double)actualLength * (1.0 + (double)this.percentOnTheTop / 100.0));
            int advisedCapacity = (int)Math.max((double)this.minCapacity, capacity);
            if (advisedCapacity < 0 || advisedCapacity > this.maxCapacity) {
                return this.maxCapacity;
            }
            return advisedCapacity;
        }

        public String toString() {
            return "DataLengthPlusFixedPercentStrategy{length + " + this.percentOnTheTop + "%, min: " + this.minCapacity + ", max: " + this.maxCapacity + ", default: " + this.defaultCapacity + "}";
        }
    }

    public static final class WriterDecidesStrategy
    implements SpaceAllocationStrategy {
        private final int defaultCapacity;
        private final int maxCapacity;

        public WriterDecidesStrategy(int maxCapacity, int defaultCapacity) {
            if (maxCapacity <= 0) {
                throw new IllegalArgumentException("maxCapacity(" + maxCapacity + ") must be >0");
            }
            if (defaultCapacity <= 0 || defaultCapacity >= maxCapacity) {
                throw new IllegalArgumentException("defaultCapacity(" + defaultCapacity + ") must be in [1," + maxCapacity + "]");
            }
            this.maxCapacity = maxCapacity;
            this.defaultCapacity = defaultCapacity;
        }

        @Override
        public int defaultCapacity() {
            return this.defaultCapacity;
        }

        @Override
        public int capacity(int actualLength, int currentCapacity) {
            if (actualLength < 0) {
                throw new IllegalArgumentException("actualLength(=" + actualLength + " must be >=0");
            }
            if (currentCapacity < actualLength) {
                throw new IllegalArgumentException("currentCapacity(=" + currentCapacity + ") must be >= actualLength(=" + actualLength + ")");
            }
            if (currentCapacity > this.maxCapacity) {
                throw new IllegalArgumentException("currentCapacity(=" + currentCapacity + ") must be <= max(=" + this.maxCapacity + ")");
            }
            return currentCapacity;
        }

        public String toString() {
            return "WriterDecidesStrategy{default: " + this.defaultCapacity + ", max: " + this.maxCapacity + "}";
        }
    }
}

