/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.partitions;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.com.amazonaws.SdkClientException;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.partitions.PartitionMetadataProvider;
import org.gradle.internal.impldep.com.amazonaws.partitions.model.Partitions;
import org.gradle.internal.impldep.com.amazonaws.util.IOUtils;
import org.gradle.internal.impldep.com.fasterxml.jackson.core.JsonParser;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.DeserializationFeature;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.MapperFeature;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.ObjectMapper;

@SdkInternalApi
public class PartitionsLoader {
    public static final String PARTITIONS_RESOURCE_PATH = "com/amazonaws/partitions/endpoints.json";
    public static final String PARTITIONS_OVERRIDE_RESOURCE_PATH = "com/amazonaws/partitions/override/endpoints.json";
    private static final ObjectMapper mapper = new ObjectMapper().disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS).disable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS).enable(JsonParser.Feature.ALLOW_COMMENTS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final ClassLoader classLoader = PartitionsLoader.class.getClassLoader();

    public PartitionMetadataProvider build() {
        InputStream stream = this.classLoader.getResourceAsStream("org/gradle/internal/impldep/com/amazonaws/partitions/override/endpoints.json");
        if (stream != null) {
            return new PartitionMetadataProvider(this.loadPartitionFromStream(stream, "org/gradle/internal/impldep/com/amazonaws/partitions/override/endpoints.json").getPartitions());
        }
        stream = this.classLoader.getResourceAsStream("org/gradle/internal/impldep/com/amazonaws/partitions/endpoints.json");
        if (stream == null) {
            throw new SdkClientException("Unable to load partition metadata from com/amazonaws/partitions/endpoints.json");
        }
        return new PartitionMetadataProvider(this.loadPartitionFromStream(stream, "org/gradle/internal/impldep/com/amazonaws/partitions/endpoints.json").getPartitions());
    }

    private Partitions loadPartitionFromStream(InputStream stream, String location) {
        try {
            Partitions partitions = mapper.readValue(stream, Partitions.class);
            return partitions;
        }
        catch (IOException e) {
            throw new SdkClientException("Error while loading partitions file from " + location, e);
        }
        finally {
            IOUtils.closeQuietly(stream, null);
        }
    }
}

