/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.io.opencensus.trace;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.io.opencensus.internal.Utils;
import org.gradle.internal.impldep.io.opencensus.trace.Annotation;
import org.gradle.internal.impldep.io.opencensus.trace.AttributeValue;
import org.gradle.internal.impldep.io.opencensus.trace.EndSpanOptions;
import org.gradle.internal.impldep.io.opencensus.trace.Link;
import org.gradle.internal.impldep.io.opencensus.trace.MessageEvent;
import org.gradle.internal.impldep.io.opencensus.trace.NetworkEvent;
import org.gradle.internal.impldep.io.opencensus.trace.SpanContext;
import org.gradle.internal.impldep.io.opencensus.trace.Status;
import org.gradle.internal.impldep.io.opencensus.trace.internal.BaseMessageEventUtils;

public abstract class Span {
    private static final Map<String, AttributeValue> EMPTY_ATTRIBUTES = Collections.emptyMap();
    private final SpanContext context;
    private final Set<Options> options;
    private static final Set<Options> DEFAULT_OPTIONS = Collections.unmodifiableSet(EnumSet.noneOf(Options.class));

    protected Span(SpanContext context, @Nullable EnumSet<Options> options) {
        this.context = Utils.checkNotNull(context, "context");
        this.options = options == null ? DEFAULT_OPTIONS : Collections.unmodifiableSet(EnumSet.copyOf(options));
        Utils.checkArgument(!context.getTraceOptions().isSampled() || this.options.contains((Object)Options.RECORD_EVENTS), "Span is sampled, but does not have RECORD_EVENTS set.");
    }

    public void putAttribute(String key, AttributeValue value) {
        Utils.checkNotNull(key, "key");
        Utils.checkNotNull(value, "value");
        this.putAttributes(Collections.singletonMap(key, value));
    }

    public void putAttributes(Map<String, AttributeValue> attributes) {
        Utils.checkNotNull(attributes, "attributes");
        this.addAttributes(attributes);
    }

    @Deprecated
    public void addAttributes(Map<String, AttributeValue> attributes) {
        this.putAttributes(attributes);
    }

    public final void addAnnotation(String description) {
        Utils.checkNotNull(description, "description");
        this.addAnnotation(description, EMPTY_ATTRIBUTES);
    }

    public abstract void addAnnotation(String var1, Map<String, AttributeValue> var2);

    public abstract void addAnnotation(Annotation var1);

    @Deprecated
    public void addNetworkEvent(NetworkEvent networkEvent) {
        this.addMessageEvent(BaseMessageEventUtils.asMessageEvent(networkEvent));
    }

    public void addMessageEvent(MessageEvent messageEvent) {
        Utils.checkNotNull(messageEvent, "messageEvent");
        this.addNetworkEvent(BaseMessageEventUtils.asNetworkEvent(messageEvent));
    }

    public abstract void addLink(Link var1);

    public void setStatus(Status status) {
        Utils.checkNotNull(status, "status");
    }

    public abstract void end(EndSpanOptions var1);

    public final void end() {
        this.end(EndSpanOptions.DEFAULT);
    }

    public final SpanContext getContext() {
        return this.context;
    }

    public final Set<Options> getOptions() {
        return this.options;
    }

    public static enum Kind {
        SERVER,
        CLIENT;

    }

    public static enum Options {
        RECORD_EVENTS;

    }
}

