/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.repository.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.TimeoutConstraint;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.AbstractRepository;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.Resource;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.vfs.VfsResource;
import org.gradle.internal.impldep.org.apache.ivy.util.CopyProgressListener;
import org.gradle.internal.impldep.org.apache.ivy.util.FileUtil;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class VfsRepository
extends AbstractRepository {
    private static final String IVY_VFS_CONFIG = "ivy_vfs.xml";
    private StandardFileSystemManager manager = null;
    private final CopyProgressListener progress = new RepositoryCopyProgressListener(this);

    public VfsRepository() {
    }

    public VfsRepository(TimeoutConstraint timeoutConstraint) {
        super(timeoutConstraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystemManager getVFSManager() throws IOException {
        VfsRepository vfsRepository = this;
        synchronized (vfsRepository) {
            if (this.manager == null) {
                this.manager = this.createVFSManager();
            }
        }
        return this.manager;
    }

    private StandardFileSystemManager createVFSManager() throws IOException {
        StandardFileSystemManager result = null;
        try {
            result = new StandardFileSystemManager(){

                protected void configurePlugins() throws FileSystemException {
                }
            };
            result.setConfiguration(this.getClass().getResource(IVY_VFS_CONFIG));
            result.init();
            Message.verbose("Available VFS schemes...");
            Object[] schemes = result.getSchemes();
            Arrays.sort(schemes);
            for (Object scheme : schemes) {
                Message.verbose("VFS Supported Scheme: " + (String)scheme);
            }
        }
        catch (FileSystemException e) {
            Message.error("Unable to initialize VFS repository manager!");
            Message.error(e.getLocalizedMessage());
            throw new IOException(e.getLocalizedMessage(), e);
        }
        return result;
    }

    protected void finalize() {
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    @Override
    public Resource getResource(String vfsURI) throws IOException {
        return new VfsResource(vfsURI, this.getVFSManager());
    }

    @Override
    public void get(String srcVfsURI, File destination) throws IOException {
        VfsResource src = new VfsResource(srcVfsURI, this.getVFSManager());
        this.fireTransferInitiated(src, 5);
        try {
            FileContent content = src.getContent();
            if (content == null) {
                throw new IllegalArgumentException("invalid vfs uri " + srcVfsURI + ": no content found");
            }
            FileUtil.copy(content.getInputStream(), destination, this.progress);
        }
        catch (IOException | RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
    }

    @Override
    public List<String> list(String vfsURI) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Message.debug("list called for URI" + vfsURI);
        FileObject resourceImpl = this.getVFSManager().resolveFile(vfsURI);
        Message.debug("resourceImpl=" + resourceImpl.toString());
        Message.debug("resourceImpl.exists()" + resourceImpl.exists());
        Message.debug("resourceImpl.getType()" + resourceImpl.getType());
        Message.debug("FileType.FOLDER" + FileType.FOLDER);
        if (resourceImpl.exists() && resourceImpl.getType() == FileType.FOLDER) {
            List<FileObject> children = Arrays.asList(resourceImpl.getChildren());
            for (FileObject child : children) {
                Message.debug("child " + children.indexOf(child) + child.getName().getURI());
                list.add(VfsResource.normalize(child.getName().getURI()));
            }
        }
        return list;
    }

    @Override
    public void put(File source, String vfsURI, boolean overwrite) throws IOException {
        VfsResource dest = new VfsResource(vfsURI, this.getVFSManager());
        this.fireTransferInitiated(dest, 6);
        if (dest.physicallyExists() && !overwrite) {
            throw new IOException("Cannot copy. Destination file: " + dest.getName() + " exists and overwrite not set.");
        }
        if (dest.getContent() == null) {
            throw new IllegalArgumentException("invalid vfs uri " + vfsURI + " to put data to: resource has no content");
        }
        FileUtil.copy((InputStream)new FileInputStream(source), dest.getContent().getOutputStream(), this.progress);
    }
}

