/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.resolver.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.plugins.repository.Resource;

public class BuiltFileResource
implements Resource {
    public static final String BUILT_ARTIFACT_PATTERN = "artifacts/[type]s/[artifact].[ext]";
    private final File file;

    public BuiltFileResource(File file) {
        this.file = file;
    }

    public BuiltFileResource(File dir2, Artifact artifact) {
        this(new File(dir2, IvyPatternHelper.substitute(BUILT_ARTIFACT_PATTERN, artifact)));
    }

    @Override
    public String getName() {
        return this.file.toURI().toString();
    }

    @Override
    public Resource clone(String name) {
        return new BuiltFileResource(new File(name));
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    public String toString() {
        return this.getName();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

