/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.lib.HandlerFactory;
import com.intellij.debugger.streams.trace.IntermediateCallHandler;
import com.intellij.debugger.streams.trace.TerminatorCallHandler;
import com.intellij.debugger.streams.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.trace.TraceHandler;
import com.intellij.debugger.streams.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CodeContext;
import com.intellij.debugger.streams.trace.dsl.Convertable;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.Lambda;
import com.intellij.debugger.streams.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.trace.dsl.Statement;
import com.intellij.debugger.streams.trace.dsl.Types;
import com.intellij.debugger.streams.trace.dsl.Variable;
import com.intellij.debugger.streams.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.impl.TraceExpressionBuilderBase;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.QualifierExpression;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.wrapper.impl.StreamChainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u0014\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/debugger/streams/trace/impl/TraceExpressionBuilderBase;", "Lcom/intellij/debugger/streams/trace/TraceExpressionBuilder;", "dsl", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "handlerFactory", "Lcom/intellij/debugger/streams/lib/HandlerFactory;", "(Lcom/intellij/debugger/streams/trace/dsl/Dsl;Lcom/intellij/debugger/streams/lib/HandlerFactory;)V", "getDsl", "()Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "resultVariableName", "", "getResultVariableName", "()Ljava/lang/String;", "buildDeclarations", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "intermediateCallsHandlers", "", "Lcom/intellij/debugger/streams/trace/IntermediateCallHandler;", "terminatorHandler", "Lcom/intellij/debugger/streams/trace/TerminatorCallHandler;", "buildFillInfo", "info", "Lcom/intellij/debugger/streams/trace/dsl/ArrayVariable;", "buildStreamExpression", "chain", "Lcom/intellij/debugger/streams/wrapper/StreamChain;", "streamResult", "Lcom/intellij/debugger/streams/trace/dsl/Variable;", "buildTraceChain", "intermediateCallHandlers", "createTimePeekCall", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "elementType", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "createTraceExpression", "intellij.java.debugger.streams"})
@SourceDebugExtension(value={"SMAP\nTraceExpressionBuilderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceExpressionBuilderBase.kt\ncom/intellij/debugger/streams/trace/impl/TraceExpressionBuilderBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,141:1\n1590#2,4:142\n37#3,2:146\n*S KotlinDebug\n*F\n+ 1 TraceExpressionBuilderBase.kt\ncom/intellij/debugger/streams/trace/impl/TraceExpressionBuilderBase\n*L\n28#1:142,4\n130#1:146,2\n*E\n"})
public abstract class TraceExpressionBuilderBase
implements TraceExpressionBuilder {
    @NotNull
    private final Dsl dsl;
    @NotNull
    private final HandlerFactory handlerFactory;
    @NotNull
    private final String resultVariableName;

    public TraceExpressionBuilderBase(@NotNull Dsl dsl, @NotNull HandlerFactory handlerFactory) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)handlerFactory, (String)"handlerFactory");
        this.dsl = dsl;
        this.handlerFactory = handlerFactory;
        this.resultVariableName = "myRes";
    }

    @NotNull
    protected final Dsl getDsl() {
        return this.dsl;
    }

    @NotNull
    protected final String getResultVariableName() {
        return this.resultVariableName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String createTraceExpression(@NotNull StreamChain chain) {
        void destination$iv;
        void $this$mapIndexedTo$iv;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        List<IntermediateStreamCall> list2 = chain.getIntermediateCalls();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getIntermediateCalls(...)");
        Iterable iterable = list2;
        Collection collection = new ArrayList();
        HandlerFactory handlerFactory = this.handlerFactory;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            void p1;
            void p0;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IntermediateStreamCall intermediateStreamCall = (IntermediateStreamCall)item$iv;
            int n2 = n;
            void var14_16 = destination$iv;
            boolean bl = false;
            var14_16.add(handlerFactory.getForIntermediate((int)p0, (IntermediateStreamCall)p1));
        }
        ArrayList intermediateHandlers = (ArrayList)destination$iv;
        TerminatorStreamCall terminatorStreamCall = chain.getTerminationCall();
        Intrinsics.checkNotNullExpressionValue((Object)terminatorStreamCall, (String)"getTerminationCall(...)");
        TerminatorStreamCall terminatorCall = terminatorStreamCall;
        TerminatorCallHandler terminatorHandler = this.handlerFactory.getForTermination(terminatorCall, "evaluationResult[0]");
        StreamChain traceChain = this.buildTraceChain(chain, intermediateHandlers, terminatorHandler);
        int infoArraySize = 2 + intermediateHandlers.size();
        ArrayVariable info = this.dsl.array(this.dsl.getTypes().getANY(), "info");
        Variable streamResult2 = this.dsl.variable(this.dsl.getTypes().nullable((Function1<? super Types, ? extends GenericType>)((Function1)createTraceExpression.streamResult.1.INSTANCE)), "streamResult");
        CodeBlock declarations = this.buildDeclarations(intermediateHandlers, terminatorHandler);
        CodeBlock tracingCall = this.buildStreamExpression(traceChain, streamResult2);
        CodeBlock fillingInfoArray = this.buildFillInfo(intermediateHandlers, terminatorHandler, info);
        Variable result = this.dsl.variable(this.dsl.getTypes().getANY(), this.resultVariableName);
        return this.dsl.code((Function1<? super CodeContext, Unit>)((Function1)new Function1<CodeContext, Unit>(info, infoArraySize, declarations, tracingCall, fillingInfoArray, result, streamResult2){
            final /* synthetic */ ArrayVariable $info;
            final /* synthetic */ int $infoArraySize;
            final /* synthetic */ CodeBlock $declarations;
            final /* synthetic */ CodeBlock $tracingCall;
            final /* synthetic */ CodeBlock $fillingInfoArray;
            final /* synthetic */ Variable $result;
            final /* synthetic */ Variable $streamResult;
            {
                this.$info = $info;
                this.$infoArraySize = $infoArraySize;
                this.$declarations = $declarations;
                this.$tracingCall = $tracingCall;
                this.$fillingInfoArray = $fillingInfoArray;
                this.$result = $result;
                this.$streamResult = $streamResult;
                super(1);
            }

            public final void invoke(@NotNull CodeContext $this$code) {
                Intrinsics.checkNotNullParameter((Object)$this$code, (String)"$this$code");
                $this$code.scope((Function1<? super CodeBlock, Unit>)((Function1)new Function1<CodeBlock, Unit>($this$code, this.$info, this.$infoArraySize, this.$declarations, this.$tracingCall, this.$fillingInfoArray, this.$result, this.$streamResult){
                    final /* synthetic */ CodeContext $this_code;
                    final /* synthetic */ ArrayVariable $info;
                    final /* synthetic */ int $infoArraySize;
                    final /* synthetic */ CodeBlock $declarations;
                    final /* synthetic */ CodeBlock $tracingCall;
                    final /* synthetic */ CodeBlock $fillingInfoArray;
                    final /* synthetic */ Variable $result;
                    final /* synthetic */ Variable $streamResult;
                    {
                        this.$this_code = $this_code;
                        this.$info = $info;
                        this.$infoArraySize = $infoArraySize;
                        this.$declarations = $declarations;
                        this.$tracingCall = $tracingCall;
                        this.$fillingInfoArray = $fillingInfoArray;
                        this.$result = $result;
                        this.$streamResult = $streamResult;
                        super(1);
                    }

                    public final void invoke(@NotNull CodeBlock $this$scope) {
                        Intrinsics.checkNotNullParameter((Object)$this$scope, (String)"$this$scope");
                        Variable startTime = $this$scope.declare(this.$this_code.variable(this.$this_code.getTypes().getLONG(), "startTime"), this.$this_code.getExpr("java.lang.System.nanoTime()"), false);
                        $this$scope.declare(this.$info, this.$this_code.newSizedArray(this.$this_code.getTypes().getANY(), this.$infoArraySize), false);
                        $this$scope.declare(this.$this_code.timeDeclaration());
                        $this$scope.add(this.$declarations);
                        $this$scope.add(this.$tracingCall);
                        $this$scope.add(this.$fillingInfoArray);
                        Expression[] expressionArray = new Expression[]{this.$this_code.getExpr("java.lang.System.nanoTime() - " + Convertable.toCode$default(startTime, 0, 1, null))};
                        Variable elapsedTime = $this$scope.declare(this.$this_code.array(this.$this_code.getTypes().getLONG(), "elapsedTime"), this.$this_code.newArray(this.$this_code.getTypes().getLONG(), expressionArray), false);
                        expressionArray = new Expression[]{this.$info, this.$streamResult, elapsedTime};
                        $this$scope.assign(this.$result, this.$this_code.newArray(this.$this_code.getTypes().getANY(), expressionArray));
                    }
                }));
            }
        }));
    }

    private final StreamChain buildTraceChain(StreamChain chain, List<? extends IntermediateCallHandler> intermediateCallHandlers, TerminatorCallHandler terminatorHandler) {
        boolean bl;
        List newIntermediateCalls = new ArrayList();
        QualifierExpression qualifierExpression = chain.getQualifierExpression();
        Intrinsics.checkNotNullExpressionValue((Object)qualifierExpression, (String)"getQualifierExpression(...)");
        QualifierExpression qualifierExpression2 = qualifierExpression;
        GenericType genericType = qualifierExpression2.getTypeAfter();
        Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getTypeAfter(...)");
        newIntermediateCalls.add(this.createTimePeekCall(genericType));
        List<IntermediateStreamCall> list2 = chain.getIntermediateCalls();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getIntermediateCalls(...)");
        List<IntermediateStreamCall> intermediateCalls = list2;
        boolean bl2 = bl = intermediateCalls.size() == intermediateCallHandlers.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (Pair pair : CollectionsKt.zip((Iterable)intermediateCalls, (Iterable)intermediateCallHandlers)) {
            IntermediateStreamCall call2 = (IntermediateStreamCall)pair.component1();
            IntermediateCallHandler handler = (IntermediateCallHandler)pair.component2();
            List<IntermediateStreamCall> list3 = handler.additionalCallsBefore();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"additionalCallsBefore(...)");
            newIntermediateCalls.addAll((Collection)list3);
            StreamCall streamCall = handler.transformCall((StreamCall)call2);
            Intrinsics.checkNotNullExpressionValue((Object)streamCall, (String)"transformCall(...)");
            newIntermediateCalls.add(streamCall);
            GenericType genericType2 = call2.getTypeAfter();
            Intrinsics.checkNotNullExpressionValue((Object)genericType2, (String)"getTypeAfter(...)");
            newIntermediateCalls.add(this.createTimePeekCall(genericType2));
            List<IntermediateStreamCall> list4 = handler.additionalCallsAfter();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"additionalCallsAfter(...)");
            newIntermediateCalls.addAll((Collection)list4);
        }
        List<IntermediateStreamCall> list5 = terminatorHandler.additionalCallsBefore();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"additionalCallsBefore(...)");
        newIntermediateCalls.addAll((Collection)list5);
        StreamCall streamCall = terminatorHandler.transformCall((StreamCall)chain.getTerminationCall());
        Intrinsics.checkNotNullExpressionValue((Object)streamCall, (String)"transformCall(...)");
        TerminatorStreamCall terminatorCall = (TerminatorStreamCall)streamCall;
        return new StreamChainImpl(qualifierExpression2, newIntermediateCalls, terminatorCall, chain.getContext());
    }

    private final IntermediateStreamCall createTimePeekCall(GenericType elementType) {
        Lambda lambda2 = this.dsl.lambda("x", (Function2<? super LambdaBody, ? super Expression, Unit>)((Function2)new Function2<LambdaBody, Expression, Unit>(this){
            final /* synthetic */ TraceExpressionBuilderBase this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull LambdaBody $this$lambda, @NotNull Expression it) {
                Intrinsics.checkNotNullParameter((Object)$this$lambda, (String)"$this$lambda");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $this$lambda.doReturn(this.this$0.getDsl().updateTime());
            }
        }));
        return this.dsl.createPeekCall(elementType, lambda2);
    }

    private final CodeBlock buildDeclarations(List<? extends IntermediateCallHandler> intermediateCallsHandlers, TerminatorCallHandler terminatorHandler) {
        return this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)new Function1<CodeContext, Unit>(intermediateCallsHandlers, terminatorHandler){
            final /* synthetic */ List<IntermediateCallHandler> $intermediateCallsHandlers;
            final /* synthetic */ TerminatorCallHandler $terminatorHandler;
            {
                this.$intermediateCallsHandlers = $intermediateCallsHandlers;
                this.$terminatorHandler = $terminatorHandler;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CodeContext $this$block) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$block, (String)"$this$block");
                Iterable $this$flatMap$iv = this.$intermediateCallsHandlers;
                boolean $i$f$flatMap = false;
                Iterator<T> iterator = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    IntermediateCallHandler it = (IntermediateCallHandler)element$iv$iv;
                    boolean bl = false;
                    List<VariableDeclaration> list2 = it.additionalVariablesDeclaration();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"additionalVariablesDeclaration(...)");
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VariableDeclaration it = (VariableDeclaration)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    $this$block.declare(it);
                }
                List<VariableDeclaration> list3 = this.$terminatorHandler.additionalVariablesDeclaration();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"additionalVariablesDeclaration(...)");
                $this$forEach$iv = list3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VariableDeclaration it = (VariableDeclaration)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    $this$block.declare(it);
                }
            }
        }));
    }

    private final CodeBlock buildStreamExpression(StreamChain chain, Variable streamResult2) {
        GenericType genericType = chain.getTerminationCall().getResultType();
        Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getResultType(...)");
        GenericType resultType = genericType;
        return this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)new Function1<CodeContext, Unit>(streamResult2, resultType, chain){
            final /* synthetic */ Variable $streamResult;
            final /* synthetic */ GenericType $resultType;
            final /* synthetic */ StreamChain $chain;
            {
                this.$streamResult = $streamResult;
                this.$resultType = $resultType;
                this.$chain = $chain;
                super(1);
            }

            public final void invoke(@NotNull CodeContext $this$block) {
                Intrinsics.checkNotNullParameter((Object)$this$block, (String)"$this$block");
                $this$block.declare(this.$streamResult, $this$block.getNullExpression(), true);
                ArrayVariable evaluationResult = $this$block.array(this.$resultType, "evaluationResult");
                if (!Intrinsics.areEqual((Object)this.$resultType, (Object)$this$block.getTypes().getVOID())) {
                    Expression[] expressionArray = new Expression[]{new TextExpression(this.$resultType.getDefaultValue())};
                    $this$block.declare(evaluationResult, $this$block.newArray(this.$resultType, expressionArray), true);
                }
                $this$block.tryBlock((Function1<? super CodeBlock, Unit>)((Function1)new Function1<CodeBlock, Unit>(this.$resultType, $this$block, this.$streamResult, evaluationResult, this.$chain){
                    final /* synthetic */ GenericType $resultType;
                    final /* synthetic */ CodeContext $this_block;
                    final /* synthetic */ Variable $streamResult;
                    final /* synthetic */ ArrayVariable $evaluationResult;
                    final /* synthetic */ StreamChain $chain;
                    {
                        this.$resultType = $resultType;
                        this.$this_block = $this_block;
                        this.$streamResult = $streamResult;
                        this.$evaluationResult = $evaluationResult;
                        this.$chain = $chain;
                        super(1);
                    }

                    public final void invoke(@NotNull CodeBlock $this$tryBlock) {
                        Intrinsics.checkNotNullParameter((Object)$this$tryBlock, (String)"$this$tryBlock");
                        if (Intrinsics.areEqual((Object)this.$resultType, (Object)this.$this_block.getTypes().getVOID())) {
                            $this$tryBlock.assign(this.$streamResult, this.$this_block.newSizedArray(this.$this_block.getTypes().getANY(), 1));
                            $this$tryBlock.statement((Function0<? extends Statement>)((Function0)new Function0<Statement>(this.$chain){
                                final /* synthetic */ StreamChain $chain;
                                {
                                    this.$chain = $chain;
                                    super(0);
                                }

                                @NotNull
                                public final Statement invoke() {
                                    String string = this.$chain.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                    return new TextExpression(string);
                                }
                            }));
                        } else {
                            $this$tryBlock.statement((Function0<? extends Statement>)((Function0)new Function0<Statement>(this.$evaluationResult, this.$chain){
                                final /* synthetic */ ArrayVariable $evaluationResult;
                                final /* synthetic */ StreamChain $chain;
                                {
                                    this.$evaluationResult = $evaluationResult;
                                    this.$chain = $chain;
                                    super(0);
                                }

                                @NotNull
                                public final Statement invoke() {
                                    String string = this.$chain.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                    return this.$evaluationResult.set(0, (Expression)new TextExpression(string));
                                }
                            }));
                            $this$tryBlock.assign(this.$streamResult, this.$evaluationResult);
                        }
                    }
                })).catch($this$block.variable($this$block.getTypes().getEXCEPTION(), "t"), (Function1<? super CodeBlock, Unit>)((Function1)new Function1<CodeBlock, Unit>(this.$streamResult, $this$block){
                    final /* synthetic */ Variable $streamResult;
                    final /* synthetic */ CodeContext $this_block;
                    {
                        this.$streamResult = $streamResult;
                        this.$this_block = $this_block;
                        super(1);
                    }

                    public final void invoke(@NotNull CodeBlock $this$catch) {
                        Intrinsics.checkNotNullParameter((Object)$this$catch, (String)"$this$catch");
                        Expression[] expressionArray = new Expression[]{this.$this_block.getExpr("t")};
                        $this$catch.assign(this.$streamResult, this.$this_block.newArray(this.$this_block.getTypes().getEXCEPTION(), expressionArray));
                    }
                }));
            }
        }));
    }

    private final CodeBlock buildFillInfo(List<? extends IntermediateCallHandler> intermediateCallsHandlers, TerminatorCallHandler terminatorHandler, ArrayVariable info) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Collection $this$toTypedArray$iv = intermediateCallsHandlers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new IntermediateCallHandler[0]));
        spreadBuilder.add((Object)terminatorHandler);
        List handlers = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new TraceHandler[spreadBuilder.size()]));
        return this.dsl.block((Function1<? super CodeContext, Unit>)((Function1)new Function1<CodeContext, Unit>((List<? extends TraceHandler>)handlers, info){
            final /* synthetic */ List<TraceHandler> $handlers;
            final /* synthetic */ ArrayVariable $info;
            {
                this.$handlers = $handlers;
                this.$info = $info;
                super(1);
            }

            public final void invoke(@NotNull CodeContext $this$block) {
                Intrinsics.checkNotNullParameter((Object)$this$block, (String)"$this$block");
                Iterator<TraceHandler> iterator = this.$handlers.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    TraceHandler handler = iterator.next();
                    $this$block.scope((Function1<? super CodeBlock, Unit>)((Function1)new Function1<CodeBlock, Unit>(handler, this.$info, i){
                        final /* synthetic */ TraceHandler $handler;
                        final /* synthetic */ ArrayVariable $info;
                        final /* synthetic */ int $i;
                        {
                            this.$handler = $handler;
                            this.$info = $info;
                            this.$i = $i;
                            super(1);
                        }

                        public final void invoke(@NotNull CodeBlock $this$scope) {
                            Intrinsics.checkNotNullParameter((Object)$this$scope, (String)"$this$scope");
                            CodeBlock codeBlock = this.$handler.prepareResult();
                            Intrinsics.checkNotNullExpressionValue((Object)codeBlock, (String)"prepareResult(...)");
                            $this$scope.add(codeBlock);
                            $this$scope.statement((Function0<? extends Statement>)((Function0)new Function0<Statement>(this.$info, this.$i, this.$handler){
                                final /* synthetic */ ArrayVariable $info;
                                final /* synthetic */ int $i;
                                final /* synthetic */ TraceHandler $handler;
                                {
                                    this.$info = $info;
                                    this.$i = $i;
                                    this.$handler = $handler;
                                    super(0);
                                }

                                @NotNull
                                public final Statement invoke() {
                                    Expression expression = this.$handler.getResultExpression();
                                    Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"getResultExpression(...)");
                                    return this.$info.set(this.$i, expression);
                                }
                            }));
                        }
                    }));
                }
            }
        }));
    }
}

