/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.AttachmentIn;
import circlet.client.api.FileIdentity;
import circlet.client.api.LinkIdentity;
import circlet.platform.api.serialization.ApiSerializable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.StringUtilsKt;

@ApiSerializable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0004H\u0016J\r\u0010\u0010\u001a\u00060\u0004j\u0002`\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0006\u0010\u0018\u001a\u00020\u0004J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0004H\u0096\u0001J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcirclet/client/api/FileAttachment;", "Lcirclet/client/api/AttachmentIn;", "Lcirclet/client/api/LinkIdentity;", "id", "", "Lcirclet/platform/api/TID;", "sizeBytes", "", "filename", "(Ljava/lang/String;JLjava/lang/String;)V", "getFilename", "()Ljava/lang/String;", "getId", "getSizeBytes", "()J", "asText", "component1", "component2", "component3", "copy", "equals", "", "other", "", "extension", "hashCode", "", "identity", "toString", "client-api"})
public final class FileAttachment
implements AttachmentIn,
LinkIdentity {
    @NotNull
    private final String id;
    private final long sizeBytes;
    @NotNull
    private final String filename;
    private final /* synthetic */ FileIdentity $$delegate_0;

    public FileAttachment(@NotNull String id2, long sizeBytes, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.id = id2;
        this.sizeBytes = sizeBytes;
        this.filename = filename;
        this.$$delegate_0 = new FileIdentity(id2, filename);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public final long getSizeBytes() {
        return this.sizeBytes;
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    @Override
    @NotNull
    public String identity() {
        return this.$$delegate_0.identity();
    }

    @Override
    @NotNull
    public String asText() {
        return "\ud83d\udcc4 " + StringUtilsKt.ellipsize(this.filename, 20);
    }

    @NotNull
    public final String extension() {
        String string2 = StringsKt.substringAfterLast((String)this.filename, (char)'.', (String)"").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string2;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.sizeBytes;
    }

    @NotNull
    public final String component3() {
        return this.filename;
    }

    @NotNull
    public final FileAttachment copy(@NotNull String id2, long sizeBytes, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new FileAttachment(id2, sizeBytes, filename);
    }

    public static /* synthetic */ FileAttachment copy$default(FileAttachment fileAttachment, String string2, long l, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = fileAttachment.id;
        }
        if ((n & 2) != 0) {
            l = fileAttachment.sizeBytes;
        }
        if ((n & 4) != 0) {
            string3 = fileAttachment.filename;
        }
        return fileAttachment.copy(string2, l, string3);
    }

    @NotNull
    public String toString() {
        return "FileAttachment(id=" + this.id + ", sizeBytes=" + this.sizeBytes + ", filename=" + this.filename + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.sizeBytes);
        result2 = result2 * 31 + this.filename.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileAttachment)) {
            return false;
        }
        FileAttachment fileAttachment = (FileAttachment)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)fileAttachment.id)) {
            return false;
        }
        if (this.sizeBytes != fileAttachment.sizeBytes) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filename, (Object)fileAttachment.filename);
    }
}

