/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.CommonIssueFlags;
import circlet.client.api.ProjectIdentifier;
import circlet.platform.api.annotations.HttpApiDoc;
import circlet.platform.api.annotations.HttpApiUrlParam;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.ApiFlagAnnotation;

@HttpApiUrlParam
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcirclet/client/api/IssueIdentifier;", "", "()V", "ExternalId", "Id", "Key", "Lcirclet/client/api/IssueIdentifier$ExternalId;", "Lcirclet/client/api/IssueIdentifier$Id;", "Lcirclet/client/api/IssueIdentifier$Key;", "client-api"})
public abstract class IssueIdentifier {
    private IssueIdentifier() {
    }

    public /* synthetic */ IssueIdentifier(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @HttpApiUrlParam.Var
    @HttpApiDoc(doc="Identifies issue in Space that was earlier imported from an external system by external id provided during the import.")
    @ApiFlagAnnotation(cls=CommonIssueFlags.ExternalId.class)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcirclet/client/api/IssueIdentifier$ExternalId;", "Lcirclet/client/api/IssueIdentifier;", "project", "Lcirclet/client/api/ProjectIdentifier;", "externalId", "", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;)V", "getExternalId", "()Ljava/lang/String;", "getProject", "()Lcirclet/client/api/ProjectIdentifier;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "client-api"})
    public static final class ExternalId
    extends IssueIdentifier {
        @NotNull
        private final ProjectIdentifier project;
        @NotNull
        private final String externalId;

        public ExternalId(@NotNull ProjectIdentifier project2, @NotNull String externalId) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalId, (String)"externalId");
            super(null);
            this.project = project2;
            this.externalId = externalId;
        }

        @NotNull
        public final ProjectIdentifier getProject() {
            return this.project;
        }

        @NotNull
        public final String getExternalId() {
            return this.externalId;
        }

        @NotNull
        public String toString() {
            return "{project:" + this.project + ",externalId:" + this.externalId + "}";
        }

        @NotNull
        public final ProjectIdentifier component1() {
            return this.project;
        }

        @NotNull
        public final String component2() {
            return this.externalId;
        }

        @NotNull
        public final ExternalId copy(@NotNull ProjectIdentifier project2, @NotNull String externalId) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalId, (String)"externalId");
            return new ExternalId(project2, externalId);
        }

        public static /* synthetic */ ExternalId copy$default(ExternalId externalId, ProjectIdentifier projectIdentifier2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                projectIdentifier2 = externalId.project;
            }
            if ((n & 2) != 0) {
                string2 = externalId.externalId;
            }
            return externalId.copy(projectIdentifier2, string2);
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + this.externalId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExternalId)) {
                return false;
            }
            ExternalId externalId = (ExternalId)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)externalId.project)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.externalId, (Object)externalId.externalId);
        }
    }

    @HttpApiUrlParam.Var(prefixRequired=false)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\t\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcirclet/client/api/IssueIdentifier$Id;", "Lcirclet/client/api/IssueIdentifier;", "id", "", "Lcirclet/platform/api/TID;", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "client-api"})
    public static final class Id
    extends IssueIdentifier {
        @NotNull
        private final String id;

        public Id(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            super(null);
            this.id = id2;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return "id:" + this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final Id copy(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return new Id(id2);
        }

        public static /* synthetic */ Id copy$default(Id id2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = id2.id;
            }
            return id2.copy(string2);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Id)) {
                return false;
            }
            Id id2 = (Id)other;
            return Intrinsics.areEqual((Object)this.id, (Object)id2.id);
        }
    }

    @HttpApiUrlParam.Var
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcirclet/client/api/IssueIdentifier$Key;", "Lcirclet/client/api/IssueIdentifier;", "key", "", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "client-api"})
    public static final class Key
    extends IssueIdentifier {
        @NotNull
        private final String key;

        public Key(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            super(null);
            this.key = key2;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public String toString() {
            return "key:" + this.key;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final Key copy(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return new Key(key2);
        }

        public static /* synthetic */ Key copy$default(Key key2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = key2.key;
            }
            return key2.copy(string2);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key2 = (Key)other;
            return Intrinsics.areEqual((Object)this.key, (Object)key2.key);
        }
    }
}

