/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.fields.type;

import circlet.client.api.fields.CFConstraint;
import circlet.client.api.fields.CFInputValue;
import circlet.client.api.fields.type.DateCFTypeKt;
import circlet.client.api.fields.type.DateCFValue;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.serialization.ApiSerializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.date.DateFormat;

@ApiSerializable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0011\u0010\u000f\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0003J\u0011\u0010\u0010\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J9\u0010\u0012\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J,\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001c0!H\u0016R\u0019\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\""}, d2={"Lcirclet/client/api/fields/type/DateCFConstraint;", "Lcirclet/client/api/fields/CFConstraint;", "min", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "max", "message", "", "(Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/KotlinXDate;Ljava/lang/String;)V", "getMax", "()Lcirclet/platform/api/KotlinXDate;", "getMessage", "()Ljava/lang/String;", "getMin", "actualMessage", "component1", "component2", "component3", "copy", "defaultMessage", "equals", "", "other", "", "hashCode", "", "toString", "validate", "", "value", "Lcirclet/client/api/fields/CFInputValue;", "validateNullValue", "error", "Lkotlin/Function1;", "client-api"})
public final class DateCFConstraint
extends CFConstraint {
    @Nullable
    private final KotlinXDate min;
    @Nullable
    private final KotlinXDate max;
    @Nullable
    private final String message;

    public DateCFConstraint(@Nullable KotlinXDate min2, @Nullable KotlinXDate max2, @Nullable String message2) {
        super(DateCFTypeKt.getDateCFTag());
        this.min = min2;
        this.max = max2;
        this.message = message2;
    }

    @Nullable
    public final KotlinXDate getMin() {
        return this.min;
    }

    @Nullable
    public final KotlinXDate getMax() {
        return this.max;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @Override
    public void validate(@NotNull CFInputValue value2, boolean validateNullValue, @NotNull Function1<? super String, Unit> error2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter(error2, (String)"error");
        if (value2 instanceof DateCFValue) {
            if (((DateCFValue)value2).getValue() == null) {
                if (validateNullValue) {
                    error2.invoke((Object)this.actualMessage());
                }
                return;
            }
            if (this.min != null && PrimitivesExKt.isBefore(((DateCFValue)value2).getValue(), this.min) || this.max != null && PrimitivesExKt.isAfter(((DateCFValue)value2).getValue(), this.max)) {
                error2.invoke((Object)this.actualMessage());
            }
        }
    }

    @Override
    @NotNull
    public String actualMessage() {
        String string2 = this.message;
        if (string2 == null) {
            string2 = this.defaultMessage();
        }
        return string2;
    }

    @Override
    @NotNull
    public String defaultMessage() {
        return this.min == null && this.max != null ? "Select a date on or before " + PrimitivesExKt.format(this.max, DateFormat.DAY_MONTH_AND_YEAR) : (this.min != null && this.max == null ? "Select a date on or after " + PrimitivesExKt.format(this.min, DateFormat.DAY_MONTH_AND_YEAR) : (this.min != null && this.max != null ? "Select a date between " + PrimitivesExKt.format(this.min, DateFormat.DAY_MONTH_AND_YEAR) + " and " + PrimitivesExKt.format(this.max, DateFormat.DAY_MONTH_AND_YEAR) : ""));
    }

    @Nullable
    public final KotlinXDate component1() {
        return this.min;
    }

    @Nullable
    public final KotlinXDate component2() {
        return this.max;
    }

    @Nullable
    public final String component3() {
        return this.message;
    }

    @NotNull
    public final DateCFConstraint copy(@Nullable KotlinXDate min2, @Nullable KotlinXDate max2, @Nullable String message2) {
        return new DateCFConstraint(min2, max2, message2);
    }

    public static /* synthetic */ DateCFConstraint copy$default(DateCFConstraint dateCFConstraint, KotlinXDate kotlinXDate, KotlinXDate kotlinXDate2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDate = dateCFConstraint.min;
        }
        if ((n & 2) != 0) {
            kotlinXDate2 = dateCFConstraint.max;
        }
        if ((n & 4) != 0) {
            string2 = dateCFConstraint.message;
        }
        return dateCFConstraint.copy(kotlinXDate, kotlinXDate2, string2);
    }

    @NotNull
    public String toString() {
        return "DateCFConstraint(min=" + this.min + ", max=" + this.max + ", message=" + this.message + ")";
    }

    public int hashCode() {
        int result2 = this.min == null ? 0 : this.min.hashCode();
        result2 = result2 * 31 + (this.max == null ? 0 : this.max.hashCode());
        result2 = result2 * 31 + (this.message == null ? 0 : this.message.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateCFConstraint)) {
            return false;
        }
        DateCFConstraint dateCFConstraint = (DateCFConstraint)other;
        if (!Intrinsics.areEqual((Object)this.min, (Object)dateCFConstraint.min)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.max, (Object)dateCFConstraint.max)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.message, (Object)dateCFConstraint.message);
    }
}

