/*
 * Decompiled with CFR 0.152.
 */
package circlet.code.review;

import circlet.code.api.CodeReviewParticipant;
import circlet.code.api.CodeReviewParticipantRole;
import circlet.code.api.CodeReviewParticipants;
import circlet.code.api.CodeReviewRecord;
import circlet.code.api.CodeReviewServiceKt;
import circlet.code.api.CodeReviewState;
import circlet.code.api.CommitSetReviewRecord;
import circlet.code.api.MergeRequestRecord;
import circlet.code.api.ReviewerState;
import circlet.code.review.ParticipantStatusBadgeParams;
import circlet.code.review.ReviewParticipantStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u001a \u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006\u000f"}, d2={"isReviewerAccepted", "", "Lcirclet/code/review/ReviewParticipantStatus;", "(Lcirclet/code/review/ReviewParticipantStatus;)Z", "isReviewerInProgress", "getParticipantStatusBadgeParams", "Lcirclet/code/review/ParticipantStatusBadgeParams;", "status", "getReviewParticipantStatus", "review", "Lcirclet/code/api/CodeReviewRecord;", "participants", "Lcirclet/code/api/CodeReviewParticipants;", "participant", "Lcirclet/code/api/CodeReviewParticipant;", "code-app-state"})
@SourceDebugExtension(value={"SMAP\nReviewParticipantStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewParticipantStatus.kt\ncirclet/code/review/ReviewParticipantStatusKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1747#2,3:127\n1747#2,3:130\n1747#2,3:133\n2624#2,3:136\n*S KotlinDebug\n*F\n+ 1 ReviewParticipantStatus.kt\ncirclet/code/review/ReviewParticipantStatusKt\n*L\n53#1:127,3\n80#1:130,3\n89#1:133,3\n90#1:136,3\n*E\n"})
public final class ReviewParticipantStatusKt {
    public static final boolean isReviewerAccepted(@NotNull ReviewParticipantStatus $this$isReviewerAccepted) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isReviewerAccepted), (String)"<this>");
        return $this$isReviewerAccepted == ReviewParticipantStatus.REVIEWER_ACCEPTED || $this$isReviewerAccepted == ReviewParticipantStatus.REVIEWER_ACCEPTED_FOREVER || $this$isReviewerAccepted == ReviewParticipantStatus.REVIEWER_ACCEPTED_OWNED_FILES;
    }

    public static final boolean isReviewerInProgress(@NotNull ReviewParticipantStatus $this$isReviewerInProgress) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isReviewerInProgress), (String)"<this>");
        return $this$isReviewerInProgress == ReviewParticipantStatus.REVIEWER_IN_PROGRESS || $this$isReviewerInProgress == ReviewParticipantStatus.REVIEWER_IN_PROGRESS_ALL_FILES || $this$isReviewerInProgress == ReviewParticipantStatus.REVIEWER_IN_PROGRESS_OWNED_FILES;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final ReviewParticipantStatus getReviewParticipantStatus(@NotNull CodeReviewRecord review2, @NotNull CodeReviewParticipants participants2, @NotNull CodeReviewParticipant participant) {
        CodeReviewParticipant it;
        boolean bl;
        ReviewParticipantStatus reviewParticipantStatus;
        List<CodeReviewParticipant> reviewers2;
        block24: {
            Iterator iterator2;
            block32: {
                boolean isWaitingReply;
                block30: {
                    Iterable $this$any$iv;
                    block31: {
                        boolean isInProgress;
                        block27: {
                            block29: {
                                block28: {
                                    boolean bl2;
                                    block23: {
                                        boolean isRejected;
                                        Object[] it2;
                                        boolean bl3;
                                        boolean isOpen2;
                                        block22: {
                                            block26: {
                                                Intrinsics.checkNotNullParameter((Object)review2, (String)"review");
                                                Intrinsics.checkNotNullParameter((Object)participants2, (String)"participants");
                                                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                                                isOpen2 = review2.getState() == CodeReviewState.Opened;
                                                reviewers2 = CodeReviewServiceKt.getReviewers(participants2);
                                                if (participant.getRole() != CodeReviewParticipantRole.Author) break block26;
                                                Iterable $this$any$iv2 = reviewers2;
                                                boolean $i$f$any = false;
                                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                                    bl3 = false;
                                                    break block22;
                                                } else {
                                                    for (Object element$iv : $this$any$iv2) {
                                                        it2 = (Object[])element$iv;
                                                        boolean bl4 = false;
                                                        if (!Intrinsics.areEqual(it2.getUser(), participant.getUser())) continue;
                                                        bl3 = true;
                                                        break block22;
                                                    }
                                                    bl3 = false;
                                                }
                                                break block22;
                                            }
                                            bl3 = false;
                                        }
                                        boolean isReviewerAlsoAuthor = bl3;
                                        boolean showTurnInfo = isOpen2 && !isReviewerAlsoAuthor;
                                        boolean isAccepted = CodeReviewServiceKt.getReviewerState(participant) == ReviewerState.Accepted;
                                        boolean bl5 = isRejected = CodeReviewServiceKt.getReviewerState(participant) == ReviewerState.Rejected;
                                        isInProgress = showTurnInfo && CodeReviewServiceKt.getReviewerState(participant) == null && SetsKt.setOf((Object[])(it2 = new Boolean[]{true, null})).contains(participant.getTheirTurn());
                                        isWaitingReply = showTurnInfo && CodeReviewServiceKt.getReviewerState(participant) == null && Intrinsics.areEqual((Object)participant.getTheirTurn(), (Object)false);
                                        if (isAccepted && Intrinsics.areEqual((Object)participant.isApproveSticky(), (Object)true)) {
                                            reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_ACCEPTED_FOREVER;
                                            return reviewParticipantStatus;
                                        }
                                        if (isAccepted) {
                                            if (Intrinsics.areEqual((Object)participant.getReviewOnlyOwnedFiles(), (Object)true)) {
                                                reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_ACCEPTED_OWNED_FILES;
                                                return reviewParticipantStatus;
                                            }
                                            reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_ACCEPTED;
                                            return reviewParticipantStatus;
                                        }
                                        if (isRejected) {
                                            reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_REJECTED;
                                            return reviewParticipantStatus;
                                        }
                                        if (!isInProgress || participant.getRole() != CodeReviewParticipantRole.Reviewer) break block27;
                                        if (review2 instanceof CommitSetReviewRecord) break block28;
                                        if (Intrinsics.areEqual((Object)((MergeRequestRecord)review2).getHasOwnedFiles(), (Object)true)) break block29;
                                        Iterable $this$any$iv3 = CodeReviewServiceKt.getReviewers(participants2);
                                        boolean $i$f$any = false;
                                        if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                            bl2 = false;
                                        } else {
                                            for (Object element$iv : $this$any$iv3) {
                                                CodeReviewParticipant it3 = (CodeReviewParticipant)element$iv;
                                                boolean bl6 = false;
                                                if (!Intrinsics.areEqual((Object)it3.getHasOwnedFiles(), (Object)true)) continue;
                                                bl2 = true;
                                                break block23;
                                            }
                                            bl2 = false;
                                        }
                                    }
                                    if (bl2) break block29;
                                }
                                reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_IN_PROGRESS;
                                return reviewParticipantStatus;
                            }
                            if (Intrinsics.areEqual((Object)participant.getReviewOnlyOwnedFiles(), (Object)true)) {
                                reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_IN_PROGRESS_OWNED_FILES;
                                return reviewParticipantStatus;
                            }
                            reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_IN_PROGRESS_ALL_FILES;
                            return reviewParticipantStatus;
                        }
                        if (!isInProgress || participant.getRole() != CodeReviewParticipantRole.Author) break block30;
                        $this$any$iv = reviewers2;
                        boolean $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block31;
                        bl = false;
                        break block24;
                    }
                    iterator2 = $this$any$iv.iterator();
                    break block32;
                }
                if (isWaitingReply && participant.getRole() == CodeReviewParticipantRole.Author) {
                    reviewParticipantStatus = ReviewParticipantStatus.AUTHOR_WAITS_RESPONSE;
                    return reviewParticipantStatus;
                }
                if (!isWaitingReply) return null;
                if (participant.getRole() != CodeReviewParticipantRole.Reviewer) return null;
                reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_WAITS_RESPONSE;
                return reviewParticipantStatus;
            }
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                it = (CodeReviewParticipant)element$iv;
                boolean bl7 = false;
                if (!(CodeReviewServiceKt.getReviewerState(it) == ReviewerState.Accepted)) continue;
                bl = true;
                break block24;
            }
            bl = false;
        }
        if (bl) {
            boolean bl8;
            block25: {
                Iterable $this$none$iv = reviewers2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl8 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (CodeReviewParticipant)element$iv;
                        boolean bl9 = false;
                        if (!(CodeReviewServiceKt.getReviewerState(it) == null && Intrinsics.areEqual((Object)it.getTheirTurn(), (Object)false))) continue;
                        bl8 = false;
                        break block25;
                    }
                    bl8 = true;
                }
            }
            if (bl8) {
                reviewParticipantStatus = ReviewParticipantStatus.AUTHOR_GOT_ALL_APPROVALS;
                return reviewParticipantStatus;
            }
        }
        reviewParticipantStatus = ReviewParticipantStatus.AUTHOR_REVISING_FILES;
        return reviewParticipantStatus;
    }

    @NotNull
    public static final ParticipantStatusBadgeParams getParticipantStatusBadgeParams(@Nullable ReviewParticipantStatus status2) {
        String string2;
        ReviewParticipantStatus reviewParticipantStatus = status2;
        switch (reviewParticipantStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[reviewParticipantStatus.ordinal()]) {
            case 1: {
                string2 = "Accepted the changes";
                break;
            }
            case 2: {
                string2 = "Accepted the changes in owned files";
                break;
            }
            case 3: {
                string2 = "Finalized approval";
                break;
            }
            case 4: {
                string2 = "Raised a concern";
                break;
            }
            case 5: {
                string2 = "Reviewing the changes";
                break;
            }
            case 6: {
                string2 = "Reviewing all files";
                break;
            }
            case 7: {
                string2 = "Reviewing owned files";
                break;
            }
            case 8: {
                string2 = "Waits for updates";
                break;
            }
            case 9: {
                string2 = "Waits for reviewers";
                break;
            }
            case 10: {
                string2 = "Revising the files";
                break;
            }
            case 11: {
                string2 = null;
                break;
            }
            case -1: {
                string2 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ReviewParticipantStatus reviewParticipantStatus2 = status2;
        return new ParticipantStatusBadgeParams(string2, reviewParticipantStatus2 != null ? reviewParticipantStatus2.getKind() : null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReviewParticipantStatus.values().length];
            try {
                nArray[ReviewParticipantStatus.REVIEWER_ACCEPTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.REVIEWER_ACCEPTED_OWNED_FILES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.REVIEWER_ACCEPTED_FOREVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.REVIEWER_REJECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.REVIEWER_IN_PROGRESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.REVIEWER_IN_PROGRESS_ALL_FILES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.REVIEWER_IN_PROGRESS_OWNED_FILES.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.REVIEWER_WAITS_RESPONSE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.AUTHOR_WAITS_RESPONSE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.AUTHOR_REVISING_FILES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReviewParticipantStatus.AUTHOR_GOT_ALL_APPROVALS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

