/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.permissions;

import circlet.common.permissions.PermissionContextType;
import circlet.common.permissions.PermissionRoleScope;
import circlet.common.permissions.RoleCode;
import circlet.common.permissions.RolesKt;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\t\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\n\"\u0016\u0010\u0000\u001a\u00020\u0001\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0005\u001a\u00020\u0001\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0006\u0010\u0003\"'\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\"\u0016\u0010\u000f\u001a\u00020\u0001\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0010\u0010\u0003\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"authorizedRoleCode", "Lcirclet/common/permissions/RoleCode;", "getAuthorizedRoleCode", "()Ljava/lang/String;", "Ljava/lang/String;", "customRoleCode", "getCustomRoleCode", "permissionContextTypeByCode", "", "", "Lcirclet/common/permissions/PermissionContextType;", "getPermissionContextTypeByCode", "()Ljava/util/Map;", "permissionContextTypeByCode$delegate", "Lkotlin/Lazy;", "requestedRoleCode", "getRequestedRoleCode", "parsePermissionContextTypeOrNull", "code", "toObsoleteScope", "Lcirclet/common/permissions/PermissionRoleScope;", "common"})
public final class RolesKt {
    @NotNull
    private static final Lazy permissionContextTypeByCode$delegate = LazyKt.lazy((Function0)permissionContextTypeByCode.2.INSTANCE);
    @NotNull
    private static final String requestedRoleCode = RoleCode.constructor-impl("Requested");
    @NotNull
    private static final String authorizedRoleCode = RoleCode.constructor-impl("Authorized");
    @NotNull
    private static final String customRoleCode = RoleCode.constructor-impl("Custom");

    @NotNull
    public static final PermissionRoleScope toObsoleteScope(@NotNull PermissionContextType $this$toObsoleteScope) {
        PermissionRoleScope permissionRoleScope;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toObsoleteScope), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toObsoleteScope.ordinal()]) {
            case 1: {
                permissionRoleScope = PermissionRoleScope.GLOBAL;
                break;
            }
            case 2: {
                permissionRoleScope = PermissionRoleScope.PROJECT;
                break;
            }
            case 3: {
                throw new IllegalStateException("can not transform channel context type".toString());
            }
            case 4: {
                throw new IllegalStateException("can not transform profile context type".toString());
            }
            case 5: {
                throw new IllegalStateException("can not transform team context type".toString());
            }
            case 6: {
                throw new IllegalStateException("can not transform document context type".toString());
            }
            case 7: {
                throw new IllegalStateException("can not transform folder context type".toString());
            }
            case 8: {
                throw new IllegalStateException("can not transform package repository context type".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return permissionRoleScope;
    }

    private static final Map<String, PermissionContextType> getPermissionContextTypeByCode() {
        Lazy lazy = permissionContextTypeByCode$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public static final PermissionContextType parsePermissionContextTypeOrNull(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return RolesKt.getPermissionContextTypeByCode().get(code);
    }

    @NotNull
    public static final String getRequestedRoleCode() {
        return requestedRoleCode;
    }

    @NotNull
    public static final String getAuthorizedRoleCode() {
        return authorizedRoleCode;
    }

    @NotNull
    public static final String getCustomRoleCode() {
        return customRoleCode;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionContextType.values().length];
            try {
                nArray[PermissionContextType.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.CHANNEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.PROFILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.TEAM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.DOCUMENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.DOCUMENT_FOLDER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionContextType.PACKAGE_REPOSITORY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

