/*
 * Decompiled with CFR 0.152.
 */
package circlet.packages.api;

import circlet.client.api.ProjectIdentifier;
import circlet.client.api.packages.DryCleanupResults;
import circlet.client.api.packages.ES_PackageRepositorySettings;
import circlet.client.api.packages.PackageData;
import circlet.client.api.packages.PackageMetadata;
import circlet.client.api.packages.PackageRepositoryConnection;
import circlet.client.api.packages.PackageRepositoryIdentifier;
import circlet.client.api.packages.PackageRepositoryMode;
import circlet.client.api.packages.PackageRepositoryStats;
import circlet.client.api.packages.PackageStats;
import circlet.client.api.packages.PackageType;
import circlet.client.api.packages.PackageVersionData;
import circlet.client.api.packages.PackageVersionDetails;
import circlet.client.api.packages.PackagesAccess;
import circlet.client.api.packages.PackagesExecutionResult;
import circlet.client.api.packages.PackagesFilters;
import circlet.client.api.packages.PackagesFlags;
import circlet.client.api.packages.PackagesPublishing;
import circlet.client.api.packages.PackagesSortColumn;
import circlet.client.api.packages.ProjectPackageRepository;
import circlet.client.api.packages.PublishingSource;
import circlet.client.api.packages.RetentionPolicyParams;
import circlet.client.api.packages.UpdatePackageRepositoryAccessIn;
import circlet.client.api.packages.VulnerabilityResponse;
import circlet.common.permissions.AdminRepository;
import circlet.common.permissions.CreateRepository;
import circlet.common.permissions.DeletePackages;
import circlet.common.permissions.ReadRepository;
import circlet.common.permissions.WritePackages;
import circlet.packages.api.HttpPackageName;
import circlet.packages.api.HttpPackageRepositoryConnection;
import circlet.packages.api.HttpPackageType;
import circlet.packages.api.HttpPackageVersion;
import circlet.packages.api.PackageNotification;
import circlet.packages.api.events.PackagesRepositoryClientEvent;
import circlet.platform.api.Api;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.Ref;
import circlet.platform.api.annotations.DefaultParameterValues;
import circlet.platform.api.annotations.Http;
import circlet.platform.api.annotations.HttpApi;
import circlet.platform.api.annotations.HttpApiDeprecated;
import circlet.platform.api.annotations.HttpApiDoc;
import circlet.platform.api.annotations.Rest;
import circlet.platform.api.annotations.Rights;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.channels.ReceiveChannel;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.ApiFlagAnnotation;
import runtime.batch.Batch;
import runtime.batch.BatchInfo;
import runtime.x.ColumnSortOrder;

@HttpApi(resource="projects/{project}/packages")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\bg\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ3\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0010\u001a\u00020\u0003H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J+\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016Ji\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J+\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J5\u0010%\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u00032\b\b\u0001\u0010&\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J9\u0010(\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J!\u0010+\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J-\u0010-\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010.\u001a\u00060\u0003j\u0002`\u0004H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J-\u0010/\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u00100\u001a\u00060\u0003j\u0002`\u0004H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J)\u00101\u001a\u0002022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00103\u001a\u00020\u0015H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J/\u00104\u001a\b\u0012\u0004\u0012\u0002050\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0003H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J=\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r072\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0018\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J=\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\b\u0001\u0010.\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010<\u001a\u00020=H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J%\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r072\u0006\u0010\u0005\u001a\u00020\u0006H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J/\u0010A\u001a\b\u0012\u0004\u0012\u00020B0:2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010<\u001a\u00020=H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ)\u0010D\u001a\n\u0018\u00010Ej\u0004\u0018\u0001`F2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J1\u0010G\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0003H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J7\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u00032\b\b\u0001\u0010&\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J;\u0010J\u001a\u0004\u0018\u00010I2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J-\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J1\u0010M\u001a\u00020N2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010O\u001a\u00020PH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QJ)\u0010R\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J'\u0010S\u001a\b\u0012\u0004\u0012\u00020\n072\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J!\u0010T\u001a\u00020U2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J!\u0010V\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u001f\u0010W\u001a\b\u0012\u0004\u0012\u00020X072\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J1\u0010Y\u001a\u00020Z2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u0003H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'Ji\u0010\\\u001a\b\u0012\u0004\u0012\u00020B0:2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\n\b\u0003\u0010.\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010]\u001a\u0004\u0018\u00010\u001b2\u0006\u0010<\u001a\u00020=2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJW\u0010c\u001a\b\u0012\u0004\u0012\u00020B0:2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u0010<\u001a\u00020=2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010dJC\u0010e\u001a\b\u0012\u0004\u0012\u00020f0:2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00108\u001a\u00020\u00032\n\b\u0003\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010<\u001a\u00020=H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010gJ?\u0010h\u001a\b\u0012\u0004\u0012\u00020f0:2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u0010<\u001a\u00020=H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ;\u0010j\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\b\u0001\u0010.\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010k\u001a\u00020lH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010mJ!\u0010n\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J!\u0010o\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J3\u0010p\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010q\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u000407H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010rJ=\u0010s\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u00032\u0010\b\u0001\u0010.\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'JG\u0010t\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010#\u001a\u00020\u00032\b\b\u0001\u0010&\u001a\u00020\u00032\u0006\u0010u\u001a\u00020\u001b2\b\u0010v\u001a\u0004\u0018\u00010\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010wJ!\u0010x\u001a\u00020y2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,JE\u0010z\u001a\b\u0012\u0004\u0012\u00020B0:2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0018\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\n\b\u0003\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010<\u001a\u00020=H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ0\u0010{\u001a\b\u0012\u0004\u0012\u00020}0|2\u0006\u0010~\u001a\u00020\u007f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0080\u0001J*\u0010\u0081\u0001\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJI\u0010\u0082\u0001\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u00100\u001a\u00060\u0003j\u0002`\u00042\u000b\b\u0002\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u001b2\u000b\b\u0002\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u001bH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0085\u0001J`\u0010\u0086\u0001\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000b\b\u0002\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0088\u0001J6\u0010\u0089\u0001\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020\u001bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008d\u0001J*\u0010\u008e\u0001\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u008f\u0001"}, d2={"Lcirclet/packages/api/ProjectPackages;", "Lcirclet/platform/api/Api;", "addRepositoryConnection", "", "Lcirclet/platform/api/TID;", "project", "Lcirclet/client/api/ProjectIdentifier;", "repository", "Lcirclet/client/api/packages/PackageRepositoryIdentifier;", "connection", "Lcirclet/client/api/packages/PackageRepositoryConnection;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Lcirclet/client/api/packages/PackageRepositoryConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attachRepositoryToProject", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/packages/ProjectPackageRepository;", "repositoryId", "name", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanupRepository", "Lcirclet/client/api/packages/PackagesExecutionResult;", "retentionPolicyParams", "Lcirclet/client/api/packages/RetentionPolicyParams;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Lcirclet/client/api/packages/RetentionPolicyParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRepository", "type", "description", "public", "", "settings", "Lcirclet/client/api/packages/ES_PackageRepositorySettings;", "mode", "Lcirclet/client/api/packages/PackageRepositoryMode;", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcirclet/client/api/packages/ES_PackageRepositorySettings;Lcirclet/client/api/packages/PackageRepositoryMode;Lcirclet/client/api/packages/PackageRepositoryConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deletePackage", "", "packageName", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deletePackageVersion", "packageVersion", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deletePackageVersionByName", "repositoryName", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteRepository", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteRepositoryConnection", "connectionId", "disableNotifications", "notificationId", "dryCleanupRepository", "Lcirclet/client/api/packages/DryCleanupResults;", "retentionParams", "enableNotifications", "Lcirclet/packages/api/PackageNotification;", "findRepositories", "", "query", "getConnectionPublishing", "Lruntime/batch/Batch;", "Lcirclet/client/api/packages/PackagesPublishing;", "batchInfo", "Lruntime/batch/BatchInfo;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Lruntime/batch/BatchInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFavoriteRepositories", "(Lcirclet/client/api/ProjectIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLatestPackages", "Lcirclet/client/api/packages/PackageVersionData;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Lruntime/batch/BatchInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNextCleanupDateTime", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "getNotifications", "getPackageDetails", "Lcirclet/client/api/packages/PackageVersionDetails;", "getPackageDetailsByName", "getPackageMetadata", "Lcirclet/client/api/packages/PackageMetadata;", "getPackageStats", "Lcirclet/client/api/packages/PackageStats;", "filters", "Lcirclet/client/api/packages/PackagesFilters;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Lcirclet/client/api/packages/PackagesFilters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRepository", "getRepositoryConnections", "getRepositoryStats", "Lcirclet/client/api/packages/PackageRepositoryStats;", "getRepositoryUrl", "getTypes", "Lcirclet/client/api/packages/PackageType;", "getVulnerabilities", "Lcirclet/client/api/packages/VulnerabilityResponse;", "version", "listPackageVersions", "pinned", "sortColumn", "Lcirclet/client/api/packages/PackagesSortColumn;", "sortOrder", "Lruntime/x/ColumnSortOrder;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lruntime/batch/BatchInfo;Lcirclet/client/api/packages/PackagesSortColumn;Lruntime/x/ColumnSortOrder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listPackageVersionsByName", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lruntime/batch/BatchInfo;Lcirclet/client/api/packages/PackagesSortColumn;Lruntime/x/ColumnSortOrder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listPackages", "Lcirclet/client/api/packages/PackageData;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Ljava/lang/String;Lruntime/batch/BatchInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listPackagesByName", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lruntime/batch/BatchInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishPackageVersionToConnection", "source", "Lcirclet/client/api/packages/PublishingSource;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Lcirclet/client/api/packages/PublishingSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reIndex", "removeRepository", "reorderRepositoryConnections", "connectionsOrder", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportPackageMetadata", "reportPackageVersionMetadata", "pin", "comment", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "repositoryOwnAccess", "Lcirclet/client/api/packages/PackagesAccess;", "searchPackages", "subscribeOnPackageEvents", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lcirclet/packages/api/events/PackagesRepositoryClientEvent;", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "(Llibraries/coroutines/extra/LifetimeSource;Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "testRepositoryConnection", "updateNotifications", "stable", "vulnerabilities", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateRepository", "cleanupEnabled", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lcirclet/client/api/packages/ES_PackageRepositorySettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateRepositoryAccess", "accessChange", "Lcirclet/client/api/packages/UpdatePackageRepositoryAccessIn;", "silent", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/packages/PackageRepositoryIdentifier;Lcirclet/client/api/packages/UpdatePackageRepositoryAccessIn;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateRepositoryConnection", "packages-api"})
public interface ProjectPackages
extends Api {
    @HttpApiDoc(doc="Returns a list of available repository types.")
    @Rest.Query(path="types")
    @DefaultParameterValues(params={})
    @Nullable
    public Object getTypes(@NotNull ProjectIdentifier var1, @NotNull Continuation<? super List<? extends PackageType>> var2);

    @Rest.Create(path="repositories", displayName="Create new repository")
    @HttpApiDoc(doc="Creates a new package repository for a given project ID")
    @Rights(rights={CreateRepository.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="description", defaultValue="null"), @DefaultParameterValues.Param(name="public", defaultValue="false"), @DefaultParameterValues.Param(name="settings", defaultValue="null"), @DefaultParameterValues.Param(name="mode", defaultValue="HOSTING"), @DefaultParameterValues.Param(name="connection", defaultValue="null")})
    @Nullable
    public Object createRepository(@NotNull ProjectIdentifier var1, @HttpPackageType @NotNull String var2, @NotNull String var3, @Nullable String var4, boolean var5, @Nullable ES_PackageRepositorySettings var6, @NotNull PackageRepositoryMode var7, @Nullable PackageRepositoryConnection var8, @NotNull Continuation<? super Ref<ProjectPackageRepository>> var9);

    @Nullable
    public Object attachRepositoryToProject(@NotNull ProjectIdentifier var1, @NotNull String var2, @NotNull String var3, @NotNull Continuation<? super Ref<ProjectPackageRepository>> var4);

    @Nullable
    public Object subscribeOnPackageEvents(@NotNull LifetimeSource var1, @NotNull ProjectIdentifier var2, @NotNull PackageRepositoryIdentifier var3, @NotNull Continuation<? super ReceiveChannel<? extends PackagesRepositoryClientEvent>> var4);

    @Rest.Query(path="repositories/{repository}", displayName="Get repository")
    @HttpApiDoc(doc="Gets a package repository for a given project ID by type and name")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getRepository(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super Ref<ProjectPackageRepository>> var3);

    @Rest.Query(path="repositories", displayName="Get repositories")
    @HttpApiDoc(doc="Gets a list of package repositories for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="type", defaultValue="null"), @DefaultParameterValues.Param(name="query", defaultValue="null")})
    @Nullable
    public Object findRepositories(@NotNull ProjectIdentifier var1, @HttpPackageType @Nullable String var2, @Nullable String var3, @NotNull Continuation<? super List<Ref<ProjectPackageRepository>>> var4);

    @Rest.Update(path="repositories/{repository}", displayName="Update repository")
    @HttpApiDoc(doc="Updates package repository settings for a given project ID")
    @Rights(rights={AdminRepository.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="name", defaultValue="null"), @DefaultParameterValues.Param(name="description", defaultValue="null"), @DefaultParameterValues.Param(name="public", defaultValue="null"), @DefaultParameterValues.Param(name="cleanupEnabled", defaultValue="null"), @DefaultParameterValues.Param(name="settings", defaultValue="null")})
    @Nullable
    public Object updateRepository(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @Nullable String var3, @Nullable String var4, @Nullable Boolean var5, @Nullable Boolean var6, @Nullable ES_PackageRepositorySettings var7, @NotNull Continuation<? super Unit> var8);

    @Rest.Get(path="repositories/{repository}/access", displayName="Get repository own access")
    @HttpApiDoc(doc="Updates package repository settings for a given project ID")
    @ApiFlagAnnotation(cls=PackagesFlags.PackagesGranularPermissions.class)
    @Rights(rights={AdminRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object repositoryOwnAccess(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super PackagesAccess> var3);

    @Rest.Update(path="repositories/{repository}/access", displayName="Update repository own access")
    @HttpApiDoc(doc="Updates package repository settings for a given project ID")
    @Rights(rights={AdminRepository.class})
    @ApiFlagAnnotation(cls=PackagesFlags.PackagesGranularPermissions.class)
    @DefaultParameterValues(params={})
    @Nullable
    public Object updateRepositoryAccess(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull UpdatePackageRepositoryAccessIn var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @Rest.Delete(path="repositories/{repository}", displayName="Delete repository")
    @HttpApiDoc(doc="Removes package repository for a given project ID")
    @Rights(rights={AdminRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object removeRepository(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Create(path="repositories/{repository}/cleanup", displayName="Cleanup repository")
    @HttpApiDoc(doc="Cleanup specified package repository")
    @Rights(rights={AdminRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object cleanupRepository(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @Nullable RetentionPolicyParams var3, @NotNull Continuation<? super PackagesExecutionResult> var4);

    @Rest.Create(path="repositories/{repository}/cleanup/dry", displayName="Dry run repository cleanup")
    @HttpApiDoc(doc="Dry run of cleanup for specified package repository")
    @Rights(rights={AdminRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object dryCleanupRepository(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull RetentionPolicyParams var3, @NotNull Continuation<? super DryCleanupResults> var4);

    @Nullable
    public Object getNextCleanupDateTime(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super KotlinXDateTime> var3);

    @Nullable
    public Object deleteRepository(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    public Object addRepositoryConnection(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull PackageRepositoryConnection var3, @NotNull Continuation<? super String> var4);

    @Rest.Query(path="repositories/{repository}/connections", displayName="Get all remote repositories")
    @HttpApiDoc(doc="Gets a list of remote package repositories for given project")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getRepositoryConnections(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super List<? extends PackageRepositoryConnection>> var3);

    @Nullable
    public Object updateRepositoryConnection(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull PackageRepositoryConnection var3, @NotNull Continuation<? super Unit> var4);

    @Nullable
    public Object reorderRepositoryConnections(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull List<String> var3, @NotNull Continuation<? super Unit> var4);

    @Nullable
    public Object testRepositoryConnection(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull PackageRepositoryConnection var3, @NotNull Continuation<? super PackagesExecutionResult> var4);

    @Rest.Create(path="repositories/{repository}/connections/{connectionId}/publish", displayName="Publish packages to remote repository")
    @HttpApiDoc(doc="Publishes packages to remote repository")
    @Rights(rights={WritePackages.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object publishPackageVersionToConnection(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageRepositoryConnection @NotNull String var3, @NotNull PublishingSource var4, @NotNull Continuation<? super String> var5);

    @Rest.Query(path="repositories/{repository}/connections/{connectionId}/publish", displayName="Get list of publishing to remote repository")
    @HttpApiDoc(doc="Get list of publishing to remote repository")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getConnectionPublishing(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageRepositoryConnection @NotNull String var3, @NotNull BatchInfo var4, @NotNull Continuation<? super Batch<PackagesPublishing>> var5);

    @Nullable
    public Object deleteRepositoryConnection(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @NotNull Continuation<? super Unit> var4);

    @Nullable
    public Object getFavoriteRepositories(@NotNull ProjectIdentifier var1, @NotNull Continuation<? super List<Ref<ProjectPackageRepository>>> var2);

    @Rest.Query(path="repositories/{repository}/url", displayName="Get repository URL")
    @HttpApiDoc(doc="Gets a package repository URL for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getRepositoryUrl(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super String> var3);

    @Nullable
    public Object getRepositoryStats(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super PackageRepositoryStats> var3);

    @Nullable
    public Object reIndex(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Query(path="search", displayName="Find packages in repository")
    @HttpApiDoc(doc="Executes a package search for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="connectionId", defaultValue="null")})
    @Nullable
    public Object searchPackages(@NotNull ProjectIdentifier var1, @HttpPackageType @NotNull String var2, @NotNull String var3, @HttpPackageRepositoryConnection @Nullable String var4, @NotNull BatchInfo var5, @NotNull Continuation<? super Batch<PackageVersionData>> var6);

    @Nullable
    public Object getLatestPackages(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull BatchInfo var3, @NotNull Continuation<? super Batch<PackageVersionData>> var4);

    @HttpApiDeprecated(message="Use GET /projects/{project}/packages/repositories/{repository}/packages", since="2020-09-01", forRemoval=true)
    @Rest.Query(path="repositories/type:{type}/repository:{repositoryName}/packages", displayName="Get all packages")
    @HttpApiDoc(doc="Gets a list of repository packages for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object listPackagesByName(@NotNull ProjectIdentifier var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, @NotNull BatchInfo var5, @NotNull Continuation<? super Batch<PackageData>> var6);

    @Rest.Query(path="repositories/{repository}/packages", displayName="Get all packages")
    @HttpApiDoc(doc="Gets a list of repository packages for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="connectionId", defaultValue="null")})
    @Nullable
    public Object listPackages(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @HttpPackageRepositoryConnection @Nullable String var4, @NotNull BatchInfo var5, @NotNull Continuation<? super Batch<PackageData>> var6);

    @Nullable
    public Object getVulnerabilities(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @NotNull String var4, @NotNull Continuation<? super VulnerabilityResponse> var5);

    @HttpApiDeprecated(message="Use GET /projects/{project}/packages/repositories/{repository}/packages/name:{packageName}/versions", since="2020-09-01", forRemoval=true)
    @Rest.Query(path="repositories/type:{type}/repository:{repositoryName}/packages/name:{packageName}/versions", displayName="Get all package versions")
    @HttpApiDoc(doc="Gets a list of repository package versions for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object listPackageVersionsByName(@NotNull ProjectIdentifier var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, @NotNull String var5, @NotNull BatchInfo var6, @NotNull PackagesSortColumn var7, @NotNull ColumnSortOrder var8, @NotNull Continuation<? super Batch<PackageVersionData>> var9);

    @Rest.Query(path="repositories/{repository}/packages/name:{packageName}/versions", displayName="Get all package versions")
    @HttpApiDoc(doc="Gets a list of repository package versions for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="connectionId", defaultValue="null"), @DefaultParameterValues.Param(name="pinned", defaultValue="null")})
    @Nullable
    public Object listPackageVersions(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageName @NotNull String var3, @NotNull String var4, @HttpPackageRepositoryConnection @Nullable String var5, @Nullable Boolean var6, @NotNull BatchInfo var7, @NotNull PackagesSortColumn var8, @NotNull ColumnSortOrder var9, @NotNull Continuation<? super Batch<PackageVersionData>> var10);

    @Nullable
    public Object getPackageStats(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @NotNull PackagesFilters var4, @NotNull Continuation<? super PackageStats> var5);

    @HttpApiDeprecated(message="Use GET /projects/{project}/packages/repositories/{repository}/packages/name:{packageName}/versions/version:{packageVersion}", since="2020-09-01", forRemoval=true)
    @Rest.Query(path="repositories/type:{type}/repository:{repositoryName}/packages/name:{packageName}/versions/version:{packageVersion}", displayName="Get package version details")
    @HttpApiDoc(doc="Gets a details for repository package version for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getPackageDetailsByName(@NotNull ProjectIdentifier var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, @NotNull String var5, @NotNull Continuation<? super PackageVersionDetails> var6);

    @Rest.Query(path="repositories/{repository}/packages/name:{packageName}/versions/version:{packageVersion}", displayName="Get package version details")
    @HttpApiDoc(doc="Gets a details for repository package version for a given project ID")
    @Rights(rights={ReadRepository.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getPackageDetails(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageName @NotNull String var3, @HttpPackageVersion @NotNull String var4, @NotNull Continuation<? super PackageVersionDetails> var5);

    @HttpApiDeprecated(message="Use DELETE /projects/{project}/packages/repositories/{repository}/packages/name:{packageName}/versions/version:{packageVersion}", since="2020-09-01", forRemoval=true)
    @Http.Delete(path="repositories/type:{type}/repository:{repositoryName}/packages/name:{packageName}/versions/version:{packageVersion}", displayName="Delete package version")
    @HttpApiDoc(doc="Removes a package version in repository for a given project ID")
    @Rights(rights={DeletePackages.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object deletePackageVersionByName(@NotNull ProjectIdentifier var1, @NotNull String var2, @NotNull String var3, @NotNull String var4, @NotNull String var5, @NotNull Continuation<? super Unit> var6);

    @Http.Delete(path="repositories/{repository}/packages/name:{packageName}/versions/version:{packageVersion}", displayName="Delete package version")
    @HttpApiDoc(doc="Removes a package version in repository for a given project ID")
    @Rights(rights={DeletePackages.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object deletePackageVersion(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageName @NotNull String var3, @HttpPackageVersion @NotNull String var4, @NotNull Continuation<? super Unit> var5);

    @Http.Get(path="repositories/{repository}/packages/name:{packageName}/metadata", displayName="Get package metadata")
    @HttpApiDoc(doc="Get package metadata in repository for a given project ID")
    @DefaultParameterValues(params={})
    @Nullable
    public Object getPackageMetadata(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageName @NotNull String var3, @NotNull Continuation<? super PackageMetadata> var4);

    @Http.Put(path="repositories/{repository}/packages/name:{packageName}/metadata", displayName="Report package  metadata")
    @HttpApiDoc(doc="Update a package metadata in repository for a given project ID")
    @DefaultParameterValues(params={})
    @Nullable
    public Object reportPackageMetadata(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageName @NotNull String var3, @HttpPackageRepositoryConnection @Nullable String var4, @NotNull Continuation<? super Unit> var5);

    @Http.Delete(path="repositories/{repository}/packages/name:{packageName}", displayName="Delete package")
    @HttpApiDoc(doc="Removes all package versions in repository for a given project ID")
    @Rights(rights={DeletePackages.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object deletePackage(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageName @NotNull String var3, @NotNull Continuation<? super Unit> var4);

    @Http.Put(path="repositories/{repository}/packages/name:{packageName}/metadata/version:{packageVersion}", displayName="Report package version metadata")
    @HttpApiDoc(doc="Report a package version metadata in repository for a given project ID")
    @DefaultParameterValues(params={})
    @Nullable
    public Object reportPackageVersionMetadata(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @HttpPackageName @NotNull String var3, @HttpPackageVersion @NotNull String var4, boolean var5, @Nullable String var6, @NotNull Continuation<? super Unit> var7);

    @Nullable
    public Object enableNotifications(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @NotNull Continuation<? super Ref<PackageNotification>> var4);

    @Nullable
    public Object getNotifications(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @NotNull Continuation<? super Ref<PackageNotification>> var4);

    @Nullable
    public Object updateNotifications(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @Nullable Boolean var4, @Nullable Boolean var5, @NotNull Continuation<? super Unit> var6);

    @Nullable
    public Object disableNotifications(@NotNull ProjectIdentifier var1, @NotNull PackageRepositoryIdentifier var2, @NotNull String var3, @NotNull Continuation<? super Unit> var4);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Object createRepository$default(ProjectPackages projectPackages, ProjectIdentifier projectIdentifier2, String string2, String string3, String string4, boolean bl, ES_PackageRepositorySettings eS_PackageRepositorySettings, PackageRepositoryMode packageRepositoryMode, PackageRepositoryConnection packageRepositoryConnection, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createRepository");
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                eS_PackageRepositorySettings = null;
            }
            if ((n & 0x40) != 0) {
                packageRepositoryMode = PackageRepositoryMode.HOSTING;
            }
            if ((n & 0x80) != 0) {
                packageRepositoryConnection = null;
            }
            return projectPackages.createRepository(projectIdentifier2, string2, string3, string4, bl, eS_PackageRepositorySettings, packageRepositoryMode, packageRepositoryConnection, (Continuation<? super Ref<ProjectPackageRepository>>)continuation);
        }

        public static /* synthetic */ Object findRepositories$default(ProjectPackages projectPackages, ProjectIdentifier projectIdentifier2, String string2, String string3, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findRepositories");
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            return projectPackages.findRepositories(projectIdentifier2, string2, string3, (Continuation<? super List<Ref<ProjectPackageRepository>>>)continuation);
        }

        public static /* synthetic */ Object updateRepository$default(ProjectPackages projectPackages, ProjectIdentifier projectIdentifier2, PackageRepositoryIdentifier packageRepositoryIdentifier, String string2, String string3, Boolean bl, Boolean bl2, ES_PackageRepositorySettings eS_PackageRepositorySettings, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateRepository");
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            if ((n & 0x20) != 0) {
                bl2 = null;
            }
            if ((n & 0x40) != 0) {
                eS_PackageRepositorySettings = null;
            }
            return projectPackages.updateRepository(projectIdentifier2, packageRepositoryIdentifier, string2, string3, bl, bl2, eS_PackageRepositorySettings, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object searchPackages$default(ProjectPackages projectPackages, ProjectIdentifier projectIdentifier2, String string2, String string3, String string4, BatchInfo batchInfo, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: searchPackages");
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            return projectPackages.searchPackages(projectIdentifier2, string2, string3, string4, batchInfo, (Continuation<? super Batch<PackageVersionData>>)continuation);
        }

        public static /* synthetic */ Object listPackages$default(ProjectPackages projectPackages, ProjectIdentifier projectIdentifier2, PackageRepositoryIdentifier packageRepositoryIdentifier, String string2, String string3, BatchInfo batchInfo, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: listPackages");
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            return projectPackages.listPackages(projectIdentifier2, packageRepositoryIdentifier, string2, string3, batchInfo, (Continuation<? super Batch<PackageData>>)continuation);
        }

        public static /* synthetic */ Object listPackageVersions$default(ProjectPackages projectPackages, ProjectIdentifier projectIdentifier2, PackageRepositoryIdentifier packageRepositoryIdentifier, String string2, String string3, String string4, Boolean bl, BatchInfo batchInfo, PackagesSortColumn packagesSortColumn, ColumnSortOrder columnSortOrder, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: listPackageVersions");
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            if ((n & 0x20) != 0) {
                bl = null;
            }
            return projectPackages.listPackageVersions(projectIdentifier2, packageRepositoryIdentifier, string2, string3, string4, bl, batchInfo, packagesSortColumn, columnSortOrder, (Continuation<? super Batch<PackageVersionData>>)continuation);
        }

        public static /* synthetic */ Object updateNotifications$default(ProjectPackages projectPackages, ProjectIdentifier projectIdentifier2, PackageRepositoryIdentifier packageRepositoryIdentifier, String string2, Boolean bl, Boolean bl2, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateNotifications");
            }
            if ((n & 8) != 0) {
                bl = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = null;
            }
            return projectPackages.updateNotifications(projectIdentifier2, packageRepositoryIdentifier, string2, bl, bl2, (Continuation<? super Unit>)continuation);
        }
    }
}

