/*
 * Decompiled with CFR 0.152.
 */
package circlet.planning;

import circlet.planning.SprintShortData;
import circlet.planning.ValidationUtilsKt;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004H\u0002\u001a8\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u001aR\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a8\u0006\u0010"}, d2={"validateRange", "", "from", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "to", "validateSprintRange", "sprints", "", "Lcirclet/planning/SprintShortData;", "validateSprintSettings", "name", "scheduledLaunchTime", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "currentSprints", "planning-api"})
@SourceDebugExtension(value={"SMAP\nValidationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidationUtils.kt\ncirclet/planning/ValidationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n288#2,2:73\n288#2:75\n289#2:77\n1855#2,2:78\n1#3:76\n*S KotlinDebug\n*F\n+ 1 ValidationUtils.kt\ncirclet/planning/ValidationUtilsKt\n*L\n26#1:73,2\n33#1:75\n33#1:77\n51#1:78,2\n*E\n"})
public final class ValidationUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String validateSprintSettings(@Nullable String name2, @Nullable KotlinXDate from, @Nullable KotlinXDate to, @Nullable KotlinXDateTime scheduledLaunchTime, @Nullable List<SprintShortData> currentSprints) {
        SprintShortData existingSprint;
        SprintShortData sprintShortData;
        String string2 = name2;
        String trimmedName = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
        CharSequence charSequence = trimmedName;
        if (charSequence == null || charSequence.length() == 0) {
            return "Please enter a value";
        }
        if (trimmedName.length() < 2) {
            return "Please enter at least 2 characters";
        }
        List<SprintShortData> list2 = currentSprints;
        if (list2 != null) {
            Object v2;
            block11: {
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SprintShortData it = (SprintShortData)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)trimmedName)) continue;
                    v2 = element$iv;
                    break block11;
                }
                v2 = null;
            }
            sprintShortData = v2;
        } else {
            sprintShortData = existingSprint = null;
        }
        if (existingSprint != null) {
            return "This issue board already has a sprint named \"" + trimmedName + "\". Please choose another name.";
        }
        if (scheduledLaunchTime != null) {
            SprintShortData sameTimeLaunchingSprint;
            SprintShortData sprintShortData2;
            ClosedRange launchFreeRange = RangesKt.rangeTo((Comparable)ADateJvmKt.plusHours(scheduledLaunchTime, -1), (Comparable)ADateJvmKt.plusHours(scheduledLaunchTime, 1));
            if (currentSprints != null) {
                Object v5;
                block12: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = currentSprints;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SprintShortData it = (SprintShortData)element$iv;
                        boolean bl = false;
                        KotlinXDateTime time = it.getScheduledLaunchTime();
                        boolean bl2 = false;
                        boolean bl3 = time != null && launchFreeRange.contains((Comparable)time);
                        if (!bl3) continue;
                        v5 = element$iv;
                        break block12;
                    }
                    v5 = null;
                }
                sprintShortData2 = v5;
            } else {
                sprintShortData2 = sameTimeLaunchingSprint = null;
            }
            if (sameTimeLaunchingSprint != null) {
                return "This issue board already has sprint " + sameTimeLaunchingSprint.getName() + " scheduled to launch at about the same time";
            }
        }
        return ValidationUtilsKt.validateSprintRange(from, to, currentSprints);
    }

    @Nullable
    public static final String validateSprintRange(@Nullable KotlinXDate from, @Nullable KotlinXDate to, @Nullable List<SprintShortData> sprints2) {
        Object object;
        KotlinXDate kotlinXDate = from;
        if (kotlinXDate == null) {
            return "Please select a start date";
        }
        KotlinXDate startDate = kotlinXDate;
        KotlinXDate kotlinXDate2 = to;
        if (kotlinXDate2 == null) {
            return "Please select an end date";
        }
        KotlinXDate endDate = kotlinXDate2;
        String defValidation = ValidationUtilsKt.validateRange(startDate, endDate);
        if (defValidation != null) {
            object = defValidation;
        } else {
            List conflictedSprints = new ArrayList();
            List<SprintShortData> list2 = sprints2;
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SprintShortData it = (SprintShortData)element$iv;
                    boolean bl = false;
                    KotlinXDate from2 = it.getFrom();
                    KotlinXDate to2 = it.getTo();
                    if (from2 == null || to2 == null || !(startDate.compareTo(from2) >= 0 && startDate.compareTo(to2) <= 0 || endDate.compareTo(from2) >= 0 && endDate.compareTo(to2) <= 0) && (startDate.compareTo(from2) >= 0 || endDate.compareTo(to2) <= 0)) continue;
                    conflictedSprints.add(it);
                }
            }
            object = CollectionsKt.any((Iterable)conflictedSprints) ? "The selected date range conflicts with the sprint schedule for: " + CollectionsKt.joinToString$default((Iterable)conflictedSprints, null, null, null, (int)0, null, (Function1)validateSprintRange.2.INSTANCE, (int)31, null) : null;
        }
        return object;
    }

    private static final String validateRange(KotlinXDate from, KotlinXDate to) {
        return from.compareTo(to) > 0 ? "start date must be before end date" : null;
    }
}

