/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;

public class IntervalDeserializer
extends JodaDateDeserializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public IntervalDeserializer(JacksonJodaDateFormat format2) {
        super(Interval.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new IntervalDeserializer(format2);
    }

    public Interval deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p2, ctxt, p2.getText());
        }
        if (p2.isExpectedStartObjectToken()) {
            return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, (JsonDeserializer)this, this.handledType()));
        }
        return (Interval)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2.currentToken(), p2, "expected JSON String", new Object[0]);
    }

    protected Interval _fromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        DateTimeZone tz;
        Interval result2;
        boolean hasSlash;
        if ((value2 = value2.trim()).isEmpty()) {
            return (Interval)this._fromEmptyString(p2, ctxt, value2);
        }
        int index2 = value2.indexOf(47, 1);
        boolean bl = hasSlash = index2 > 0;
        if (!hasSlash) {
            index2 = value2.indexOf(45, 1);
        }
        if (index2 < 0) {
            throw ctxt.weirdStringException(value2, this.handledType(), "no slash or hyphen found to separate start, end");
        }
        String str = value2.substring(0, index2);
        try {
            if (hasSlash) {
                result2 = Interval.parseWithOffset(value2);
            } else {
                long start2 = Long.valueOf(str);
                str = value2.substring(index2 + 1);
                long end = Long.valueOf(str);
                result2 = new Interval(start2, end);
            }
        }
        catch (NumberFormatException e) {
            return (Interval)ctxt.handleWeirdStringValue(this.handledType(), str, "Failed to parse number from '%s' (full source String '%s')", new Object[]{str, value2});
        }
        DateTimeZone contextTimezone = this._format.shouldAdjustToContextTimeZone(ctxt) ? DateTimeZone.forTimeZone(ctxt.getTimeZone()) : null;
        DateTimeZone dateTimeZone = tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : contextTimezone;
        if (tz != null && !tz.equals(result2.getStart().getZone())) {
            result2 = new Interval(result2.getStartMillis(), result2.getEndMillis(), tz);
        }
        return result2;
    }
}

