/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.components;

import circlet.platform.api.PrimitivesExKt;
import circlet.workspaces.Workspace;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.space.components.SpaceInactivityDetectorKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u000b\u001a\u00020\u0004*\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/space/components/SpaceInactivityDetector;", "", "()V", "reconnectWorkspaceAfterInactivity", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "workspace", "Lcirclet/workspaces/Workspace;", "reconnectWorkspaceOnIDEOpen", "reconnectWorkspaceOnSleep", "reconnect", "intellij.space"})
@SourceDebugExtension(value={"SMAP\nSpaceInactivityDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceInactivityDetector.kt\ncom/intellij/space/components/SpaceInactivityDetector\n+ 2 LifetimeUtils.kt\nlibraries/coroutines/extra/LifetimeUtilsKt\n*L\n1#1,60:1\n199#2:61\n226#2,5:62\n*S KotlinDebug\n*F\n+ 1 SpaceInactivityDetector.kt\ncom/intellij/space/components/SpaceInactivityDetector\n*L\n56#1:61\n56#1:62,5\n*E\n"})
public final class SpaceInactivityDetector {
    @NotNull
    public static final SpaceInactivityDetector INSTANCE = new SpaceInactivityDetector();

    private SpaceInactivityDetector() {
    }

    public final void reconnectWorkspaceAfterInactivity(@NotNull CoroutineScope coroutineScope2, @NotNull Workspace workspace2) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope2, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)workspace2, (String)"workspace");
        this.reconnectWorkspaceOnSleep(coroutineScope2, workspace2);
        this.reconnectWorkspaceOnIDEOpen(coroutineScope2, workspace2);
    }

    private final void reconnectWorkspaceOnIDEOpen(CoroutineScope coroutineScope2, Workspace workspace2) {
        Ref.LongRef lastVisible = new Ref.LongRef();
        lastVisible.element = PrimitivesExKt.getNowMs();
        long reconnectAfterMs = Duration.ofMinutes(10L).toMillis();
        SimpleMessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect(coroutineScope2);
        Topic topic = ApplicationActivationListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        appConnection.subscribe(topic, (Object)new ApplicationActivationListener(lastVisible, reconnectAfterMs, workspace2){
            final /* synthetic */ Ref.LongRef $lastVisible;
            final /* synthetic */ long $reconnectAfterMs;
            final /* synthetic */ Workspace $workspace;
            {
                this.$lastVisible = $lastVisible;
                this.$reconnectAfterMs = $reconnectAfterMs;
                this.$workspace = $workspace;
            }

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                if (PrimitivesExKt.getNowMs() - this.$lastVisible.element > this.$reconnectAfterMs) {
                    SpaceInactivityDetector.access$reconnect(SpaceInactivityDetector.INSTANCE, this.$workspace);
                    SpaceInactivityDetectorKt.access$getLOG$p().info("Reconnecting to workspace because of inactivity");
                }
            }

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                this.$lastVisible.element = PrimitivesExKt.getNowMs();
            }
        });
    }

    private final void reconnectWorkspaceOnSleep(CoroutineScope coroutineScope2, Workspace workspace2) {
        Ref.LongRef currentTime = new Ref.LongRef();
        BuildersKt.launch$default((CoroutineScope)coroutineScope2, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentTime, workspace2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ref.LongRef $currentTime;
            final /* synthetic */ Workspace $workspace;
            {
                this.$currentTime = $currentTime;
                this.$workspace = $workspace;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.$currentTime.element = PrimitivesExKt.getNowMs();
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)Duration.ofSeconds(20L).toMillis(), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl19
                        }
                        break;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (PrimitivesExKt.getNowMs() - this.$currentTime.element <= Duration.ofMinutes(1L).toMillis()) ** GOTO lbl6
                        SpaceInactivityDetector.access$reconnect(SpaceInactivityDetector.INSTANCE, this.$workspace);
                        SpaceInactivityDetectorKt.access$getLOG$p().info("Reconnecting to workspace because of computer hibernation");
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reconnect(Workspace $this$reconnect) {
        boolean $i$f$using = false;
        LifetimeSource $this$runAndTerminate$iv$iv = new LifetimeSource();
        boolean $i$f$runAndTerminate = false;
        try {
            Lifetime lt2 = $this$runAndTerminate$iv$iv;
            boolean bl = false;
            $this$reconnect.getClient().interruptConnection(lt2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeSource it$iv = $this$runAndTerminate$iv$iv;
            boolean bl = false;
            it$iv.terminate();
        }
    }

    public static final /* synthetic */ void access$reconnect(SpaceInactivityDetector $this, Workspace $receiver) {
        $this.reconnect($receiver);
    }
}

