/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.klogging.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.space.klogging.impl.ApplicationLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggerFactory;
import libraries.klogging.KLoggerStaticFactoryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bj\u0002`\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/space/klogging/impl/KLoggerFactoryIdea;", "Llibraries/klogging/KLoggerFactory;", "()V", "logger", "Llibraries/klogging/KLogger;", "owner", "", "name", "", "Lkotlin/reflect/KClass;", "nameSource", "Lkotlin/Function0;", "Llibraries/klogging/LoggerNameSource;", "wrapLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "wrapWithApplicationLogger", "Lcom/intellij/space/klogging/impl/ApplicationLogger;", "intellij.space"})
public final class KLoggerFactoryIdea
implements KLoggerFactory {
    @NotNull
    public static final KLoggerFactoryIdea INSTANCE = new KLoggerFactoryIdea();

    private KLoggerFactoryIdea() {
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull KClass<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Logger logger2 = Logger.getInstance((Class)JvmClassMappingKt.getJavaClass(owner));
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return this.wrapLogger(logger2);
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.logger(JvmClassMappingKt.getKotlinClass(owner.getClass()));
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Logger logger2 = Logger.getInstance((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return this.wrapLogger(logger2);
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Function0<String> nameSource) {
        Intrinsics.checkNotNullParameter(nameSource, (String)"nameSource");
        return this.logger(KLoggerStaticFactoryKt.loggerNameFromSource(nameSource));
    }

    private final KLogger wrapLogger(Logger logger2) {
        return new KLogger(this.wrapWithApplicationLogger(logger2));
    }

    private final ApplicationLogger wrapWithApplicationLogger(Logger logger2) {
        return new ApplicationLogger(logger2);
    }
}

