/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.settings;

import circlet.client.api.TeamDirectoryKt;
import circlet.workspaces.Workspace;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.space.components.SpaceUserAvatarProvider;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.settings.CloneType;
import com.intellij.space.settings.SpaceLoginState;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.settings.SpaceSettingsPanel;
import com.intellij.space.settings.SpaceSettingsPanelKt;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.ui.LoginComponents;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.ui.icons.SpaceMeIcon;
import com.intellij.space.ui.panel.SpaceComponentWrapper;
import com.intellij.space.utils.LifetimedDisposable;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import libraries.coroutines.extra.Lifetime;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.PropertyKt;
import runtime.reactive.SequentialLifetimes;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0001J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/space/settings/SpaceSettingsPanel;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/space/utils/LifetimedDisposable;", "()V", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "selectedCloneType", "Lruntime/reactive/MutableProperty;", "Lcom/intellij/space/settings/CloneType;", "sqLifetime", "Lruntime/reactive/SequentialLifetimes;", "createConfigureHttpAndSshLink", "Ljavax/swing/JComponent;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createView", "wrapper", "st", "Lcom/intellij/space/settings/SpaceLoginState;", "dispose", "", "getHelpTopic", "", "getId", "Companion", "intellij.space"})
public final class SpaceSettingsPanel
extends BoundConfigurable
implements SearchableConfigurable,
LifetimedDisposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ LifetimedDisposable $$delegate_0;
    @NotNull
    private final SequentialLifetimes sqLifetime;
    @NotNull
    private final MutableProperty<CloneType> selectedCloneType;

    public SpaceSettingsPanel() {
        String string2 = SpaceBundle.message("configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(string2, null);
        this.$$delegate_0 = com.intellij.space.utils.UtilitiesKt.LifetimedDisposable();
        this.sqLifetime = new SequentialLifetimes(this.getLifetime());
        this.selectedCloneType = PropertyKt.mutableProperty(SpaceSettings.Companion.getInstance().getCloneType());
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.$$delegate_0.getLifetime();
    }

    public void dispose() {
        this.$$delegate_0.dispose();
    }

    @NotNull
    public String getId() {
        return "settings.space";
    }

    @NotNull
    public String getHelpTopic() {
        return "Space";
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ SpaceSettingsPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Lifetime panelLifetime = SpaceSettingsPanel.access$getSqLifetime$p(this.this$0).next();
                SpaceComponentWrapper accountPanel = new SpaceComponentWrapper(null, null, 3, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(accountPanel){
                    final /* synthetic */ SpaceComponentWrapper $accountPanel;
                    {
                        this.$accountPanel = $accountPanel;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)((Object)this.$accountPanel)).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null);
                Row separatorRow = Panel.separator$default((Panel)$this$panel, null, (int)1, null);
                String string2 = SpaceBundle.message("settings.panel.clone.repositories.with.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                Row cloneTypeRow2 = $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ SpaceSettingsPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (Collection)ArraysKt.asList((Object[])CloneType.values()), null, (int)2, null), (com.intellij.ui.dsl.builder.MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(SpaceSettings.Companion.getInstance()){

                            @Nullable
                            public Object get() {
                                return ((SpaceSettings)this.receiver).getCloneType();
                            }

                            public void set(@Nullable Object value2) {
                                ((SpaceSettings)this.receiver).setCloneType((CloneType)((Object)value2));
                            }
                        }))).applyToComponent((Function1)new Function1<ComboBox<CloneType>, Unit>(this.this$0){
                            final /* synthetic */ SpaceSettingsPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ComboBox<CloneType> $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter($this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.addItemListener(arg_0 -> createPanel.cloneTypeRow.2.invoke$lambda$0(this.this$0, $this$applyToComponent, arg_0));
                            }

                            private static final void invoke$lambda$0(SpaceSettingsPanel this$0, ComboBox $this_applyToComponent, ItemEvent it) {
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)$this_applyToComponent, (String)"$this_applyToComponent");
                                MutableProperty mutableProperty2 = SpaceSettingsPanel.access$getSelectedCloneType$p(this$0);
                                Object object = $this_applyToComponent.getSelectedItem();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.space.settings.CloneType");
                                mutableProperty2.setValue((CloneType)((Object)object));
                            }
                        });
                        $this$row.cell(SpaceSettingsPanel.access$createConfigureHttpAndSshLink(this.this$0));
                    }
                });
                SpaceWorkspaceComponent.Companion.getInstance().getLoginState().forEach(panelLifetime, (Function1<SpaceLoginState, Unit>)((Function1)new Function1<SpaceLoginState, Unit>(accountPanel, this.this$0, separatorRow, cloneTypeRow2){
                    final /* synthetic */ SpaceComponentWrapper $accountPanel;
                    final /* synthetic */ SpaceSettingsPanel this$0;
                    final /* synthetic */ Row $separatorRow;
                    final /* synthetic */ Row $cloneTypeRow;
                    {
                        this.$accountPanel = $accountPanel;
                        this.this$0 = $receiver;
                        this.$separatorRow = $separatorRow;
                        this.$cloneTypeRow = $cloneTypeRow;
                        super(1);
                    }

                    public final void invoke(@NotNull SpaceLoginState loginState2) {
                        Intrinsics.checkNotNullParameter((Object)loginState2, (String)"loginState");
                        this.$accountPanel.setContent(SpaceSettingsPanel.access$createView(this.this$0, (JComponent)((Object)this.$accountPanel), loginState2));
                        boolean rowsVisibility = loginState2 instanceof SpaceLoginState.Connected;
                        this.$separatorRow.visible(rowsVisibility);
                        this.$cloneTypeRow.visible(rowsVisibility);
                    }
                }));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createView(JComponent wrapper2, SpaceLoginState st) {
        SpaceLoginState spaceLoginState = st;
        if (spaceLoginState instanceof SpaceLoginState.Disconnected) {
            return (JComponent)SpaceSettingsPanelKt.buildSettingsLoginPanel((SpaceLoginState.Disconnected)st, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, wrapper2){
                final /* synthetic */ SpaceSettingsPanel this$0;
                final /* synthetic */ JComponent $wrapper;
                {
                    this.this$0 = $receiver;
                    this.$wrapper = $wrapper;
                    super(1);
                }

                public final void invoke(@NotNull String server) {
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    SpaceWorkspaceComponent.Companion.getInstance().signInManually(server, this.this$0.getLifetime(), this.$wrapper);
                }
            }));
        }
        if (spaceLoginState instanceof SpaceLoginState.Connecting) {
            return (JComponent)LoginComponents.buildConnectingPanel$default(LoginComponents.INSTANCE, (SpaceLoginState.Connecting)st, SpaceStatsCounterCollector.LoginPlace.SETTINGS, null, (Function0)new Function0<Unit>(st){
                final /* synthetic */ SpaceLoginState $st;
                {
                    this.$st = $st;
                    super(0);
                }

                public final void invoke() {
                    ((SpaceLoginState.Connecting)this.$st).cancel();
                }
            }, 4, null);
        }
        if (spaceLoginState instanceof SpaceLoginState.Connected) {
            void $this$createView_u24lambda_u247_u24lambda_u246;
            MigLayout migLayout;
            JPanel jPanel;
            BorderLayoutPanel borderLayoutPanel;
            JLabel jLabel = new JLabel(UtilitiesKt.cleanupUrl(st.getServer()));
            JComponent $this$createView_u24lambda_u240 = jLabel;
            boolean bl = false;
            $this$createView_u24lambda_u240.setForeground(UIUtil.getContextHelpForeground());
            JLabel serverComponent = jLabel;
            JComponent $this$createView_u24lambda_u242 = $this$createView_u24lambda_u240 = new JButton(SpaceBundle.message("settings.panel.log.out.button.text", new Object[0]));
            boolean bl2 = false;
            ((AbstractButton)$this$createView_u24lambda_u242).addActionListener(SpaceSettingsPanel::createView$lambda$2$lambda$1);
            JComponent logoutButton = $this$createView_u24lambda_u240;
            JComponent $this$createView_u24lambda_u243 = $this$createView_u24lambda_u242 = new JPanel((LayoutManager)new VerticalLayout(4));
            boolean bl3 = false;
            $this$createView_u24lambda_u243.add(new JLabel(TeamDirectoryKt.englishFullName(((SpaceLoginState.Connected)st).getWorkspace().getMe().getValue())));
            $this$createView_u24lambda_u243.add(serverComponent);
            JComponent namePanel = $this$createView_u24lambda_u242;
            JComponent $this$createView_u24lambda_u245 = $this$createView_u24lambda_u243 = new JPanel((LayoutManager)new VerticalLayout(4));
            boolean bl4 = false;
            $this$createView_u24lambda_u245.add(namePanel);
            BorderLayoutPanel $this$createView_u24lambda_u245_u24lambda_u244 = borderLayoutPanel = new BorderLayoutPanel().addToLeft((Component)logoutButton);
            boolean $i$a$-apply-SpaceSettingsPanel$createView$infoPanel$1$logoutButtonPanel$22 = false;
            $this$createView_u24lambda_u245_u24lambda_u244.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"apply(...)");
            BorderLayoutPanel logoutButtonPanel = borderLayoutPanel2;
            $this$createView_u24lambda_u245.add((Component)logoutButtonPanel);
            JComponent infoPanel = $this$createView_u24lambda_u243;
            JLabel avatarLabel = new JLabel();
            SpaceUserAvatarProvider.Companion.getInstance().getAvatars().forEach(this.getLifetime(), (Function1<SpaceMeIcon, Unit>)((Function1)new Function1<SpaceMeIcon, Unit>(avatarLabel){
                final /* synthetic */ JLabel $avatarLabel;
                {
                    this.$avatarLabel = $avatarLabel;
                    super(1);
                }

                public final void invoke(@NotNull SpaceMeIcon avatars2) {
                    Intrinsics.checkNotNullParameter((Object)avatars2, (String)"avatars");
                    this.$avatarLabel.setIcon(UtilitiesKt.resizeIcon(avatars2.getCircle(), 64));
                }
            }));
            JPanel $this$createView_u24lambda_u247 = jPanel = new JPanel();
            boolean bl5 = false;
            MigLayout $i$a$-apply-SpaceSettingsPanel$createView$infoPanel$1$logoutButtonPanel$22 = migLayout = new MigLayout(new LC().gridGap("10", "0").insets("0", "0", "0", "0").fill());
            JPanel jPanel2 = $this$createView_u24lambda_u247;
            boolean bl6 = false;
            $this$createView_u24lambda_u247_u24lambda_u246.setColumnConstraints((Object)"[][]");
            jPanel2.setLayout((LayoutManager)migLayout);
            $this$createView_u24lambda_u247.add((Component)avatarLabel, new CC().pushY().alignY("center"));
            $this$createView_u24lambda_u247.add((Component)infoPanel, new CC().push());
            return jPanel;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final JComponent createConfigureHttpAndSshLink() {
        SpaceComponentWrapper contentPanel2 = new SpaceComponentWrapper(null, null, 3, null);
        SourceKt.view((Source)SpaceWorkspaceComponent.Companion.getInstance().getWorkspace(), this.getLifetime(), (Function2)new Function2<Lifetime, Workspace, Unit>(this, contentPanel2){
            final /* synthetic */ SpaceSettingsPanel this$0;
            final /* synthetic */ SpaceComponentWrapper $contentPanel;
            {
                this.this$0 = $receiver;
                this.$contentPanel = $contentPanel;
                super(2);
            }

            public final void invoke(@NotNull Lifetime wsLifetime, @Nullable Workspace workspace2) {
                Intrinsics.checkNotNullParameter((Object)wsLifetime, (String)"wsLifetime");
                if (workspace2 != null) {
                    SpaceSettingsPanel.access$getSelectedCloneType$p(this.this$0).forEach(wsLifetime, (Function1)new Function1<CloneType, Unit>(this.$contentPanel, workspace2){
                        final /* synthetic */ SpaceComponentWrapper $contentPanel;
                        final /* synthetic */ Workspace $workspace;
                        {
                            this.$contentPanel = $contentPanel;
                            this.$workspace = $workspace;
                            super(1);
                        }

                        public final void invoke(@NotNull CloneType cloneType) {
                            block2: {
                                Intrinsics.checkNotNullParameter((Object)((Object)cloneType), (String)"cloneType");
                                if (cloneType == CloneType.HTTPS) {
                                    this.$contentPanel.setContent(null);
                                } else {
                                    BrowserLink browserLink;
                                    String url2 = SpaceUrls.INSTANCE.git(this.$workspace.getMe().getValue().getUsername());
                                    String string2 = SpaceBundle.message("settings.panel.configure.git.ssh.keys.configure.link", new Object[0]);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                    BrowserLink $this$invoke_u24lambda_u241 = browserLink = new BrowserLink(string2, url2);
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u241.addActionListener(createConfigureHttpAndSshLink.1::invoke$lambda$1$lambda$0);
                                    BrowserLink browserLink2 = browserLink;
                                    this.$contentPanel.setContent((JComponent)browserLink2);
                                }
                                Container container2 = this.$contentPanel.getParent();
                                if (container2 == null) break block2;
                                container2.repaint();
                            }
                        }

                        private static final void invoke$lambda$1$lambda$0(ActionEvent it) {
                            SpaceStatsCounterCollector.OPEN_SSH_SETTINGS_IN_SPACE.log();
                        }
                    });
                } else {
                    this.$contentPanel.setContent(null);
                }
            }
        });
        return (JComponent)((Object)contentPanel2);
    }

    private static final void createView$lambda$2$lambda$1(ActionEvent it) {
        SpaceStatsCounterCollector.LOG_OUT.log((Object)SpaceStatsCounterCollector.LogoutPlace.SETTINGS);
        SpaceWorkspaceComponent.Companion.getInstance().signOut();
    }

    public static final /* synthetic */ SequentialLifetimes access$getSqLifetime$p(SpaceSettingsPanel $this) {
        return $this.sqLifetime;
    }

    public static final /* synthetic */ MutableProperty access$getSelectedCloneType$p(SpaceSettingsPanel $this) {
        return $this.selectedCloneType;
    }

    public static final /* synthetic */ JComponent access$createConfigureHttpAndSshLink(SpaceSettingsPanel $this) {
        return $this.createConfigureHttpAndSshLink();
    }

    public static final /* synthetic */ JComponent access$createView(SpaceSettingsPanel $this, JComponent wrapper2, SpaceLoginState st) {
        return $this.createView(wrapper2, st);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/settings/SpaceSettingsPanel$Companion;", "", "()V", "openSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.space"})
    public static final class Companion {
        private Companion() {
        }

        public final void openSettings(@Nullable Project project2) {
            ShowSettingsUtil.getInstance().showSettingsDialog(project2, SpaceSettingsPanel.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

