/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.changes;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewController;
import com.intellij.openapi.vcs.changes.DiffPreviewControllerImpl;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.ui.Scroll;
import com.intellij.space.utils.UtilitiesKt;
import com.intellij.space.vcs.changes.SpaceChange;
import com.intellij.space.vcs.changes.SpaceChangesTree;
import com.intellij.space.vcs.changes.SpaceChangesVm;
import com.intellij.space.vcs.changes.SpaceDiffFileProvider;
import com.intellij.space.vcs.changes.SpaceEditorDiffPreview;
import com.intellij.space.vcs.changes.SpaceVmHolder;
import com.intellij.space.vcs.editor.SpaceVirtualFilesManager;
import com.intellij.space.vcs.review.create.SpaceCreateCodeReviewCombinedDiffPreview;
import com.intellij.space.vcs.review.create.SpaceCreateCodeReviewVm;
import com.intellij.space.vcs.review.create.SpaceCreateMergeRequestCombinedDiffPreview;
import com.intellij.space.vcs.review.create.SpaceCreateMergeRequestVm;
import com.intellij.space.vcs.review.details.SpaceReviewDetailsCombinedDiffPreview;
import com.intellij.space.vcs.review.details.SpaceReviewDetailsVm;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.LoadingValue;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTreeComponent;", "", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "parentPanel", "Ljavax/swing/JComponent;", "vms", "Lcom/intellij/space/vcs/changes/SpaceVmHolder;", "changesVm", "Lcom/intellij/space/vcs/changes/SpaceChangesVm;", "spaceDiffFileProvider", "Lcom/intellij/space/vcs/changes/SpaceDiffFileProvider;", "statsPlace", "Lcom/intellij/space/stats/SpaceStatsCounterCollector$DiffPlace;", "(Llibraries/coroutines/extra/Lifetime;Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;Lcom/intellij/space/vcs/changes/SpaceVmHolder;Lcom/intellij/space/vcs/changes/SpaceChangesVm;Lcom/intellij/space/vcs/changes/SpaceDiffFileProvider;Lcom/intellij/space/stats/SpaceStatsCounterCollector$DiffPlace;)V", "_loaded", "Lruntime/reactive/MutableProperty;", "", "changesTree", "Lcom/intellij/space/vcs/changes/SpaceChangesTree;", "loaded", "Lruntime/reactive/Property;", "getLoaded", "()Lruntime/reactive/Property;", "view", "getView", "()Ljavax/swing/JComponent;", "createChangesBrowserToolbar", "Lcom/intellij/openapi/vcs/changes/ui/TreeActionsToolbarPanel;", "createCombinedDiffPreview", "Lcom/intellij/openapi/vcs/changes/actions/diff/CombinedDiffPreview;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceChangesTreeComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceChangesTreeComponent.kt\ncom/intellij/space/vcs/changes/SpaceChangesTreeComponent\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n30#2,3:128\n10#3:131\n*S KotlinDebug\n*F\n+ 1 SpaceChangesTreeComponent.kt\ncom/intellij/space/vcs/changes/SpaceChangesTreeComponent\n*L\n85#1:128,3\n124#1:131\n*E\n"})
public final class SpaceChangesTreeComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpaceChangesTree changesTree;
    @NotNull
    private final JComponent view;
    @NotNull
    private final MutableProperty<Boolean> _loaded;
    @NotNull
    private final Property<Boolean> loaded;
    @NotNull
    private static final Logger LOG;

    public SpaceChangesTreeComponent(@NotNull Lifetime lifetime, @NotNull Project project2, @NotNull JComponent parentPanel, @NotNull SpaceVmHolder vms, final @NotNull SpaceChangesVm changesVm2, @NotNull SpaceDiffFileProvider spaceDiffFileProvider, @NotNull SpaceStatsCounterCollector.DiffPlace statsPlace) {
        JBLoadingPanel jBLoadingPanel;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentPanel, (String)"parentPanel");
        Intrinsics.checkNotNullParameter((Object)vms, (String)"vms");
        Intrinsics.checkNotNullParameter((Object)changesVm2, (String)"changesVm");
        Intrinsics.checkNotNullParameter((Object)spaceDiffFileProvider, (String)"spaceDiffFileProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)statsPlace), (String)"statsPlace");
        this.changesTree = new SpaceChangesTree(project2);
        this._loaded = PropertyKt.mutableProperty(false);
        this.loaded = this._loaded;
        Disposable disposable = UtilitiesKt.nestedDisposable(lifetime);
        final JBLoadingPanel loadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposable, 300);
        SourceKt.view((Source)changesVm2.getSpaceChanges(), lifetime, (Function2)new Function2<Lifetime, LoadingValue<? extends List<? extends SpaceChange>>, Unit>(){

            public final void invoke(@NotNull Lifetime changesStateLifetime, @NotNull LoadingValue<? extends List<SpaceChange>> loadingChanges) {
                Intrinsics.checkNotNullParameter((Object)changesStateLifetime, (String)"changesStateLifetime");
                Intrinsics.checkNotNullParameter(loadingChanges, (String)"loadingChanges");
                _loaded.setValue(false);
                changesTree.setChanges(CollectionsKt.emptyList());
                LoadingValue<? extends List<SpaceChange>> loadingValue = loadingChanges;
                if (loadingValue instanceof LoadingValue.Loaded) {
                    loadingPane.stopLoading();
                    changesTree.setChanges((List)((LoadingValue.Loaded)loadingChanges).getValue());
                    changesTree.getSelection().forEach(changesStateLifetime, (Function1<ListSelection<SpaceChange>, Unit>)((Function1)new Function1<ListSelection<SpaceChange>, Unit>(){

                        public final void invoke(@NotNull ListSelection<SpaceChange> selection2) {
                            Intrinsics.checkNotNullParameter(selection2, (String)"selection");
                            if (!selection2.isEmpty()) {
                                changesVm2.setSelectedChanges(selection2);
                            }
                        }
                    }));
                    _loaded.setValue(true);
                } else if (Intrinsics.areEqual(loadingValue, (Object)LoadingValue.Loading.INSTANCE)) {
                    loadingPane.startLoading();
                    changesTree.setEmptyText("");
                } else if (loadingValue instanceof LoadingValue.Failure) {
                    loadingPane.stopLoading();
                    LOG.info("Could not load changes for selected commits", ((LoadingValue.Failure)loadingChanges).getError());
                    changesTree.setEmptyText(SpaceBundle.message("review.changes.browser.failure.text", new Object[0]));
                    _loaded.setValue(true);
                }
            }
        });
        changesVm2.getSelectedFilePath().forEach(lifetime, (Function1<FilePath, Unit>)((Function1)new Function1<FilePath, Unit>((Object)this.changesTree){

            public final void invoke(@Nullable FilePath p0) {
                ((SpaceChangesTree)((Object)this.receiver)).selectFile(p0);
            }
        }));
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<SpaceVirtualFilesManager> serviceClass$iv = SpaceVirtualFilesManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        SpaceVirtualFilesManager diffPreviewDisposable = (SpaceVirtualFilesManager)object;
        DiffPreviewControllerImpl editorDiffPreviewController2 = new DiffPreviewControllerImpl((Function0)new Function0<DiffPreview>(project2, this, spaceDiffFileProvider, statsPlace){
            final /* synthetic */ Project $project;
            final /* synthetic */ SpaceChangesTreeComponent this$0;
            final /* synthetic */ SpaceDiffFileProvider $spaceDiffFileProvider;
            final /* synthetic */ SpaceStatsCounterCollector.DiffPlace $statsPlace;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$spaceDiffFileProvider = $spaceDiffFileProvider;
                this.$statsPlace = $statsPlace;
                super(0);
            }

            @NotNull
            public final DiffPreview invoke() {
                return new SpaceEditorDiffPreview(this.$project, (ChangesTree)SpaceChangesTreeComponent.access$getChangesTree$p(this.this$0), this.$spaceDiffFileProvider, this.$statsPlace);
            }
        }, (Function0)new Function0<CombinedDiffPreview>(this, vms, diffPreviewDisposable){
            final /* synthetic */ SpaceChangesTreeComponent this$0;
            final /* synthetic */ SpaceVmHolder $vms;
            final /* synthetic */ SpaceVirtualFilesManager $diffPreviewDisposable;
            {
                this.this$0 = $receiver;
                this.$vms = $vms;
                this.$diffPreviewDisposable = $diffPreviewDisposable;
                super(0);
            }

            @Nullable
            public final CombinedDiffPreview invoke() {
                return SpaceChangesTreeComponent.access$createCombinedDiffPreview(this.this$0, this.$vms, this.$diffPreviewDisposable);
            }
        });
        this.changesTree.installDiffPreview((DiffPreviewController)editorDiffPreviewController2);
        DataManager.registerDataProvider((JComponent)parentPanel, arg_0 -> SpaceChangesTreeComponent._init_$lambda$0(this, arg_0));
        AnAction anAction = ActionManager.getInstance().getAction("space.review.changes.popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        this.changesTree.installPopupHandler((ActionGroup)anAction);
        JBLoadingPanel $this$_init__u24lambda_u241 = jBLoadingPanel = loadingPane;
        boolean bl = false;
        $this$_init__u24lambda_u241.add((Component)Scroll.INSTANCE.wrapWithScrollPane((JComponent)((Object)this.changesTree)), (Object)"Center");
        this.view = (JComponent)loadingPane;
    }

    @NotNull
    public final JComponent getView() {
        return this.view;
    }

    @NotNull
    public final Property<Boolean> getLoaded() {
        return this.loaded;
    }

    private final CombinedDiffPreview createCombinedDiffPreview(SpaceVmHolder vms, Disposable parentDisposable) {
        CombinedDiffPreview combinedDiffPreview;
        SpaceReviewDetailsVm<?> detailsVm = vms.component1();
        SpaceCreateCodeReviewVm createReviewVm = vms.component2();
        SpaceCreateMergeRequestVm createMergeRequestVm = vms.component3();
        if (detailsVm != null) {
            combinedDiffPreview = new SpaceReviewDetailsCombinedDiffPreview(detailsVm, (ChangesTree)this.changesTree, parentDisposable);
        } else if (createReviewVm != null) {
            combinedDiffPreview = new SpaceCreateCodeReviewCombinedDiffPreview(createReviewVm, this.changesTree, parentDisposable);
        } else if (createMergeRequestVm != null) {
            combinedDiffPreview = new SpaceCreateMergeRequestCombinedDiffPreview(createMergeRequestVm, this.changesTree, parentDisposable);
        } else {
            throw new IllegalArgumentException("SpaceVmHolder doesn't contains any VM");
        }
        return combinedDiffPreview;
    }

    @NotNull
    public final TreeActionsToolbarPanel createChangesBrowserToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("space.review.changes.toolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup changesToolbarActionGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = actionManager.createActionToolbar("ChangesBrowser", changesToolbarActionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar changesToolbar = actionToolbar;
        AnAction[] anActionArray = new AnAction[]{actionManager.getAction("ExpandAll"), actionManager.getAction("CollapseAll")};
        DefaultActionGroup treeActionsGroup = new DefaultActionGroup(anActionArray);
        return new TreeActionsToolbarPanel(changesToolbar, (ActionGroup)treeActionsGroup, this.view);
    }

    private static final Object _init_$lambda$0(SpaceChangesTreeComponent this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.changesTree.isShowing() ? this$0.changesTree.getData(it) : null;
    }

    public static final /* synthetic */ CombinedDiffPreview access$createCombinedDiffPreview(SpaceChangesTreeComponent $this, SpaceVmHolder vms, Disposable parentDisposable) {
        return $this.createCombinedDiffPreview(vms, parentDisposable);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SpaceChangesTreeComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTreeComponent$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.space.vcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

