/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.diff;

import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.MutableDiffRequestChainProcessor;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.utils.UtilitiesKt;
import com.intellij.space.vcs.diff.SpaceDiffModel;
import com.intellij.space.vcs.diff.SpaceDiffModelHolder;
import com.intellij.space.vcs.editor.SpaceDiffComplexPathVirtualFileSystem;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Property;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/space/vcs/diff/SpaceDiffFile;", "Lcom/intellij/diff/editor/DiffVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "sessionId", "", "projectHash", "fileId", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileId", "()Ljava/lang/String;", "createProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/space/vcs/editor/SpaceDiffComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "hashCode", "", "intellij.space.vcs"})
public final class SpaceDiffFile
extends DiffVirtualFile
implements VirtualFilePathWrapper {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String projectHash;
    @NotNull
    private final String fileId;

    public SpaceDiffFile(@NotNull String sessionId, @NotNull String projectHash, @NotNull String fileId, @Nls @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Object[] objectArray = new Object[]{fileName};
        String string2 = SpaceBundle.message("review.diff.tab.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(string2);
        this.sessionId = sessionId;
        this.projectHash = projectHash;
        this.fileId = fileId;
    }

    @NotNull
    public final String getFileId() {
        return this.fileId;
    }

    @NotNull
    public SpaceDiffComplexPathVirtualFileSystem getFileSystem() {
        return SpaceDiffComplexPathVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        String string2;
        try {
            string2 = this.getFileSystem().getPath(this.sessionId, this.projectHash, this.fileId);
        }
        catch (Exception e) {
            String string3 = this.getName();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        String string2 = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project2) {
        MutableDiffRequestChainProcessor mutableDiffRequestChainProcessor;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Property<SpaceDiffModel> diffModel = SpaceDiffModelHolder.Companion.getInstance(project2).getModel(this.fileId);
        MutableDiffRequestChainProcessor $this$createProcessor_u24lambda_u241 = mutableDiffRequestChainProcessor = new MutableDiffRequestChainProcessor(project2, null);
        boolean bl = false;
        $this$createProcessor_u24lambda_u241.getSelectionEventDispatcher().addListener((EventListener)((MutableDiffRequestChainProcessor.SelectionListener)arg_0 -> SpaceDiffFile.createProcessor$lambda$1$lambda$0(diffModel, arg_0)));
        MutableDiffRequestChainProcessor processor = mutableDiffRequestChainProcessor;
        diffModel.forEach(UtilitiesKt.nestedLifetime((Disposable)processor), (Function1<SpaceDiffModel, Unit>)((Function1)new Function1<SpaceDiffModel, Unit>(processor){
            final /* synthetic */ MutableDiffRequestChainProcessor $processor;
            {
                this.$processor = $processor;
                super(1);
            }

            public final void invoke(@Nullable SpaceDiffModel diffVM) {
                block0: {
                    SpaceDiffModel spaceDiffModel = diffVM;
                    if (spaceDiffModel == null) break block0;
                    SpaceDiffModel spaceDiffModel2 = spaceDiffModel;
                    MutableDiffRequestChainProcessor mutableDiffRequestChainProcessor = this.$processor;
                    SpaceDiffModel it = spaceDiffModel2;
                    boolean bl = false;
                    mutableDiffRequestChainProcessor.setChain(diffVM.getChain());
                }
            }
        }));
        return (DiffRequestProcessor)processor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.space.vcs.diff.SpaceDiffFile");
        SpaceDiffFile cfr_ignored_0 = (SpaceDiffFile)((Object)other);
        return Intrinsics.areEqual((Object)this.fileId, (Object)((SpaceDiffFile)((Object)other)).fileId);
    }

    public int hashCode() {
        return this.fileId.hashCode();
    }

    private static final void createProcessor$lambda$1$lambda$0(Property $diffModel, ChangeDiffRequestChain.Producer it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$diffModel, (String)"$diffModel");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            SpaceDiffModel spaceDiffModel = (SpaceDiffModel)$diffModel.getValue();
            if (spaceDiffModel == null) break block0;
            FilePath filePath = it.getFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            spaceDiffModel.select(filePath);
        }
    }
}

