/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003BO\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00128\b\u0002\u0010\u0007\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0002\u0010\u000eJ\b\u0010&\u001a\u00020\rH\u0016J\u0015\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020(2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010)J\u0018\u0010+\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020(H\u0016J\u001f\u0010.\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\r2\u0014\u00101\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000102H\u0016J\u0017\u00103\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,R&\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R>\u0010\u0007\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0019j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0019j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001cR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00064"}, d2={"Llibraries/collections/SLRUMap;", "K", "V", "", "protectedQueueSize", "", "probationalQueueSize", "onDropFromCache", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "key", "value", "", "(IILkotlin/jvm/functions/Function2;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "misses", "probationalHits", "probationalQueue", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getProbationalQueueSize", "()I", "protectedHits", "protectedQueue", "getProtectedQueueSize", "size", "getSize", "values", "", "getValues", "()Ljava/util/Collection;", "clear", "containsKey", "", "(Ljava/lang/Object;)Z", "containsValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "libraries-collections"})
public final class SLRUMap<K, V>
implements Map<K, V>,
KMutableMap {
    private final int protectedQueueSize;
    private final int probationalQueueSize;
    @NotNull
    private final Function2<K, V, Unit> onDropFromCache;
    @NotNull
    private final LinkedHashMap<K, V> protectedQueue;
    @NotNull
    private final LinkedHashMap<K, V> probationalQueue;
    private int probationalHits;
    private int protectedHits;
    private int misses;

    public SLRUMap(int protectedQueueSize, int probationalQueueSize, @NotNull Function2<? super K, ? super V, Unit> onDropFromCache) {
        Intrinsics.checkNotNullParameter(onDropFromCache, (String)"onDropFromCache");
        this.protectedQueueSize = protectedQueueSize;
        this.probationalQueueSize = probationalQueueSize;
        this.onDropFromCache = onDropFromCache;
        this.probationalQueue = new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(@NotNull Map.Entry<K, V> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                if (this.size() > this.getProbationalQueueSize()) {
                    onDropFromCache.invoke(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
        this.protectedQueue = new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(@NotNull Map.Entry<K, V> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                if (this.size() > this.getProtectedQueueSize()) {
                    probationalQueue.put(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    public /* synthetic */ SLRUMap(int n, int n2, Function2 function2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        this(n, n2, function2);
    }

    public final int getProtectedQueueSize() {
        return this.protectedQueueSize;
    }

    public final int getProbationalQueueSize() {
        return this.probationalQueueSize;
    }

    @Override
    @Nullable
    public V get(Object key2) {
        V value2 = this.protectedQueue.get(key2);
        if (value2 != null) {
            int n = this.protectedHits;
            this.protectedHits = n + 1;
            return value2;
        }
        value2 = this.probationalQueue.remove(key2);
        if (value2 != null) {
            int n = this.probationalHits;
            this.probationalHits = n + 1;
            ((Map)this.protectedQueue).put(key2, value2);
            return value2;
        }
        int n = this.misses;
        this.misses = n + 1;
        return null;
    }

    @Override
    @Nullable
    public V put(K key2, V value2) {
        Object v;
        V oldProbationValue;
        Object oldProtectedValue = this.protectedQueue.remove(key2);
        if (oldProtectedValue != null) {
            this.onDropFromCache.invoke(key2, oldProtectedValue);
        }
        if ((oldProbationValue = this.probationalQueue.put(key2, value2)) != null) {
            this.onDropFromCache.invoke(key2, oldProbationValue);
        }
        if ((v = oldProtectedValue) == null) {
            v = oldProbationValue;
        }
        return v;
    }

    @Override
    @Nullable
    public V remove(Object key2) {
        Object value2 = this.protectedQueue.remove(key2);
        if (value2 != null) {
            this.onDropFromCache.invoke(key2, value2);
            return value2;
        }
        value2 = this.probationalQueue.remove(key2);
        if (value2 != null) {
            this.onDropFromCache.invoke(key2, value2);
            return value2;
        }
        return null;
    }

    @NotNull
    public Set<K> getKeys() {
        HashSet jointKeys = new HashSet(this.protectedQueue.size() + this.probationalQueue.size());
        jointKeys.addAll(this.protectedQueue.keySet());
        jointKeys.addAll(this.probationalQueue.keySet());
        return jointKeys;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        HashSet set = new HashSet(this.protectedQueue.size() + this.probationalQueue.size());
        set.addAll(this.protectedQueue.entrySet());
        set.addAll(this.probationalQueue.entrySet());
        return set;
    }

    @Override
    public void clear() {
        Object value2;
        Object key2;
        if (!this.protectedQueue.isEmpty()) {
            for (Map.Entry entry : ((Map)this.protectedQueue).entrySet()) {
                key2 = entry.getKey();
                value2 = entry.getValue();
                this.onDropFromCache.invoke(key2, value2);
            }
            this.protectedQueue.clear();
        }
        if (!this.probationalQueue.isEmpty()) {
            for (Map.Entry entry : ((Map)this.probationalQueue).entrySet()) {
                key2 = entry.getKey();
                value2 = entry.getValue();
                this.onDropFromCache.invoke(key2, value2);
            }
            this.probationalQueue.clear();
        }
    }

    public int getSize() {
        return this.protectedQueue.size() + this.probationalQueue.size();
    }

    @Override
    public boolean containsKey(Object key2) {
        return ((Map)this.protectedQueue).containsKey(key2) || ((Map)this.probationalQueue).containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.protectedQueue.containsValue(value2) || this.probationalQueue.containsValue(value2);
    }

    @Override
    public boolean isEmpty() {
        return this.protectedQueue.isEmpty() && this.probationalQueue.isEmpty();
    }

    @NotNull
    public Collection<V> getValues() {
        ArrayList<V> values2 = new ArrayList<V>(this.protectedQueue.size() + this.probationalQueue.size());
        values2.addAll(this.protectedQueue.values());
        values2.addAll(this.probationalQueue.values());
        return values2;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        for (Map.Entry<K, V> entry : from.entrySet()) {
            K key2 = entry.getKey();
            V value2 = entry.getValue();
            this.put(key2, value2);
        }
    }
}

