/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.AbstractArtifact;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class DefaultArtifact
extends AbstractArtifact {
    private Date publicationDate;
    private ArtifactRevisionId arid;
    private URL url;
    private boolean isMetadata = false;

    public static Artifact newIvyArtifact(ModuleRevisionId mrid, Date pubDate) {
        return new DefaultArtifact(mrid, pubDate, "ivy", "ivy", "xml", true);
    }

    public static Artifact newPomArtifact(ModuleRevisionId mrid, Date pubDate) {
        return new DefaultArtifact(mrid, pubDate, mrid.getName(), "pom", "pom", true);
    }

    public static Artifact cloneWithAnotherExt(Artifact artifact, String newExt) {
        return DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, artifact.getType(), newExt);
    }

    public static Artifact cloneWithAnotherType(Artifact artifact, String newType) {
        return DefaultArtifact.cloneWithAnotherTypeAndExt(artifact, newType, artifact.getExt());
    }

    public static Artifact cloneWithAnotherTypeAndExt(Artifact artifact, String newType, String newExt) {
        return new DefaultArtifact(ArtifactRevisionId.newInstance(artifact.getModuleRevisionId(), artifact.getName(), newType, newExt, artifact.getQualifiedExtraAttributes()), artifact.getPublicationDate(), artifact.getUrl(), artifact.isMetadata());
    }

    public static Artifact cloneWithAnotherName(Artifact artifact, String name2) {
        return new DefaultArtifact(ArtifactRevisionId.newInstance(artifact.getModuleRevisionId(), name2, artifact.getType(), artifact.getExt(), artifact.getQualifiedExtraAttributes()), artifact.getPublicationDate(), artifact.getUrl(), artifact.isMetadata());
    }

    public static Artifact cloneWithAnotherMrid(Artifact artifact, ModuleRevisionId mrid) {
        return new DefaultArtifact(ArtifactRevisionId.newInstance(mrid, artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getQualifiedExtraAttributes()), artifact.getPublicationDate(), artifact.getUrl(), artifact.isMetadata());
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name2, String type2, String ext2) {
        this(mrid, publicationDate, name2, type2, ext2, null, null);
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name2, String type2, String ext2, boolean isMetadata) {
        this(mrid, publicationDate, name2, type2, ext2, null, null);
        this.isMetadata = isMetadata;
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name2, String type2, String ext2, Map<String, String> extraAttributes) {
        this(mrid, publicationDate, name2, type2, ext2, null, extraAttributes);
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name2, String type2, String ext2, URL url2, Map<String, String> extraAttributes) {
        this(ArtifactRevisionId.newInstance(mrid, name2, type2, ext2, extraAttributes), publicationDate, url2, false);
    }

    public DefaultArtifact(ArtifactRevisionId arid, Date publicationDate, URL url2, boolean isMetadata) {
        if (arid == null) {
            throw new NullPointerException("null arid not allowed");
        }
        if (publicationDate == null) {
            publicationDate = new Date();
        }
        this.publicationDate = publicationDate;
        this.arid = arid;
        this.url = url2;
        this.isMetadata = isMetadata;
    }

    @Override
    public ModuleRevisionId getModuleRevisionId() {
        return this.arid.getModuleRevisionId();
    }

    @Override
    public String getName() {
        return this.arid.getName();
    }

    @Override
    public Date getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public String getType() {
        return this.arid.getType();
    }

    @Override
    public String getExt() {
        return this.arid.getExt();
    }

    @Override
    public ArtifactRevisionId getId() {
        return this.arid;
    }

    @Override
    public String[] getConfigurations() {
        return new String[0];
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isMetadata() {
        return this.isMetadata;
    }
}

