/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.retrieve;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.retrieve.EndRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.EndRetrieveEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.pack.PackagingManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class RetrieveEngine {
    private static final int KILO = 1024;
    private RetrieveEngineSettings settings;
    private EventManager eventManager;

    public RetrieveEngine(RetrieveEngineSettings settings2, EventManager eventManager) {
        this.settings = settings2;
        this.eventManager = eventManager;
    }

    @Deprecated
    public int retrieve(ModuleRevisionId mrid, String destFilePattern, RetrieveOptions options2) throws IOException {
        RetrieveOptions retrieveOptions = new RetrieveOptions(options2);
        retrieveOptions.setDestArtifactPattern(destFilePattern);
        RetrieveReport result2 = this.retrieve(mrid, retrieveOptions);
        return result2.getNbrArtifactsCopied();
    }

    public RetrieveReport retrieve(ModuleRevisionId mrid, RetrieveOptions options2) throws IOException {
        RetrieveReport report2 = new RetrieveReport();
        ModuleId moduleId = mrid.getModuleId();
        if ("default".equals(options2.getLog())) {
            Message.info(":: retrieving :: " + moduleId + (options2.isSync() ? " [sync]" : ""));
        } else {
            Message.verbose(":: retrieving :: " + moduleId + (options2.isSync() ? " [sync]" : ""));
        }
        Message.verbose("\tcheckUpToDate=" + this.settings.isCheckUpToDate());
        long start2 = System.currentTimeMillis();
        String destFilePattern = IvyPatternHelper.substituteVariables(options2.getDestArtifactPattern(), this.settings.getVariables());
        String destIvyPattern = IvyPatternHelper.substituteVariables(options2.getDestIvyPattern(), this.settings.getVariables());
        String[] confs = this.getConfs(mrid, options2);
        if ("default".equals(options2.getLog())) {
            Message.info("\tconfs: " + Arrays.asList(confs));
        } else {
            Message.verbose("\tconfs: " + Arrays.asList(confs));
        }
        if (this.eventManager != null) {
            this.eventManager.fireIvyEvent(new StartRetrieveEvent(mrid, confs, options2));
        }
        try {
            Map<ArtifactDownloadReport, Set<String>> artifactsToCopy = this.determineArtifactsToCopy(mrid, destFilePattern, options2);
            File fileRetrieveRoot = this.settings.resolveFile(IvyPatternHelper.getTokenRoot(destFilePattern));
            report2.setRetrieveRoot(fileRetrieveRoot);
            File ivyRetrieveRoot = destIvyPattern == null ? null : this.settings.resolveFile(IvyPatternHelper.getTokenRoot(destIvyPattern));
            HashSet<File> targetArtifactsStructure = new HashSet<File>();
            HashSet<File> targetIvysStructure = new HashSet<File>();
            long totalCopiedSize = 0L;
            for (Map.Entry<ArtifactDownloadReport, Set<String>> artifactAndPaths : artifactsToCopy.entrySet()) {
                ArtifactDownloadReport artifact = artifactAndPaths.getKey();
                File archive2 = artifact.getLocalFile();
                if (artifact.getUnpackedLocalFile() != null) {
                    archive2 = artifact.getUnpackedLocalFile();
                }
                if (archive2 == null) {
                    Message.verbose("\tno local file available for " + artifact + ": skipping");
                    continue;
                }
                Message.verbose("\tretrieving " + archive2);
                for (String path2 : artifactAndPaths.getValue()) {
                    IvyContext.getContext().checkInterrupted();
                    File destFile = this.settings.resolveFile(path2);
                    if (!this.settings.isCheckUpToDate() || !this.upToDate(archive2, destFile, options2)) {
                        Message.verbose("\t\tto " + destFile);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new StartRetrieveArtifactEvent(artifact, destFile));
                        }
                        if (options2.isMakeSymlinks()) {
                            boolean symlinkCreated;
                            try {
                                symlinkCreated = FileUtil.symlink(archive2, destFile, true);
                            }
                            catch (IOException ioe) {
                                symlinkCreated = false;
                                Message.warn("symlink creation failed at path " + destFile, ioe);
                            }
                            if (!symlinkCreated) {
                                Message.info("Attempting a copy operation (since symlink creation failed) at path " + destFile);
                                FileUtil.copy(archive2, destFile, null, true);
                            }
                        } else {
                            FileUtil.copy(archive2, destFile, null, true);
                        }
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new EndRetrieveArtifactEvent(artifact, destFile));
                        }
                        totalCopiedSize += FileUtil.getFileLength(destFile);
                        report2.addCopiedFile(destFile, artifact);
                    } else {
                        Message.verbose("\t\tto " + destFile + " [NOT REQUIRED]");
                        report2.addUpToDateFile(destFile, artifact);
                    }
                    if ("ivy".equals(artifact.getType())) {
                        targetIvysStructure.addAll(FileUtil.getPathFiles(ivyRetrieveRoot, destFile));
                        continue;
                    }
                    Collection<File> files2 = FileUtil.listAll(destFile, Collections.emptyList());
                    for (File file2 : files2) {
                        targetArtifactsStructure.addAll(FileUtil.getPathFiles(fileRetrieveRoot, file2));
                    }
                }
            }
            if (options2.isSync()) {
                Collection<File> existingIvys;
                Message.verbose("\tsyncing...");
                String[] ignorableFilenames = this.settings.getIgnorableFilenames();
                List<String> ignoreList = Arrays.asList(ignorableFilenames);
                Collection<File> existingArtifacts = FileUtil.listAll(fileRetrieveRoot, ignoreList);
                Collection<File> collection = existingIvys = ivyRetrieveRoot == null ? null : FileUtil.listAll(ivyRetrieveRoot, ignoreList);
                if (fileRetrieveRoot.equals(ivyRetrieveRoot)) {
                    targetArtifactsStructure.addAll(targetIvysStructure);
                    existingArtifacts.addAll(existingIvys);
                    this.sync(targetArtifactsStructure, existingArtifacts);
                } else {
                    this.sync(targetArtifactsStructure, existingArtifacts);
                    if (existingIvys != null) {
                        this.sync(targetIvysStructure, existingIvys);
                    }
                }
            }
            long elapsedTime = System.currentTimeMillis() - start2;
            String msg = "\t" + report2.getNbrArtifactsCopied() + " artifacts copied" + (this.settings.isCheckUpToDate() ? ", " + report2.getNbrArtifactsUpToDate() + " already retrieved" : "") + " (" + totalCopiedSize / 1024L + "kB/" + elapsedTime + "ms)";
            if ("default".equals(options2.getLog())) {
                Message.info(msg);
            } else {
                Message.verbose(msg);
            }
            Message.verbose("\tretrieve done (" + elapsedTime + "ms)");
            if (this.eventManager != null) {
                this.eventManager.fireIvyEvent(new EndRetrieveEvent(mrid, confs, elapsedTime, report2.getNbrArtifactsCopied(), report2.getNbrArtifactsUpToDate(), totalCopiedSize, options2));
            }
            return report2;
        }
        catch (Exception ex) {
            throw new RuntimeException("problem during retrieve of " + moduleId + ": " + ex, ex);
        }
    }

    private String[] getConfs(ModuleRevisionId mrid, RetrieveOptions options2) throws IOException {
        String[] confs = options2.getConfs();
        if (confs == null || confs.length == 1 && "*".equals(confs[0])) {
            try {
                ModuleDescriptor md = this.getCache().getResolvedModuleDescriptor(mrid);
                Message.verbose("no explicit confs given for retrieve, using ivy file: " + md.getResource().getName());
                confs = md.getConfigurationsNames();
                options2.setConfs(confs);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return confs;
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    private void sync(Collection<File> target, Collection<File> existing) {
        HashSet<File> toRemove = new HashSet<File>();
        for (File file2 : existing) {
            toRemove.add(file2.getAbsoluteFile());
        }
        for (File file2 : target) {
            toRemove.remove(file2.getAbsoluteFile());
        }
        for (File file2 : toRemove) {
            if (!file2.exists()) continue;
            Message.verbose("\t\tdeleting " + file2);
            FileUtil.forceDelete(file2);
        }
    }

    public Map<ArtifactDownloadReport, Set<String>> determineArtifactsToCopy(ModuleRevisionId mrid, String destFilePattern, RetrieveOptions options2) throws ParseException, IOException {
        ModuleId moduleId = mrid.getModuleId();
        if (options2.getResolveId() == null) {
            options2.setResolveId(ResolveOptions.getDefaultResolveId(moduleId));
        }
        ResolutionCacheManager cacheManager = this.getCache();
        String[] confs = this.getConfs(mrid, options2);
        String destIvyPattern = IvyPatternHelper.substituteVariables(options2.getDestIvyPattern(), this.settings.getVariables());
        HashMap<ArtifactDownloadReport, Set<String>> artifactsToCopy = new HashMap<ArtifactDownloadReport, Set<String>>();
        HashMap conflictsMap = new HashMap();
        HashMap conflictsReportsMap = new HashMap();
        HashMap conflictsConfMap = new HashMap();
        XmlReportParser parser = new XmlReportParser();
        for (String conf : confs) {
            File report2 = cacheManager.getConfigurationResolveReportInCache(options2.getResolveId(), conf);
            parser.parse(report2);
            ArrayList<ArtifactDownloadReport> artifacts = new ArrayList<ArtifactDownloadReport>(Arrays.asList(parser.getArtifactReports()));
            if (destIvyPattern != null) {
                for (ModuleRevisionId rmrid : parser.getRealDependencyRevisionIds()) {
                    artifacts.add(parser.getMetadataArtifactReport(rmrid));
                }
            }
            PackagingManager packagingManager = new PackagingManager();
            packagingManager.setSettings(IvyContext.getContext().getSettings());
            for (ArtifactDownloadReport adr : artifacts) {
                String destPattern;
                String ext2;
                Artifact artifact = adr.getArtifact();
                if (adr.getUnpackedLocalFile() == null) {
                    String ext22 = artifact.getExt();
                } else {
                    Artifact unpackedArtifact = adr.getUnpackedArtifact() != null ? adr.getUnpackedArtifact() : packagingManager.getUnpackedArtifact(artifact);
                    if (unpackedArtifact == null) {
                        throw new RuntimeException("Could not determine unpacked artifact for " + artifact + " while determining artifacts to copy for module " + mrid);
                    }
                    ext2 = unpackedArtifact.getExt();
                }
                String string2 = destPattern = "ivy".equals(adr.getType()) ? destIvyPattern : destFilePattern;
                if (!"ivy".equals(adr.getType()) && !options2.getArtifactFilter().accept(adr.getArtifact())) continue;
                ModuleRevisionId aMrid = artifact.getModuleRevisionId();
                String destFileName = IvyPatternHelper.substitute(destPattern, aMrid.getOrganisation(), aMrid.getName(), aMrid.getBranch(), aMrid.getRevision(), artifact.getName(), artifact.getType(), ext2, conf, adr.getArtifactOrigin(), aMrid.getQualifiedExtraAttributes(), artifact.getQualifiedExtraAttributes());
                HashSet<String> dest = (HashSet<String>)artifactsToCopy.get(adr);
                if (dest == null) {
                    dest = new HashSet<String>();
                    artifactsToCopy.put(adr, dest);
                }
                String copyDest = this.settings.resolveFile(destFileName).getAbsolutePath();
                String[] destinations = new String[]{copyDest};
                if (options2.getMapper() != null) {
                    destinations = options2.getMapper().mapFileName(copyDest);
                }
                for (String destination : destinations) {
                    dest.add(destination);
                    HashSet<ArtifactRevisionId> conflicts = (HashSet<ArtifactRevisionId>)conflictsMap.get(destination);
                    HashSet<ArtifactDownloadReport> conflictsReports = (HashSet<ArtifactDownloadReport>)conflictsReportsMap.get(destination);
                    HashSet<String> conflictsConf = (HashSet<String>)conflictsConfMap.get(destination);
                    if (conflicts == null) {
                        conflicts = new HashSet<ArtifactRevisionId>();
                        conflictsMap.put(destination, conflicts);
                    }
                    if (conflictsReports == null) {
                        conflictsReports = new HashSet<ArtifactDownloadReport>();
                        conflictsReportsMap.put(destination, conflictsReports);
                    }
                    if (conflictsConf == null) {
                        conflictsConf = new HashSet<String>();
                        conflictsConfMap.put(destination, conflictsConf);
                    }
                    if (!conflicts.add(artifact.getId())) continue;
                    conflictsReports.add(adr);
                    conflictsConf.add(conf);
                }
            }
        }
        for (Map.Entry entry : conflictsMap.entrySet()) {
            int i;
            String copyDest = (String)entry.getKey();
            Set artifacts = (Set)entry.getValue();
            Set conflictsConfs = (Set)conflictsConfMap.get(copyDest);
            if (artifacts.size() <= 1) continue;
            ArrayList artifactsList = new ArrayList((Collection)conflictsReportsMap.get(copyDest));
            Collections.sort(artifactsList, this.getConflictResolvingPolicy());
            ArtifactDownloadReport winner = (ArtifactDownloadReport)artifactsList.get(artifactsList.size() - 1);
            ModuleRevisionId winnerMD = winner.getArtifact().getModuleRevisionId();
            for (i = artifactsList.size() - 2; i >= 0; --i) {
                ArtifactDownloadReport current2 = (ArtifactDownloadReport)artifactsList.get(i);
                if (!winnerMD.equals(current2.getArtifact().getModuleRevisionId())) continue;
                throw new RuntimeException("Multiple artifacts of the module " + winnerMD + " are retrieved to the same file! Update the retrieve pattern  to fix this error.");
            }
            Message.info("\tconflict on " + copyDest + " in " + conflictsConfs + ": " + winnerMD.getRevision() + " won");
            for (i = artifactsList.size() - 2; i >= 0; --i) {
                ArtifactDownloadReport looser = (ArtifactDownloadReport)artifactsList.get(i);
                Message.verbose("\t\tremoving conflict looser artifact: " + looser.getArtifact());
                Set dest = (Set)artifactsToCopy.get(looser);
                dest.remove(copyDest);
                if (!dest.isEmpty()) continue;
                artifactsToCopy.remove(looser);
            }
        }
        return artifactsToCopy;
    }

    private boolean upToDate(File source2, File target, RetrieveOptions options2) {
        if (!target.exists()) {
            return false;
        }
        String overwriteMode = options2.getOverwriteMode();
        if ("always".equals(overwriteMode)) {
            return false;
        }
        if ("never".equals(overwriteMode)) {
            return true;
        }
        if ("newer".equals(overwriteMode)) {
            return source2.lastModified() <= target.lastModified();
        }
        if ("different".equals(overwriteMode)) {
            return source2.lastModified() == target.lastModified();
        }
        return false;
    }

    private Comparator<ArtifactDownloadReport> getConflictResolvingPolicy() {
        return new Comparator<ArtifactDownloadReport>(){

            @Override
            public int compare(ArtifactDownloadReport o1, ArtifactDownloadReport o2) {
                Artifact a1 = o1.getArtifact();
                Artifact a2 = o2.getArtifact();
                if (a1.getPublicationDate().after(a2.getPublicationDate())) {
                    return 1;
                }
                if (a1.getPublicationDate().before(a2.getPublicationDate())) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

